#include <inc/map.hpp>
#include <inc/nini.hpp>
#include <inc/kitten.hpp>
#include <inc/camera.hpp>
#include <inc/engine.hpp>
#include <inc/krampus.hpp>
#include <inc/random.hpp>

const unsigned int number_of_kittens = 10;

Map Map;
Nini Nini;
Camera Camera;
Engine Engine;
Random Random;
vector < Kitten > Kittens;

Krampus::Krampus(void) {

  points = 0;

  map_bitmap = NULL;

  kitten_bitmap = NULL;

  kitten_meow_sample = NULL;

  cool_down = 0;

  show_extras = false;

  current_time.str("12:00");

  alpha[0] = 0.0;
  alpha[1] = 255.0;
  alpha[2] = 0.0;

  kitten_names[0] = "Cocoa";
  kitten_names[1] = "Fred";
  kitten_names[2] = "Brownie";
  kitten_names[3] = "Mac";
  kitten_names[4] = "Mittens";
  kitten_names[5] = "Cheese";
  kitten_names[6] = "Niki";
  kitten_names[7] = "Bob";
  kitten_names[8] = "Mimi";
  kitten_names[9] = "Bub";

  distances[0] = 0;
  distances[1] = 0;
  distances[2] = 0;
  distances[3] = 0;
  distances[4] = 0;
  distances[5] = 0;
  distances[6] = 0;
  distances[7] = 0;
  distances[8] = 0;
  distances[9] = 0;

  shortest_distance = 0;

  x1 = 0;
  x2 = 0;
  y1 = 0;
  y2 = 0;

  hours = 12;
  minutes = 0;
  seconds = 0;

  gain = 1.0;

  // 0 = intro; 1 = game; 2 = win; 3 = lose; 4 = credits.
  state = 0;

  kittens_found = 0;

  fade_intro = true;

  // No player movement from the start.
  keys[0] = false;
  keys[1] = false;
  keys[2] = false;
  keys[3] = false;

  ready_to_win = false;
  ready_to_lose = false;

  built_in_font = NULL;

  background_sample = NULL;
  background_sample_instance = NULL;
}

void Krampus::loop(void) {

  Engine.startTimer();

  while (Engine.isRunning()) {

    Engine.checkEventQueue();

    if (Engine.isKeyPressed()) {

      if (state == 0) {

        if (Engine.isKey(ALLEGRO_KEY_ESCAPE)) {

          ++state;

          // Don't show credits during first state.
          continue;
        }

        ++state;
      }

      if (Engine.isKey(ALLEGRO_KEY_UP)) {

        keys[UP] = true;
      }
      else if (Engine.isKey(ALLEGRO_KEY_DOWN)) {

        keys[DOWN] = true;
      }
      else if (Engine.isKey(ALLEGRO_KEY_LEFT)) {

        keys[LEFT] = true;
      }
      else if (Engine.isKey(ALLEGRO_KEY_RIGHT)) {

        keys[RIGHT] = true;
      }
      else if (Engine.isKey(ALLEGRO_KEY_ESCAPE)) {

        if (state == 4) {

          Engine.end();
        }
        else {

          state = 4;
        }
      }
      else if (Engine.isKey(ALLEGRO_KEY_T)) {

        // Toggle extras.
        show_extras = !show_extras;
      }
      else if (Engine.isKey(ALLEGRO_KEY_Z)) {

        // Action key.

        static unsigned int multiplier = 0;
        static unsigned int points_to_add = 0;

        if (cool_down < 15) {

          continue;
        }

        cool_down = 0;

        if (state == 1) {

          Nini.meow();
        }

        unsigned int tile_x = int(Nini.getX()) / 16;
        unsigned int tile_y = int(Nini.getY()) / 16;

        for (unsigned int i = 0; i < number_of_kittens; ++i) {

          if (Kittens[i].isFound()) {

            continue;
          }

          unsigned int k_x = Kittens[i].getX() / 16;
          unsigned int k_y = Kittens[i].getY() / 16;

          if (tile_x == k_x && tile_y - 1 == k_y) {

            ++multiplier;

            // Flag the kitten as being found.
            Kittens[i].find(kitten_meow_sample);

            ++kittens_found;

            // Set the kitten's tile to non-solid.
            Map.getTiles()[tile_x][tile_y - 1] = "00x00L";

            points_to_add += 250;
          }

          if (tile_x == k_x && tile_y + 1 == k_y) {

            ++multiplier;

            // Flag the kitten as being found.
            Kittens[i].find(kitten_meow_sample);

            ++kittens_found;

            // Set the kitten's tile to non-solid.
            Map.getTiles()[tile_x][tile_y + 1] = "00x00L";

            points_to_add += 250;
          }

          if (tile_x - 1 == k_x && tile_y == k_y) {

            ++multiplier;

            // Flag the kitten as being found.
            Kittens[i].find(kitten_meow_sample);

            ++kittens_found;

            // Set the kitten's tile to non-solid.
            Map.getTiles()[tile_x - 1][tile_y] = "00x00L";

            points_to_add += 250;
          }

          if (tile_x + 1 == k_x && tile_y == k_y) {

            ++multiplier;

            // Flag the kitten as being found.
            Kittens[i].find(kitten_meow_sample);

            ++kittens_found;

            // Set the kitten's tile to non-solid.
            Map.getTiles()[tile_x + 1][tile_y] = "00x00L";

            points_to_add += 250;
          }
        }

        if (tile_x > 1) {

          if (Map.getTiles()[tile_x - 1][tile_y].substr(5, 6) == "S" && Map.getTiles()[tile_x - 1][tile_y] != "00x00S") {

            ++multiplier;

            if (Map.getTiles()[tile_x - 1][tile_y] == "01x00S") {

              // Green tree.

              points_to_add += 10;
            }
            else if (Map.getTiles()[tile_x - 1][tile_y] == "02x00S") {

              // Brown tree.

              points_to_add += 5;
            }
            else if (Map.getTiles()[tile_x - 1][tile_y] == "03x00S") {

              // Mushroom.

              points_to_add += 15;
            }

            // Destroy tiles to the left.
            //Map.getTiles()[tile_x - 1][tile_y] = "05x00L";
            Map.getTiles()[tile_x - 1][tile_y] = Map.getTiles()[tile_x - 1][tile_y].substr(0, 3) + string("01L");
          }
        }

        if (tile_x < Map.getTiles().size() - 1) {

          if (Map.getTiles()[tile_x + 1][tile_y].substr(5, 6) == "S" && Map.getTiles()[tile_x + 1][tile_y] != "00x00S") {

            ++multiplier;

            if (Map.getTiles()[tile_x + 1][tile_y] == "01x00S") {

              // Green tree.

              points_to_add += 10;
            }
            else if (Map.getTiles()[tile_x + 1][tile_y] == "02x00S") {

              // Brown tree.

              points_to_add += 5;
            }
            else if (Map.getTiles()[tile_x + 1][tile_y] == "03x00S") {

              // Mushroom.

              points_to_add += 15;
            }

            // Destroy tiles to the right.
            //Map.getTiles()[tile_x + 1][tile_y] = "05x00L";
            Map.getTiles()[tile_x + 1][tile_y] = Map.getTiles()[tile_x + 1][tile_y].substr(0, 3) + string("01L");
          }
        }

        if (tile_y > 1) {

          if (Map.getTiles()[tile_x][tile_y - 1].substr(5, 6) == "S" && Map.getTiles()[tile_x][tile_y - 1] != "00x00S") {

            ++multiplier;

            if (Map.getTiles()[tile_x][tile_y - 1] == "01x00S") {

              // Green tree.

              points_to_add += 10;
            }
            else if (Map.getTiles()[tile_x][tile_y - 1] == "02x00S") {

              // Brown tree.

              points_to_add += 5;
            }
            else if (Map.getTiles()[tile_x][tile_y - 1] == "03x00S") {

              // Mushroom.

              points_to_add += 15;
            }

            // Destroy tiles above Nini.
            //Map.getTiles()[tile_x][tile_y - 1] = "05x00L";
            Map.getTiles()[tile_x][tile_y - 1] = Map.getTiles()[tile_x][tile_y - 1].substr(0, 3) + string("01L");
          }
        }

        if (tile_y < Map.getTiles()[0].size() - 1) {

          if (Map.getTiles()[tile_x][tile_y + 1].substr(5, 6) == "S" && Map.getTiles()[tile_x][tile_y + 1] != "00x00S") {

            ++multiplier;

            if (Map.getTiles()[tile_x][tile_y + 1] == "01x00S") {

              // Green tree.

              points_to_add += 10;
            }
            else if (Map.getTiles()[tile_x][tile_y + 1] == "02x00S") {

              // Brown tree.

              points_to_add += 5;
            }
            else if (Map.getTiles()[tile_x][tile_y + 1] == "03x00S") {

              // Mushroom.

              points_to_add += 15;
            }

            // Destroy tiles below Nini.
            //Map.getTiles()[tile_x][tile_y + 1] = "05x00L";
            Map.getTiles()[tile_x][tile_y + 1] = Map.getTiles()[tile_x][tile_y + 1].substr(0, 3) + string("01L");
          }
        }

        // Add up the points and bonuses.
        points += points_to_add * multiplier;

        // Reset.
        points_to_add = 0;
        multiplier = 0;
      }
    }
    else if (Engine.isKeyReleased()) {

      if (Engine.isKey(ALLEGRO_KEY_UP)) {

        keys[UP] = false;
      }
      else if (Engine.isKey(ALLEGRO_KEY_DOWN)) {

        keys[DOWN] = false;
      }
      else if (Engine.isKey(ALLEGRO_KEY_LEFT)) {

        keys[LEFT] = false;
      }
      else if (Engine.isKey(ALLEGRO_KEY_RIGHT)) {

        keys[RIGHT] = false;
      }
    }
    else if (Engine.isUpdatePhase()) {

      Engine.flipPhase();

      if (state != 3) {

        // Play background music.
        al_play_sample_instance(background_sample_instance);
      }

      switch (state) {

        case 0:

          // Intro sequence.
        break;

        case 1:

          // Normal game.

          ++cool_down;

          Nini.move(keys);

          Nini.update();

          Camera.setTarget(Nini.getX(), Nini.getY());

          for (unsigned int i = 0; i < number_of_kittens; ++i) {

            if (Kittens[i].isFound()) {

              continue;
            }

            Kittens[i].move(Camera.getX(), Camera.getY());

            Kittens[i].update();
          }

          Camera.pan();

          ++seconds;

          if (seconds >= 60 * 2) {

            ++minutes;

            seconds = 0;
          }

          if (minutes >= 60) {

            ++hours;

            minutes = 0;
          }

          if (hours > 23) {

            // Roll over hours.
            hours = 0;
          }

          static int ticks = 0;

          ++ticks;

          if (ticks > 60) {

            current_time.str("");

            if (hours < 10) {

              current_time << "0";
            }

            current_time << hours << ":";

            if (minutes < 10) {

              current_time << "0";
            }

            current_time << minutes;
          }

          if (hours >= 18) {

            // Kittens not found by sundown. Lose the game.
            ready_to_lose = true;
          }

          if (kittens_found == number_of_kittens) {

            ready_to_win = true;
          }

          if (ready_to_lose || ready_to_win) {

            if (gain > 0.1) {

              // Fade out the background music.
              gain -= 0.006;
            }

            al_set_sample_instance_gain(background_sample_instance, gain);
          }

          for (unsigned int i = 0; i < number_of_kittens; ++i) {

            if (Kittens[i].isFound()) {

              continue;
            }

            x1 = int(Nini.getX()) / 16;
            y1 = int(Nini.getY()) / 16;

            x2 = int(Kittens[i].getX()) / 16;
            y2 = int(Kittens[i].getY()) / 16;

            distances[i] = sqrt(pow((x2 - x1), 2) + pow((y2 - y1), 2));
          }

          if (kittens_found == number_of_kittens) {

            shortest_distance = 0;
          }
          else {

            shortest_distance = 999;
          }

          for (unsigned int i = 0; i < number_of_kittens; ++i) {

            if (Kittens[i].isFound()) {

              continue;
            }

            if (distances[i] <= shortest_distance) {

              // Find nearest kitten.

              shortest_distance_kitten_number = i;

              shortest_distance = distances[i];
            }
          }

          if (hours >= 17) {

            if (alpha[0] < 180.0) {

              // Take one in-game hour to transition to dark.
              alpha[0] += 0.05 / 2.0;
            }
          }

          if (fade_intro) {

            alpha[1] -= 3.2;

            if (alpha[1] < 0) {

              alpha[1] = 0;
            }

            if (alpha[1] <= 0) {

              fade_intro = false;
            }
          }

          if (ready_to_lose || ready_to_win) {

            alpha[2] += 1.6;

            if (alpha[2] > 255) {

              alpha[2] = 255;
            }

            al_draw_filled_rectangle(0, 0, 768 / 4, 448 / 4, al_map_rgba(0, 0, 0, alpha[2]));

            if (alpha[2] >= 255) {

              if (ready_to_win) {

                // Player won.
                state = 2;
              }
              else if (ready_to_lose) {

                // Player lost.
                state = 3;
              }
            }
          }
        break;

        case 2:

          // Winning sequence.
        break;

        case 3:

          // Losing sequence.
        break;
      }
    }
    else if (Engine.getEvent().type == ALLEGRO_EVENT_DISPLAY_CLOSE) {

      state = 4;
    }

    if (Engine.isRenderPhase()) {

      Engine.flipPhase();

      switch (state) {

        case 0:

          // Intro sequence.

          Engine.setDisplayScale(2.0);

          al_draw_text(built_in_font, al_map_rgb(255, 255, 255), 32 + 8, 32 + 8, ALLEGRO_ALIGN_LEFT, "Oh no! Your kittens have gone missing!");
          al_draw_text(built_in_font, al_map_rgb(255, 255, 255), 32 + 8, 32 + 8 * 3, ALLEGRO_ALIGN_LEFT, "Find them before nightfall, lest they");
          al_draw_text(built_in_font, al_map_rgb(255, 255, 255), 32 + 8, 32 + 8 * 5, ALLEGRO_ALIGN_LEFT, "freeze to death in this chilly autumn");
          al_draw_text(built_in_font, al_map_rgb(255, 255, 255), 32 + 8, 32 + 8 * 7, ALLEGRO_ALIGN_LEFT, "weather! Sunset is at 18:00. Be quick!");
          al_draw_text(built_in_font, al_map_rgb(255, 255, 255), 32 + 8, 32 + 8 * 9, ALLEGRO_ALIGN_LEFT, "Also, dinner tonight is ramen noodles.");
          al_draw_text(built_in_font, al_map_rgb(255, 255, 255), 32 + 8, 32 + 8 * 15, ALLEGRO_ALIGN_LEFT, "Press any key to continue.");

          Engine.setDisplayScale(4.0);
        break;

        case 1:

          // Normal game.

          Map.render(Camera.getX(), Camera.getY());

          Nini.render(Camera.getX(), Camera.getY());

          al_hold_bitmap_drawing(true);

          for (unsigned int i = 0; i < number_of_kittens; ++i) {

            if (Kittens[i].isFound()) {

              continue;
            }

            Kittens[i].render(Camera.getX(), Camera.getY(), kitten_bitmap);

            if (show_extras) {

              Engine.setDisplayScale(2.0);

              al_draw_textf(built_in_font, al_map_rgb(255, 255, 255), (Kittens[i].getX() - Camera.getX()) * 2 + 16, (Kittens[i].getY() - Camera.getY()) * 2 - 16, ALLEGRO_ALIGN_CENTER, "%s", Kittens[i].getName().c_str());

              Engine.setDisplayScale(4.0);
            }
          }

          al_hold_bitmap_drawing(false);

          if (hours >= 17) {

            al_draw_filled_rectangle(0, 0, 768, 448, al_map_rgba(0, 0, 0, alpha[0]));
          }

          Engine.setDisplayScale(2.0);

          al_draw_textf(built_in_font, al_map_rgb(255, 255, 255), 8, 8, ALLEGRO_ALIGN_LEFT, "Kittens found: %i/%i", kittens_found, number_of_kittens);

          al_draw_textf(built_in_font, al_map_rgb(255, 255, 255), 8, 448 / 2 - 16, ALLEGRO_ALIGN_LEFT, "%s: %im", Kittens[shortest_distance_kitten_number].getName().c_str(), shortest_distance);

          al_draw_textf(built_in_font, al_map_rgb(255, 255, 255), 768 / 2 - 8, 8, ALLEGRO_ALIGN_RIGHT, "Time: %s", current_time.str().c_str());

          // Draw points.
          al_draw_textf(built_in_font, al_map_rgb(255, 255, 255), 768 / 2 - 8, 448 / 2 - 16, ALLEGRO_ALIGN_RIGHT, "Score: %i", points);

          Engine.setDisplayScale(4.0);

          if (fade_intro) {

            al_draw_filled_rectangle(0, 0, 768 / 4, 448 / 4, al_map_rgba(0, 0, 0, alpha[1]));
          }

          if (ready_to_lose || ready_to_win) {

            al_draw_filled_rectangle(0, 0, 768 / 4, 448 / 4, al_map_rgba(0, 0, 0, alpha[2]));
          }
        break;

        case 2:

          // Winning sequence.

          Engine.setDisplayScale(2.0);

          static unsigned int timer = 0;

          static bool flash = false;

          ++timer;

          if (timer > 15) {

            timer = 0;

            flash = !flash;
          }

          if (flash) {

            // Yellow text.
            al_draw_text(built_in_font, al_map_rgb(255, 255, 0), 32 + 8, 32 + 8, ALLEGRO_ALIGN_LEFT, "You did it! You found your kittens!");
            al_draw_text(built_in_font, al_map_rgb(255, 255, 0), 32 + 8, 32 + 24, ALLEGRO_ALIGN_LEFT, "With time to spare, too! Now you can");
            al_draw_text(built_in_font, al_map_rgb(255, 255, 0), 32 + 8, 32 + 40, ALLEGRO_ALIGN_LEFT, "go home and enjoy noodles for dinner!");

            al_draw_text(built_in_font, al_map_rgb(255, 255, 0), 32 + 8, 32 + 72, ALLEGRO_ALIGN_LEFT, "Thanks for playing!");

            al_draw_text(built_in_font, al_map_rgb(255, 255, 0), 32 + 8, 32 + 94, ALLEGRO_ALIGN_LEFT, "Press escape to end the game.");

            // Draw scores.
            al_draw_textf(built_in_font, al_map_rgb(255, 255, 0), 32 + 8, 16 + 32 + 94 + 16, ALLEGRO_ALIGN_LEFT, "Score: %i", points);
            al_draw_textf(built_in_font, al_map_rgb(255, 255, 0), 32 + 8, 16 + 32 + 94 + 16 + 16, ALLEGRO_ALIGN_LEFT, "Bonus: %i", (1080 - (hours * 60) + minutes) * 10);
            al_draw_textf(built_in_font, al_map_rgb(255, 255, 0), 32 + 8, 16 + 32 + 94 + 16 + 16 + 16, ALLEGRO_ALIGN_LEFT, "Final: %i", points + ((1080 - (hours * 60) + minutes) * 10));
          }
          else {

            // White text.
            al_draw_text(built_in_font, al_map_rgb(255, 255, 255), 32 + 8, 32 + 8, ALLEGRO_ALIGN_LEFT, "You did it! You found your kittens!");
            al_draw_text(built_in_font, al_map_rgb(255, 255, 255), 32 + 8, 32 + 24, ALLEGRO_ALIGN_LEFT, "With time to spare, too! Now you can");
            al_draw_text(built_in_font, al_map_rgb(255, 255, 255), 32 + 8, 32 + 40, ALLEGRO_ALIGN_LEFT, "go home and enjoy noodles for dinner!");

            al_draw_text(built_in_font, al_map_rgb(255, 255, 255), 32 + 8, 32 + 72, ALLEGRO_ALIGN_LEFT, "Thanks for playing!");

            al_draw_text(built_in_font, al_map_rgb(255, 255, 255), 32 + 8, 32 + 94, ALLEGRO_ALIGN_LEFT, "Press escape to end the game.");

            // Draw scores.
            al_draw_textf(built_in_font, al_map_rgb(255, 255, 255), 32 + 8, 16 + 32 + 94 + 16, ALLEGRO_ALIGN_LEFT, "Score: %i", points);
            al_draw_textf(built_in_font, al_map_rgb(255, 255, 255), 32 + 8, 16 + 32 + 94 + 16 + 16, ALLEGRO_ALIGN_LEFT, "Bonus: %i", (1080 - (hours * 60) + minutes) * 10);
            al_draw_textf(built_in_font, al_map_rgb(255, 255, 255), 32 + 8, 16 + 32 + 94 + 16 + 16 + 16, ALLEGRO_ALIGN_LEFT, "Final: %i", points + ((1080 - (hours * 60) + minutes) * 10));
          }

          Engine.setDisplayScale(4.0);
        break;

        case 3:

          // Losing sequence.

          Engine.setDisplayScale(2.0);

          al_draw_text(built_in_font, al_map_rgb(255, 0, 0), 32 + 8, 32 + 8, ALLEGRO_ALIGN_LEFT, "You were not quick enough. Sadly, your");
          al_draw_text(built_in_font, al_map_rgb(255, 0, 0), 32 + 8, 32 + 8 * 3, ALLEGRO_ALIGN_LEFT, "kittens perished in the cold of night.");
          al_draw_text(built_in_font, al_map_rgb(255, 0, 0), 32 + 8, 32 + 8 * 5, ALLEGRO_ALIGN_LEFT, "From dust to dust...");
          al_draw_text(built_in_font, al_map_rgb(255, 0, 0), 32 + 8, 32 + 8 * 9, ALLEGRO_ALIGN_LEFT, "Press escape to end your misery.");

          // Draw scores.
          al_draw_textf(built_in_font, al_map_rgb(255, 0, 0), 32 + 8, 32 + 8 * 13, ALLEGRO_ALIGN_LEFT, "Score: %i", points);
          al_draw_text(built_in_font, al_map_rgb(255, 0, 0), 32 + 8, 32 + 8 * 15, ALLEGRO_ALIGN_LEFT, "Bonus: 0");
          al_draw_textf(built_in_font, al_map_rgb(255, 0, 0), 32 + 8, 32 + 8 * 17, ALLEGRO_ALIGN_LEFT, "Final: %i", points);

          Engine.setDisplayScale(4.0);
        break;

        case 4:

          // Credits.

          al_set_sample_instance_gain(background_sample_instance, 0.0);

          static float c_y = -(448 / 2);

          static string participants[13];

          participants[0] = "Amarillion";
          participants[1] = "Derezo";
          participants[2] = "Edgar Reynaldo";
          participants[3] = "Elias";
          participants[4] = "Eric Johnson";
          participants[5] = "GullRaDriel";
          participants[6] = "m c";
          participants[7] = "Mark Oates";
          participants[8] = "MiquelFire";
          participants[9] = "Onewing";
          participants[10] = "SiegeLord";
          participants[11] = "Takaaki Furukawa";
          participants[12] = "Vanneto";

          c_y += 1.0;

          if (c_y > 515) {

            // Credits have finished scrolling. Close the program.
            Engine.end();
          }

          al_draw_text(built_in_font, al_map_rgb(255, 0, 0), 768 / 8, 0 - (c_y / 2), ALLEGRO_ALIGN_CENTER, "KrampusHack 2016");

          Engine.setDisplayScale(2.0);

          al_draw_text(built_in_font, al_map_rgb(255, 0, 0), 768 / 4, 8 * 5 - c_y, ALLEGRO_ALIGN_CENTER, "Participants");

          for (unsigned int i = 0; i < 13; ++i) {

            al_draw_textf(built_in_font, al_map_rgb(255, 255, 255), 768 / 4, 8 * 5 + (24 * (i + 1)) - c_y, ALLEGRO_ALIGN_CENTER, "%s", participants[i].c_str());
          }

          al_draw_text(built_in_font, al_map_rgb(255, 0, 0), 768 / 4, 8 * 5 + (24 * 15) - c_y, ALLEGRO_ALIGN_CENTER, "Special Thanks");

          al_draw_text(built_in_font, al_map_rgb(255, 255, 255), 768 / 4, 8 * 5 + (24 * 16) - c_y, ALLEGRO_ALIGN_CENTER, "Robin Kettman");

          Engine.setDisplayScale(4.0);

          // Draw bowl of ramen noodles at the end.
          al_draw_bitmap_region(map_bitmap, 16 * 4, 0, 16, 16, 768 / 8 - 8, (8 * 5 + (24 * 16) / 2) - c_y / 2, 0);
        break;
      }

      Engine.flipDisplay();
    }
  }
}

void Krampus::initialize(const unsigned int seed) {

  Kittens.resize(number_of_kittens);

  Random.setSeed(seed);

  Engine.initialize(768, 448, "Kitten Kerfuffle");

  Engine.setDisplayScale(4.0);

  Engine.reserveSamples(5);

  loadResources();

  loop();

  destroyResources();
}

void Krampus::loadResources(void) {

  Engine.setResourcePath("data");

  map_bitmap = al_load_bitmap("png/map.png");

  Engine.checkReturn(map_bitmap);

  kitten_meow_sample = al_load_sample("ogg/kitten_meow.ogg");
  Engine.checkReturn(kitten_meow_sample);

  kitten_bitmap = al_load_bitmap("png/kitten.png");
  Engine.checkReturn(kitten_bitmap);

  Engine.checkReturn(Map.loadBitmap());
  Map.setRandomNumberGenerator(&Random);
  Map.loadTiles();

  for (unsigned int i = 0; i < number_of_kittens; ++i) {

    Kittens[i].setRandomNumberGenerator(&Random);
    Kittens[i].setMap(&Map);
    Kittens[i].spawn();

    // Give the kitten a name.
    Kittens[i].setName(getName());
  }

  Engine.checkReturn(Nini.loadBitmap());
  Nini.setObjects(&Map, &Random);
  Nini.spawn();

  // Use Allegro's built-in font. It looks decent enough.
  built_in_font = al_create_builtin_font();
  Engine.checkReturn(built_in_font);

  background_sample = al_load_sample("ogg/annoying.ogg");
  background_sample_instance = al_create_sample_instance(background_sample);
  Engine.checkReturn(background_sample);
  Engine.checkReturn(background_sample_instance);
  al_set_sample_instance_playmode(background_sample_instance, ALLEGRO_PLAYMODE_LOOP);
  al_attach_sample_instance_to_mixer(background_sample_instance, al_get_default_mixer());
}

void Krampus::destroyResources(void) {

  al_destroy_bitmap(map_bitmap);

  al_destroy_bitmap(kitten_bitmap);

  al_destroy_sample(kitten_meow_sample);

  Nini.destroyBitmap();

  Map.destroyBitmap();

  al_destroy_font(built_in_font);

  al_destroy_sample(background_sample);
  al_destroy_sample_instance(background_sample_instance);

  Engine.destroyResources();
}

string Krampus::getName(void) {

  static unsigned int times_called = 0;

  ++times_called;

  if (times_called > 10) {

    // Default name.
    return "Lost Kitten";
  }

  int selection = Random.getNumber() % 10;

  // Get a kitten name at random.
  string name = kitten_names[selection];

  if (name == "") {

    while (name == "") {

      // The selected name has already been used. Get another one.

      selection = Random.getNumber() % 10;

      name = kitten_names[selection];
    }
  }

  // Remove the name from the array, so it won't be selected again.
  kitten_names[selection] = "";

  return name;
}
