#include <inc/kitten.hpp>

Kitten::Kitten(void) {

  ticks = 0;
  frame = 0;

  found = false;

  keys[0] = false;
  keys[1] = false;
  keys[2] = false;
  keys[3] = false;

  is_moving = false;

  moving[0] = false;
  moving[1] = false;
  moving[2] = false;
  moving[3] = false;

  x = 32.0;
  y = 16.0 * 3;

  move_speed = 1.0;

  facing_direction[LEFT] = false;
  facing_direction[RIGHT] = false;

  reset = true;

  timer = 0;
  duration = 60;
}

bool Kitten::isFound(void) {

  return found;
}

float Kitten::getX(void) {

  return x;
}

float Kitten::getY(void) {

  return y;
}

void Kitten::move(const float cam_x, const float cam_y) {

  if (y + 16 < cam_y || y > cam_y + (448 / 4) || x + 16 < cam_x || x > cam_x + (768 / 4)) {

    // Kitten is outside of camera view. Don't update movement.

    return;
  }

  ++timer;

  if (timer > duration) {

    int new_direction = RandomNumberGenerator->getNumber() % 4;

    timer = 0;

    duration = RandomNumberGenerator->getNumber() % (60 * 2);

    keys[0] = false;
    keys[1] = false;
    keys[2] = false;
    keys[3] = false;

    keys[new_direction] = true;
  }

  if (!is_moving) {

    if (keys[0]) {

      // Attempt to move up.

      if (TileMap->getTiles()[(x / 16)][(y / 16) - 1].substr(5, 6) != "S") {

        is_moving = true;

        moving[0] = true;
        moving[1] = false;
        moving[2] = false;
        moving[3] = false;
      }
    }
    else if (keys[1]) {

      // Attempt to move down.

      if (TileMap->getTiles()[(x / 16)][(y / 16) + 1].substr(5, 6) != "S") {

        is_moving = true;

        moving[0] = false;
        moving[1] = true;
        moving[2] = false;
        moving[3] = false;
      }
    }
    else if (keys[2]) {

      // Attempt to move left.

      setFacingDirection(LEFT);

      if (TileMap->getTiles()[(x / 16) - 1][(y / 16)].substr(5, 6) != "S") {

        is_moving = true;

        moving[0] = false;
        moving[1] = false;
        moving[2] = true;
        moving[3] = false;
      }
    }
    else if (keys[3]) {

      // Attempt to move right.

      setFacingDirection(RIGHT);

      if (TileMap->getTiles()[(x / 16) + 1][(y / 16)].substr(5, 6) != "S") {

        is_moving = true;

        moving[0] = false;
        moving[1] = false;
        moving[2] = false;
        moving[3] = true;
      }
    }
  }
}

void Kitten::find(ALLEGRO_SAMPLE *sample) {

  found = true;

  al_play_sample(sample, 1.0, 0.0, 1.0, ALLEGRO_PLAYMODE_ONCE, 0);
}

void Kitten::spawn(void) {

  // Pick a random spot to spawn the kitten.
  unsigned int spawn_x = RandomNumberGenerator->getNumber() % TileMap->getTiles().size();
  unsigned int spawn_y = RandomNumberGenerator->getNumber() % TileMap->getTiles()[0].size();

  while (TileMap->getTiles()[spawn_x][spawn_y].substr(5, 6) != "C") {

    // Kitten spawned in non-designated tile. Try again.
    spawn_x = RandomNumberGenerator->getNumber() % TileMap->getTiles().size();
    spawn_y = RandomNumberGenerator->getNumber() % TileMap->getTiles()[0].size();
  }

  x = spawn_x * 16;
  y = spawn_y * 16;

  // Remove spawn marker. Make it solid though, so nothing can pass it before its first move.
  TileMap->getTiles()[spawn_x][spawn_y] = "00x00S";

  setFacingDirection(RandomNumberGenerator->getNumber() % 2);
}

void Kitten::update(void) {

  if (moving[0]) {

    moveUp();
  }
  else if (moving[1]) {

    moveDown();
  }
  else if (moving[2]) {

    moveLeft();
  }
  else if (moving[3]) {

    moveRight();
  }

  if (is_moving) {

    // Update animation.

    ++ticks;

    if (ticks > 8) {

      ticks = 0;

      ++frame;

      if (frame > 1) {

        frame = 0;
      }
    }
  }

  for (unsigned int i = 0; i < 2; ++i) {

    if (facing_direction[i]) {

      facing = i;
    }
  }
}

void Kitten::render(const float cam_x, const float cam_y, ALLEGRO_BITMAP *bitmap) {

  if (y + 16 < cam_y || y > cam_y + (448 / 4) + 16 || x + 16 < cam_x - 16 || x > cam_x + (768 / 4) + 16) {

    // Kitten is outside of camera view. Don't render.

    return;
  }

  al_draw_bitmap_region(bitmap, 16 * facing, 16 * frame, 16, 16, x - cam_x, y - cam_y, 0);
}

void Kitten::moveUp(void) {

  if (reset) {

    start_tile = y / 16;

    stop_tile = start_tile - 1;

    TileMap->getTiles()[x / 16][stop_tile] = TileMap->getTiles()[x / 16][stop_tile].substr(0, 5) + string("S");
    TileMap->getTiles()[x / 16][start_tile] = TileMap->getTiles()[x / 16][start_tile].substr(0, 5) + string("S");

    reset = false;
  }

  if (start_tile == 0) {

    start_tile = y / 16;
  }

  if (stop_tile == 0) {

    stop_tile = start_tile - 1;
  }

  if (y / 16 > stop_tile) {

    y -= move_speed;
  }
  else {

    TileMap->getTiles()[x / 16][start_tile] = TileMap->getTiles()[x / 16][start_tile].substr(0, 5) + string("L");

    reset = true;

    keys[0] = false;
    keys[1] = false;
    keys[2] = false;
    keys[3] = false;

    is_moving = false;

    moving[0] = false;
    moving[1] = false;
    moving[2] = false;
    moving[3] = false;

    stop_tile = 0;
    start_tile = 0;
  }
}

void Kitten::moveDown(void) {

  if (reset) {

    start_tile = y / 16;

    stop_tile = start_tile + 1;

    TileMap->getTiles()[x / 16][stop_tile] = TileMap->getTiles()[x / 16][stop_tile].substr(0, 5) + string("S");
    TileMap->getTiles()[x / 16][start_tile] = TileMap->getTiles()[x / 16][start_tile].substr(0, 5) + string("S");

    reset = false;
  }

  if (start_tile == 0) {

    start_tile = y / 16;
  }

  if (stop_tile == 0) {

    stop_tile = start_tile + 1;
  }

  if (y / 16 < stop_tile) {

    y += move_speed;
  }
  else {

    TileMap->getTiles()[x / 16][start_tile] = TileMap->getTiles()[x / 16][start_tile].substr(0, 5) + string("L");

    reset = true;

    keys[0] = false;
    keys[1] = false;
    keys[2] = false;
    keys[3] = false;

    is_moving = false;

    moving[0] = false;
    moving[1] = false;
    moving[2] = false;
    moving[3] = false;

    stop_tile = 0;
    start_tile = 0;
  }
}

void Kitten::moveLeft(void) {

  if (reset) {

    start_tile = x / 16;

    stop_tile = start_tile - 1;

    TileMap->getTiles()[stop_tile][y / 16] = TileMap->getTiles()[stop_tile][y / 16].substr(0, 5) + string("S");
    TileMap->getTiles()[stop_tile][y / 16] = TileMap->getTiles()[stop_tile][y / 16].substr(0, 5) + string("S");

    reset = false;
  }

  if (start_tile == 0) {

    start_tile = x / 16;
  }

  if (stop_tile == 0) {

    stop_tile = start_tile - 1;
  }

  if (x / 16 > stop_tile) {

    x -= move_speed;
  }
  else {

    TileMap->getTiles()[start_tile][y / 16] = TileMap->getTiles()[start_tile][y / 16].substr(0, 5) + string("L");

    reset = true;

    keys[0] = false;
    keys[1] = false;
    keys[2] = false;
    keys[3] = false;

    is_moving = false;

    moving[0] = false;
    moving[1] = false;
    moving[2] = false;
    moving[3] = false;

    stop_tile = 0;
    start_tile = 0;
  }
}

void Kitten::moveRight(void) {

  if (reset) {

    start_tile = x / 16;

    stop_tile = start_tile + 1;

    TileMap->getTiles()[stop_tile][y / 16] = TileMap->getTiles()[stop_tile][y / 16].substr(0, 5) + string("S");
    TileMap->getTiles()[stop_tile][y / 16] = TileMap->getTiles()[stop_tile][y / 16].substr(0, 5) + string("S");

    reset = false;
  }

  if (start_tile == 0) {

    start_tile = x / 16;
  }

  if (stop_tile == 0) {

    stop_tile = start_tile + 1;
  }

  if (x / 16 < stop_tile) {

    x += move_speed;
  }
  else {

    TileMap->getTiles()[start_tile][y / 16] = TileMap->getTiles()[start_tile][y / 16].substr(0, 5) + string("L");

    reset = true;

    keys[0] = false;
    keys[1] = false;
    keys[2] = false;
    keys[3] = false;

    is_moving = false;

    moving[0] = false;
    moving[1] = false;
    moving[2] = false;
    moving[3] = false;

    stop_tile = 0;
    start_tile = 0;
  }
}

void Kitten::setFacingDirection(const unsigned int direction) {

  facing_direction[LEFT] = false;
  facing_direction[RIGHT] = false;

  facing_direction[direction] = true;
}

void Kitten::setRandomNumberGenerator(Random *R) {

  RandomNumberGenerator = R;
}

void Kitten::setMap(Map *M) {

  TileMap = M;
}

void Kitten::setName(const string given_name) {

  name = given_name;
}

string Kitten::getName(void) {

  return name;
}
