#define MAX_BAD			50
#define MAX_GOOD			1
#define MAX_BULLET		100
#define MAX_STAR			100


#define SCREEN_WIDTH		640
#define SCREEN_HEIGHT	480
#define SCREEN_DRIVER	GFX_AUTODETECT_WINDOWED

#define INTERTIA			0.9
#define ENGINE_SPEED		1.3

#define MAX_LIFE			25
#define MAX_POWERUP		25

#define BULLET_SPEED		-5;

#define ROCK_SIZE		12
#define LIFE_COLOUR	makecol(200,120,50)

#define LASER_USAGE 0.1
#define SPREAD_USAGE 1

#define ROCK_COLOUR	makecol(100,100,100)
#define GOODIE_COLOUR makecol(0,255,0)
#define BULLET_COLOUR	makecol(255,100,100)
#define POWERUP_COLOUR makecol(200,0,255)
#include <allegro.h>


volatile int counter;
void inc_counter()
{
	counter++;
} END_OF_FUNCTION( inc_counter );

typedef struct thingtype
{
	int alive;
	int type;
	float x, y;
	float vx, vy;
} thingtype;


int main(void)
{
	BITMAP *buffer;

	thingtype you;
	thingtype baddie[ MAX_BAD ];
	thingtype bullet[ MAX_BULLET ];
	thingtype powerup;
	thingtype star[ MAX_STAR ];

	float score = 0;
	float level = 1.0;
	int done = 0;
	int i, c;
	int stillclicked = 0;
	int life = MAX_LIFE;
	float powerupamount;
	int poweruptype;
	
	char buf[255];

	allegro_init();
	install_keyboard();

	set_color_depth( 16 );
	if ( set_gfx_mode( SCREEN_DRIVER, SCREEN_WIDTH, SCREEN_HEIGHT, 0, 0 ) < 0 )
	{
		printf("Couldn't Init Graphics\n");
		exit( 1 );
	}
	buffer = create_bitmap( SCREEN_WIDTH, SCREEN_HEIGHT );

	LOCK_VARIABLE( counter );
	LOCK_FUNCTION( inc_counter );
	install_int_ex( inc_counter, BPS_TO_TIMER( 60 ) );

	you.x = SCREEN_WIDTH/2;
	you.y = SCREEN_HEIGHT - 20;

	//Init bullets
	for ( i = 0; i < MAX_BULLET; i++ )
		bullet[i].alive = 0;
	//Init Baddies
	for ( i = 0; i < MAX_BAD; i++ )
		baddie[i].alive = 0;

	powerup.alive = 0;
	powerupamount = 0;


	//Init stars
	for ( i = 0; i < MAX_STAR; i++ )
	{
		star[i].x = (int)(rand()%SCREEN_WIDTH);
		star[i].y = (int)(rand()%SCREEN_HEIGHT);
		star[i].vy = (int)(rand()%3) + 1;
		if ( star[i].vy == 1 )
			star[i].type = makecol(255,255,100);
		if ( star[i].vy == 2 )
			star[i].type = makecol(200,200,255);
		if ( star[i].vy == 3 )
			star[i].type = makecol(250,150,150);
	}

	while ( !done )
	{
		while ( counter > 0 )
		{
			if ( key[ KEY_ESC ] )
				done = 1;
			you.x += you.vx;
			you.y += you.vy;
			you.vx *= INTERTIA;
			you.vy *= INTERTIA;

			if ( you.x > (SCREEN_WIDTH - 20 ) )
			{
				you.vx *= -1;
				you.x = SCREEN_WIDTH - 20;
			}
			if ( you.x < 20 )
			{
				you.vx *= -1;
				you.x = 20;
			}

			if ( you.y > (SCREEN_HEIGHT - 20) )
				you.y = SCREEN_HEIGHT - 20;
			if ( you.y < 20 )
				you.y = 20;

			if ( key[ KEY_LEFT ] )
				you.vx -= ENGINE_SPEED;
			if ( key[ KEY_RIGHT ] )
				you.vx += ENGINE_SPEED;
			if ( key[ KEY_UP ] )
				you.vy -= ENGINE_SPEED;
			if ( key[ KEY_DOWN ] )
				you.vy += ENGINE_SPEED;

			//Laser Effect
			if ( (powerupamount > 0 ) && (poweruptype == 0 ) )
				stillclicked = 0;

			//Shooting bullets
			if ( key[ KEY_SPACE ] && !stillclicked )
			{
				for ( i = 0; (i <= MAX_BULLET) && ( bullet[ i ].alive ); i++ );
				if ( i < MAX_BULLET )
				{
					bullet[ i ].x = you.x;
					bullet[ i ].y = you.y - 5;
					bullet[ i ].vy = BULLET_SPEED;
					bullet[ i ].vx = 0;
					bullet[ i ].alive = 1;
					if ( (poweruptype == 0) && (powerupamount > 0 ) )
						powerupamount -= LASER_USAGE;

					if ( (poweruptype == 1 ) && (powerupamount > 0 ) )
					{
						for ( i = 0; (i <= MAX_BULLET) && ( bullet[ i ].alive ); i++ );
						if ( i < MAX_BULLET )
						{
							bullet[ i ].x = you.x;
							bullet[ i ].y = you.y - 5;
							bullet[ i ].vy = BULLET_SPEED;
							bullet[ i ].vx = 1;
							bullet[ i ].alive = 1;
						}
						for ( i = 0; (i <= MAX_BULLET) && ( bullet[ i ].alive ); i++ );
						if ( i < MAX_BULLET )
						{
							bullet[ i ].x = you.x;
							bullet[ i ].y = you.y - 5;
							bullet[ i ].vy = BULLET_SPEED;
							bullet[ i ].vx = -1;
							bullet[ i ].alive = 1;
						}
						powerupamount -= SPREAD_USAGE;

					}

				}
				stillclicked = 1;
			}

			if ( !key[ KEY_SPACE ] && stillclicked )
				stillclicked = 0;

			//Bullet Physics
			for ( i = 0; i < MAX_BULLET; i++ )
				if ( bullet[ i ].alive )
				{
					bullet[ i ].y += bullet[ i ].vy;
					bullet[ i ].x += bullet[ i ].vx;
					if ( bullet[ i ].y < -20 )
						bullet[ i ].alive = 0;
					
					//Bullets and Baddies Unite!
					for ( c = 0; c < MAX_BAD; c++ )
						if ( baddie[c].alive)
							if ( (bullet[i].x > baddie[c].x-ROCK_SIZE) && (bullet[i].x < baddie[c].x+ROCK_SIZE) &&
						   	  (bullet[i].y > baddie[c].y-ROCK_SIZE) && (bullet[i].y < baddie[c].y+ROCK_SIZE) )
							{
								if ( baddie[c].type || ( (poweruptype == 0)&&(powerupamount > 0) )  )
								{
									baddie[c].alive = 0;
									level += 0.05;
									score += 10;
								}
								bullet[i].alive = 0;

							}
				}

			//Baddie Physics (grey rectangles)
			for ( i = 0; i < MAX_BAD; i++ )
			{
				if ( !baddie[i].alive )
				{
					baddie[ i ].alive = 1;
					baddie[ i ].x = (int)(rand()%SCREEN_WIDTH);
					baddie[ i ].y = (int)(rand()%SCREEN_HEIGHT) * -1;
					baddie[ i ].vy = 1 + (int)(level/5);
					baddie[ i ].vx = (int)(rand()%3) - 1;

					c = (int)(rand()%10);
					baddie[i].type =  !( c <= level );
				}
				else
				{
					baddie[i].x += baddie[i].vx;
					baddie[i].y += baddie[i].vy;
					if ( baddie[i].y > SCREEN_HEIGHT + 20 )
						baddie[i].alive = 0;
					//Collisison detection with "you"
					if ( (you.x > baddie[i].x-(ROCK_SIZE+3)) && (you.x < baddie[i].x+(ROCK_SIZE+3)) &&
					     (you.y > baddie[i].y-(ROCK_SIZE+5)) && (you.y < baddie[i].y+(ROCK_SIZE+5)) )
					{
						life -= 1;
					}
				}

				if ( life <= 0 )
					done = 1;

			}

			//Score for just moving along
			score += 0.1;

			//Do Powerup
			if ( !powerup.alive && ((int)(rand()%500) == 1) )
			{
				powerup.alive = 1;
				powerup.x = (int)(rand()%SCREEN_WIDTH);
				powerup.y = -20;
				powerup.vx = 0.1;
				powerup.vy = 2;
				powerup.type = (int)(rand()%2);
			}
			if ( powerup.alive )
			{
				powerup.x += powerup.vx;
				powerup.y += powerup.vy;
				if ( powerup.y > SCREEN_HEIGHT )
					powerup.alive = 0;
				if ( (you.x > powerup.x-(ROCK_SIZE+3)) && (you.x < powerup.x+(ROCK_SIZE+3)) &&
				     (you.y > powerup.y-(ROCK_SIZE+5)) && (you.y < powerup.y+(ROCK_SIZE+5)) )
				{
					powerupamount = MAX_POWERUP;
					poweruptype = powerup.type;
					powerup.alive = 0;
				}
			}

			//Do stars
			for ( i = 0; i < MAX_STAR; i++ )
			{
				star[i].y += star[i].vy;
				if ( star[i].y > SCREEN_HEIGHT )
					star[i].y -= SCREEN_HEIGHT ;
			}

			counter--;
		}

		clear( buffer );
		//Draw Stars
		for ( i = 0; i < MAX_STAR; i++ )
			putpixel( buffer, star[i].x, star[i].y, star[i].type );

		//Draw You
		sprintf( buf, "Score: %i", (int)(score) );
		textout( buffer, font, buf, 10, 10, makecol(255,255,255) );
		rectfill( buffer, 0, SCREEN_HEIGHT - 10, (((float)life/MAX_LIFE)*SCREEN_WIDTH), SCREEN_HEIGHT-9, LIFE_COLOUR );
		rectfill( buffer, 0, SCREEN_HEIGHT - 15, (((float)powerupamount/MAX_POWERUP)*SCREEN_WIDTH), SCREEN_HEIGHT-14, POWERUP_COLOUR );
		rectfill( buffer, you.x - 3, you.y - 5, you.x + 3, you.y + 5, makecol(0,0,255) );

		//Draw Powerup
		if ( powerup.alive )
		{
			circle( buffer, powerup.x, powerup.y, ROCK_SIZE, makecol(100,100,255) );
			if ( powerup.type == 0 )
				textout_centre( buffer, font, "L", powerup.x, powerup.y, makecol(255,200,200) );
			else
				textout_centre( buffer, font, "S", powerup.x, powerup.y, makecol(200,255,200) );
		}


		//Draw Bullets
		for ( i = 0; i < MAX_BULLET; i++ )
			if ( bullet[ i ].alive )
				circlefill( buffer, bullet[i].x, bullet[i].y, 2, BULLET_COLOUR );

		//Draw Baddies
		for( i = 0; i < MAX_BAD; i++ )
			if ( baddie[i].alive )
				if ( baddie[i].type == 0 )
					rectfill( buffer, baddie[i].x - ROCK_SIZE, baddie[i].y - ROCK_SIZE, baddie[i].x + ROCK_SIZE, baddie[i].y + ROCK_SIZE, ROCK_COLOUR );
				else
					circlefill( buffer, baddie[i].x, baddie[i].y, ROCK_SIZE, GOODIE_COLOUR );

		blit( buffer, screen, 0, 0, 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT );
	}
	
	printf("Score %i\nThanks For Playing\n", (int)(score) );
	destroy_bitmap( buffer );
	allegro_exit();
} END_OF_MAIN()

