#define MAX_BULLET		40
#define MAX_BADDIE		5
#define MAX_PART			100


#define SIZE 12
#define BULLETSPEED -10

#include <allegro.h>

volatile int counter;
void inc_counter()
{
	counter++;
} END_OF_FUNCTION( inc_counter );


typedef struct thingtype
{
	int x, y, alive;
	float vx, vy;
	int value;
} thingtype;

int main(void)
{
	BITMAP *buffer;
	thingtype bullet[ MAX_BULLET ];
	thingtype baddie[ MAX_BADDIE ];

	thingtype you;

	float level;
	int missed;
	int i;
	int c;
	int score;
	char buf[255];
	int done;

	int stillclicked;

	level = 1.0;
	allegro_init();
	install_keyboard();
	install_mouse();

	set_color_depth( 16 );
	if ( set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0 ) )
	{
		printf("Couldn't init graphics\n");
		exit(1);
	}
	buffer = create_bitmap( 640, 480 );


	LOCK_VARIABLE( counter );
	LOCK_FUNCTION( inc_counter );

	install_int_ex( inc_counter, BPS_TO_TIMER(60) );

	you.y = 460;
	stillclicked = 0;

	done = 0;
	score = 0;
	missed = 0;

	while ( !done )
	{
		while ( counter > 0 )
		{
			you.x = mouse_x;
			if ( key[ KEY_ESC ] )
				done = 1;

			if ( missed > 10 )
				done = 1;
			//Baddies
			for ( i = 0; i < MAX_BADDIE; i++ )
			{
				if ( !baddie[ i ].alive )
				{
					baddie[ i ].alive = 1;
					baddie[ i ].x = (int)(rand()%100) * -1;
					baddie[ i ].y = (rand()%400);
					baddie[ i ].vx = level + ((rand()%10)/10);
				}
				if ( baddie[ i ].alive )
				{
					baddie[ i ].x += baddie[ i ].vx;
					if ( baddie[ i ].x > 640 )
					{
						baddie[ i ].alive = 0;
						missed++;

					}
				}
			}

			//Bullets
			if ( (mouse_b == 1 ) && (!stillclicked) )
			{
				for ( i = 0; (bullet[i].alive) && (i <= MAX_BULLET); i++ );

				if ( i < MAX_BULLET )
				{
					bullet[ i ].alive = 1;
					bullet[ i ].x = you.x;
					bullet[ i ].y = you.y - 5;
					bullet[ i ].vy = BULLETSPEED;
				}
				stillclicked = 1;
			}
			else

			if ( mouse_b == 0 )
				stillclicked = 0;

			for ( i = 0; i < MAX_BULLET; i++ )
				if ( bullet[ i ].alive )
				{
					bullet[ i ].y += bullet[ i ].vy;
					if ( bullet[ i ].y < -10 )
						bullet[ i ].alive = 0;
					//Bullets hitting baddies
					for ( c = 0; c < MAX_BADDIE; c++ )
						if ( (bullet[ i ].x > baddie[ c ].x - SIZE ) && (bullet[i].x < baddie[c].x+SIZE) && (bullet[i].y > baddie[c].y-SIZE) && (bullet[i].y < baddie[c].y+SIZE) && baddie[c].alive )
						{
							bullet[ i ].alive = 0;
							baddie[ c ].alive = 0;
							level += 0.1;
							score += level * 10;
						}
				}

			counter--;
		}
		clear( buffer );

		sprintf( buf, "Score: %i, Misses: %i", score, missed );
		textout( buffer, font, buf, 0, 0, makecol(255,255,255) );
		rectfill( buffer, you.x - 3, you.y - 5, you.x + 3, you.y + 5, makecol(255,0,0) );

		for ( i = 0; i < MAX_BADDIE; i++ )
			if ( baddie[ i ].alive )
				rectfill( buffer, baddie[ i ].x - SIZE, baddie[ i ].y - SIZE, baddie[ i ].x + SIZE, baddie[ i ].y + SIZE, makecol(0,255,0) );
		for ( i = 0; i < MAX_BULLET; i++ )
			if ( bullet[ i ].alive )
				putpixel( buffer, bullet[ i ].x, bullet[ i ].y, makecol(255,255,255) );
		blit( buffer, screen, 0, 0, 0, 0, 640, 480 );
	}

	printf("Game over\n");
	printf("Your Score: %i\n", score);


} END_OF_MAIN()


