
#include <stdio.h>
#include <iostream>
#include <fstream>
#include <allegro5/allegro.h>
#include <allegro5/allegro_image.h>

ALLEGRO_PATH * g_pLogPath = NULL;
std::ofstream logfile;

int screenshot(const char *destination_path, const char *gamename)
{
	ALLEGRO_PATH *path;
	char *filename, *filename_wp;
	struct tm *tmp;
	time_t t;
	unsigned int i;
	const char *path_cstr;

	if(!destination_path)
		path = al_get_standard_path(ALLEGRO_USER_DOCUMENTS_PATH);
	else
		path = al_create_path_for_directory(destination_path);

	if(!path)
		return -1;

	if(!gamename) {
		if( !(gamename = al_get_app_name()) ) {
			al_destroy_path(path);
			return -2;
		}
	}

	t = time(0);
	tmp = localtime(&t);
	if(!tmp) {
		al_destroy_path(path);
		return -3;
	}

	// Length of gamename + length of "-YYYYMMDD" + length of maximum [a-z] + NULL terminator
	if ( !(filename_wp = filename = (char *)malloc(strlen(gamename) + 9 + 2 + 1)) ) {
		al_destroy_path(path);
		return -4;
	}

	strcpy(filename, gamename);
	// Skip to the '.' in the filename, or the end.
	for(; *filename_wp != '.' && *filename_wp != 0; ++filename_wp);

	*filename_wp++ = '-';
	if(strftime(filename_wp, 9, "%Y%m%d", tmp) != 8) {
		free(filename);
		al_destroy_path(path);
		return -5;
	}
	filename_wp += 8;

	for(i = 0; i < 26*26; ++i) {
		if(i > 25) {
			filename_wp[0] = (i / 26) + 'a';
			filename_wp[1] = (i % 26) + 'a';
			filename_wp[2] = 0;
		}
		else {
			filename_wp[0] = (i % 26) + 'a';
			filename_wp[1] = 0;
		}

		al_set_path_filename(path, filename);
		al_set_path_extension(path, ".png");
		path_cstr = al_path_cstr(path, ALLEGRO_NATIVE_PATH_SEP);

		if (al_filename_exists(path_cstr))
			continue;

		al_save_bitmap(path_cstr, al_get_target_bitmap());
		free(filename);
		al_destroy_path(path);
		return 0;
	}

	free(filename);
	al_destroy_path(path);

	return -6;
}

void InitLog()
{
    g_pLogPath = al_get_standard_path(ALLEGRO_RESOURCES_PATH);
    al_set_path_filename(g_pLogPath, "Startrek.LOG");
    logfile.open(al_path_cstr(g_pLogPath,ALLEGRO_NATIVE_PATH_SEP));
}

void Log(const std::string a_strLog)
{
   logfile << a_strLog << "\n";
   logfile.flush();
}

