//
// ___.--------._____________,------' -----.`----._
// \                           `  -  .  _         /\
//  `.__________                           `  -  |  |                 __,---"-._
//              `-----------.______             ,'_/  ________,------'___________`----.___________
//                                 `-----.____,'      \===========================================/
//                                       |   :|        >--------------.----------.---------------'
//                                       /   :|   _,--'          ,--'  `--.__.--'
//                                      /   : |--'______________/_
//                                ,---,'    :  \__________________`--.
//                               `__________                        |/|
//                                          `------._               |\|
//                                                    `--._________,-'
//
//
//
//      Credits go to Paramount pictures for the star - trek concept and universe.


//      Copyright (C) 2015 - 2016   E.J.M. Martens
//
//      This program is free software; you can redistribute it and/or
//      modify it under the terms of the GNU General Public License
//      as published by the Free Software Foundation; either version 2
//      of the License, or (at your option) any later version.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.



#ifndef _TYPES
#define _TYPES

#define TSK_STANDARD     0
#define TSK_CONTACT      1
#define TSK_STRIKE       2

#define MODE_MAINSCREEN      1
#define MODE_ENGINEERING     2
#define MODE_NAVIGATION      3
#define MODE_COMMUNICATION   4

#define CS_UNCLOAKED	0
#define CS_CLOAKING     1
#define CS_CLOAKED      2
#define CS_DECLOAKING   3



#define DOCK_HEIGHT 18

#define GO_PLAYING 0
#define GO_LOOSE_CRITICAL 1
#define GO_ENTERPRISE     2
#define GO_TIME           3
#define GO_WIN_REACHED   10


#define RESERVED_SAMPLES    20
#define CLOAK_DELAY        800
#define MAX_ENERGY       10000
#define MAX_TORPEDOES       25
#define CORE_CRITICAL       25

#define ENTERPRISE_ENERGY_DELAY 20
#define ENTERPRISE_PHASERLOAD_DELAY 40
#define ENTERPRISE_SHIELDLOAD_DELAY 40
#define ENTERPRISE_REPAIR_DELAY 80

#define MAX_CREW_FEDERATION  500
#define MAX_CREW_ROMULAN     200
#define MAX_CREW_KLINGON_BC  400
#define MAX_CREW_KLINGON_BOP  50
#define MAX_STARBASE_HEALTH  200

#define ENTERPRISE_PHASER_POWER    1000
#define ROMULAN_BOP_PHASER_POWER   1000

#define PLASMA_DAMAGE     50
#define PHOTON_DAMAGE     30
#define DISRUPTOR_DAMAGE  10


#define DEGTORAD(x) ((x)*(ALLEGRO_PI/180.0))
#define RADTODEG(x) ((x)/(ALLEGRO_PI*180.0))

#define UNIVERSE_SIZE 200
#define SECTORSIZE 10000

#define KLINGON_EMPIRE_CENTER_X  (UNIVERSE_SIZE/2)+8
#define KLINGON_EMPIRE_CENTER_Y  (UNIVERSE_SIZE/2)+8
#define ROMULAN_EMPIRE_CENTER_X  (UNIVERSE_SIZE/2)+11
#define ROMULAN_EMPIRE_CENTER_Y  (UNIVERSE_SIZE/2)-11





enum GAME_STATE
{
    GS_EXIT = 0,
    GS_MENU,
    GS_LOAD,
    GS_SAVE,
    GS_GAME,
    GS_GAMEOVER,
    GS_TITLE,
    GS_CREDITS,
    GS_INTRO,
    GS_KEYMAP,
    GS_END
};







enum PARTICLE_EFFECT
{
    EFF_NORMAL,
    EFF_PROBE
};

enum MEMBER
{
    MEM_NONE =    0,
    MEM_NEUTRAL,
    MEM_FEDERATION,
    MEM_KLINGON,
    MEM_FERENGI,
    MEM_ROMULAN,
    MEM_OTHER,
    MEM_ENEMY,
    MEM_END
};

enum NAVIGATION_MODE
{
    NAV_NONE      = 0,
    NAV_TOPO,
    NAV_TACTICAL,
    NAV_OCCUPATION,
    NAV_END
};

enum HEALTH
{
    HLT_UNDEFINED=-1,
    HLT_HULL,
    HLT_WARPCORE,
    HLT_IMPULSE,
    HLT_THRUSTER,
    HLT_COMPUTER,
    HLT_SENSOR,
    HLT_SHIELD,
    HLT_PHASER,
    HLT_PHOTON,
    HLT_CLOAK
};

enum ID
{
    ID_NONE = 0,

    ID_ANIMATION,

    ID_PLANET_BOTTOM,
    ID_CLASS_A,
	ID_CLASS_B,
	ID_CLASS_L,
	ID_CLASS_N,
	ID_CLASS_M1,
    ID_CLASS_M2,
    ID_CLASS_M3,
    ID_PLANET_TOP,

    ID_STAR_BOTTOM,
    ID_STAR_BLUE,
	ID_STAR_WHITE,
	ID_STAR_YELLOW,
	ID_STAR_RED,
	ID_BLACK_HOLE,
	ID_STAR_TOP,

    ID_PROBE,

    ID_BULLET_BOTTOM,
    ID_DISRUPTOR,
    ID_PHOTON,
    ID_PROTON,
    ID_PLASMA,
    ID_BULLET_TOP,

    ID_SHIP_BOTTOM,
    ID_GALAXYCLASS,
    ID_PLAYER,
    ID_KLINGONBC,
    ID_KLINGONBOP,
    ID_ROMULANBOP,
    ID_SHIP_TOP,

    ID_BASE_BOTTOM,
    ID_FEDERATIONBASE,
    ID_KLINGON_BASE,
    ID_ROMULAN_BASE,
    ID_BASE_TOP,

    ID_SPECIAL_BOTTOM,
    ID_SPECIAL_TOP,
};


enum AI
{
    AI_NONE,
    AI_CHASE,
    AI_EVADE,
    AI_MOVE,
    AI_WANDER,
    AI_DOCK,
    AI_RELEASE,
    AI_MAX
};



const char  SIGNATURE[] = "File Version 0001A"; // for Load / Save

#endif
