//
// ___.--------._____________,------' -----.`----._
// \                           `  -  .  _         /\
//  `.__________                           `  -  |  |                 __,---"-._
//              `-----------.______             ,'_/  ________,------'___________`----.___________
//                                 `-----.____,'      \===========================================/
//                                       |   :|        >--------------.----------.---------------'
//                                       /   :|   _,--'          ,--'  `--.__.--'
//                                      /   : |--'______________/_
//                                ,---,'    :  \__________________`--.
//                               `__________                        |/|
//                                          `------._               |\|
//                                                    `--._________,-'
//
//
//
//      Credits go to Paramount pictures for the star - trek concept and universe.


//      Copyright (C) 2015 - 2016   E.J.M. Martens
//
//      This program is free software; you can redistribute it and/or
//      modify it under the terms of the GNU General Public License
//      as published by the Free Software Foundation; either version 2
//      of the License, or (at your option) any later version.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.



#ifndef _UNIVERSE
#define _UNIVERSE


#include "types.h"
#include "Engine.h"
#include "SpaceObject.h"
#include "Starbase.h"
#include <vector>
#include <math.h>



class TStarbase;

class GamePlanetRec
{
    friend class TEnterprise;

public:
	MEMBER m_Member;
	ID  m_PlanetType;
	int  m_nX;
	int  m_nY;
	int  m_nPopulation;
    GamePlanetRec();
};

class GameSpecialRec
{
    friend class TEnterprise;

public:
	MEMBER m_Member;
	ID  m_SpecialType;
	int m_nX;
	int m_nY;
	GameSpecialRec();
};


class GameStarbaseRec
{
    friend class TEnterprise;

public:
    MEMBER m_Member;
    ID m_StarbaseType;
	int m_nX;
	int m_nY;
	int m_nHealth[11];
	GameStarbaseRec(ID a_nStarbaseType);
};




class Sector
{
    friend class TEnterprise;

private:
bool m_blKnown;
char m_nMember;
char m_nKlingonBC;
char m_nKlingonBOP;
char m_nRomulanBOP;
char m_nFederation1;
char m_nFederation2;
char m_nFederation3;


vector<GamePlanetRec>  m_Planet;
vector<GameSpecialRec> m_Special;
vector<GameStarbaseRec> m_Starbase;

void StoreStarbase(TStarbase    * a_pStarbase);
void StorePlanet  (TSpaceObject * a_pPlanet);
void StoreSpecial (TSprite      * a_pSprite);

public:
GamePlanetRec * GetPlanetForStarbase();
Sector();

void Build(TEngine * a_pEngine);
void Store(TEngine * a_pEngine);

void Save(ofstream & a_SaveStream);
void Load(ifstream & a_LoadStream);

void Clear();

friend class Universe;
};




class Universe
{
    friend class TEnterprise;

private:
  Sector m_nSector[UNIVERSE_SIZE][UNIVERSE_SIZE];
  int m_nHomeX;
  int m_nHomeY;

protected:
  void BuildFederationSpace();
  void BuildKlingonSpace();
  void BuildRomulanSpace();

  void GenerateStarSystems();
  void GenerateBlueStarSystem(Sector & a_Sector);
  void GenerateWhiteStarSystem(Sector & a_Sector);
  void GenerateYellowStarSystem(Sector & a_Sector);
  void GenerateRedStarSystem(Sector & a_Sector);

  void GenerateHomeSector(Sector & a_Sector);

public:


  int m_nSectorCenter;
  int GetHomeX();
  int GetHomeY();

  Universe();

  void Generate();
  void BuildSector(int a_nX, int a_nY,TEngine * a_pEngine);
  void StoreSector(int a_nX, int a_nY,TEngine * a_pEngine);

  void Save(ofstream & a_SaveStream);
  void Load(ifstream & a_LoadStream);

};


#endif
