#include "Animation.h"

static std::vector<ALLEGRO_BITMAP *> g_lstAnimationFrames;



TAnimation::TAnimation(ANIMATION::TYPE a_Type,
                       double a_dX, double a_dY,
                       double a_dSpeed = 0,
                       double a_dAngle = 0,
                       int a_nZ = 100)
{
    m_Type   = a_Type;
    m_blReverse = false;

    m_dX = a_dX;
    m_dY = a_dY;
    m_nZ = a_nZ;
    m_nWait  = m_nDelay;

    m_dSpeed = a_dSpeed;
    m_dAngle = a_dAngle;
    m_ID=ID_ANIMATION;
    SetAnimation();
}

TAnimation::TAnimation()
{
   	m_nZ	        = 100;
	m_nFrame        =  0;
	m_blReverse     = false;
	m_blDestroyed   = false;
	m_blCanCollide  = false;
	m_ID            = ID_ANIMATION;
	m_Type          = ANIMATION::EXPLOSION;
	SetAnimation();
}



void TAnimation::SetAnimation()
{
    switch (m_Type)
    {
        case ANIMATION::EXPLOSION:
        m_nStartFrame = 0;
        m_nEndFrame   = 15;
        m_nDelay      = 6;
        m_Mode        = ONCE;
        break;


        case ANIMATION::SMOKE:
        m_nStartFrame = 16;
        m_nEndFrame   = 27;
        m_nDelay      = 2;
        m_Mode        = ONCE;

        break;

        case ANIMATION::WARP_IN:

        break;

        case ANIMATION::WARP_OUT:

        break;

        default:
          m_nFrame      = -1;
          m_nStartFrame = -1;
          m_nEndFrame   = -1;

    }
    m_nFrame = m_nStartFrame;
    m_nWait  = m_nDelay;
    SetImage(g_lstAnimationFrames[m_nFrame]);
}


void TAnimation::Do_ai()
{
	if (m_nWait <=0)
	{
		switch (m_Mode)
		{
            case ONCE:
            {
                 m_nFrame ++;
                 if ((m_nFrame >= m_nStartFrame)&&(m_nFrame <= m_nEndFrame))
                 {
                     SetImage(g_lstAnimationFrames[m_nFrame]);
                 }
                 else
                 {
                     m_blDestroyed = true;
                 }
            }
            break;

            case LOOP:
            {
                 m_nFrame ++;
                 if ((m_nFrame >= m_nStartFrame)&&(m_nFrame <= m_nEndFrame))
                 {
                     SetImage(g_lstAnimationFrames[m_nFrame]);
                 }
                 else
                 {
                     if (m_nFrame > m_nEndFrame)
                     {
                         m_nFrame = m_nStartFrame;
                     }
                     else if (m_nFrame < m_nStartFrame)
                     {
                         m_nFrame = m_nEndFrame;
                     }
                     SetImage(g_lstAnimationFrames[m_nFrame]);
                 }
            }
            break;

            case BACK_FORTH:

                 break;



		}
		m_nWait=m_nDelay;
	}
	else
	{
		m_nWait--;
	}
}


bool TAnimation::Init()
{
	ALLEGRO_PATH * pPath = al_get_standard_path(ALLEGRO_RESOURCES_PATH);
	al_append_path_component(pPath, "graphics");
    al_append_path_component(pPath, "Explosion");

    for (int i=0;i<16;i++)
	{
		char szFileName[255];
		sprintf(szFileName,"Expl%02d.png",i+1);
		al_set_path_filename(pPath,szFileName);
        ALLEGRO_BITMAP * pBitmap = al_load_bitmap(al_path_cstr(pPath,ALLEGRO_NATIVE_PATH_SEP));
	    if (pBitmap!=NULL)
	    {
	        g_lstAnimationFrames.push_back(pBitmap);
	    }
	    else
	    {
            al_destroy_path(pPath);
            return false;
	    }
	}

	al_destroy_path(pPath);

	pPath = al_get_standard_path(ALLEGRO_RESOURCES_PATH);
	al_append_path_component(pPath, "graphics");
    al_append_path_component(pPath, "smoke");

    for (int i=0;i<12;i++)
	{
		char szFileName[255];
		sprintf(szFileName,"S%02d.png",i);
		al_set_path_filename(pPath,szFileName);
        ALLEGRO_BITMAP * pBitmap = al_load_bitmap(al_path_cstr(pPath,ALLEGRO_NATIVE_PATH_SEP));
	    if (pBitmap!=NULL)
	    {
	        g_lstAnimationFrames.push_back(pBitmap);
	    }
	    else
	    {
            al_destroy_path(pPath);
            return false;
	    }
	}
	al_destroy_path(pPath);

	return true;
}


void TAnimation::DeInit()
{
    ALLEGRO_BITMAP * pBitmap = NULL;
    for (size_t i=0; i< g_lstAnimationFrames.size();i++)
    {
        pBitmap = g_lstAnimationFrames[i];
        al_destroy_bitmap(pBitmap);
    }
    g_lstAnimationFrames.clear();
}




