#ifndef CONSTANTS_H
#define CONSTANTS_H
//general
#define STARTING_LIVES	5
#define SPEED_MULT		1000
//playfield borders
#define TOP_GAME	50
#define BOT_GAME	30
#define LEFT_GAME	20
#define RIGHT_GAME	20
//playfield dimensions
#define PF_W		760
#define PF_H		550
//background colour
#define backCol		0
//size of background.bmp
#define BG_W		108
#define BG_H		108
//brick dimensions
#define BRICK_HEIGHT	18
#define BRICK_WIDTH		36
//ball dimensions
#define SMALL_RAD		4
#define LARGE_RAD		8
#define SMALL_W			8
#define LARGE_W			16
//max bricks per level
#define MAX_COLLUM	760 / BRICK_WIDTH
#define MAX_ROW		25
#define MAX_BRICKS			MAX_COLLUM * MAX_ROW
//used for collision detection
#define	TOP			1
#define SIDE		2
#define CORNER		3
//values used in level text files
#define NONE		' '
#define NEW_ROW		'\n'
#define NO_KILL		'I'
#define TYPE1		'1'
#define TYPE2		'2'
//max powerups
#define MAX_POWERUPS	10
//power up IDs
#define EXTRA_BALL		1
#define EXPAND_PADDLE	2
#define EXTRA_LIFE		3
#define FAST_BALL		4
#define FIRE_BALL		5
#define GROW_BALL		6
//powerup dimensions
#define PU_HEIGHT		12
#define PU_WIDTH		24
#define PU_BMP_WIDTH	96
//bounding box structure
struct bounds {
		float left, right;
		float top, bot;
		float xs, ys;
};


//returns 0 if no collision, TOP if idle hit from the top, SIDE, and CORNER used also.
int calcCollision(struct bounds hitter, struct bounds idle);
#endif

