#include "Special.h"

CSpecial::CSpecial(int newX, int newY)
{
	x = newX;
	y = newY;
	ys = 2*SPEED_MULT;
	type = (rand() % 6) + 1;
	xSize = PU_WIDTH;
	ySize = PU_HEIGHT;
}

CSpecial::CSpecial()
{
	x = 200;
	y = 200;
	ys = 2*SPEED_MULT;
	type = 5;
	xSize = 10;
	ySize = 10;
	type = rand() % 10;
}

//updates position on screen
//returns true if position is out of bounds (below SCREEN_H)
bool CSpecial::update()
{
	oldx = x;
	oldy = y;
	y += ys / SPEED_MULT;
	if(y > SCREEN_H)
		return true;
	else
		return false;
}

int CSpecial::checkPadCollision(CPaddle *pad)
{
	struct bounds hitter;
	struct bounds idle;
	hitter.bot = y + ySize;
	hitter.top = y;
	hitter.left = x;
	hitter.right = x + xSize;
	idle.bot = pad->getY() + pad->getYSize();
	idle.top = pad->getY();
	idle.left = pad->getX();
	idle.right = pad->getX() + pad->getXSize();
	
	if(((y + ySize >= pad->getY() && y + ySize <= pad->getY() + pad->getYSize()) 
		|| (y >= pad->getY() && y <= pad->getY() + pad->getYSize())
		|| (y + ySize >= pad->getY() && y <= pad->getY() + pad->getYSize()))
		&& ((x + xSize >= pad->getX() && x + xSize <= pad->getX() + pad->getXSize())
			|| (x >= pad->getX() && x <= pad->getX() + pad->getXSize())))
		return type;
	return 0;
}

int CSpecial::getType()
{
	return type;
}

void CSpecial::erase(BITMAP *bmp)
{
	rectfill(bmp, oldx, oldy, oldx + xSize, oldy + ySize, backCol);
}

void CSpecial::draw(BITMAP *bmp, BITMAP *powerUpSet)
{
	int xPos, yPos;
	xPos = (PU_WIDTH * (type - 1)) % PU_BMP_WIDTH;
	yPos = PU_HEIGHT * ((type - 1) / 4);
	
	switch(type)
	{
	case EXTRA_LIFE:	
	case EXPAND_PADDLE: 
	case EXTRA_BALL:	
	case FIRE_BALL:		
	case FAST_BALL:		
	case GROW_BALL:
						blit(powerUpSet, bmp, xPos, yPos, x, y, xSize, ySize);
						break;
	default:			rectfill(bmp, x, y, x + xSize, y + ySize, 1000);
						textprintf_centre(bmp, font, x + (xSize / 2), y + 2, makecol(0, 0, 31), "%d", type);
						break;
	}
}


CSpecial::~CSpecial(void)
{
}
