#include "Engine.h"
#include <fstream>

#ifdef local
#define DECLARE
#else 
#define DECLARE extern
#endif
DECLARE CSpecialList specialList;

//timer variable
volatile int timeInSec = 0;
volatile int inc_frame = 0;
volatile int FPS = 0;

//timer function
void inc_time(void)
{
   timeInSec++;
   FPS = inc_frame;
   inc_frame = 0;
}

END_OF_FUNCTION(inc_update);

CEngine::CEngine(void)
{
	buffer = NULL;
	bricks = NULL;
	paddle = NULL;
	ballList = NULL;
	backGround = NULL;
}

CEngine::~CEngine(void)
{
}

//loads a level from a text file and stores in levelBricks;
bool CEngine::loadLevel(char *fileName)
{
	//loading bricks
	for(int i = 0; i < MAX_BRICKS; i++)
		levelBricks[i] = '\0';
	std::ifstream levelFile(fileName);
    levelFile.read(levelBricks, sizeof(char) * MAX_BRICKS);
    levelFile.close();
	levelBricks[MAX_BRICKS - 1] = '\0';
	return true;
}

// outputs heads-up-display (player info)
void CEngine::outHud(BITMAP *bmp)
{
	rectfill(bmp, LEFT_GAME, 0, SCREEN_W - RIGHT_GAME, 50, backCol);
	rect(bmp, LEFT_GAME, 0, SCREEN_W - RIGHT_GAME, 50, makecol(0, 0, 255));
	line(bmp, LEFT_GAME, 0, LEFT_GAME, SCREEN_H, makecol(0, 0, 255));
	line(bmp, SCREEN_W - RIGHT_GAME, 0, SCREEN_W - RIGHT_GAME, SCREEN_H, makecol(0, 0, 255));

	textprintf(bmp, font, LEFT_GAME + 3, 20, 1000, "Level: %c Lives: %d  Score: %d Total Bricks: %d Bricks Left: %d  Time: %d", currentLevel, lives, score, bricks->getTotal(), bricks->getNumLeft(), timeInSec);
	for(int i = 0; i < MAX_POWERUPS; i++)
		textprintf(bmp, font, LEFT_GAME+(i*8)+3, 30, 1000, "%d", powerUps[i]);
	textprintf(bmp, font, LEFT_GAME+3, 40, 1000, "FPS: %d NumBalls: %d", FPS, ballList->getNumBalls());

}

void CEngine::outBackGround(BITMAP *bmp)
{
	int playField_W = SCREEN_W - RIGHT_GAME - LEFT_GAME;
	int playField_H = SCREEN_H - TOP_GAME;
	int playField_top = TOP_GAME;
	int playField_left = LEFT_GAME;
	int playField_right = SCREEN_W - RIGHT_GAME;
	int x, y;
	for(y = playField_top; y < playField_H; y += BG_H)
	{
		for(x = playField_left; x < playField_W; x += BG_W)
		{
			if((x + BG_W) < playField_right)
				blit(backGround, bmp, 0, 0, x, y, BG_W, BG_H);
			else
				blit(backGround, bmp, 0, 0, x, y, playField_W % BG_W, BG_H);
		}
	}
}
//puts double buffer onto screen after waiting for screen refresh
void CEngine::display()
{
	vsync();
	blit(buffer , screen , 0 , 0 , 0 , 0 , SCREEN_W , SCREEN_H );
	clear_to_color(buffer, backCol);
	inc_frame++;
}

void CEngine::output()
{
	if(!endgame && buffer != NULL)
	{
	if(isBallDead)
	{
		outBackGround(buffer);
		textout(buffer, font, "Ball lost to the abyss!", 200, 200, 1000);
		paddle->restart();
		ballList->restart(paddle, 5, 1000, 5, 5);
		ballList->draw(buffer);
		bricks->draw(buffer);
		outHud(buffer);
		display();
		while(!key[ KEY_ENTER ]);
		clear_to_color(buffer, backCol);
		isBallDead = false;
	}
	else if(win)
	{
		clear_to_color(buffer, backCol);
		outBackGround(buffer);
		paddle->restart();
		ballList->restart(paddle, 5, 1000, 5, 5);
		ballList->draw(buffer);
		bricks->draw(buffer);
		outHud(buffer);
		textout(buffer, font, "YOU WON!!!!", 200, 200, 1000);
		display();
		clear_keybuf();
		//readkey();
		while(!key[ KEY_ENTER ]);
		clear_to_color(buffer, backCol);
		isBallDead = false;
		win = false;
	}
	else
	{
		outBackGround(buffer);
		//ballList->erase(buffer);
		ballList->draw(buffer);
		//paddle->erase(buffer);
		paddle->draw(buffer);
		bricks->draw(buffer);
		//specialList.erase(buffer);
		specialList.draw(buffer);
		outHud(buffer);
		display();
	}
	}
	else if(buffer == NULL)
	{
		allegro_message("lost the buffer");
		exit(1);
	}
}

bool CEngine::process()
{
	int tempScore = 0;
	if(ballList)
	{
		if(ballList->isEmpty())
			isBallDead = true;
		else if(bricks->getNumLeft() == 0)
		{
			toNextLevel();
			win = true;
			free(bricks);
			bricks = new CBricks(levelBricks);
		}
		else
		{
			//bounceGame must come after bouncePaddle, or the ball might bounce out of the game and get "stuck"
			ballList->bouncePaddle(paddle);
			ballList->bounceGame();
			ballList->bounceBricks(bricks, &tempScore);
			ballList->update(paddle);
			specialList.checkPadCollision(paddle, powerUps, buffer);
			specialList.update();
			getPowerUps();
			score += tempScore * scoreMultiplier;
		}
	}
	return endgame;
}

void CEngine::getPowerUps()
{
	for(int i = 0; i < MAX_POWERUPS; i++)
	{
		if(powerUps[i] == 1)
		{
			switch(i)
			{
			case EXTRA_LIFE:	lives++;
								powerUps[i] = 0;
								break;
			case EXPAND_PADDLE:	paddle->grow();
								powerUps[i] = 0;
								break;
			case EXTRA_BALL:	ballList->newBall();
								powerUps[i] = 0;
								break;
			case FIRE_BALL:		ballList->toFire();
								powerUps[i] = 0;
								break;
			case FAST_BALL:		ballList->quicken();
								powerUps[i] = 0;
								break;
			default:			break;
			}
		}
	}
}


//increments the game level, which entails:
//  loading the brick text file, and initializing Bricks to new values
//  loading the background bitmap
//  killing all specials left
void CEngine::toNextLevel()
{
	currentLevel++;
	if(currentLevel > maxLevel)
	{
		textout(buffer, font, "YOU WON THE GAME!!!!", 200, 200, 1000);
		currentLevel = '1';
	}
	//fixing new levelX.txt filename
	strcpy(levelFileName, "levelX.txt");
	levelFileName[5] = currentLevel;
	//loading level
	loadLevel(levelFileName);
	//fixing backgroundX.bmp filename
	strcpy(backGroundFileName, "backgroundX.bmp");
	backGroundFileName[10] = currentLevel;
	//loading background bitmap
	backGround = load_bitmap(backGroundFileName, palette_bg);
	if(backGround == NULL)
	{
		allegro_message("problem loading background.bmp");
		exit(1);
	}
	//clear specials
	specialList.killAll();
}

// check to see if user wants to quit
// get new mouse coordinates for paddle
void CEngine::input()
{
	static int lastTime = 0;
	//cheatmode input
	if(cheatMode)
	{
		if(key[ KEY_F ]) 
			ballList->toFire();
		if(key[ KEY_PLUS_PAD ]) 
			ballList->newBall();
		if(key[ KEY_Q ])
		{
			if(lastTime != timeInSec)
			{
				lastTime = timeInSec;
				ballList->quicken();
			}
		}
		if(key[ KEY_E ])
			paddle->grow();
	}
	//normal input
	if(key[ KEY_ESC ]) endgame = TRUE;
	if(key[ KEY_SPACE])
			ballList->unStick(paddle);
	if(key[ KEY_P ])
	{
		textout(buffer, font, "***PAUSED***", SCREEN_W / 2, SCREEN_H / 2, makecol(255, 0, 0));
		display();
		rectfill(buffer, SCREEN_W / 2, SCREEN_H / 2, SCREEN_W / 2 + 100, SCREEN_H / 2 + 10, backCol);
		clear_keybuf();
		readkey();
		clear_keybuf();
	}
	paddle->update();
}

// must expand this to make a menu
void CEngine::welcome()
{
	int choiceSelect = 1;
	int choice = 0;
	while(choice == 0)
	{
		//output menu
		clear_to_color(buffer, backCol);
		//this is the "selector" 
		textout(buffer, font, "**", 175, 220 + choiceSelect * 10, 1000);	
		textout(buffer, font, "Welcome to NewAnoid!", 200, 200, 1000);
		//here starts the menu choices
		textout(buffer, font, "New Game: Regular", 200, 230, 1000);
		textout(buffer, font, "New Game: Cheat Mode", 200, 240, 1000);
		textout(buffer, font, "Quit", 200, 250, 1000);
		display();

		readkey();
		if(key[ KEY_DOWN ]) choiceSelect++;
		if(choiceSelect > 3)
			choiceSelect = 1;
		if(key[ KEY_UP ]) choiceSelect--;
		if(choiceSelect < 1)
			choiceSelect = 3;
		if(key[ KEY_ENTER ]) choice = choiceSelect;
	}
	clear_keybuf();
	if(choice == 2)
		cheatMode = true;
	else if(choice == 3)
		endgame = true;
	clear_to_color(buffer, backCol);
}

// initialize game. should create ball, paddle, load first level,
// and init game flags and player info
void CEngine::init()
{
	//init allegro stuff
	allegro_init();
    install_keyboard();
    install_mouse();
	install_timer();
	install_int(inc_time, 1000);
	srand( (unsigned)time( NULL ) );
	text_mode(-1);
	//screen should be 640, 480 with 16 bit colours
    set_color_depth( 16 );
    if ( set_gfx_mode( GFX_AUTODETECT , 640 , 480 , 0 , 0 ) < 0 )
    {
        set_color_depth( 15 );
        if ( set_gfx_mode( GFX_AUTODETECT , 640 , 480 , 0 , 0 ) < 0 )
        {
            allegro_message( "Unable to initialize graphics module\n % s\n" , allegro_error );
            exit(1);
        }
    }
	//paddle should only move this far
    set_mouse_range( 0 , 0 , SCREEN_W - LEFT_GAME , SCREEN_H - BOT_GAME );
	//making space for double buffer
    buffer=create_bitmap( SCREEN_W , SCREEN_H );
	clear_to_color(buffer, backCol);
	//init ball and paddle
	paddle = new CPaddle();
	ballList = new CBallList(paddle);
	//init level
	currentLevel = '0';
	maxLevel = '2';
	toNextLevel();
	bricks = new CBricks(levelBricks);
	//init flags
	isBallDead = false;
	endgame = false;
	cheatMode = false;
	//init player info
	lives = 5;
	score = 0;
	scoreMultiplier = 1.0;
	win = false;
	for(int i = 0; i < MAX_POWERUPS; i++)
		powerUps[i] = 0;
}
