#pragma once
#include <allegro.h>
#include <winalleg.h>
#include "constants.h"

class CBrick
{
public:
	CBrick();
	CBrick(int newX, int newY, int newType);
	~CBrick(void);
	void draw(BITMAP *bmp, BITMAP *brickSet, BITMAP *plant, bool incAnimation);
	void erase(BITMAP *bmp);
	void kill();
	bool isAlive();
	int isHit(struct bounds ballBounds);
	int getType();
	bool isIndestructable();

private:
	int x, y;
	//animation values (frame in bitmap, and whether animation is moving foward or backward
	int frame;
	int frameCont;
	int killFrame;
	bool goingUp;
	bool indestructable;
	//sound wavs
	SAMPLE *sound_die;

	int xSize, ySize;
	int col;	//colour
	bool isDead;
	bool hasCorpse;	//must erase from double buffer if true
	struct bounds myBounds;
	int type;	//which brick type it is
	int killAnimationCount;
	int killPixles[BRICK_WIDTH][BRICK_HEIGHT];
};
