#include "balllist.h"

//initializes ball list to include 1 ball
CBallList::CBallList(CPaddle *paddle)
{
	ballHead = new ball;
	ballHead->instance = CBall(paddle, 8, 1000, 5, 5);
	ballHead->next = 0;
	ballTail = ballHead;
	numBalls = 1;
}

CBallList::~CBallList(void)
{
	ball *p = ballHead;
	ball *prev = NULL;
	while(p)
	{
		prev = p;
		p = p->next;
		free(prev);
	}
}
void CBallList::unStick(CPaddle *pad)
{
	ball *p = ballHead;
	while(p)
	{
		p->instance.unStick(pad);
		p = p->next;
	}
}
void CBallList::toFire()
{
	ball *p = ballHead;
	while(p)
	{
		p->instance.toFire();
		p = p->next;
	}
}
void CBallList::newBall()
{
	if(numBalls < 5)
	{
		ballTail->next = new ball;
		ballTail = ballTail->next;
		ballTail->instance = ballHead->instance;
		ballTail->instance.skew();
		ballTail->next = NULL;
		numBalls++;
	}
}

void CBallList::restart(CPaddle *pad, int newRad, int newCol, int newXs, int newYs)
{
	ball *p = ballHead;
	ball *prev = NULL;
	while(p)
	{
		prev = p;
		p = p->next;
		free(prev);
	}
	ballHead = new ball;
	ballHead->instance = CBall(pad, newRad, newCol, newXs, newYs);
	ballHead->next = NULL;
	ballTail = ballHead;
	numBalls = 1;
}

void CBallList::bounceGame()
{
	ball *p = ballHead;
	while(p)
	{
		p->instance.bounceGame();
		p = p->next;
	}
}

void CBallList::bouncePaddle(CPaddle *paddle)
{
	ball *p = ballHead;
	while(p)
	{
		p->instance.bouncePaddle(paddle);
		p = p->next;
	}
}

void CBallList::bounceBricks(CBricks *bricks, int *score)
{
	ball *p = ballHead;
	while(p)
	{
		p->instance.bounceBricks(bricks, score);
		p = p->next;
	}
}
void CBallList::enlargen()
{
	ball *p = ballHead;
	while(p)
	{
		p->instance.enlargen();
		p = p->next;
	}
}
void CBallList::quicken()
{
	ball *p = ballHead;
	while(p)
	{
		p->instance.quicken();
		p = p->next;
	}
}

void CBallList::update(CPaddle *pad)
{
	ball *p = ballHead;
	ball *prev = NULL;
	ball *temp = NULL;
	while(p)
	{
		if(p->instance.isKilled())
		{
			if(prev)
				prev->next = p->next;
			else if(p == ballHead)
				ballHead = p->next;
			temp = p;
			if(p == ballTail)
				ballTail = prev;
			p = p->next;
			free(temp);
			numBalls--;
		}
		else
		{
			prev = p;
			p = p->next;
		}
	}
	p = ballHead;
	prev = NULL;
	while(p)
	{
		p->instance.update(pad);
		p = p->next;
	}
}

int CBallList::getNumBalls()
{
	return numBalls;
}

bool CBallList::isEmpty()
{
	if(ballHead == NULL)
		return true;
	else
		return false;
}

void CBallList::draw (BITMAP *bmp)
{
	ball *p = ballHead;
	while(p)
	{
		p->instance.draw(bmp);
		p = p->next;
	}
}

void CBallList::erase (BITMAP *bmp)
{
	ball *p = ballHead;
	while(p)
	{
		p->instance.erase(bmp);
		p = p->next;
	}
}