#pragma once
#include <allegro.h>
#include "Paddle.h"
#include "Bricks.h"
#include "constants.h"
#ifndef BALL_H
#define BALL_H

class CBall
{
public:
	CBall();
	CBall(CPaddle *pad, int rad, int col, int xs, int ys);
	~CBall();
	void draw(BITMAP *bmp);
	void erase(BITMAP *bmp);
	void update(CPaddle *pad);
	void bounceBricks(CBricks *bricks, int *score);
	void bouncePaddle(CPaddle *paddle);
	void bounceGame();
	void bounceX();
	void bounceY();
	bool isKilled();
	bool isStuck();
	void unStick(CPaddle *pad);
	void putOnPad(CPaddle *pad);
	void skew();
	void toFire();
	void quicken();
	void enlargen();
	void restart(CPaddle *Pad, int newRad, int newCol, int newXs, int newYs);


private:
	int x, y;
	float gameX, gameY;
	BITMAP *ballImage_s;
	PALETTE palette_s;
	BITMAP *ballImage_l;
	PALETTE palette_l;
	int oldx, oldy;
	int rad;
	float xs, ys;
	int speed;
	bool hasCorpse;
	bool isOnFire;
	bool isLarge;
	struct bounds myBounds;
	bool stuck;
};
#endif