#include "Ball.h"
#include "constants.h"
#include <math.h>
#define PIE		3.14159

CBall::CBall()
{
	rad = SMALL_RAD;
	x = 200;
	y = 200;
	gameX = x * SPEED_MULT;
	gameY = y * SPEED_MULT;
	xs = 200;
	ys = -400;
	myBounds.left = x - rad;
	myBounds.right = x + rad;
	myBounds.top = y - rad;
	myBounds.bot = y + rad;
	hasCorpse = false;
	speed = 5.5 * SPEED_MULT;
	stuck = false;
	isOnFire= false;

	ballImage_l = load_bitmap("ball_l.bmp", palette_l);
	if(ballImage_l == NULL)
	{
		allegro_message("problem loading ball_l bitmap.");
		exit(1);
	}
	ballImage_s = load_bitmap("ball_s.bmp", palette_s);
	if(ballImage_s == NULL)
	{
		allegro_message("problem loading ball_s bitmap.");
		exit(1);
	}
	isLarge= false;
}

// creates a circle in the (x, y) position with radius of rad,
// of colour col, moving with speed (xs, ys)
CBall::CBall(CPaddle *pad, int newRad, int newCol, int newXs, int newYs)
{
	rad = SMALL_RAD;
	putOnPad(pad);
	gameX = x * SPEED_MULT;
	gameY = y * SPEED_MULT;
	xs = newXs;
	ys = newYs;
	myBounds.left = x - rad;
	myBounds.right = x + rad;
	myBounds.top = y - rad;
	myBounds.bot = y + rad;
	hasCorpse = false;
	speed = 5.5 * SPEED_MULT;
	stuck = true;
	isOnFire = false;
	ballImage_l = load_bitmap("ball_l.bmp", palette_l);
	if(ballImage_l == NULL)
	{
		allegro_message("problem loading ball_l bitmap.");
		exit(1);
	}
	ballImage_s = load_bitmap("ball_s.bmp", palette_s);
	if(ballImage_s == NULL)
	{
		allegro_message("problem loading ball_s bitmap.");
		exit(1);
	}
	isLarge = false;
}

CBall::~CBall()
{
	/*if(ballImage)
		destroy_bitmap(ballImage);*/
}

void CBall::quicken()
{
	speed *= 1.2;
	xs *= 1.2;
	ys *= 1.2;
}

void CBall::draw (BITMAP *bmp)
{
	int x1 = x;
	int y1 = y;
	int x2 = x + (6+rad)*xs/(-SPEED_MULT);
	int y2 = y + (6+rad)*ys/(-SPEED_MULT);
	int xT = x;
	int yT = y;
	if(x1 < 0)
		x1 = 0;
	if(x1 >= SCREEN_W)
		x1 = SCREEN_W - 1;
	if(y1 < 0)
		y1 = 0;
	if(y1 >= SCREEN_H)
		y1 = SCREEN_H - 1;
	if(x2 < 0)
		x2 = 0;
	if(x2 >= SCREEN_W)
		x2 = SCREEN_W - 1;
	if(y2 < 0)
		y2 = 0;
	if(y2 >= SCREEN_H)
		y2 = SCREEN_H - 1;
	if(!isKilled())
	{
		if(isOnFire)
		{
			for(int i = 0; i < 15; i++)
			{
				if(rand()%2 == 0)
					xT = x2 + rand() % (rad+2);
				else
					xT = x2 - rand() % (rad+2);
				if(rand()%2 == 0)
					yT = y2 + rand() % (rad+2);
				else
					yT = y2 - rand() % (rad+2);
				if(x1 < 0)
					x1 = 0;
				if(xT >= SCREEN_W)
					xT = SCREEN_W - 1;
				if(yT < 0)
					yT = 0;
				if(yT >= SCREEN_H)
					yT = SCREEN_H - 1;
				do_line(bmp, x1, y1, xT, yT, makecol(rand()%200+55, 0, rand()%100), _putpixel16);
			}
			for(int i = rad; i > 0; i--)
				circlefill(bmp, x, y, i, makecol(rand()%100+155, 0, 0));
		}
		else if(isLarge)
			masked_blit(ballImage_l, bmp, 0, 0, x - LARGE_RAD, y - LARGE_RAD, LARGE_W, LARGE_W);
		else
			masked_blit(ballImage_s, bmp, 0, 0, x - SMALL_RAD, y - SMALL_RAD, SMALL_W, SMALL_W);
	}
}
void CBall::enlargen()
{
	isLarge = true;
}
void CBall::skew()
{
	xs = xs + 0.2 * xs;
	if(abs(xs) >= speed)
		xs = speed * 0.2;
	ys = - sqrt(speed * speed - xs * xs);
}
void CBall::toFire()
{
	isOnFire = true;
}
void CBall::erase (BITMAP *bmp)
{
	if(hasCorpse && !isOnFire)
	{
		circlefill(bmp, oldx, oldy, rad + 1, backCol);
		hasCorpse = false;
	}
	else if(hasCorpse && isOnFire) //doesn't work yet
		rectfill(bmp, oldx-xs/SPEED_MULT-10, oldy-ys/SPEED_MULT-10,oldx+xs/SPEED_MULT+10, oldy+ys/SPEED_MULT+10, backCol); 
}

void CBall::bouncePaddle(CPaddle *p)
{
	float ballPos = x - (2*p->getX() + p->getXSize()) / 2;
	float xVel = 2.0 * ballPos / p->getXSize();
	
	if(xVel > 0.9)
		xVel = 0.9;
	else if(xVel < -0.9)
		xVel = -0.9;

	//checking to see if ball hits paddle
	if(y + rad >= p->getY() && y - rad <= p->getY())
	{
		if(x > p->getX() && x < p->getX() + p->getXSize())
		{	
			xs = speed * xVel;
			ys = - sqrt(speed * speed - xs * xs);
			//minimum xs and ys should be 1
			if(xs >= -1 && xs <= 1)
				xs = 1;
			if(ys >= -1 && ys <= 1)
				ys = -1;
		}
	}
}

//checks to see if ball bounces off of bricks, and kills the bricks (in isHit())if it does.
//bounces accordingly
void CBall::bounceBricks(CBricks *bricks, int *score)
{
	int place;
	bool alwaysBounce;
	place = bricks->isHit(myBounds, score, &alwaysBounce);
	if(!isOnFire || alwaysBounce)
	{
		if(place == TOP)
			bounceY();
		else if(place == SIDE)
			bounceX();
		else if(place == CORNER)
		{
			bounceX();
			bounceY();
		}
	}
}

//check to see if ball bounces off of the playfield bounderies
//bounces accordingly
void CBall::bounceGame()
{
	if(((y - rad) <= TOP_GAME) && (((x - rad) <= LEFT_GAME) || ((x + rad) >= (SCREEN_W - RIGHT_GAME))))
	{
		bounceX();
		bounceY();
	}
	else if((y - rad) <= TOP_GAME)
		bounceY();
	else if(((x - rad) <= LEFT_GAME) || ((x + rad) >= (SCREEN_W - RIGHT_GAME)))
		bounceX();
}
void CBall::bounceX()
{
	xs = -xs;
}

void CBall::bounceY()
{
	ys = -ys;
}

//updates ball position based on speed;
void CBall::update (CPaddle *pad)
{
	// save current position
	oldx = x;
	oldy = y;

	// change position
	if(!stuck)
	{
		gameX += (int)xs;
		gameY += (int)ys;
		x = int(gameX / SPEED_MULT);
		y = int(gameY / SPEED_MULT);
	}
	else
	{
		putOnPad(pad);
		gameX = x * SPEED_MULT;
		gameY = y * SPEED_MULT;
	}
	if(isLarge)
		rad = LARGE_RAD;
	else
		rad = SMALL_RAD;
	myBounds.left = x - rad;
	myBounds.right = x + rad;
	myBounds.top = y - rad;
	myBounds.bot = y + rad;
	myBounds.xs = xs/SPEED_MULT;
	myBounds.ys = ys/SPEED_MULT;
	hasCorpse = true;
}

void CBall::putOnPad(CPaddle *pad)
{
	x = pad->getX() + (pad->getXSize() / 2) + 4;
	y = (pad->getY() - rad) + 1;
}

void CBall::unStick(CPaddle *pad)
{
	if(stuck)
	{
		stuck = false;
		bouncePaddle(pad);
	}
}

bool CBall::isStuck()
{
	return stuck;
}


bool CBall::isKilled()
{
	return y > SCREEN_H;
}
void CBall::restart(CPaddle *pad, int newRad, int newCol, int newXs, int newYs)
{
	rad = 8;
	putOnPad(pad);
	xs = newXs;
	ys = newYs;
	myBounds.left = x - rad;
	myBounds.right = x + rad;
	myBounds.top = y - rad;
	myBounds.bot = y + rad;
	hasCorpse = false;
	speed = 5.5*SPEED_MULT;
	stuck = true;
	isLarge = false;
}