#include "constants.h"

//returns 0 if no collision, TOP if idle hit from the top, SIDE, and CORNER used also.
int calcCollision(struct bounds hitter, struct bounds idle)
{
	float hitHorMid = (hitter.right + hitter.left) / 2.0;
	float iddleHorMid = (idle.right + idle.left) / 2.0;
	float hitVerMid = (hitter.top + hitter.bot) / 2.0;
	float iddleVerMid = (idle.top + idle.bot) / 2.0;
	//checking to see if idle is hit by hitter
	if(((hitter.right >= idle.left && hitter.right <= idle.right) ||
		(hitter.left >= idle.left && hitter.left <= idle.right)) &&
		((hitter.top <= idle.bot && hitter.top >= idle.top) ||
		(hitter.bot <= idle.bot && hitter.bot >= idle.top)))
	{
		//idle hit, now checking to see where it was hit
		if((hitVerMid >= idle.bot || hitVerMid <= idle.top) &&
			(hitHorMid <= idle.left || hitHorMid >= idle.right))
			return CORNER;
		if(hitVerMid >= idle.bot || hitVerMid <= idle.top)
			return TOP;
		else
			return SIDE;
	}
	else
		return 0;
}