#include <allegro.h>

int distance( int x1 , int y1 , int x2 , int y2 )
{
    int sx = ABS( x2 - x1 ) , sy = ABS( y2 - y1 );

    return fixtoi( fhypot( itofix( sx ) , itofix( sy ) ) );
}

int main()
{
    int x , y , r , g , b;
    BITMAP *bitmap , *behind , *buffer;
    int done = FALSE;

    allegro_init();
    install_keyboard();
    install_timer();
    install_mouse();

    set_color_depth( 16 );
    if ( set_gfx_mode( GFX_AUTODETECT , 640 , 480 , 0 , 0 ) < 0 )
    {
        set_color_depth( 15 );
        if ( set_gfx_mode( GFX_AUTODETECT , 640 , 480 , 0 , 0 ) < 0 )
        {
            allegro_message( "Unable initialize graphics module\n % s\n" , allegro_error );
            return  - 1;
        }
    }

    set_mouse_range( 0 , 0 , SCREEN_W - 31 , SCREEN_H - 31 );

    buffer=create_bitmap( SCREEN_W , SCREEN_H );
    bitmap=create_bitmap( 32 , 32 );
    behind=create_bitmap( 32 , 32 );
    clear_to_color( bitmap,makecol( 255 , 0 , 255 ) ); // bright pink
    
    // just for show we are going to PREtty up our buffer.
    for ( int i = 0; i < SCREEN_W; i++ )
    {
        for ( int j = 0; j < SCREEN_H; j++ )
        {   
            if ( i > = 320 )
            {
                r = distance( 629 , 469 , i , j );
            }
            else
            {
                r = distance( 10 , 10 , i , j );
            }

            if ( i > = 320 )
            {
                g = distance( 629 , 10 , i , j );
            }
            else
            {
                g = distance( 10 , 469 , i , j );
            }
            b = distance( 320 , 240 , i , j );

            if ( r > 255 ) r = 255;
            if ( g > 255 ) g = 255;
            if ( b > 255 ) b = 255;
            putpixel( buffer , i , j , makecol( 255 - r , 255 - g , 255 - b ) );
        }
    }

    // bright white
    circlefill( bitmap , 15 , 15 , 15 , makecol( 255 ,255 , 255 ) );

    // mask color
    circlefill( bitmap , 15 , 15 , 10 , makecol( 255 , 0 , 255 ) );

    while ( !done )
    {

        acquire_screen();

        // mouse_x and mouse_y might change in the middle of out process so
        // we don't want to mess things up. 
        x = mouse_x , y = mouse_y;

        blit( buffer , behind , x , y , 0 , 0 , 32 , 32 );
        
        draw_sprite( buffer , bitmap , x , y );

        blit( buffer , screen , 0 , 0 , 0 , 0 , SCREEN_W , SCREEN_H );
        
        blit( behind , buffer , 0 , 0 , x , y , 32 , 32 );
        release_screen();

        // Press Esc or click the mouse to exit
        if ( key[ KEY_ESC ] || ( mouse_b & 1 ) ) done = TRUE;
    }

    destroy_bitmap( bitmap );
    destroy_bitmap( behind );
    destroy_bitmap( buffer );

    return 0;
}
END_OF_MAIN();

