#include "SpecialList.h"

CSpecialList::CSpecialList(void)
{
	head = NULL;
	tail = NULL;
	powerUpSet = NULL;
}

CSpecialList::~CSpecialList(void)
{
}

void CSpecialList::init()
{
	powerUpSet = load_bitmap("pu_set.bmp", palette);
	if(powerUpSet == NULL)
	{
		allegro_message("problem loading powerup bitmap.");
		exit(1);
	}
}

void CSpecialList::draw(BITMAP *bmp)
{
	specialElem *p = head;
	while(p)
	{
		p->instance.draw(bmp, powerUpSet);
		p = p->next;
	}
}

void CSpecialList::erase(BITMAP *bmp)
{
	specialElem *p = head;
	while(p)
	{
		p->instance.erase(bmp);
		p = p->next;
	}
}

void CSpecialList::killAll()
{
	specialElem *p = head;
	specialElem *prev = NULL;
	while(p)
	{
		prev = p;
		p = p->next;
		free(prev);
	}
	head = NULL;
	tail = NULL;
}

void CSpecialList::checkPadCollision(CPaddle *pad, int *powerUps, BITMAP *buffer)
{
	specialElem *p = head;
	specialElem *temp = NULL;
	specialElem *prev = NULL;
	int type = 0;
	
	while(p)
	{
		type = p->instance.checkPadCollision(pad);
		if(type != 0)
		{
			powerUps[type] = 1;
			temp = p;
			if(p == tail)
				tail = prev;
			if(prev)
				prev->next = p->next;
			else
				head = p->next;
			p = p->next;
			temp->instance.update();
			//temp->instance.erase(buffer);
			free(temp);
		}
		if(p)
		{
			prev = p;
			p = p->next;
		}
	}
}

//updates position of all special instances on screen
//handles destruction of special if it drops below screen
void CSpecialList::update()
{
	specialElem *p = head;
	specialElem *prev = NULL;
	specialElem *temp;
	while(p)
	{
		if(p->instance.update())
		{
			temp = p;
			if(p == tail)
				tail = prev;
			if(prev)
				prev->next = p->next;
			else
				head = p->next;
			p = p->next;
			free(temp);
		}
		if(p)
		{
			prev = p;
			p = p->next;
		}
	}
}

bool CSpecialList::isEmpty()
{
	if(head)
		return true;
	else
		return false;
}

void CSpecialList::insert(CSpecial *v)
{
	if((v->getType() >= 1) && (v->getType() <= 6)) //check to see if the type is supported
	{
		if(head == NULL)
		{
			head = new specialElem;
			head->instance = *v;
			head->next = 0;
			tail = head;
		}
		else
		{
			tail->next = new specialElem;
			tail = tail->next;
			tail->instance = *v;
			tail->next = NULL;
		}
	}
}