#include "paddle.h"
#include "constants.h"

CPaddle::CPaddle(void)
{
	x = SCREEN_W / 2;
	y = SCREEN_H - 32;
	xSize = 100;
	ySize = 4;

	col = 2000;
}

CPaddle::~CPaddle(void)
{
}

void CPaddle::draw(BITMAP *bmp)
{
	rectfill(bmp, x, y, x + xSize, y + ySize, col);
}

void CPaddle::erase(BITMAP *bmp)
{
	rectfill(bmp, oldX, y, oldX + xSize, y + ySize, backCol);
}

void CPaddle::update()
{
	oldX = x;
	x = mouse_x;
	if((x + xSize) > SCREEN_W - RIGHT_GAME)
		x = SCREEN_W - RIGHT_GAME - xSize;
	else if(x < LEFT_GAME)
		x = LEFT_GAME;
}
void CPaddle::restart()
{
	xSize = 100;
	ySize = 4;
}

//increases paddle size
void CPaddle::grow()
{
	xSize += 5;
}
int CPaddle::getY()
{
	return y;
}
int CPaddle::getX()
{
	return x;
}
int CPaddle::getXSize()
{
	return xSize;
}
int CPaddle::getYSize()
{
	return ySize;
}
