#pragma once
#ifndef ENGINE_H
#define ENGINE_H

#include <allegro.h>
#include <winalleg.h>
#include "Ball.h"
#include "BallList.h"
#include "Paddle.h"
#include "Brick.h"
#include "Bricks.h"
#include "constants.h"
#include "SpecialList.h"

class CEngine
{
public:
	CEngine(void);
	~CEngine(void);
	void init();
	void welcome();
	void input();
	bool process();
	void output();
	void display();		//helper func for output()
	//void goodbye();
	//void freeAll();
	void outHud(BITMAP *bmp);
	void outBackGround(BITMAP *bmp);
	bool loadLevel(char *fileName);
	void toNextLevel();
	void getPowerUps();
private:
	CBallList *ballList;
	//graphics stuff
	BITMAP *buffer;
	BITMAP *backGround;
	PALETTE palette_bg;
	BITMAP *stars;
	//game flags
	bool endgame;
	bool isBallDead;	//true when ball falls off screen
	bool win;
	bool wonGame;
	bool cheatMode;
	bool isPlaying;
	bool lostGame;
	bool paused;
	//player info
	int lives;
	int score;
	float scoreMultiplier;
	int currentLevel;
	int maxLevel;
	int powerUps[MAX_POWERUPS];
	//actors
	CBricks *bricks;
	//CBall *ball;
	CPaddle *paddle;
	//level info
	char levelBricks[MAX_BRICKS];
	char levelFileName[30];
	char backGroundFileName[30];
};
#endif