#include "bricks.h"

volatile bool doAnimation = false;

void inc_animation(void)
{
   doAnimation = true;
}
END_OF_FUNCTION(inc_time);

//checks to see if all bricks are hit by the ball. Kills the brick if it is. Returns
//the place where the ball hit (CORNER, SIDE, or TOP). Score of bricks hit is returned
//by reference.
int CBricks::isHit(struct bounds ballBounds, int *score, bool *alwaysBounce)
{
	int place1 = 0;
	int place2 = 0;
	int row, collum;
	bool done = false;

	*alwaysBounce = false;
	for(row = 0; !done && row < MAX_ROW; row++)
	{
		for(collum = 0; !done && collum < MAX_COLLUM; collum++)
		{
		if(place1 == 0 && list[row][collum])
		{
			place1 = list[row][collum]->isHit(ballBounds);
			if(place1 && list[row][collum]->isIndestructable())
				*alwaysBounce = true;
			else if(place1)
			{
				*score += 100;		//MUST CHANGE TO BE DYNAMIC
				list[row][collum]->kill();
				numLeft--;
			}
		}
		else if(place2 == 0 && list[row][collum])
		{
			place2 = list[row][collum]->isHit(ballBounds);
			if(place2 && list[row][collum]->isIndestructable())
				*alwaysBounce = true;
			else if(place2)
			{
				*score += 100;		//MUST CHANGE TO BE DYNAMIC
				list[row][collum]->kill();
				numLeft--;
			}
		}
		else if(list[row][collum])
			done = true;
		}
	}
	if(place1 && place2)
		return TOP;
	else
		return place1;
}


CBricks::CBricks(char *level)
{
	int row, collum;
	int i = 0;
	int numRow = 10;
	total = 0;
	strcpy(levelInfo, level);
	install_int(inc_animation, 100); //for animating the bricks

	for(row = 0; row < MAX_ROW; row++)
		for(collum = 0; collum < MAX_COLLUM; collum++)
			list[row][collum] = NULL;
	for(row = 0; row < MAX_ROW; row++)
	{
		for(collum = 0; collum < MAX_COLLUM && levelInfo[i] != NEW_ROW; collum++, i++)
		{
			if((levelInfo[i] >= TYPE1 && levelInfo[i] <= TYPE2))
			{	
				total++;
				list[row][collum] = new CBrick(LEFT_GAME + collum*(BRICK_WIDTH), TOP_GAME + (row)*BRICK_HEIGHT, levelInfo[i]);
			}
			else if(levelInfo[i] == NO_KILL)
				list[row][collum] = new CBrick(LEFT_GAME + collum*(BRICK_WIDTH), TOP_GAME + (row)*BRICK_HEIGHT, levelInfo[i]);
		}
		i++;
	}
	numLeft = total;
	
	//load brickset
	brickSet = load_bitmap("bricks.bmp", palette);
	if(brickSet == NULL)
	{
		allegro_message("problem loading bitmap.");
		exit(1);
	}
	//load brickset
	plant = load_bitmap("brick_set.bmp", palette);
	if(plant == NULL)
	{
		allegro_message("problem loading brick_set bitmap.");
		exit(1);
	}
}

CBricks::~CBricks(void)
{
	/*if(brickSet)
		destroy_bitmap(brickSet);*/
}

int CBricks::getTotal()
{
	return total;
}

int CBricks::getNumLeft()
{
	return numLeft;
}

void CBricks::draw(BITMAP *bmp)
{
	int row, collum;
	bool incAnimation = doAnimation;
	for(row = 0; row < MAX_ROW; row++)
	{
		for(collum = 0; collum < MAX_COLLUM; collum++)
		{
			if(list[row][collum] != NULL)
				list[row][collum]->draw(bmp, brickSet, plant, incAnimation);
		}
	}
	doAnimation = false;
}