#include "brick.h"
#include "constants.h"
#include "SpecialList.h"
CSpecialList specialList;

CBrick::CBrick()
{
}

//
int CBrick::isHit(struct bounds ballBounds)
{
	int place;
	if(isDead)
		return 0;
	place = calcCollision(ballBounds, myBounds);
	return place;
}

CBrick::CBrick(int newX, int newY, int newType)
{
	x = newX;
	y = newY;
	isDead = false;
	myBounds.left = x;
	myBounds.right = x + BRICK_WIDTH;
	myBounds.top = y;
	myBounds.bot = y + BRICK_HEIGHT;
	hasCorpse = false;
	type = newType;	//must change this to be dynamic!
	killAnimationCount = 0;
	frame = 0;
	frameCont = rand() % 5;
	killFrame = 0;
	goingUp = true;
	sound_die = load_sample("die.wav");
	if(sound_die == NULL)
	{
		sound_die = load_sample("die2.wav");
		if(sound_die == NULL)
		{
		allegro_message("couldn't load die.wav");
		exit(1);
		}
	}
	if(type == NO_KILL)
		indestructable = true;
	else
		indestructable = false;
}

bool CBrick::isIndestructable()
{
	return indestructable;
}

CBrick::~CBrick(void)
{
}

void CBrick::kill()
{
	//1 in 4 chance to create a powerups upon death
	killFrame = 0;
	if((rand()%3)==0)
	{
		CSpecial newSpecial(x, y);
		specialList.insert(&newSpecial);
	}
	isDead = true;
	hasCorpse = true;
	//do death sound
	if(sound_die)
		play_sample(sound_die, 255, 126, 500 * (rand() % 6), 0);
}

void CBrick::draw(BITMAP *bmp, BITMAP *brickSet, BITMAP *plant, bool incAnimation)
{
	if(incAnimation && frame != 0)
	{
		killFrame++;
		frameCont++;
		if(frameCont >= 6)
			frameCont = 0;
		if(goingUp)
		{
			frame++;
			if(frame == 6)
			{
				frame = 5;
				goingUp = false;
			}
		}
		else
		{
			killFrame--;
			frame--;
			if(frame == -1)
			{
				frame = 0;
				goingUp = true;
			}
		}
	}
	else if(incAnimation)
	{
		killFrame++;
		frameCont++;
		if(frameCont >= 6)
			frameCont= 0;
		if((rand() % 100) == 0)
		{
			frame++;
			goingUp = true;
		}
	}

	if(type == TYPE1)
	{
		if(!isDead)
		  masked_blit(plant, bmp, (36 * frame), 0, x, y, BRICK_WIDTH, BRICK_HEIGHT);
		else if(killFrame < 4)
			masked_blit(plant, bmp, (36 * (killFrame)), 18, x, y, BRICK_WIDTH, BRICK_HEIGHT);
	}
	else if(type == TYPE2)
	{
		if(!isDead)
			masked_blit(plant, bmp, (36 * frame), 36, x, y, BRICK_WIDTH, BRICK_HEIGHT);
		else if(killFrame < 4)
			masked_blit(plant, bmp, (36 * (killFrame)), 54, x, y, BRICK_WIDTH, BRICK_HEIGHT);
	}
	else if(type == NO_KILL)
		masked_blit(plant, bmp, (36 * frameCont), 72, x, y, BRICK_WIDTH, BRICK_HEIGHT);
}

void CBrick::erase(BITMAP *bmp)
{
	rectfill(bmp, x, y, x + xSize, y + ySize, backCol);
	hasCorpse = false;
}

bool CBrick::isAlive()
{
	return !isDead;
}
