#pragma once

#include <allegro5/allegro.h>
#include <allegro5/allegro_image.h>
#include <allegro5/allegro_font.h>
#include <allegro5/allegro_ttf.h>

#include <cstdio>

#include <string>
#include <map>
#include <vector>

#include "Pos2D.h"
#include "Sprite.h"

class GraphicsHandler
{
    public:
    GraphicsHandler(int width,int height);
    void drawSprite(Sprite spr,Pos2D pos);
    void drawText(std::string text,Pos2D pos);
    void drawText(int text,Pos2D pos);

    Sprite getSprite(std::string key);

    int screenWidth;
    int screenHeight;
    private:
    std::map<std::string,Sprite> spritePool;
    ALLEGRO_FONT* fontNormal;
};
