#pragma once
#include <allegro5/allegro.h>
#include <allegro5/allegro_image.h>

#include <stdlib.h>
#include <time.h>
#include <string>
#include <vector>
#include <iostream>

#include "GraphicsHandler.h"
#include "SoundHandler.h"
#include "ScoreHandler.h"
#include "Pos2D.h"
#include "Entity.h"
#include "City.h"
#include "Enemy.h"
#include "Bullet.h"
#include "Explosion.h"

class Controller
{
  public:
    Controller(GraphicsHandler* g,SoundHandler* s);

    GraphicsHandler* getGraphicsHandler();
    SoundHandler* getSoundHandler();

    bool leftPressed;
    bool rightPressed;
    Pos2D mousePosition;

    bool spacePressed;

    const int POINTFORENEMY = 10;
  private:
    void gameLoop();
    void handleLogic();
    void handleDrawing();
    void handlePostLogic();
    void spawnEnemy();
    void decreaseCooldown();
    void checkShoot();
    void enemyShoot();
    void endGame();
    void insertEntity(Entity* entity);

    void displayHUD();

    void handleDeathScreen();
    void restartGame();

    //game states
    bool endNow;
    bool deadNow;
    /////////////

    GraphicsHandler* gh;
    SoundHandler* sh;
    ScoreHandler scoreHandler;

    ALLEGRO_TIMER* currentTimer;
    ALLEGRO_EVENT_QUEUE* currentQueue;

    City* city;
    std::vector<Entity*> entityArray;
    std::vector<Enemy*> enemyArray;
    std::vector<Bullet*> bulletArray;
    std::vector<Explosion*> explosionArray;

    int maxEnemyCooldown;
    int currentEnemyCooldown;
};
