

#process "base"

class auto_att_right;
class auto_allocate;
class auto_harvest;
class auto_att_left;
class auto_att_fwd;

core_static_hex_A, 6840, 
  {object_repair, 0},
  {object_downlink, 0, 
    {component_bowl, // member 1
      {object_uplink, 0},
      {object_interface, 0},
      {object_interface_depth, 0},
      {object_storage, 0},
      {object_pulse_l:auto_att_fwd, 0},
    }
  },
  {object_allocate:auto_allocate, 0},
  {object_downlink, 0, 
    {component_bowl, // member 2
      {object_uplink, 0},
      {object_interface_depth, 0},
      {object_interface, 0},
      {object_storage, 0},
      {object_pulse_l:auto_att_right, -643},
    }
  },
  {object_build, 0},
  {object_downlink, 0, 
    {component_bowl, // member 4
      {object_uplink, 0},
      {object_interface, 0},
      {object_interface_depth, 0},
      {object_harvest:auto_harvest, 0},
      {object_pulse_l:auto_att_left, -624},
    }
  }

#code


enum
{
TARGET_PARENT, // TM 0 is set to parent process

TM_HARVESTER_0,
TM_HARVESTER_1,
//TM_HARVESTER_2,
TM_BUILDER_0,
TM_COMMANDER_0,
TM_COMMANDER_1,
TM_COMMANDER_2,

TARGET_LEFT, // target of directional left attack
TARGET_RIGHT, // target of directional right attack
TARGET_FRONT, // target of directional front attack

TM_END
};

enum
{
TEMPLATE_BASE,
TEMPLATE_BUILDER,
TEMPLATE_HARVESTER,
TEMPLATE_COMMANDER,
TEMPLATE_ATTACKER

};

// Variable declaration and initialisation
//  (note that declaration and initialisation cannot be combined)
//  (also, variables retain their values between execution cycles)
int core_x, core_y; // location of core
core_x = get_core_x(); // location is updated each cycle
core_y = get_core_y();
int angle; // direction process is pointing
 // angles are in integer degrees from 0 to 8192, with 0 being right,
 // 2048 down, 4096 left and 6144 up.
angle = get_core_angle(); // angle is updated each cycle


int build_result; // build result code (returned by build call)
int i;

int special_build_counter;


if (special_build_counter < 6)
{
 build_result = build_process(TEMPLATE_ATTACKER, cos(angle, 400), sin(angle, 400), angle, -1);
 if (build_result == 1)
  special_build_counter ++;
 goto finished_building;
}


// check whether each entry in targetting memory has something:
for (i = TM_HARVESTER_0; i < TM_BUILDER_0; i ++)
{
 if (process[i].visible() <= 0) // doesn't exist
 {
  build_result = build_process(TEMPLATE_HARVESTER, cos(angle, 400), sin(angle, 400), angle, i);
  if (build_result == 1)
   special_build_counter = 3;
  goto finished_building;
 }
}

for (i = TM_COMMANDER_0; i < TM_END; i ++)
{
 if (process[i].visible() <= 0) // doesn't exist
 {
  build_result = build_process(TEMPLATE_COMMANDER, cos(angle, 400), sin(angle, 400), angle, i);
  if (build_result == 1)
   special_build_counter = 0;
  goto finished_building;
 }
}




finished_building:

auto_harvest.gather_data();

auto_allocate.allocate_data(4); // actually I think the maximum is 2. Doesn't matter


auto_att_left.attack_scan(-3000, 400, TARGET_LEFT);

auto_att_right.attack_scan(3000, 400, TARGET_RIGHT);

auto_att_fwd.attack_scan(0, 400, TARGET_FRONT);

charge_interface_max(); // charges the process' interface. Since the interface is shared across all
 // components with interface objects, this call is not specific to any object or class.
 // charge_interface_max() charges the interface using any power left over.


if (get_power_left() > 120)
  restore_self(); // tries to restore any destroyed components

if (get_power_left() > 120)
  repair_self(); // tries to repair any damaged components
