

#process "base"
class auto_allocate;
class auto_harvest;

core_static_pent, 0, 
  {object_repair_other, 0},
  {object_allocate:auto_allocate, 0},
  {object_storage, 0},
  {object_harvest:auto_harvest, 0},
  {object_build, 0},
#code




// Process AI modes (these reflect the capabilities of the process)
enum
{
  MODE_IDLE, // process isn't doing anything ongoing
  MODES
};

// Commands that the user may give the process
// (these are fixed and should not be changed, although not all processes accept all commands)
enum
{
  COM_NONE, // no command
  COM_LOCATION, // user has right-clicked somewhere on the display or map
  COM_TARGET, // user has right-clicked on an enemy process
  COM_FRIEND, // user has right-clicked on a friendly process
  COM_DATA_WELL, // user has right-clicked on a data well
  COM_NUMBER // user has pressed a number key
};

// Targetting information
// Targetting memory allows processes to track targets (enemy or friend)
// The following enums are used as indices in the process' targetting memory
enum
{
  TARGET_PARENT, // a newly built process starts with its builder in address 0
  TARGET_BUILT, // processes built by this process
  TARGET_ALLOCATOR, // process that this process will return to when finished harvesting
};


// Variable declaration and initialisation
//  (note that declaration and initialisation cannot be combined)
//  (also, variables retain their values between execution cycles)
int core_x, core_y; // location of core
core_x = get_core_x(); // location is updated each cycle
core_y = get_core_y();
int angle; // direction process is pointing
 // angles are in integer degrees from 0 to 8192, with 0 being right,
 // 2048 down, 4096 left and 6144 (or -2048) up.
angle = get_core_angle(); // angle is updated each cycle

int mode; // what is the process doing? (should be one of the MODE enums)

int scan_result; // used to hold the results of a scan of nearby processes

// builder variables
int build_multi; // indicates that user has commanded repeat build (by pressing control)
int build_result; // build result code (returned by build call)
int initialised; // set to 1 after initialisation code below run the first time

if (!initialised)
{
   // initialisation code goes here (not all autocoded processes have initialisation code)
  initialised = 1;
  attack_mode(4); // attack objects (if present) will fire only when there is enough power
}

int verbose; // if 1, process will print various things to the console

if (check_selected_single()) // returns 1 if the user has selected this process (and no other processes)
{
  if (!verbose) printf("\nProcess selected.");
  verbose = 1;
  set_debug_mode(1); // 1 means errors for this process will be printed to the console. Resets to 0 each cycle
}
  else
    verbose = 0;

// Accept commands from user
if (check_new_command() == 1) // returns 1 if a command has been given
{
  switch(get_command_type()) // get_command_type() returns the type of command given
  {
    case COM_LOCATION:
    case COM_DATA_WELL: // this process can't harvest, so treat data well commands as location commands
      if (verbose) printf("\nLocation command will be sent to new processes.");
      break;
    
    case COM_TARGET:
      if (verbose) printf("\nTarget command will be sent to new processes.");
      break;
    
    case COM_FRIEND:
      if (verbose) printf("\nFriendly target command will be sent to new processes.");
      break;
    
    default:
      if (verbose) printf("\nUnrecognised command.");
      break;
  
  } // end of command type switch
} // end of new command code


if (check_new_build_command() == 1) // build commands are separate from move/attack commands
{
  if (get_build_command_ctrl() == 0) // returns 1 if control was pressed at the last point of giving the build command
  {
    build_multi = 0; // just build one
    if (verbose) printf("\nBuilding.");
  }
    else
    {
      build_multi = 1; // build repeatedly
      if (verbose) printf("\nRepeat building.");
    }
} // end if (check_new_build_command() == 1)

if (check_build_command() == 1) // check for queued build commands
{
  build_result = build_as_commanded(TARGET_BUILT); // build_as_commanded automatically executes the build command
  if (build_result == 1) // 1 means success
  {
    copy_commands(TARGET_BUILT); // copies builder's command queue to newly built process
    if (build_multi == 0)
      clear_build_command(); // only clear the command if not multi-building
    if (verbose) printf("\nProcess built.");
  } // end if (build_result == 1)
} // end if (check_build_command() == 1)




auto_harvest.gather_data();


auto_allocate.allocate_data(4); // actually I think the maximum is 2


// What the process does next depends on its current mode
switch(mode)
{
  
  case MODE_IDLE:
    break;

} // end of mode switch

restore_self(); // tries to restore any destroyed components

repair_self(); // tries to repair any damaged components

restore_scan(0,0); // scans for nearby processes with destroyed components and tries to restore them

repair_scan(0,0); // scans for nearby damaged processes and tries to repair them
