


#process "tank"

class auto_att_fwd;
class auto_move;
class auto_att_back;
class auto_att_right;
class auto_att_left;

core_hex_B, 0, 
  {object_repair, 0},
  {object_downlink, -802, 
    {component_long5, // component 1
      {object_interface, 0},
      {object_interface_depth, 0},
      {object_downlink, 828, 
        {component_long5, // component 2
          {object_pulse:auto_att_back, 0},
          {object_interface, 0},
          {object_uplink, 0},
          {object_pulse_l:auto_att_right, 0},
          {object_interface_depth, 0},
        }
      },
      {object_uplink, 0},
      {object_pulse_xl:auto_att_fwd, -1221},
    }
  },
  {object_downlink, -35, 
    {component_cap, // component 3
      {object_move:auto_move, 632},
      {object_move:auto_move, -369},
      {object_downlink, -990, 
        {component_cap, // component 4
          {object_uplink, 0},
          {object_move:auto_move, 2048},
          {object_move:auto_move, 1128},
          {object_pulse:auto_att_back, 209},
        }
      },
      {object_uplink, 0},
    }
  },
  {object_repair_other, 0},
  {object_downlink, 35, 
    {component_cap, // component 5
      {object_uplink, 0},
      {object_downlink, 965, 
        {component_cap, // component 6
          {object_pulse:auto_att_back, -209},
          {object_move:auto_move, -1128},
          {object_move:auto_move, -2048},
          {object_uplink, 0},
        }
      },
      {object_move:auto_move, 369},
      {object_move:auto_move, -632},
    }
  },
  {object_downlink, 802, 
    {component_long5, // component 7
      {object_interface, 0},
      {object_downlink, -828, 
        {component_long5, // component 8
          {object_pulse:auto_att_back, 0},
          {object_uplink, 0},
          {object_interface, 0},
          {object_interface_depth, 0},
          {object_pulse_l:auto_att_left, 0},
        }
      },
      {object_interface_depth, 0},
      {object_pulse_xl:auto_att_fwd, 1175},
      {object_uplink, 0},
    }
  }

#code




// Process AI modes (these reflect the capabilities of the process)
enum
{
  MODE_WANDER, // wandering randomly
  MODE_ATTACK, // process is attacking something it found
  MODES
};


// Targetting information
// Targetting memory allows processes to track targets (enemy or friend)
// The following enums are used as indices in the process' targetting memory
enum
{
  TARGET_PARENT, // a newly built process starts with its builder as entry 0
  TARGET_MAIN, // main target
  TARGET_FRONT,
  TARGET_LEFT,
  TARGET_RIGHT,
  TARGET_BACK
};

//int other_target_x, other_target_y;
//int angle_to_leader;

// Variable declaration and initialisation
//  (note that declaration and initialisation cannot be combined)
//  (also, variables retain their values between execution cycles)
int core_x, core_y; // location of core
core_x = get_core_x(); // location is updated each cycle
core_y = get_core_y();
int angle; // direction process is pointing
 // angles are in integer degrees from 0 to 8192, with 0 being right,
 // 2048 down, 4096 left and 6144 up.
angle = get_core_angle(); // angle is updated each cycle

int mode; // what is the process doing? (should be one of the MODE enums)

int move_x, move_y; // destination
int attack_x, attack_y;

int scan_result; // used to hold the results of a scan of nearby processes

int initialised;
if (initialised == 0)
{
 initialised = 1;
 listen_channel(4); // this is the channel used to broadcast "target found" and "cancel" messages
 attack_mode(1); // limits rate of fire from a single class call to 1
 broadcast(1500, // range of broadcast, in pixels
           5, // channel
           0,
           40); // message code for "please follow me"
 gosub start_wandering;
}


charge_interface_max();

int attacking_main_target;
attacking_main_target = 0;


// What the process does next depends on its current mode
switch(mode)
{

 case MODE_WANDER:
  if (distance_from_xy(move_x, move_y) < 900)
  {
   gosub start_wandering;
   break;
  }
  if (scan_for_threat(cos(angle, 400), sin(angle, 400), TARGET_MAIN))
  {
   mode = MODE_ATTACK;
   attack_x = process[TARGET_MAIN].get_core_x();
   attack_y = process[TARGET_MAIN].get_core_y();
// tell nearby processes about the target:
   broadcast_target(3000, // range of broadcast, in pixels
                    4, // channel
                    1, // priority
                    TARGET_MAIN, // the target will be broadcast so other processes can find it directly
// message contents:
                    1, // indicates target found
                    attack_x,
                    attack_y);
  }
  gosub listen_to_broadcasts;
  auto_move.move_to(move_x, move_y);
  break;

 case MODE_ATTACK: // attacking TARGET_MAIN
  if (!process[TARGET_MAIN].visible()) // target no longer exists, or is out of range of any friendly process
  {
// go to target's last known location:
    auto_move.move_to(attack_x, attack_y);
// should be able to assume that attack_x, attack_y hold the target's last know location:
    if (target_destroyed(TARGET_MAIN) // returns 1 if the target was recently destroyed in vision of a friendly process
     || distance_from_xy_less(attack_x, attack_y, 300)) // returns 1 if process is less than 300 pixels from attack_x,attack_y
    {
// Near enough to the target that if it existing we'd see it. So give up and go back to wandering:
      gosub start_wandering;
      break;
    }
    break;
  }
// Target visible. So approach it, and attack if near enough:
  attack_x = process[TARGET_MAIN].get_core_x();
  attack_y = process[TARGET_MAIN].get_core_y();
  auto_move.approach_target(TARGET_MAIN, 0, 500);
  if (process[TARGET_MAIN].distance_less(1000)
   && arc_length(angle, process[TARGET_MAIN].target_angle()) < 2048)
  {
   auto_att_fwd.fire_at(TARGET_MAIN, 0);
   attacking_main_target = 1;
  }
  break;
  
} // end of mode switch

if (!attacking_main_target)
 auto_att_fwd.attack_scan(0, 400, TARGET_FRONT);

auto_att_back.attack_scan(4096, 400, TARGET_BACK);
auto_att_left.attack_scan(6144, 400, TARGET_LEFT);
auto_att_right.attack_scan(2048, 400, TARGET_RIGHT);


restore_self();

repair_self();

restore_scan(0,0); // scans for nearby processes with destroyed components and tries to restore them

repair_scan(0,0); // scans for nearby damaged processes and tries to repair them


exit;

// subroutine that makes process move randomly
start_wandering:
 mode = MODE_WANDER;
 move_x = 600 + random(world_x() - 1200);
 move_y = 600 + random(world_y() - 1200);
 return;
 

// subroutine that listens to scouts' broadcasts
listen_to_broadcasts:
// Listen for a broadcast on channel 3 (listen_channel(3) call above sets the process to listen to channel 3)
  while (check_messages()) // returns number of messages received since previous cycle
  {
   switch(read_message()) // read_message() returns next value in message
   {

    case 1: // a scout has found a target
    case 2: // a scout has found a high priority target (currently treated the same)
// expected message format is (1 [or 2], target_x, target_y), with the target attached to the broadcast
     attack_x = read_message();
     attack_y = read_message();
     get_message_target(TARGET_MAIN); // copies target attached to broadcast to target TARGET_MAIN
     mode = MODE_ATTACK;
     break;

   } // end switch(read_message())
   next_message();
  } // end if (check_messages())
 return;
