


#process "spikey2"

class auto_att_spike;
class auto_att_back;
class auto_move;
class auto_retro;

core_hex_B, 0, 
  {object_downlink, 0, 
    {component_long6, // component 1
      {object_uplink, 0},
      {object_interface, 0},
      {object_spike:auto_att_spike, 0},
      {object_spike:auto_att_spike, 0},
      {object_spike:auto_att_spike, 0},
      {object_interface_depth, 0}
    }
  },
  {object_downlink, -415, 
    {component_long5, // component 2
      {object_interface_depth, 0},
      {object_spike:auto_att_spike, 0},
      {object_interface, 0},
      {object_spike:auto_att_spike, 0},
      {object_uplink, 0},
    }
  },
  {object_downlink, -105, 
    {component_long6, // component 3
      {object_uplink, 0},
      {object_move:auto_move, 1304},
      {object_move:auto_move:auto_retro, -1255},
      {object_move:auto_move:auto_retro, -2048},
      {object_move:auto_move, 201},
      {object_downlink, -239, 
        {component_cap, // component 4
          {object_uplink, 0},
          {object_pulse:auto_att_back, 1818},
          {object_move:auto_move, 958},
          {object_move:auto_move, -57},
        }
      }
    }
  },
  {object_repair, 0},
  {object_downlink, 23, 
    {component_long6, // component 5
      {object_uplink, 0},
      {object_downlink, 239, 
        {component_cap, // component 6
          {object_move:auto_move, 57},
          {object_move:auto_move, -958},
          {object_pulse:auto_att_back, -1818},
          {object_uplink, 0},
        }
      },
      {object_move:auto_move, -201},
      {object_move:auto_move:auto_retro, 2048},
      {object_move:auto_move:auto_retro, 1255},
      {object_move:auto_move, -1304}
    }
  },
  {object_downlink, 246, 
    {component_long5, // component 7
      {object_interface_depth, 0},
      {object_interface, 0},
      {object_spike:auto_att_spike, 0},
      {object_uplink, 0},
      {object_spike:auto_att_spike, 0},
    }
  }

#code




// Process AI modes (these reflect the capabilities of the process)
enum
{
  MODE_WANDER, // wandering randomly
  MODE_ATTACK, // process is attacking something it found
  MODES
};


// Targetting information
// Targetting memory allows processes to track targets (enemy or friend)
// The following enums are used as indices in the process' targetting memory
enum
{
  TARGET_PARENT, // a newly built process starts with its builder as entry 0
  TARGET_MAIN, // main target
  TARGET_FOUND, // will attack this target with spikes, but won't chase it
  TARGET_BACK
};

//int other_target_x, other_target_y;
//int angle_to_leader;

// Variable declaration and initialisation
//  (note that declaration and initialisation cannot be combined)
//  (also, variables retain their values between execution cycles)
int core_x, core_y; // location of core
core_x = get_core_x(); // location is updated each cycle
core_y = get_core_y();
int angle; // direction process is pointing
 // angles are in integer degrees from 0 to 8192, with 0 being right,
 // 2048 down, 4096 left and 6144 up.
angle = get_core_angle(); // angle is updated each cycle

int mode; // what is the process doing? (should be one of the MODE enums)

int move_x, move_y; // destination
int attack_x, attack_y;

int scan_result; // used to hold the results of a scan of nearby processes

int initialised;
if (initialised == 0)
{
 initialised = 1;
 listen_channel(4); // this is the channel used to broadcast "target found" and "cancel" messages
 attack_mode(3); // limits rate of fire from a single class call to 3
 broadcast(1500, // range of broadcast, in pixels
           5, // channel
           0,
           40); // message code for "please follow me"
 gosub start_wandering;
}


charge_interface_max();

auto_att_back.attack_scan(4096, 400, TARGET_BACK);


// What the process does next depends on its current mode
switch(mode)
{

 case MODE_WANDER:
  if (distance_from_xy(move_x, move_y) < 900)
  {
   gosub start_wandering;
   break;
  }
  if (scan_for_threat(cos(angle, 400), sin(angle, 400), TARGET_MAIN))
  {
   mode = MODE_ATTACK;
   attack_x = process[TARGET_MAIN].get_core_x();
   attack_y = process[TARGET_MAIN].get_core_y();
// tell nearby processes about the target:
   broadcast_target(3000, // range of broadcast, in pixels
                    4, // channel
                    1, // priority
                    TARGET_MAIN, // the target will be broadcast so other processes can find it directly
// message contents:
                    1, // indicates target found
                    attack_x,
                    attack_y);
   break;
  }
  gosub listen_to_broadcasts;
  auto_move.move_to(move_x, move_y);
  break;

 case MODE_ATTACK: // attacking TARGET_MAIN
  if (!process[TARGET_MAIN].visible()) // target no longer exists, or is out of range of any friendly process
  {
// go to target's last known location:
    auto_move.move_to(attack_x, attack_y);
// should be able to assume that attack_x, attack_y hold the target's last know location:
    if (target_destroyed(TARGET_MAIN) // returns 1 if the target was recently destroyed in vision of a friendly process
     || distance_from_xy_less(attack_x, attack_y, 900)) // returns 1 if process is less than 900 pixels from attack_x,attack_y
    {
// Near enough to the target that if it existing we'd see it. So give up and go back to wandering:
      gosub start_wandering;
      break;
    }
     else
     {
      if (distance_from_xy_less(attack_x, attack_y, 2000))
       auto_att_spike.fire_spike_xy(attack_x, attack_y);
        else
         gosub spike_attack_anything;
     }
    break;
  }
// Target visible. So approach it, and attack if near enough:
  attack_x = process[TARGET_MAIN].get_core_x();
  attack_y = process[TARGET_MAIN].get_core_y();
  auto_move.approach_target(TARGET_MAIN, 0, 1800);
  if (process[TARGET_MAIN].distance() < 2000)
  {
   auto_att_spike.fire_spike_at(TARGET_MAIN, 0);
  }
   else
    gosub spike_attack_anything;
  break;
  
} // end of mode switch



restore_self();

repair_self();

restore_scan(0,0); // scans for nearby processes with destroyed components and tries to restore them

repair_scan(0,0); // scans for nearby damaged processes and tries to repair them


exit;

// subroutine that makes process move randomly
start_wandering:
 mode = MODE_WANDER;
 move_x = 600 + random(world_x() - 1200);
 move_y = 600 + random(world_y() - 1200);
 return;
 
// subroutine that attacks nearby threats with spikes
spike_attack_anything:
 if (scan_for_threat(cos(angle, 400), sin(angle, 400), TARGET_FOUND))
  auto_att_spike.fire_spike_at(TARGET_FOUND, 0);
 return;

// subroutine that listens to scouts' broadcasts
listen_to_broadcasts:
// Listen for a broadcast on channel 3 (listen_channel(3) call above sets the process to listen to channel 3)
  while (check_messages()) // returns number of messages received since previous cycle
  {
   switch(read_message()) // read_message() returns next value in message
   {

    case 1: // a scout has found a target
    case 2: // a scout has found a high priority target (currently treated the same)
// expected message format is (1 [or 2], target_x, target_y), with the target attached to the broadcast
     attack_x = read_message();
     attack_y = read_message();
     get_message_target(TARGET_MAIN); // copies target attached to broadcast to target TARGET_MAIN
     mode = MODE_ATTACK;
     break;

   } // end switch(read_message())
   next_message();
  } // end if (check_messages())
 return;
