

#process "scout"

class auto_att_fwd;
class auto_move;

core_quad_A, 0, 
  {object_pulse:auto_att_fwd, 0},
  {object_move:auto_move, 2048},
  {object_move:auto_move, 0},
  {object_move:auto_move, -2048},

#code




// Process AI modes (these reflect the capabilities of the process)
enum
{
  MODE_GUARD, // process is circling builder for a while after being built
  MODE_WANDER, // wandering randomly
  MODE_ATTACK, // process is attacking something it found
  MODE_SEEK, // process is moving towards a more distant target (possibly found by another process)
  MODES
};


// Targetting information
// Targetting memory allows processes to track targets (enemy or friend)
// The following enums are used as indices in the process' targetting memory
enum
{
  TARGET_PARENT, // a newly built process starts with its builder as entry 0
  TARGET_MAIN, // main target
};

int other_target_x, other_target_y;

// Variable declaration and initialisation
//  (note that declaration and initialisation cannot be combined)
//  (also, variables retain their values between execution cycles)
int core_x, core_y; // location of core
core_x = get_core_x(); // location is updated each cycle
core_y = get_core_y();
int angle; // direction process is pointing
 // angles are in integer degrees from 0 to 8192, with 0 being right,
 // 2048 down, 4096 left and 6144 up.
angle = get_core_angle(); // angle is updated each cycle

int mode; // what is the process doing? (should be one of the MODE enums)
int guard_count;

int move_x, move_y; // destination
int attack_x, attack_y;

int scan_result; // used to hold the results of a scan of nearby processes

int initialised;
if (initialised == 0)
{
 initialised = 1;
 listen_channel(4); // this is the channel used to broadcast "target found" and "cancel" messages
 mode = MODE_GUARD;
}


// always look for enemy allocators - they are priority targets:
  if (scan_single(0,0, // x,y offsets of target
                  TARGET_MAIN, // target memory index
                  0, // accept/require friendly? (0 means ignore friendly)
                  0,100, // size of target - min/max components to accept (0,100 will accept any)
                  0b1000)) // filter bitfield - 0b1000 means accept only targets with allocator objects (see the manual for more about scan filters)
  {
   attack_x = process[TARGET_MAIN].get_core_x();
   attack_y = process[TARGET_MAIN].get_core_y();
// tell other scouts that a target has been found!
   broadcast_target(-1, // range - -1 means unlimited range
                    4, // channel
                    1, // priority
                    TARGET_MAIN, // the target will be broadcast so other processes can find it directly
// message contents:
                    2, // indicates allocator target found
                    attack_x,
                    attack_y);
   mode = MODE_ATTACK;
  }




// What the process does next depends on its current mode
switch(mode)
{

 case MODE_GUARD:
  guard_count ++;
  if (guard_count > 10
   || !process[TARGET_PARENT].visible()) // visible() always returns 1 for a friendly process, unless it no longer exists
  {
   mode = MODE_WANDER;
   gosub start_wandering;
   break;
  }
  if (process[TARGET_PARENT].distance() < 700
   && scan_for_threat(cos(angle, 400), sin(angle, 400), TARGET_MAIN))
  {
   mode = MODE_ATTACK;
  }
  int angle_to_parent;
// find the angle to the parent, then move in a circle around it:
  angle_to_parent = atan2(process[TARGET_PARENT].get_core_y() - core_y, process[TARGET_PARENT].get_core_x() - core_x);
  angle_to_parent += 1024;
  move_x = process[TARGET_PARENT].get_core_x() - cos(angle_to_parent, 300);
  move_y = process[TARGET_PARENT].get_core_y() - sin(angle_to_parent, 300);
  auto_move.move_to(move_x, move_y);
  break;
  
 case MODE_WANDER:
  if (distance_from_xy(move_x, move_y) < 300)
  {
   gosub start_wandering;
   break;
  }
  if (scan_for_threat(cos(angle, 400), sin(angle, 400), TARGET_MAIN))
  {
   mode = MODE_ATTACK;
   attack_x = process[TARGET_MAIN].get_core_x();
   attack_y = process[TARGET_MAIN].get_core_y();
// tell nearby processes about the target:
   broadcast_target(4000, // range of broadcast, in pixels
                    4, // channel
                    1, // priority
                    TARGET_MAIN, // the target will be broadcast so other processes can find it directly
// message contents:
                    1, // indicates target found
                    attack_x,
                    attack_y);
   break;
  }
  gosub listen_to_broadcasts;
  auto_move.move_to(move_x, move_y);
  break;

 case MODE_ATTACK: // attacking TARGET_MAIN
  if (!process[TARGET_MAIN].visible()) // target no longer exists, or is out of range of any friendly process
  {
// should be able to assume that attack_x, attack_y hold the target's last know location:
    if (distance_from_xy_less(attack_x, attack_y, 600)) // returns 1 if process is less than 600 pixels from attack_x,attack_y
    {
// Near enough to the target that if it existing we'd see it. So give up and go back to wandering:
      gosub start_wandering;
      break;
    }
// go to target's last known location:
    auto_move.move_to(attack_x, attack_y);
    break;
  }
// Target visible. So approach it, and attack if near enough:
  attack_x = process[TARGET_MAIN].get_core_x();
  attack_y = process[TARGET_MAIN].get_core_y();
  if (process[TARGET_MAIN].distance() < 1000)
  {
    if (arc_length(angle, atan2(process[TARGET_MAIN].get_core_y() - core_y, process[TARGET_MAIN].get_core_x() - core_x)) <= 2048)
      auto_att_fwd.fire_at(TARGET_MAIN, 0);
    auto_move.approach_target(TARGET_MAIN, 0, 300);
    break;
  }
  auto_move.move_to(attack_x, attack_y);
  break;
  

} // end of mode switch



exit; // finished!

// subroutine that makes process move randomly
start_wandering:
 if (guard_count < 10) // but if it's still guarding parent, go back to doing that
 {
  mode = MODE_GUARD;
  return;
 }
 mode = MODE_WANDER;
 move_x = 800 + random(world_x() - 1600);
 move_y = 800 + random(world_y() - 1600);
 auto_att_fwd.no_target();
 return;


// subroutine that listens to other scouts' broadcasts
listen_to_broadcasts:
// Listen for a broadcast on channel 3 (listen_channel(3) call above sets the process to listen to channel 3)
  if (check_messages()) // returns number of messages received since previous cycle
  {
   switch(read_message()) // read_message() returns next value in message
   {

    case 1: // another scout has found a target
    case 2: // another scout has found an allocator target (currently treated the same)
// expected message format is (1 [or 2], target_x, target_y), with the target attached to the broadcast
     attack_x = read_message();
     attack_y = read_message();
     get_message_target(TARGET_MAIN); // copies target attached to broadcast to target TARGET_MAIN
     mode = MODE_ATTACK;
     break;

   } // end switch(read_message())
  } // end if (check_messages())
 return;
