

#process "battle"

class auto_att_fwd;
class auto_att_right;
class auto_att_back;
class auto_move;
class auto_att_left;

core_hex_C, 0, 
  {object_stream_dir:auto_att_fwd, 0},
  {object_downlink, -660, 
    {component_long6, // component 1
      {object_interface, 0},
      {object_uplink, 0},
      {object_interface_depth, 0},
      {object_repair, 0},
      {object_downlink, -1098, 
        {component_prong, // component 2
          {object_pulse_xl:auto_att_right, 0},
          {object_uplink, 0},
          {object_pulse_l:auto_att_fwd, 0},
          {object_interface, 0},
        }
      },
      {object_downlink, 1111, 
        {component_prong, // component 3
          {object_uplink, 0},
          {object_pulse:auto_att_fwd, 0},
          {object_interface, 0},
          {object_pulse:auto_att_right, 0},
        }
      }
    }
  },
  {object_downlink, 370, 
    {component_long6, // component 4
      {object_interface, 0},
      {object_downlink, 545, 
        {component_cap, // component 5
          {object_move:auto_move, 719},
          {object_move:auto_move, -282},
          {object_move:auto_move, -1562},
          {object_uplink, 0},
        }
      },
      {object_pulse:auto_att_back, 0},
      {object_downlink, -101, 
        {component_cap, // component 6
          {object_uplink, 0},
          {object_pulse:auto_att_right, 599},
          {object_move:auto_move, 1385},
          {object_move:auto_move, 370},
        }
      },
      {object_interface_depth, 0},
      {object_uplink, 0}
    }
  },
  {object_repair, 0},
  {object_downlink, -370, 
    {component_long6, // component 7
      {object_interface, 0},
      {object_uplink, 0},
      {object_interface_depth, 0},
      {object_downlink, 101, 
        {component_cap, // component 8
          {object_move:auto_move, -370},
          {object_move:auto_move, -1385},
          {object_pulse:auto_att_left, -599},
          {object_uplink, 0},
        }
      },
      {object_pulse:auto_att_back, 0},
      {object_downlink, -545, 
        {component_cap, // component 9
          {object_uplink, 0},
          {object_move:auto_move, 1562},
          {object_move:auto_move, 282},
          {object_move:auto_move, -719},
        }
      }
    }
  },
  {object_downlink, 660, 
    {component_long6, // component 10
      {object_interface, 0},
      {object_downlink, -1111, 
        {component_prong, // component 11
          {object_pulse:auto_att_fwd, 0},
          {object_uplink, 0},
          {object_pulse:auto_att_left, 0},
          {object_interface, 0},
        }
      },
      {object_downlink, 1115, 
        {component_prong, // component 12
          {object_uplink, 0},
          {object_pulse_xl:auto_att_left, 0},
          {object_interface, 0},
          {object_pulse_l:auto_att_fwd, 0},
        }
      },
      {object_repair, 0},
      {object_interface_depth, 0},
      {object_uplink, 0}
    }
  }

#code




// Process AI modes (these reflect the capabilities of the process)
enum
{
  MODE_WANDER, // wandering randomly
  MODE_ATTACK, // process is attacking something it found
  MODE_ASSAULT_SEEK, // process is moving towards an allocator found by another scout
  MODE_ASSAULT_ATTACK, // process is attacking an allocator
  MODES
};


// Targetting information
// Targetting memory allows processes to track targets (enemy or friend)
// The following enums are used as indices in the process' targetting memory
enum
{
  TARGET_PARENT, // a newly built process starts with its builder as entry 0
  TARGET_MAIN, // main target
  TARGET_LEFT,
  TARGET_RIGHT,
  TARGET_BACK
};

int other_target_x, other_target_y;
int angle_to_leader;

// Variable declaration and initialisation
//  (note that declaration and initialisation cannot be combined)
//  (also, variables retain their values between execution cycles)
int core_x, core_y; // location of core
core_x = get_core_x(); // location is updated each cycle
core_y = get_core_y();
int angle; // direction process is pointing
 // angles are in integer degrees from 0 to 8192, with 0 being right,
 // 2048 down, 4096 left and 6144 up.
angle = get_core_angle(); // angle is updated each cycle

int mode; // what is the process doing? (should be one of the MODE enums)

int move_x, move_y; // destination
int attack_x, attack_y;

int scan_result; // used to hold the results of a scan of nearby processes

int initialised;
if (initialised == 0)
{
 initialised = 1;
 listen_channel(4); // this is the channel used to broadcast "target found" and "cancel" messages
 gosub start_wandering;
}


// What the process does next depends on its current mode
switch(mode)
{

 case MODE_WANDER:
  if (distance_from_xy(move_x, move_y) < 900)
  {
   gosub start_wandering;
   break;
  }
  if (scan_for_threat(cos(angle, 400), sin(angle, 400), TARGET_MAIN))
  {
   mode = MODE_ATTACK;
   attack_x = process[TARGET_MAIN].get_core_x();
   attack_y = process[TARGET_MAIN].get_core_y();
// tell nearby processes about the target:
   broadcast_target(3000, // range of broadcast, in pixels
                    4, // channel
                    1, // priority
                    TARGET_MAIN, // the target will be broadcast so other processes can find it directly
// message contents:
                    1, // indicates target found
                    attack_x,
                    attack_y);
   break;
  }
  gosub listen_to_broadcasts;
  auto_move.move_to(move_x, move_y);
  break;

 case MODE_ATTACK: // attacking TARGET_MAIN
  if (!process[TARGET_MAIN].visible()) // target no longer exists, or is out of range of any friendly process
  {
// should be able to assume that attack_x, attack_y hold the target's last know location:
    if (distance_from_xy_less(attack_x, attack_y, 600)) // returns 1 if process is less than 600 pixels from attack_x,attack_y
    {
// Near enough to the target that if it existing we'd see it. So give up and go back to wandering:
      gosub start_wandering;
      break;
    }
// go to target's last known location:
    auto_move.move_to(attack_x, attack_y);
    break;
  }
// Target visible. So approach it, and attack if near enough:
  attack_x = process[TARGET_MAIN].get_core_x();
  attack_y = process[TARGET_MAIN].get_core_y();
  if (process[TARGET_MAIN].distance() < 1000)
  {
    if (arc_length(angle, atan2(process[TARGET_MAIN].get_core_y() - core_y, process[TARGET_MAIN].get_core_x() - core_x)) <= 1024)
      auto_att_fwd.fire_at(TARGET_MAIN, 0);
    auto_move.approach_target(TARGET_MAIN, 0, 300);
    break;
  }
  auto_move.move_to(attack_x, attack_y);
  break;
  
} // end of mode switch

auto_att_fwd.attack_scan(0, 400, TARGET_MAIN);
auto_att_left.attack_scan(-2048, 400, TARGET_LEFT);
auto_att_back.attack_scan(4096, 400, TARGET_BACK);
auto_att_right.attack_scan(2048, 400, TARGET_RIGHT);


charge_interface_max();

restore_self();

repair_self();


exit;

// subroutine that makes process move randomly
start_wandering:
 mode = MODE_WANDER;
 move_x = 600 + random(world_x() - 1200);
 move_y = 600 + random(world_y() - 1200);
 return;
 

// subroutine that listens to scouts' broadcasts
listen_to_broadcasts:
// Listen for a broadcast on channel 4 (listen_channel(4) call above sets the process to listen to channel 4)
  while (check_messages()) // returns number of messages received since previous cycle and still unread
  {
   switch(read_message()) // read_message() returns next value in message; the first value is used as a code
   {

    case 1: // a scout has found a target
    case 2: // a scout has found a high priority target (currently treated the same)
// expected message format is (1 [or 2], target_x, target_y), with the target attached to the broadcast
     attack_x = read_message();
     attack_y = read_message();
     get_message_target(TARGET_MAIN); // copies target attached to broadcast to target TARGET_MAIN
     mode = MODE_ATTACK;
     break;

   } // end switch(read_message())
   next_message(); // discards current message and prepares to read the next
  } // end if (check_messages())
 return;
