

#process "base"

class auto_att_right;
class auto_allocate;
class auto_harvest;
class auto_att_left;
class auto_att_fwd;

core_static_hex_A, 6840, 
  {object_build, 0},
  {object_downlink, 0, 
    {component_bowl, // member 1
      {object_uplink, 0},
      {object_interface, 0},
      {object_interface_depth, 0},
      {object_storage, 0},
      {object_pulse_l:auto_att_fwd, 0},
    }
  },
  {object_allocate:auto_allocate, 0},
  {object_downlink, 0, 
    {component_bowl, // member 2
      {object_uplink, 0},
      {object_interface_depth, 0},
      {object_interface, 0},
      {object_storage, 0},
      {object_pulse_l:auto_att_right, -643},
    }
  },
  {object_repair, 0},
  {object_downlink, 0, 
    {component_bowl, // member 3
      {object_uplink, 0},
      {object_interface, 0},
      {object_interface_depth, 0},
      {object_harvest:auto_harvest, 0},
      {object_pulse_l:auto_att_left, -624},
    }
  }
  
#code


enum
{
TARGET_PARENT, // TM 0 is set to parent process

TM_HARVESTER_0,
TM_HARVESTER_1,
TM_HARVESTER_2,
TM_BUILDER_0,
TM_COMMANDER_0,
TM_COMMANDER_1,
TM_COMMANDER_2,

TARGET_LEFT, // target of directional left attack
TARGET_RIGHT, // target of directional right attack
TARGET_FRONT, // target of directional front attack

TARGET_THREAT,

TM_END
};

enum
{
TEMPLATE_BASE,
TEMPLATE_BUILDER,
TEMPLATE_HARVESTER,
TEMPLATE_COMMANDER,
TEMPLATE_ATTACKER

};

// Variable declaration and initialisation
//  (note that declaration and initialisation cannot be combined)
//  (also, variables retain their values between execution cycles)
int core_x, core_y; // location of core
core_x = get_core_x(); // location is updated each cycle
core_y = get_core_y();
int angle; // direction process is pointing
 // angles are in integer degrees from 0 to 8192, with 0 being right,
 // 2048 down, 4096 left and 6144 up.

int initialised;

int this_is_main_base; // is 1 if this is the main base. Only main base builds harvesters.
int received_main_base_broadcast; // the main base broadcasts an "i am the main base" announcement.
int received_dont_build_broadcast; // is 1 if another process is trying to build something expensive.
received_dont_build_broadcast = 0;
received_main_base_broadcast = 0;

if (!initialised)
{
 initialised = 1;
 angle = get_core_angle(); // only need to check this once as process is static
 listen_channel(1); // processes in this mission use channel 1 for messages to bases
 listen_channel(2); //  and channel 2 for messages to builders in general
 received_main_base_broadcast = -1; // when process just spawned, shouldn't assume that it is or is not the main base
}



int build_result; // build result code (returned by build call)
int i;

int special_build_counter;

// listen to broadcasts from other processes
while(check_messages()) // returns number of unread messages
{
 switch(read_message())
 {
  case 10: // 10 is code for "I am the main base"
   received_main_base_broadcast = 1; 
   break;
  case 20: // 20 means "please don't build anything this cycle"
   received_dont_build_broadcast = 1;
   break;
 }
 next_message();
}


// check for whether there is another main base
if (received_main_base_broadcast == 0) // main base doesn't exist, or has just been destroyed, and no other base has claimed its place.
 this_is_main_base = 1; // so this base will claim the status of main base

if (this_is_main_base)
{
// every cycle, the main base broadcasts an announcement that the main base exists, so that no other base will try to become the main base
 broadcast(-1, // range of broadcast (in pixels). -1 means unlimited range.
           1, // channel - other processes must be listening on this channel to receive the message
           1, // priority - 0 or 1. 0 means message may be replaced by priority 1 messages
           10); // message contents - 10 means an announcement that this process is the main base.
}



if (received_dont_build_broadcast) // another process is waiting for there to be enough data to build something expensive
 goto finished_building;


if (special_build_counter < 3)
{
 build_result = build_process(TEMPLATE_ATTACKER, cos(angle, 400), sin(angle, 400), angle, -1);
 if (build_result == 1)
  special_build_counter ++;
 goto finished_building;
}

if (this_is_main_base) // only the main base tries to build harvesters and builders
{
// check whether each harvester entry in targetting memory has something:
 for (i = TM_HARVESTER_0; i < TM_BUILDER_0; i ++)
 {
  if (process[i].visible() <= 0) // doesn't exist
  {
// a harvester is missing or has never been built. Try to build one.
   build_result = build_process(TEMPLATE_HARVESTER, cos(angle, 400), sin(angle, 400), angle, i);
   if (build_result == 1)
    special_build_counter = 0;
   goto finished_building;
  }
 }

 if (process[TARGET_PARENT].visible() <= 0) // build builder only if parent doesn't exist
 {
  i = TM_BUILDER_0;
  if (process[i].visible() <= 0) // doesn't exist
  {
   build_result = build_process(TEMPLATE_BUILDER, cos(angle, 400), sin(angle, 400), angle, i);
   if (build_result == 1)
    special_build_counter = 0;
   goto finished_building;
  }
 }
}

// try to build a large attacking process
for (i = TM_COMMANDER_0; i < TM_END; i ++)
{
 if (process[i].visible() <= 0) // doesn't exist
 {
  if (get_available_data() < get_template_cost(TEMPLATE_COMMANDER))
  {
// Tells other builder processes not to build anything while we wait for more data
     broadcast(-1, // range of broadcast (in pixels). -1 means unlimited range.
               2, // channel - other processes must be listening on this channel to receive the message
               0, // priority - 0 or 1. 0 means message may be replaced by priority 1 messages
               20); // message contents - 20 is code for "please don't build"
  }
    else
    {
      build_result = build_process(TEMPLATE_COMMANDER, cos(angle, 400), sin(angle, 400), angle, i);
      if (build_result == 1)
       special_build_counter = 0;
    }
  goto finished_building;
 }
}


finished_building:


auto_att_left.attack_scan(-3000, 400, TARGET_LEFT);

auto_att_right.attack_scan(3000, 400, TARGET_RIGHT);

auto_att_fwd.attack_scan(0, 400, TARGET_FRONT);


if (scan_for_threat(0, 0, TARGET_THREAT))
{
// tell nearby processes about the target:
   broadcast_target(4000, // range of broadcast, in pixels
                    4, // channel
                    1, // priority
                    TARGET_THREAT, // the target will be broadcast so other processes can find it directly
// message contents:
                    1, // indicates target found
                    process[TARGET_THREAT].get_core_x(),
                    process[TARGET_THREAT].get_core_y());

}


charge_interface_max(); // charges the process' interface. Since the interface is shared across all
 // components with interface objects, this call is not specific to any object or class.
 // charge_interface_max() charges the interface using any power left over.


auto_harvest.gather_data();

auto_allocate.allocate_data(4); // actually I think the maximum is 2

restore_self(); // tries to restore any destroyed components

repair_self(); // tries to repair any damaged components
