

#process "leader1"

class auto_att_left;
class auto_move;
class auto_att_fwd;
class auto_att_right;
class auto_att_back;

core_pent_B, 0, 
  {object_repair_other, 0},
  {object_downlink, -174, 
    {component_long5, // member 1
      {object_repair, 0},
      {object_pulse:auto_att_fwd, 0},
      {object_downlink, -1534, 
        {component_cap, // member 2
          {object_uplink, 0},
          {object_move:auto_move, 1876},
          {object_pulse:auto_att_back, 596},
          {object_move:auto_move, -405},
        }
      },
      {object_uplink, 0},
      {object_interface, 0},
    }
  },
  {object_downlink, 174, 
    {component_long5, // member 3
      {object_interface_depth, 0},
      {object_downlink, 1534, 
        {component_cap, // member 4
          {object_move:auto_move, 405},
          {object_pulse:auto_att_back, -596},
          {object_move:auto_move, -1876},
          {object_uplink, 0},
        }
      },
      {object_pulse:auto_att_fwd, 0},
      {object_interface, 0},
      {object_uplink, 0},
    }
  },
  {object_downlink, 1501, 
    {component_prong, // member 5
      {object_uplink, 0},
      {object_interface_depth, 0},
      {object_interface, 0},
      {object_pulse:auto_att_left, 0},
    }
  },
  {object_downlink, -1501, 
    {component_prong, // member 6
      {object_interface_depth, 0},
      {object_uplink, 0},
      {object_pulse:auto_att_right, 0},
      {object_interface, 0},
    }
  },

#code




// Process AI modes (these reflect the capabilities of the process)
enum
{
  MODE_WANDER,
  MODE_ATTACK,
  MODES
};


// Targetting information
// Targetting memory allows processes to track targets (enemy or friend)
// The following enums are used as indices in the process' targetting memory
enum
{
  TARGET_PARENT, // a newly built process starts with its builder as entry 0
  TARGET_MAIN, // main target
  TARGET_FRONT, // target of directional forward attack
  TARGET_BACK,
  TARGET_LEFT,
  TARGET_RIGHT
};

int attacking_front; // is set to 1 if forward directional attack objects have a target
int front_attack_primary; // is set to 1 if forward directional attack objects are attacking
 // the primary target (e.g. target selected by command). Set to 0 if the objects are available for autonomous fire.
int attacking_back, attacking_left, attacking_right;

int other_target_x, other_target_y;

// Variable declaration and initialisation
//  (note that declaration and initialisation cannot be combined)
//  (also, variables retain their values between execution cycles)
int core_x, core_y; // location of core
core_x = get_core_x(); // location is updated each cycle
core_y = get_core_y();
int angle; // direction process is pointing
 // angles are in integer degrees from 0 to 8192, with 0 being right,
 // 2048 down, 4096 left and 6144 up.
angle = get_core_angle(); // angle is updated each cycle

int mode; // what is the process doing? (should be one of the MODE enums)
int saved_mode; // save the process' mode while it's attacking something it found

int move_x, move_y; // destination
int target_x, target_y; // location of target (to attack, follow etc)

int scan_result; // used to hold the results of a scan of nearby processes

int initialised;
if (initialised == 0)
{
 initialised = 1;
 mode = MODE_WANDER;
 gosub start_wandering;
}

front_attack_primary = 0; // this will be set to 1 if process is attacking its main target

// Because this is a leader, it broadcasts its presence to any nearby followers:
broadcast(1000, // range of broadcast (in pixels).
          5, // follower processes in this mission listen to channel 5
          0, // priority - 0 or 1. This message doesn't need high priority (which replaces low priority messages)
          40, // code 40 means "please follow me"
          0); // message contents (can be up to 8 parameters here, but this is a simple message)

// What the process does next depends on its current mode
switch(mode)
{


 case MODE_WANDER:
  if (distance_from_xy(move_x, move_y) < 300)
  {
   gosub start_wandering;
   break;
  }
  if (scan_single(0,0,TARGET_MAIN,0,6,100,0b11)
   || scan_single(0,0,TARGET_MAIN,0,0,100,0b1000))
  {
   mode = MODE_ATTACK;
   break;
  }
  auto_move.move_to(move_x, move_y);
  break;
  
 case MODE_ATTACK: // attacking something it found itself
  if (process[TARGET_MAIN].visible() <= 0) // target no longer exists, or is out of range
  {
   gosub start_wandering;
   break;
  }
  auto_move.approach_target(TARGET_MAIN, 0, 300);
  break;
  
  
} // end of mode switch

auto_att_fwd.attack_scan(0, 400, TARGET_FRONT);

auto_att_left.attack_scan(-2048, 400, TARGET_LEFT);

auto_att_right.attack_scan(2048, 400, TARGET_RIGHT);

auto_att_back.attack_scan(4096, 400, TARGET_BACK);


// give next priority to charging interface:
charge_interface_max();

restore_self();

repair_self();

restore_scan(0,0); // scans for nearby processes with destroyed components and tries to restore them

repair_scan(0,0); // scans for nearby damaged processes and tries to repair them
  
exit;


start_wandering:
 mode = MODE_WANDER;
 move_x = 800 + random(world_x() - 1600);
 move_y = 800 + random(world_y() - 1600);
 return;
