

#process "rbase"

class auto_att_right;
class auto_allocate;
class auto_harvest;
class auto_att_left;
class auto_att_fwd;

core_static_hex_A, 6840, 
  {object_build, 0},
  {object_downlink, 0, 
    {component_bowl, // member 1
      {object_uplink, 0},
      {object_interface, 0},
      {object_interface_depth, 0},
      {object_storage, 0},
      {object_pulse_l:auto_att_fwd, 0},
    }
  },
  {object_allocate:auto_allocate, 0},
  {object_downlink, 0, 
    {component_bowl, // member 2
      {object_uplink, 0},
      {object_interface_depth, 0},
      {object_interface, 0},
      {object_storage, 0},
      {object_pulse_l:auto_att_right, -643},
    }
  },
  {object_repair, 0},
  {object_downlink, 0, 
    {component_bowl, // member 3
      {object_uplink, 0},
      {object_interface, 0},
      {object_interface_depth, 0},
      {object_harvest:auto_harvest, 0},
      {object_pulse_l:auto_att_left, -624},
    }
  }

#code




// Targetting information
// Targetting memory allows processes to track targets (enemy or friend)
// The following enums are used as indices in the process' targetting memory
enum
{
  TARGET_PARENT, // a newly built process starts with its builder in address 0
  TARGET_LEFT, // target of directional left attack
  TARGET_RIGHT, // target of directional right attack
  TARGET_FRONT, // target of directional front attack
// The following addresses are used to track processes that this process
//  has built, to make sure it builds the right number of each:
  TARGET_HARVESTER_0,
  TARGET_HARVESTER_1,
  TARGET_HARVESTER_2,
  TARGET_BUILDER_0,
  TARGET_COMMANDER_0,
  TARGET_COMMANDER_1,
  TARGET_COMMANDER_2,
  TARGET_END

};



// Templates
//  - this process assumes that the templates have been set up in a certain way,
//    as follows:
enum
{
TEMPLATE_BASE,
TEMPLATE_ATTACKER1,
TEMPLATE_ATTACKER2

};



// Variable declaration and initialisation
//  (note that declaration and initialisation cannot be combined)
//  (also, variables retain their values between execution cycles)
int core_x, core_y; // location of core
core_x = get_core_x(); // location is updated each cycle
core_y = get_core_y();
int angle; // direction process is pointing
 // angles are in integer degrees from 0 to 8192, with 0 being right,
 // 2048 down, 4096 left and 6144 (or -2048) up.
angle = get_core_angle(); // angle is updated each cycle

// builder variables
int build_result; // build result code (returned by build call)
int build_counter;



auto_harvest.gather_data();


auto_allocate.allocate_data(4); // actually I think the maximum is 2

if (build_counter < 5)
{
 build_result = build_process(TEMPLATE_ATTACKER1, cos(angle, 400), sin(angle, 400), angle, -1);
 if (build_result == 1)
  build_counter ++;
 goto finished_building;
}

// build_counter must be 5, so build a different attacker:

build_result = build_process(TEMPLATE_ATTACKER2, cos(angle, 400), sin(angle, 400), angle, -1);
if (build_result == 1)
 build_counter = 0;



finished_building:

auto_harvest.gather_data();

auto_allocate.allocate_data(4); // actually I think the maximum is 2








 auto_att_left.attack_scan(-3000, 400, TARGET_LEFT);

 auto_att_right.attack_scan(3000, 400, TARGET_RIGHT);

 auto_att_fwd.attack_scan(0, 400, TARGET_FRONT);

charge_interface_max(); // charges the process' interface. Since the interface is shared across all
 // components with interface objects, this call is not specific to any object or class.
 // charge_interface_max() charges the interface using any power left over.

repair_self(); // tries to repair any damaged components

restore_self(); // tries to restore any destroyed components
