

#process "defender2"
class auto_att_left;
class auto_att_right;
class auto_move;

core_quad_B, 0, 
  {object_pulse:auto_att_left, -1003},
  {object_pulse:auto_att_right, 981},
  {object_move:auto_move, -1174},
  {object_move:auto_move, 1114},
#code





// Targetting information
// Targetting memory allows processes to track targets (enemy or friend)
// The following enums are used as indices in the process' targetting memory
enum
{
  TARGET_PARENT, // a newly built process starts with its builder as entry 0
  TARGET_LEFT, // target of directional left attack
  TARGET_RIGHT, // target of directional right attack
};

int attacking_left; // is set to 1 if left directional attack objects have a target
int attacking_right; // is set to 1 if right directional attack objects have a target

int other_target_x, other_target_y;

// Variable declaration and initialisation
//  (note that declaration and initialisation cannot be combined)
//  (also, variables retain their values between execution cycles)
int core_x, core_y; // location of core
core_x = get_core_x(); // location is updated each cycle
core_y = get_core_y();
int angle; // direction process is pointing
 // angles are in integer degrees from 0 to 8192, with 0 being right,
 // 2048 down, 4096 left and 6144 up.
angle = get_core_angle(); // angle is updated each cycle

int move_x, move_y; // destination
int centre_x, centre_y; // centre of circle process is orbiting
int scan_result; // used to hold the results of a scan of nearby processes

int initialised; // will start as 0

if (!initialised)
{
// this process just moves in a circle around a point identified when it's created.
 centre_x = core_x + cos(angle + 2048, 400);
 centre_y = core_y + sin(angle + 2048, 400);
 initialised = 1;
}

int angle_to_centre;
angle_to_centre = atan2(core_y - centre_y, core_x - centre_x);
int move_angle;
move_angle = angle_to_centre + 400; // target is always a little clockwise from the current positiono

move_x = centre_x + cos(move_angle, 400);
move_y = centre_y + sin(move_angle, 400);

auto_move.move_to(move_x, move_y);


// now target and fire the left and right pulse objects:

if (attacking_left == 1)
{
  other_target_x = process[TARGET_LEFT].get_core_x();
  other_target_y = process[TARGET_LEFT].get_core_y();
  if (other_target_x >= 0 // checks target visibility (will be <0 if target not visible)
   && process[TARGET_LEFT].distance_less(1000) // checks distance from this process to target
   && arc_length(angle - 2048, atan2(other_target_y - core_y, other_target_x - core_x)) <= 2500)
  {
    auto_att_left.fire_at(TARGET_LEFT, 0);
  }
    else
      {
        attacking_left = 0;
      }
}
  else
    {
      scan_result = scan_for_threat(cos(angle - 2048, 400), sin(angle - 2048, 400), TARGET_LEFT);
      if (scan_result == 1)
      {
        attacking_left = 1;
        auto_att_left.aim_at(TARGET_LEFT, 0); // just aim for now. wait until next cycle to fire
      }
        else
          auto_att_left.no_target(); // returns object to its default angle
    }

if (attacking_right == 1)
{
  other_target_x = process[TARGET_RIGHT].get_core_x();
  other_target_y = process[TARGET_RIGHT].get_core_y();
  if (other_target_x >= 0 // checks target visibility (will be <0 if target not visible)
   && process[TARGET_RIGHT].distance_less(1000) // checks distance from this process to target
   && arc_length(angle + 2048, atan2(other_target_y - core_y, other_target_x - core_x)) <= 2500)
  {
    auto_att_right.fire_at(TARGET_RIGHT, 0);
  }
    else
      {
        attacking_right = 0;
      }
}
  else
    {
      scan_result = scan_for_threat(cos(angle + 2048, 400), sin(angle + 2048, 400), TARGET_RIGHT);
      if (scan_result == 1)
      {
        attacking_right = 1;
        auto_att_right.aim_at(TARGET_RIGHT, 0); // just aim for now. wait until next cycle to fire
      }
        else
          auto_att_right.no_target(); // returns object to its default angle
    }
