#include <allegro5/allegro.h>
#include <allegro5/allegro_primitives.h>

#include <stdio.h>
#include <string.h>

#include "m_config.h"

#include "g_header.h"
#include "g_method.h"
#include "e_slider.h"
#include "m_globvars.h"
#include "m_input.h"
#include "m_maths.h"
#include "i_console.h"
#include "i_header.h"
#include "i_buttons.h"
#include "i_display.h"
#include "g_command.h"

#include "g_misc.h"
#include "p_panels.h"

extern struct control_struct control;
extern struct game_struct game;
extern struct command_struct command;
extern struct template_struct templ [PLAYERS] [TEMPLATES_PER_PLAYER];

extern struct fontstruct font [FONTS];
extern struct view_struct view;






struct consolestruct console [CONSOLES];


struct proc_boxstruct proc_box;

void console_newline(int console_index, int print_colour);

// This function is called in initialisation just before the main game loop starts.
// It's also called during game loading (to zero out all of the console data)
void init_consoles(void)
{

 int i;

 for (i = 0; i < CONSOLES; i ++)
 {
  clear_console(i);
 }



// general console
 console[CONSOLE_GENERAL].h_lines = 12;
 console[CONSOLE_GENERAL].h_pixels = console[CONSOLE_GENERAL].h_lines * CONSOLE_LINE_HEIGHT;
 console[CONSOLE_GENERAL].w_letters = 66;
 console[CONSOLE_GENERAL].w_pixels = console[CONSOLE_GENERAL].w_letters * 7 + 32; // +25 is to leave space for the source index on the left
 console[CONSOLE_GENERAL].x = 40;
 console[CONSOLE_GENERAL].y = settings.option [OPTION_WINDOW_H] - console[CONSOLE_GENERAL].h_pixels - 40;

// system console
 console[CONSOLE_SYSTEM].h_lines = 8;
 console[CONSOLE_SYSTEM].h_pixels = console[CONSOLE_SYSTEM].h_lines * CONSOLE_LINE_HEIGHT;
 console[CONSOLE_SYSTEM].w_letters = SYSTEM_CONSOLE_WIDTH_LETTERS;
 console[CONSOLE_SYSTEM].w_pixels = console[CONSOLE_SYSTEM].w_letters * 7 + 32; // ???
 console[CONSOLE_SYSTEM].x = 40;
 console[CONSOLE_SYSTEM].y = 40;



// fprintf(stdout, "\nInit console scrollbar: clines %i min %i h_lines %i", CLINES, CLINES - console[i].h_lines, console[i].h_lines);
//void init_slider(struct slider_struct* sl, int* value_pointer, int dir, int value_min, int value_max, int total_length, int button_increment, int track_increment, int slider_represents_size, int x, int y, int thickness)

// place_proc_box(640, 50, NULL);
// proc_box.button_highlight = 0;
// proc_box.maximised = 1;

}

void setup_consoles(void)
{

 // not currently used

}

void clear_console(int console_index)
{


  console[console_index].cpos = 0;
  console[console_index].current_line_length = 0;
  console[console_index].line_highlight = -1;
  console[console_index].line_highlight = 0;
  console[console_index].source_index = -1;
  console[console_index].time_written = 0;

  int i;

  for (i = 0; i < CLINES; i++)
		{
			console[console_index].cline[i].used = 0;
			console[console_index].cline[i].colour = COL_GREY;
			console[console_index].cline[i].text[0] = '\0';
			console[console_index].cline[i].source_index = -1;
			console[console_index].cline[i].time_written = 0;
		}

}


void run_consoles(void)
{

 int i;

 for (i = 0; i < CONSOLES; i ++)
 {
/*
  if (console[i].open != CONSOLE_CLOSED
   && (console[i].style == CONSOLE_STYLE_BASIC
    || console[i].style == CONSOLE_STYLE_BASIC_UP))
   run_slider(&console[i].scrollbar_v, 0, 0);*/
 }

// console_tick_rollover();

}


char *build_fail_message [4] =
{
	"collision",
	"out of range",
	"too near data well",
	"out of bounds"

};

void display_consoles_and_buttons(void)
{

	int c;
	int i;
	int line_index;

//	for (c = 0; c < CONSOLES; c ++)
	{

		c = CONSOLE_GENERAL; // currently only the general console (bottom left) is displayed fully.

//	 al_draw_filled_rectangle(console[c].x, console[c].y, console[c].x + console[c].w_pixels, console[c].y + console[c].h_pixels, colours.base_trans [COL_BLUE] [SHADE_MED] [1]);
			add_menu_button(console[c].x, console[c].y, console[c].x + console[c].w_pixels, console[c].y + console[c].h_pixels,
																			colours.base_trans [COL_BLUE] [SHADE_MED] [TRANS_MED], 7, 3);


		line_index = console[c].cpos;
	 for (i = 0; i < console[c].h_lines; i ++)
		{
			if (console[c].cline[line_index].time_written > w.world_time - 64)
			 add_menu_button(console[c].x + 3, console[c].y + console[c].h_pixels - ((i+1)*CONSOLE_LINE_HEIGHT) + 1, console[c].x + console[c].w_pixels - 6, console[c].y + console[c].h_pixels - ((i)*CONSOLE_LINE_HEIGHT) - 1,
																				al_map_rgba(80, 120, 200, 129 - (w.world_time - console[c].cline[line_index].time_written) * 2), 5, 3);

//				 															colours.base_trans [COL_BLUE] [SHADE_MED] [TRANS_MED], 3, 1);

			line_index --;
			if (line_index < 0)
				line_index = CLINES-1;
		}

		if (console[c].line_highlight_time >= game.total_time)
			 add_menu_button(console[c].x + 3, console[c].y + ((console[c].line_highlight)*CONSOLE_LINE_HEIGHT) + 1, console[c].x + console[c].w_pixels - 6, console[c].y + ((console[c].line_highlight+1)*CONSOLE_LINE_HEIGHT) - 1,
																				al_map_rgba(100, 140, 200, 80), 5, 3);


		draw_menu_buttons();


		line_index = console[c].cpos;
	 for (i = 0; i < console[c].h_lines; i ++)
		{
			if (console[c].cline[line_index].source_index != -1)
 			al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_MED], console[c].x + 22, console[c].y + console[c].h_pixels - ((i+1)*CONSOLE_LINE_HEIGHT) + 5, ALLEGRO_ALIGN_RIGHT, "%i", console[c].cline[line_index].source_index);
			al_draw_textf(font[FONT_SQUARE].fnt, colours.print [console[c].cline[line_index].colour], console[c].x + 29, console[c].y + console[c].h_pixels - ((i+1)*CONSOLE_LINE_HEIGHT) + 4, ALLEGRO_ALIGN_LEFT, "%s", console[c].cline[line_index].text);

			line_index --;
			if (line_index < 0)
				line_index = CLINES-1;
		}

	}

c = CONSOLE_SYSTEM; // system console gets special minimalist treatment:

 if (console[c].time_written > w.world_time - 64)
	{
			add_menu_button(console[c].x, console[c].y, console[c].x + console[c].w_pixels, console[c].y + console[c].h_pixels,
																			colours.packet [1] [(console[c].time_written + 64 - w.world_time) / 2], 7, 3);
	}



		line_index = console[c].cpos;
	 for (i = 0; i < console[c].h_lines; i ++)
		{
			al_draw_textf(font[FONT_SQUARE].fnt, colours.print [console[c].cline[line_index].colour], console[c].x + 29, console[c].y + console[c].h_pixels - ((i+1)*CONSOLE_LINE_HEIGHT) + 4, ALLEGRO_ALIGN_LEFT, "%s", console[c].cline[line_index].text);

			line_index --;
			if (line_index < 0)
				line_index = CLINES-1;
		}




// TO DO: initialise this in a more sensible way

	if (command.display_build_buttons)
	{
  char build_button_string [TEMPLATES_PER_PLAYER] [TEMPLATE_NAME_LENGTH + 8];
  reset_i_buttons();
		int button_y = view.build_buttons_y2 - (BUILD_BUTTON_H * TEMPLATES_PER_PLAYER);

		int button_shade;
		int template_index = 1;
  for (i = 0; i < TEMPLATES_PER_PLAYER; i ++)
		{
			template_index = i;
			if (!templ[game.user_player_index][template_index].active)
			{
				button_shade = SHADE_LOW;
 			sprintf(build_button_string [i], "Empty");
			}
			 else
				{
			  if (view.mouse_on_build_button_timestamp == game.total_time
				  && view.mouse_on_build_button == template_index)
				 {
					  button_shade = SHADE_HIGH;
				 }
			     else
					    button_shade = SHADE_MED;
//  			sprintf(build_button_string [i], "%s", templ[game.user_player_index][i].name);
//  			sprintf(build_button_string [i], "%s (%i)", templ[game.user_player_index][i].name, templ[game.user_player_index][i].data_cost);
				}

			add_menu_button(view.build_buttons_x1, button_y + (i * BUILD_BUTTON_H), view.build_buttons_x2, button_y + (i * BUILD_BUTTON_H) + BUILD_BUTTON_H - 2,
																			colours.base_trans [COL_BLUE] [button_shade] [TRANS_MED], 7, 3);
//			add_menu_string(view.build_buttons_x1 + 6, button_y + (i * BUILD_BUTTON_H) + 10, &colours.base_trans [COL_GREY] [SHADE_HIGH] [TRANS_THICK], 0, FONT_SQUARE, build_button_string [i]);
//			al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH],
//																	view.build_buttons_x1 + 2, button_y - (buttons_drawn * BUILD_BUTTON_H) + 2, ALLEGRO_ALIGN_LEFT, "Build %i:%s", i, templ[game.user_player_index][i].name);
//			buttons_drawn++;
		}
	 //if (buttons_drawn > 0)
//		 draw_menu_buttons();

		add_menu_button(view.build_buttons_x1 - 3, button_y - BUILD_BUTTON_H, view.build_buttons_x2 - 13, button_y - 2,
																			colours.base_trans [COL_BLUE] [SHADE_MAX] [TRANS_MED], 7, 3);


   draw_vbuf();

	  al_draw_textf(font[FONT_SQUARE].fnt, colours.base_trans [COL_GREY] [SHADE_HIGH] [TRANS_THICK], view.build_buttons_x1 + 3, button_y - BUILD_BUTTON_H + 10, ALLEGRO_ALIGN_LEFT, "Build");


   template_index = 0;

   for (i = 0; i < TEMPLATES_PER_PLAYER; i ++)
		 {
		  al_draw_textf(font[FONT_SQUARE].fnt, colours.base_trans [COL_GREY] [SHADE_HIGH] [TRANS_MED], view.build_buttons_x1 + 6, button_y + (i * BUILD_BUTTON_H) + 10, ALLEGRO_ALIGN_LEFT, "%i", template_index);
 			if (templ[game.user_player_index][template_index].active)
			 {
			  al_draw_textf(font[FONT_SQUARE].fnt, colours.base_trans [COL_GREY] [SHADE_HIGH] [TRANS_THICK], view.build_buttons_x1 + 22, button_y + (i * BUILD_BUTTON_H) + 10, ALLEGRO_ALIGN_LEFT, "%s", templ[game.user_player_index][template_index].name);
			  al_draw_textf(font[FONT_SQUARE].fnt, colours.base_trans [COL_GREY] [SHADE_HIGH] [TRANS_THICK], view.build_buttons_x2 - 8, button_y + (i * BUILD_BUTTON_H) + 10, ALLEGRO_ALIGN_RIGHT, "%i", templ[game.user_player_index][template_index].data_cost);
//			  al_draw_textf(font[FONT_SQUARE].fnt, colours.base_trans [COL_GREY] [SHADE_HIGH] [TRANS_THICK], view.build_buttons_x2 - 8, button_y + (i * BUILD_BUTTON_H) + 10, ALLEGRO_ALIGN_RIGHT, "%i", templ[game.user_player_index][template_index].data_cost);

//				 core->build_cooldown_time = w.world_time + ((templ[core->player_index][build_template].build_cooldown_time / core->number_of_build_objects + 1) * EXECUTION_COUNT); // number_of_build_objects has been confirmed to be non-zero above

			 }
			  else
 			  al_draw_textf(font[FONT_SQUARE].fnt, colours.base_trans [COL_GREY] [SHADE_HIGH] [TRANS_MED], view.build_buttons_x1 + 22, button_y + (i * BUILD_BUTTON_H) + 10, ALLEGRO_ALIGN_LEFT, "empty");
 			template_index++;
// 			template_index %= TEMPLATES_PER_PLAYER;
		 }



		 if (command.build_mode != BUILD_MODE_NONE)
			{
				button_y = view.build_buttons_y2 - 5;
				int fail_message = 0;
#define BUILD_FAIL_BUTTON_W 160
#define BUILD_FAIL_BUTTON_H 30
				if (command.build_fail_collision)
				{
							add_menu_button(view.build_buttons_x2 + 5, button_y - BUILD_FAIL_BUTTON_H, view.build_buttons_x2 + BUILD_FAIL_BUTTON_W, button_y - 2,
																			colours.base_trans [COL_RED] [SHADE_MAX] [TRANS_MED], 7, 3);
							add_menu_string(view.build_buttons_x2 + 10, button_y - BUILD_FAIL_BUTTON_H + 10, &colours.base_trans [COL_GREY] [SHADE_HIGH] [TRANS_THICK], ALLEGRO_ALIGN_LEFT, FONT_SQUARE, build_fail_message [0]);
							fail_message = 1;
				   button_y -= BUILD_FAIL_BUTTON_H;
				}
				if (command.build_fail_range)
				{
							add_menu_button(view.build_buttons_x2 + 5, button_y - BUILD_FAIL_BUTTON_H, view.build_buttons_x2 + BUILD_FAIL_BUTTON_W, button_y - 2,
																			colours.base_trans [COL_RED] [SHADE_MAX] [TRANS_MED], 7, 3);
							add_menu_string(view.build_buttons_x2 + 10, button_y - BUILD_FAIL_BUTTON_H + 10, &colours.base_trans [COL_GREY] [SHADE_HIGH] [TRANS_THICK], ALLEGRO_ALIGN_LEFT, FONT_SQUARE, build_fail_message [1]);
							fail_message = 1;
				   button_y -= BUILD_FAIL_BUTTON_H;
				}
				if (command.build_fail_static)
				{
							add_menu_button(view.build_buttons_x2 + 5, button_y - BUILD_FAIL_BUTTON_H, view.build_buttons_x2 + BUILD_FAIL_BUTTON_W, button_y - 2,
																			colours.base_trans [COL_RED] [SHADE_MAX] [TRANS_MED], 7, 3);
							add_menu_string(view.build_buttons_x2 + 10, button_y - BUILD_FAIL_BUTTON_H + 10, &colours.base_trans [COL_GREY] [SHADE_HIGH] [TRANS_THICK], ALLEGRO_ALIGN_LEFT, FONT_SQUARE, build_fail_message [2]);
							fail_message = 1;
   				button_y -= BUILD_FAIL_BUTTON_H;
				}
				if (command.build_fail_edge)
				{
							add_menu_button(view.build_buttons_x2 + 5, button_y - BUILD_FAIL_BUTTON_H, view.build_buttons_x2 + BUILD_FAIL_BUTTON_W, button_y - 2,
																			colours.base_trans [COL_RED] [SHADE_MAX] [TRANS_MED], 7, 3);
							add_menu_string(view.build_buttons_x2 + 10, button_y - BUILD_FAIL_BUTTON_H + 10, &colours.base_trans [COL_GREY] [SHADE_HIGH] [TRANS_THICK], ALLEGRO_ALIGN_LEFT, FONT_SQUARE, build_fail_message [3]);
							fail_message = 1;
   				button_y -= BUILD_FAIL_BUTTON_H;
				}
				if (fail_message)
				{
					draw_menu_buttons();
					draw_menu_strings();
				}

			}




// queue: (should be able to assume that command.builder_core_index is valid if display_build_buttons is 1

		button_y = view.build_buttons_y2 - (BUILD_BUTTON_H * (TEMPLATES_PER_PLAYER + 3)) - 10;
//   fpr("\nQueue: ");

//  for (i = 0; i < BUILD_COMMAND_QUEUE; i ++)
		{
//   fpr(" %i", w.core[command.builder_core_index].build_command_queue[i].active);

		}

  for (i = 0; i < BUILD_COMMAND_QUEUE; i ++)
		{
			if (w.core[command.builder_core_index].build_command_queue[i].active == 0)
				break;

			  if (view.mouse_on_build_queue_button_timestamp == game.total_time
				  && view.mouse_on_build_queue_button == i)
					  button_shade = SHADE_HIGH;
			     else
					    button_shade = SHADE_MED;


			add_menu_button(view.build_buttons_x1, button_y - (i * BUILD_BUTTON_H), view.build_buttons_x2, button_y - (i * BUILD_BUTTON_H) + BUILD_BUTTON_H - 2,
																			colours.base_trans [COL_AQUA] [button_shade] [TRANS_MED], 3, 7);


		}

  for (i = 0; i < BUILD_COMMAND_QUEUE; i ++)
		{
			if (w.core[command.builder_core_index].build_command_queue[i].active == 0)
				break;

			template_index = w.core[command.builder_core_index].build_command_queue[i].build_template;
	  al_draw_textf(font[FONT_SQUARE].fnt, colours.base_trans [COL_GREY] [SHADE_HIGH] [TRANS_THICK], view.build_buttons_x1 + 22, button_y - (i * BUILD_BUTTON_H) + 10, ALLEGRO_ALIGN_LEFT, "%s", templ[game.user_player_index][template_index].name);
   if (w.core[command.builder_core_index].build_command_queue[i].build_command_ctrl)
	   al_draw_textf(font[FONT_SQUARE].fnt, colours.base_trans [COL_TURQUOISE] [SHADE_MAX] [TRANS_THICK], view.build_buttons_x2 - 8, button_y - (i * BUILD_BUTTON_H) + 10, ALLEGRO_ALIGN_RIGHT, "+");

		}

//			if (w.core[command.builder_core_index].build_command_queue[0].active != 0)
			{

		  add_menu_button(view.build_buttons_x1 - 3, button_y + (BUILD_BUTTON_H*1), view.build_buttons_x2 - 13, button_y + (BUILD_BUTTON_H*2) - 2,// - BUILD_BUTTON_H - 2,
				 															colours.base_trans [COL_AQUA] [SHADE_MAX] [TRANS_MED], 3, 7);


    draw_vbuf();

	   al_draw_textf(font[FONT_SQUARE].fnt, colours.base_trans [COL_GREY] [SHADE_HIGH] [TRANS_THICK], view.build_buttons_x1 + 3, button_y + BUILD_BUTTON_H + 10, ALLEGRO_ALIGN_LEFT, "Queue");
			}



	}


 if (game.phase == GAME_PHASE_PREGAME)
 {
 	 int shade = SHADE_MED;

 	 if (control.mouse_panel == PANEL_MAIN
				&&	control.mouse_x_screen_pixels > view.window_x_unzoomed / 2 - 180
			 && control.mouse_x_screen_pixels < view.window_x_unzoomed / 2 + 180
			 && control.mouse_y_screen_pixels > view.window_y_unzoomed / 2 - 60
			 && control.mouse_y_screen_pixels < view.window_y_unzoomed / 2 + 30)
					shade = SHADE_MAX;

	  add_menu_button(view.window_x_unzoomed / 2 - 180,
																			view.window_y_unzoomed / 2 - 60,
																			view.window_x_unzoomed / 2 + 180,
																			view.window_y_unzoomed / 2 + 30,
			 															colours.base_trans [COL_AQUA] [shade] [TRANS_MED], 12, 7);
// button dimensions also dealt with in run_pregame() in g_game.c

   draw_vbuf();

   al_draw_textf(font[FONT_SQUARE_LARGE].fnt, colours.base [COL_GREY] [SHADE_MAX], view.window_x_unzoomed / 2, view.window_y_unzoomed / 2 - 20, ALLEGRO_ALIGN_CENTRE, ">>> CLICK WHEN READY <<<");

   if (game.spawn_fail != -1)
			{

 	  add_menu_button(view.window_x_unzoomed / 2 - 170,
																			 view.window_y_unzoomed / 2 + 55,
																			 view.window_x_unzoomed / 2 + 170,
																			 view.window_y_unzoomed / 2 + 100,
			 															 colours.base_trans [COL_RED] [SHADE_LOW] [TRANS_FAINT], 12, 7);
// button dimensions also dealt with in run_pregame() in g_game.c

   draw_vbuf();

   al_draw_textf(font[FONT_SQUARE].fnt, colours.base [COL_RED] [SHADE_MAX], view.window_x_unzoomed / 2, view.window_y_unzoomed / 2 + 65, ALLEGRO_ALIGN_CENTRE, "Player %i spawn failure", game.spawn_fail);
   switch(game.spawn_fail_reason)
   {
   	case SPAWN_FAIL_LOCK:
     al_draw_textf(font[FONT_SQUARE].fnt, colours.base [COL_RED] [SHADE_MAX], view.window_x_unzoomed / 2, view.window_y_unzoomed / 2 + 80, ALLEGRO_ALIGN_CENTRE, "(template 0 could not be locked)");
     break;
   	case SPAWN_FAIL_DATA:
     al_draw_textf(font[FONT_SQUARE].fnt, colours.base [COL_RED] [SHADE_MAX], view.window_x_unzoomed / 2, view.window_y_unzoomed / 2 + 80, ALLEGRO_ALIGN_CENTRE, "(template 0 data cost too high (maximum %i))", w.player[game.spawn_fail].data);
     break;
   }


			}
 }
  else
		{
   if (game.phase == GAME_PHASE_OVER
			 && game.game_over_time > 60)
   {
   	 int shade = SHADE_MED;

 	   if (control.mouse_panel == PANEL_MAIN
				  &&	control.mouse_x_screen_pixels > view.window_x_unzoomed / 2 - 180
			   && control.mouse_x_screen_pixels < view.window_x_unzoomed / 2 + 180
			   && control.mouse_y_screen_pixels > view.window_y_unzoomed / 2 - 60
			   && control.mouse_y_screen_pixels < view.window_y_unzoomed / 2 + 30)
					  shade = SHADE_MAX;

	    add_menu_button(view.window_x_unzoomed / 2 - 180,
																			  view.window_y_unzoomed / 2 - 60,
																			  view.window_x_unzoomed / 2 + 180,
																			  view.window_y_unzoomed / 2 + 30,
			 															  colours.base_trans [COL_YELLOW] [shade] [TRANS_MED], 12, 7);
// button dimensions also dealt with in run_pregame() in g_game.c

     draw_vbuf();

     al_draw_textf(font[FONT_SQUARE_LARGE].fnt, colours.base [COL_GREY] [SHADE_MAX], view.window_x_unzoomed / 2, view.window_y_unzoomed / 2 - 20, ALLEGRO_ALIGN_CENTRE, ">>> CLICK TO EXIT <<<");
   }
    else
     draw_vbuf();
		}



}


void place_build_buttons(void)
{

	view.build_buttons_x1 = console[CONSOLE_GENERAL].x;
	view.build_buttons_y2 = console[CONSOLE_GENERAL].y - 5;
	view.build_buttons_x2 = view.build_buttons_x1 + BUILD_BUTTON_W;
	view.build_buttons_y1 = view.build_buttons_y2 - (TEMPLATES_PER_PLAYER * BUILD_BUTTON_H);

	view.build_queue_buttons_y2 = view.build_buttons_y2 - (BUILD_BUTTON_H * (TEMPLATES_PER_PLAYER + 2)) - 10; //view.build_buttons_y1 - 5;
	view.build_queue_buttons_y1 = view.build_queue_buttons_y2 - (BUILD_COMMAND_QUEUE * BUILD_BUTTON_H); // note not all of the build command queue buttons may be open

//		button_y = view.build_buttons_y2 - (BUILD_BUTTON_H * (TEMPLATES_PER_PLAYER + 3)) - 10;


}


void check_mouse_on_consoles_etc(int mouse_x, int mouse_y, int left_button)
{


}

void write_text_to_console(int console_index, int print_colour, int text_source, int source_core_created_timestamp, char* write_text)
{
//fpr("\n Console: [%s]", write_text);
// if the most recently written line was written by a different core, or in a different tick, go to next line:
 if ((console[console_index].source_index != text_source
		 || console[console_index].time_written != w.world_time)
				&& write_text[0] != '\n') // no need for newline if process has written newline itself
			console_newline(console_index, print_colour);

	int line_pos = console[console_index].current_line_length;
	int write_text_pos = 0;

	while(write_text [write_text_pos] != '\0')
	{
  if (write_text [write_text_pos] == '\n')
		{
  	console[console_index].cline[console[console_index].cpos].text [line_pos] = '\0';
  	if (write_text_pos != 0) // don't indicate a newly written line on the old line if the \n is at the start of the new line
	   console[console_index].cline[console[console_index].cpos].time_written = w.world_time;
			console_newline(console_index, print_colour);
			write_text_pos ++;
			line_pos = 0;
			continue;
		}
		if (line_pos >= console[console_index].w_letters - 2)
		{
  	console[console_index].cline[console[console_index].cpos].text [line_pos] = '\0';
   console[console_index].cline[console[console_index].cpos].time_written = w.world_time;
			console_newline(console_index, print_colour);
			line_pos = 0;
		}
		console[console_index].cline[console[console_index].cpos].text [line_pos] = write_text [write_text_pos];
		write_text_pos ++;
		line_pos ++;

	};

	console[console_index].cline[console[console_index].cpos].text [line_pos] = '\0';
 console[console_index].cline[console[console_index].cpos].time_written = w.world_time;
	console[console_index].current_line_length = line_pos;

	console[console_index].cline[console[console_index].cpos].source_index = text_source;
	console[console_index].cline[console[console_index].cpos].source_core_created_timestamp = source_core_created_timestamp;

 console[console_index].source_index = text_source;
 console[console_index].time_written = w.world_time;


}


void console_newline(int console_index, int print_colour)
{
	console[console_index].cpos++;
	if (console[console_index].cpos >= CLINES)
		console[console_index].cpos = 0;

	console[console_index].cline[console[console_index].cpos].text [0] = '\0';
	console[console_index].current_line_length = 0;
	console[console_index].cline[console[console_index].cpos].source_index = -1;
	console[console_index].cline[console[console_index].cpos].colour = print_colour;

}
