

#include <allegro5/allegro.h>
#include <allegro5/allegro_primitives.h>


#include <stdio.h>
#include <string.h>
#include <math.h>

#include "m_config.h"

#include "g_header.h"
#include "m_globvars.h"

#include "g_misc.h"

#include "c_header.h"

#include "e_header.h"
#include "e_inter.h"
#include "e_help.h"
#include "i_header.h"
#include "i_input.h"
#include "i_view.h"
#include "i_buttons.h"
#include "i_display.h"
#include "m_input.h"
#include "e_log.h"
#include "m_maths.h"

#include "p_panels.h"
#include "d_draw.h"
#include "d_design.h"
#include "t_template.h"

#include "g_shapes.h"

struct design_window_struct dwindow;
extern struct nshape_struct nshape [NSHAPES];
extern struct dshape_struct dshape [NSHAPES]; // uses same indices as NSHAPES
extern struct vbuf_struct vbuf;
extern struct object_type_struct otype [OBJECT_TYPES];;

extern struct template_struct templ [PLAYERS] [TEMPLATES_PER_PLAYER];
extern struct fontstruct font [FONTS];
extern struct game_struct game;
extern struct identifierstruct identifier [IDENTIFIERS]; // used to display some information about e.g. core name
extern struct design_sub_button_struct design_sub_button [DSB_STRUCT_SIZE];

void draw_template_members(void);
static void draw_select_box(float xa, float ya, float box_size, float line_length, float line_width, timestamp select_time, ALLEGRO_COLOR col);
static void draw_collision_box(float xa, float ya, float box_size, ALLEGRO_COLOR col);
void reset_design_window(void);

static void add_design_quad(float xa, float ya, float xb, float yb, float xc, float yc, float xd, float yd, ALLEGRO_COLOR col);

static void design_help_unhighlighted(int base_x, int base_y);
static void design_help_highlight(int base_x, int base_y);

void init_design_window(void)
{

 dwindow.templ = &templ [0] [0];

 reset_design_window();

}

void reset_design_window(void)
{

	dwindow.window_pos_x = (DESIGN_WINDOW_W / 2) - (panel[PANEL_DESIGN].element[FPE_DESIGN_WINDOW].w / 2);
	dwindow.window_pos_y = (DESIGN_WINDOW_H / 2) - (panel[PANEL_DESIGN].element[FPE_DESIGN_WINDOW].h / 2);

 update_slider(SLIDER_DESIGN_SCROLLBAR_H);
 update_slider(SLIDER_DESIGN_SCROLLBAR_V);

 dwindow.highlight_member = -1;
 dwindow.highlight_link = -1;

 dwindow.selected_member = -1;
 dwindow.selected_link = -1;

}

// This function draws the design window based on position of the relevant panel element
void draw_design_window(void)
{

	int base_x1 = panel[PANEL_DESIGN].x1 + panel[PANEL_DESIGN].subpanel[FSP_DESIGN_WINDOW].x1; // don't need to add element x1 as it's always 0
	int base_y1 = panel[PANEL_DESIGN].y1 + panel[PANEL_DESIGN].subpanel[FSP_DESIGN_WINDOW].y1; // don't need to add element y1 as it's always 0
	int base_x2 = panel[PANEL_DESIGN].x1 + panel[PANEL_DESIGN].subpanel[FSP_DESIGN_WINDOW].x1 + panel[PANEL_DESIGN].element[FPE_DESIGN_WINDOW].w - 10;
	int base_y2 = panel[PANEL_DESIGN].y1 + panel[PANEL_DESIGN].subpanel[FSP_DESIGN_WINDOW].y1 + panel[PANEL_DESIGN].element[FPE_DESIGN_WINDOW].h;

 int clip_x2 = base_x2;
 if (clip_x2 > panel[PANEL_DESIGN].x2)
		clip_x2 = panel[PANEL_DESIGN].x2;

// Note that x2 can be outside the panel:
 al_set_clipping_rectangle(base_x1, base_y1, base_x2 - base_x1 + SLIDER_BUTTON_SIZE, base_y2 - base_y1 + SLIDER_BUTTON_SIZE);

 al_clear_to_color(colours.base [COL_GREY] [SHADE_MIN]);

// al_draw_rectangle(base_x1 + 3, base_y1 + 3, base_x2 + 93, base_y2 - 3, colours.base [COL_YELLOW] [SHADE_HIGH], 1);

	float centre_x = base_x1 + (DESIGN_WINDOW_W/2) - dwindow.window_pos_x;
	float centre_y = base_y1 + (DESIGN_WINDOW_H/2) - dwindow.window_pos_y;

	if (dwindow.templ->active == 0)
	{
		al_draw_textf(font[FONT_SQUARE].fnt, colours.base [COL_GREY] [SHADE_HIGH], centre_x, centre_y - 10, ALLEGRO_ALIGN_CENTRE, "Empty template");
 	al_set_clipping_rectangle(panel[PANEL_DESIGN].x1, panel[PANEL_DESIGN].y1, panel[PANEL_DESIGN].w, panel[PANEL_DESIGN].h);
		return;
	}

 add_line(0, base_x1, centre_y, base_x2, centre_y, colours.base [COL_GREY] [SHADE_MED]);
 add_line(0, centre_x, base_y1, centre_x, base_y2, colours.base [COL_GREY] [SHADE_MED]);
	al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_MED], base_x2 - 3, centre_y + 5, ALLEGRO_ALIGN_RIGHT, "Front >>");

 if (dwindow.templ->active)
	{
	 al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_MED], base_x2 - 4, base_y2 - 26, ALLEGRO_ALIGN_RIGHT, "data cost %i", dwindow.templ->data_cost);
	 al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_MED], base_x2 - 4, base_y2 - 13, ALLEGRO_ALIGN_RIGHT, "power: capacity %i peak %i base %i", nshape[dwindow.templ->member[0].shape].power_capacity, dwindow.templ->power_use_peak, dwindow.templ->power_use_base);
//  al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], panel[PANEL_DESIGN].x1 + 140, panel[PANEL_DESIGN].y1+15, ALLEGRO_ALIGN_LEFT, "Power: capacity %i  use: peak %i average %i base %i", nshape[dwindow.templ->member[0].shape].power_capacity, dwindow.templ->power_use_peak, dwindow.templ->power_use_smoothed, dwindow.templ->power_use_base);

	}


 draw_vbuf();


 draw_template_members();

 draw_vbuf();

// reset clipping rectangle to draw rest of the panel
	al_set_clipping_rectangle(panel[PANEL_DESIGN].x1, panel[PANEL_DESIGN].y1, panel[PANEL_DESIGN].w, panel[PANEL_DESIGN].h);


}


void draw_template_members(void)
{

	int m,i;
	float base_x = panel[PANEL_DESIGN].x1 + panel[PANEL_DESIGN].subpanel[FSP_DESIGN_WINDOW].x1 + (DESIGN_WINDOW_W/2) - dwindow.window_pos_x;
	float base_y = panel[PANEL_DESIGN].y1 + panel[PANEL_DESIGN].subpanel[FSP_DESIGN_WINDOW].y1 + (DESIGN_WINDOW_H/2) - dwindow.window_pos_y;
	float x, y;
	struct template_member_struct* mem;


	struct nshape_struct* nsh;
/*
	ALLEGRO_COLOR proc_col [2] [PROC_COL_LEVELS] [2]; // first [2] is for colliding (0)/non-colliding (1)
	proc_col [0] [0] [0] = colours.proc_col [0] [0] [9];
	proc_col [0] [1] [0] = colours.proc_col [0] [1] [9];
	proc_col [0] [2] [0] = colours.proc_col [0] [2] [9];
	proc_col [0] [3] [0] = colours.proc_col [0] [3] [9];

	proc_col [0] [0] [1] = colours.proc_outline [0] [0] [9];
	proc_col [0] [1] [1] = colours.proc_outline [0] [1] [9];
	proc_col [0] [2] [1] = colours.proc_outline [0] [2] [9];
	proc_col [0] [3] [1] = colours.proc_outline [0] [3] [9];

	proc_col [1] [0] [0] = colours.proc_col [1] [0] [9];
	proc_col [1] [1] [0] = colours.proc_col [1] [1] [9];
	proc_col [1] [2] [0] = colours.proc_col [1] [2] [9];
	proc_col [1] [3] [0] = colours.proc_col [1] [3] [9];

	proc_col [1] [0] [1] = colours.proc_outline [1] [0] [9];
	proc_col [1] [1] [1] = colours.proc_outline [1] [1] [9];
	proc_col [1] [2] [1] = colours.proc_outline [1] [2] [9];
	proc_col [1] [3] [1] = colours.proc_outline [1] [3] [9];*/

	for (m = 0; m < GROUP_MAX_MEMBERS; m++)
	{
		if (dwindow.templ->member[m].exists == 0)
			continue;
		mem = &dwindow.templ->member[m];

		x = base_x + al_fixtof(mem->position.x);
		y = base_y + al_fixtof(mem->position.y);
		if (dwindow.highlight_member == m
			&&	control.mouse_panel == PANEL_DESIGN) // don't draw highlight if mouse not in panel)
		{
   draw_select_box(x,
																			y,
																			30, // box size
																		 5, // line length
																		 2, // line_width
																		 game.total_time,
																		 colours.base_trans [COL_YELLOW] [SHADE_MAX] [TRANS_THICK]);
		}
		if (dwindow.selected_member == m)
		{
   draw_select_box(x,
																			y,
																			39, // box size
																		 7, // line length
																		 3, // line_width
																		 dwindow.select_member_timestamp,
																		 colours.base_trans [COL_GREY] [SHADE_MAX] [TRANS_THICK]);
//			for (i = 0; i < nshape[mem->shape].links; i ++)
		}

		if (mem->move_obstruction)
   draw_collision_box(x, y, MOVE_OBSTRUCTION_BOX_SIZE, colours.base_trans [COL_RED] [SHADE_HIGH] [TRANS_MED]);
    else
     draw_collision_box(x, y, MOVE_OBSTRUCTION_BOX_SIZE, colours.base_trans [COL_GREY] [SHADE_MED] [TRANS_FAINT]);


  int design_colour [2] = {PLAN_COL_DESIGN_BASIC, PLAN_COL_DESIGN_ERROR};
  if (dwindow.templ->locked)
			design_colour [0] = PLAN_COL_DESIGN_LOCKED; // should be able to assume that mem->collision and mem->move_obstruction will always be 0 for a locked template
  if (dwindow.templ->modified)
			design_colour [0] = PLAN_COL_DESIGN_MODIFIED;

  draw_proc_shape(x, y, mem->group_angle_offset,// - AFX_ANGLE_4,
																	mem->shape,
																	0, // player_index
																	1, // zoom
															  colours.plan_col [design_colour [((mem->collision | mem->move_obstruction) != 0)]]);


   for (i = 0; i < MAX_LINKS; i ++)
			{
				switch(mem->object[i].type)
				{
				 case OBJECT_TYPE_UPLINK: // note downlink isn't drawn
			   draw_link_shape(x, y,
																			   mem->group_angle_offset,// - AFX_ANGLE_4,
																	     mem->shape,
																	     i,
																			   base_x + al_fixtof(dwindow.templ->member[mem->connection[0].template_member_index].position.x),
																			   base_y + al_fixtof(dwindow.templ->member[mem->connection[0].template_member_index].position.y),
																			   dwindow.templ->member[mem->connection[0].template_member_index].group_angle_offset,// - AFX_ANGLE_4,
																			   dwindow.templ->member[mem->connection[0].template_member_index].shape,
																	     mem->connection[0].reverse_link_index,
																	     colours.plan_col [design_colour [((mem->collision | mem->move_obstruction) != 0)]],
//																			   proc_col [(mem->collision | mem->move_obstruction | mem->object[i].template_error) != 0] [1] [0],
//																			   proc_col [(mem->collision | mem->move_obstruction | mem->object[i].template_error) != 0] [1] [1],
																			   1); // last number is zoom
						break;

					case OBJECT_TYPE_MOVE:
						{
							float object_x = x + al_fixtoi(fixed_cos(mem->group_angle_offset + nshape[mem->shape].object_angle_fixed [i]) * nshape[mem->shape].object_dist_pixel [i]) + al_fixtoi(fixed_xpart(mem->group_angle_offset + nshape[mem->shape].object_angle_fixed [i] + mem->object[i].base_angle_offset, al_itofix(10)));
							float object_y = y + al_fixtoi(fixed_sin(mem->group_angle_offset + nshape[mem->shape].object_angle_fixed [i]) * nshape[mem->shape].object_dist_pixel [i]) + al_fixtoi(fixed_ypart(mem->group_angle_offset + nshape[mem->shape].object_angle_fixed [i] + mem->object[i].base_angle_offset, al_itofix(10)));
       add_line(4,
					     				  object_x,
     									  object_y,
									       object_x + al_fixtoi(fixed_xpart(mem->group_angle_offset + nshape[mem->shape].object_angle_fixed [i] + mem->object[i].base_angle_offset, al_itofix(400))),
									       object_y + al_fixtoi(fixed_ypart(mem->group_angle_offset + nshape[mem->shape].object_angle_fixed [i] + mem->object[i].base_angle_offset, al_itofix(400))),
										      colours.base_trans [COL_GREY] [SHADE_MED] [TRANS_MED]);
						}
// fall-through

					default:
      draw_object(x, y,
																					mem->group_angle_offset,
																					mem->shape,
																					&mem->object[i], // uses same code as drawing objects for the main display
																					NULL, // no object instance
																					NULL, // no core
																					NULL, // no proc
																					i,
																					colours.plan_col [design_colour [((mem->collision | mem->move_obstruction | (mem->object[i].template_error != 0)) != 0)]],
//																			  colours.proc_col [(mem->collision | mem->move_obstruction | mem->object[i].template_error) != 0] [PROC_DAMAGE_COLS - 1],
//																			  proc_col [(mem->collision | mem->move_obstruction | mem->object[i].template_error) != 0] [1] [0],
//																			  proc_col [(mem->collision | mem->move_obstruction | mem->object[i].template_error) != 0] [2] [1],
																			  1); // last number is zoom
/*
      draw_object_base_shape(x, y,
																					mem->group_angle_offset,
																					mem->shape,
																					i,
																			  colours.base [col] [SHADE_MED],
																			  colours.base [col] [SHADE_LOW],
																			  1); // last number is zoom*/
						break;


				}
/*
 - use this code to work out the correct position for a shape's links
				add_line(3, x, y,
													x + (cos(fixed_to_radians(mem->group_angle_offset) + fixed_to_radians(nshape[mem->shape].link_angle_fixed [i])) * al_fixtof(nshape[mem->shape].link_dist_fixed [i])),
													y + (sin(fixed_to_radians(mem->group_angle_offset) + fixed_to_radians(nshape[mem->shape].link_angle_fixed [i])) * al_fixtof(nshape[mem->shape].link_dist_fixed [i])),
													colours.base [COL_YELLOW] [SHADE_MAX]);*/
			}

/*
	 if (mem->connection[0].template_member_index != -1)
	 {
			draw_link_shape(x, y,
																			mem->group_angle_offset,// - AFX_ANGLE_4,
																	  mem->shape,
																	  mem->connection[0].link_index,
																			base_x + al_fixtof(dwindow.templ->member[mem->connection[0].template_member_index].position.x),
																			base_y + al_fixtof(dwindow.templ->member[mem->connection[0].template_member_index].position.y),
																			dwindow.templ->member[mem->connection[0].template_member_index].group_angle_offset,// - AFX_ANGLE_4,
																			dwindow.templ->member[mem->connection[0].template_member_index].shape,
																	  mem->connection[0].reverse_link_index,
																			colours.base [col] [SHADE_MED],
																			colours.base [col] [SHADE_LOW],
																			1); // last number is zoom


	 }*/
/*
 add_line(2,
									 x + al_fixtof(fixed_xpart(mem->group_angle_offset, al_itofix(15))),
									 y + al_fixtof(fixed_ypart(mem->group_angle_offset, al_itofix(15))),
									 x + al_fixtof(fixed_xpart(mem->group_angle_offset, al_itofix(25))),
									 y + al_fixtof(fixed_ypart(mem->group_angle_offset, al_itofix(25))),
										colours.base [COL_GREY] [SHADE_MED]);*/
/*									 x + al_fixtof(fixed_xpart(mem->group_angle_offset - AFX_ANGLE_4, al_itofix(15))),
									 y + al_fixtof(fixed_ypart(mem->group_angle_offset - AFX_ANGLE_4, al_itofix(15))),
									 x + al_fixtof(fixed_xpart(mem->group_angle_offset - AFX_ANGLE_4, al_itofix(25))),
									 y + al_fixtof(fixed_ypart(mem->group_angle_offset - AFX_ANGLE_4, al_itofix(25))),
										colours.base [COL_GREY] [SHADE_MED]);*/


		if (control.mouse_panel == PANEL_DESIGN // don't draw highlight if mouse not in panel
			&&	dwindow.highlight_member == m
			&& dwindow.highlight_link	!= -1)
		{
#define VERTEX_BOX_SIZE 10
   draw_select_box(base_x - (DESIGN_WINDOW_W/2) + dwindow.highlight_link_x,
																			base_y - (DESIGN_WINDOW_H/2) + dwindow.highlight_link_y,
																			7, // box size
																		 2, // line length
																		 1, // line_width
																		 game.total_time,
																		 colours.base_trans [COL_YELLOW] [SHADE_MAX] [TRANS_THICK]);

		}
		if (dwindow.selected_member == m
			&& dwindow.selected_link	!= -1)
		{
			nsh = &nshape [dwindow.templ->member[m].shape];

   draw_select_box(x + al_fixtoi(fixed_cos(dwindow.templ->member[m].group_angle_offset + nsh->object_angle_fixed [dwindow.selected_link]) * nsh->object_dist_pixel [dwindow.selected_link]),
																			y + al_fixtoi(fixed_sin(dwindow.templ->member[m].group_angle_offset + nsh->object_angle_fixed [dwindow.selected_link]) * nsh->object_dist_pixel [dwindow.selected_link]),
																		 13, // box size
																		 3, // line length
																		 2, // line_width
																		 dwindow.select_link_timestamp,
																		 colours.base_trans [COL_GREY] [SHADE_MAX] [TRANS_THICK]);
		}

	}

}


static void draw_select_box(float xa, float ya, float box_size, float line_length, float line_width, timestamp select_time, ALLEGRO_COLOR col)
{


 float draw_angle = game.total_time * 0.015;

 if (select_time > game.total_time - 8)
		box_size += (8 - (game.total_time - select_time)) * 0.2;

	int i;
	float bit_angle;

	for (i = 0; i < 4; i ++)
	{
		bit_angle = draw_angle + (PI / 2) * i;
 add_design_quad(xa + cos(bit_angle - 0.3) * box_size,
																	ya + sin(bit_angle - 0.3) * box_size,
																	xa + cos(bit_angle - 0.3) * (box_size + line_width),
																	ya + sin(bit_angle - 0.3) * (box_size + line_width),
																	xa + cos(bit_angle + 0.3) * (box_size + line_width),
																	ya + sin(bit_angle + 0.3) * (box_size + line_width),
																	xa + cos(bit_angle + 0.3) * box_size,
																	ya + sin(bit_angle + 0.3) * box_size,
																	col);

	}
/*
 add_design_quad(xa - box_size - line_length, // bottom outer
																	ya - box_size + line_length,
																	xa - box_size - line_length + line_width, // bottom inner
																	ya - box_size + line_length + line_width,
																	xa - box_size + line_length + line_width,
																	ya - box_size - line_length + line_width,
																	xa - box_size + line_length,
																	ya - box_size - line_length,
																	col);

 add_design_quad(xa - box_size - line_length, // bottom outer
																	ya + box_size - line_length,
																	xa - box_size - line_length + line_width, // bottom inner
																	ya + box_size - line_length - line_width,
																	xa - box_size + line_length + line_width,
																	ya + box_size + line_length - line_width,
																	xa - box_size + line_length,
																	ya + box_size + line_length,
																	col);

 add_design_quad(xa + box_size - line_length, // bottom outer
																	ya + box_size + line_length,
																	xa + box_size - line_length - line_width, // bottom inner
																	ya + box_size + line_length - line_width,
																	xa + box_size + line_length - line_width,
																	ya + box_size - line_length - line_width,
																	xa + box_size + line_length,
																	ya + box_size - line_length,
																	col);

 add_design_quad(xa + box_size - line_length, // bottom outer
																	ya - box_size - line_length,
																	xa + box_size - line_length - line_width, // bottom inner
																	ya - box_size - line_length + line_width,
																	xa + box_size + line_length - line_width,
																	ya - box_size + line_length + line_width,
																	xa + box_size + line_length,
																	ya - box_size + line_length,
																	col);
*/
/*
 xa -= 0.5;
 ya -= 0.5;

// top left
			add_line(2,
												xa - box_size + line_length,
												ya - box_size,
												xa - box_size,
												ya - box_size,
												col);
			add_line(2,
												xa - box_size,
												ya - box_size,
												xa - box_size,
												ya - box_size + line_length,
												col);

// top right
			add_line(2,
												xa + box_size - line_length,
												ya - box_size,
												xa + box_size,
												ya - box_size,
												col);
			add_line(2,
												xa + box_size,
												ya - box_size,
												xa + box_size,
												ya - box_size + line_length,
												col);

// bottom left
			add_line(2,
												xa - box_size + line_length,
												ya + box_size,
												xa - box_size,
												ya + box_size,
												col);
			add_line(2,
												xa - box_size,
												ya + box_size,
												xa - box_size,
												ya + box_size - line_length,
												col);

// bottom right
			add_line(2,
												xa + box_size - line_length,
												ya + box_size,
												xa + box_size,
												ya + box_size,
												col);
			add_line(2,
												xa + box_size,
												ya + box_size,
												xa + box_size,
												ya + box_size - line_length,
												col);
*/
}

static void add_design_quad(float xa, float ya, float xb, float yb, float xc, float yc, float xd, float yd, ALLEGRO_COLOR col)
{

#define DESIGN_QUAD_LAYER 4

	vbuf.buffer_triangle[vbuf.vertex_pos_triangle].x = xa;
	vbuf.buffer_triangle[vbuf.vertex_pos_triangle].y = ya;
 vbuf.buffer_triangle[vbuf.vertex_pos_triangle].color = col;
 vbuf.index_triangle [DESIGN_QUAD_LAYER] [vbuf.index_pos_triangle [DESIGN_QUAD_LAYER]++] = vbuf.vertex_pos_triangle;
 vbuf.vertex_pos_triangle++;

	vbuf.buffer_triangle[vbuf.vertex_pos_triangle].x = xb;
	vbuf.buffer_triangle[vbuf.vertex_pos_triangle].y = yb;
 vbuf.buffer_triangle[vbuf.vertex_pos_triangle].color = col;
 vbuf.index_triangle [DESIGN_QUAD_LAYER] [vbuf.index_pos_triangle [DESIGN_QUAD_LAYER]++] = vbuf.vertex_pos_triangle;
 vbuf.vertex_pos_triangle++;

	vbuf.buffer_triangle[vbuf.vertex_pos_triangle].x = xc;
	vbuf.buffer_triangle[vbuf.vertex_pos_triangle].y = yc;
 vbuf.buffer_triangle[vbuf.vertex_pos_triangle].color = col;
 vbuf.index_triangle [DESIGN_QUAD_LAYER] [vbuf.index_pos_triangle [DESIGN_QUAD_LAYER]++] = vbuf.vertex_pos_triangle;
 vbuf.vertex_pos_triangle++;


	vbuf.buffer_triangle[vbuf.vertex_pos_triangle].x = xa;
	vbuf.buffer_triangle[vbuf.vertex_pos_triangle].y = ya;
 vbuf.buffer_triangle[vbuf.vertex_pos_triangle].color = col;
 vbuf.index_triangle [DESIGN_QUAD_LAYER] [vbuf.index_pos_triangle [DESIGN_QUAD_LAYER]++] = vbuf.vertex_pos_triangle;
 vbuf.vertex_pos_triangle++;

	vbuf.buffer_triangle[vbuf.vertex_pos_triangle].x = xc;
	vbuf.buffer_triangle[vbuf.vertex_pos_triangle].y = yc;
 vbuf.buffer_triangle[vbuf.vertex_pos_triangle].color = col;
 vbuf.index_triangle [DESIGN_QUAD_LAYER] [vbuf.index_pos_triangle [DESIGN_QUAD_LAYER]++] = vbuf.vertex_pos_triangle;
 vbuf.vertex_pos_triangle++;

	vbuf.buffer_triangle[vbuf.vertex_pos_triangle].x = xd;
	vbuf.buffer_triangle[vbuf.vertex_pos_triangle].y = yd;
 vbuf.buffer_triangle[vbuf.vertex_pos_triangle].color = col;
 vbuf.index_triangle [DESIGN_QUAD_LAYER] [vbuf.index_pos_triangle [DESIGN_QUAD_LAYER]++] = vbuf.vertex_pos_triangle;
 vbuf.vertex_pos_triangle++;


}


static void draw_collision_box(float xa, float ya, float box_size, ALLEGRO_COLOR col)
{

	add_line(0,
										xa - box_size,
										ya - box_size,
										xa + box_size,
										ya - box_size,
										col);
	add_line(0,
										xa + box_size,
										ya - box_size,
										xa + box_size,
										ya + box_size,
										col);
		add_line(0,
										xa + box_size,
										ya + box_size,
										xa - box_size,
										ya + box_size,
										col);
	add_line(0,
										xa - box_size,
										ya + box_size,
										xa - box_size,
										ya - box_size,
										col);



}

void draw_design_data(void)
{

	int base_x = panel[PANEL_DESIGN].x1 + panel[PANEL_DESIGN].subpanel[FSP_DESIGN_DATA].x1 + 10;
	int base_y = panel[PANEL_DESIGN].y1 + panel[PANEL_DESIGN].subpanel[FSP_DESIGN_DATA].y1 + 3;

#define LOWER_HELP_LINE lower_help_line

// float lower_help_line = panel[PANEL_DESIGN].y1 + panel[PANEL_DESIGN].subpanel[FSP_DESIGN_TOOLS_MAIN].y2 - 42;
 float lower_help_line = panel[PANEL_LOG].y1 - 28;

	switch(dwindow.tools_open)
	{
		case FSP_DESIGN_TOOLS_EMPTY:
   al_draw_textf(font[FONT_SQUARE].fnt, colours.base [COL_BLUE] [SHADE_MAX], base_x - 10, base_y+2, ALLEGRO_ALIGN_LEFT, "Empty template");  break;
		case FSP_DESIGN_TOOLS_CORE:
   al_draw_textf(font[FONT_SQUARE].fnt, colours.base [COL_BLUE] [SHADE_MAX], base_x - 10, base_y+2, ALLEGRO_ALIGN_LEFT, "Core selected");
//   if (dwindow.selected_member != -1) // should never happen but check just to make sure
//			{
//    al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_BLUE] [SHADE_MAX], base_x + 150, base_y+3, ALLEGRO_ALIGN_LEFT, "Component data cost %i", dwindow.templ->member[dwindow.selected_member].data_cost);
//			}
   if (dwindow.templ->locked)
    al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_BLUE] [SHADE_MAX], base_x - 10, LOWER_HELP_LINE+14, ALLEGRO_ALIGN_LEFT, "This template is locked and can't be modified.");
/*			  else
					{
      al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_BLUE] [SHADE_MAX], base_x - 10, LOWER_HELP_LINE, ALLEGRO_ALIGN_LEFT, "Click and drag the core while holding shift to rotate it.");
      al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_BLUE] [SHADE_MAX], base_x - 10, LOWER_HELP_LINE+14, ALLEGRO_ALIGN_LEFT, "Hold control at the same time to lock the front angle.");
					}*/
   break;
		case FSP_DESIGN_TOOLS_MAIN:
   al_draw_textf(font[FONT_SQUARE].fnt, colours.base [COL_BLUE] [SHADE_MAX], base_x - 10, base_y+2, ALLEGRO_ALIGN_LEFT, "Process design");  break;
		case FSP_DESIGN_TOOLS_MEMBER:
   al_draw_textf(font[FONT_SQUARE].fnt, colours.base [COL_BLUE] [SHADE_MAX], base_x - 10, base_y+2, ALLEGRO_ALIGN_LEFT, "Component selected");
//   if (dwindow.selected_member != -1) // should never happen but check just to make sure
//			{
//    al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_BLUE] [SHADE_MAX], base_x + 150, base_y+3, ALLEGRO_ALIGN_LEFT, "Component data cost %i", dwindow.templ->member[dwindow.selected_member].data_cost);
//			}
   if (dwindow.templ->locked)
    al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_BLUE] [SHADE_MAX], base_x - 10, LOWER_HELP_LINE+14, ALLEGRO_ALIGN_LEFT, "This template is locked and can't be modified.");
/*			  else
					{
      al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_BLUE] [SHADE_MAX], base_x - 10, LOWER_HELP_LINE, ALLEGRO_ALIGN_LEFT, "Click and drag the component while holding shift to rotate it.");
      al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_BLUE] [SHADE_MAX], base_x - 10, LOWER_HELP_LINE+14, ALLEGRO_ALIGN_LEFT, "Hold control at the same time to lock the angle.");
					}*/
   break;
		case FSP_DESIGN_TOOLS_EMPTY_LINK:
//   al_draw_textf(font[FONT_SQUARE].fnt, colours.base [COL_BLUE] [SHADE_MAX], base_x - 10, base_y+2, ALLEGRO_ALIGN_LEFT, "Empty link selected");  break;
		case FSP_DESIGN_TOOLS_ACTIVE_LINK:
   al_draw_textf(font[FONT_SQUARE].fnt, colours.base [COL_BLUE] [SHADE_MAX], base_x - 10, base_y+2, ALLEGRO_ALIGN_LEFT, "Object selected");
   if (dwindow.templ->locked)
    al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_BLUE] [SHADE_MAX], base_x - 10, LOWER_HELP_LINE+14, ALLEGRO_ALIGN_LEFT, "This template is locked and can't be modified.");
/*			  else
					{
      al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_BLUE] [SHADE_MAX], base_x - 10, LOWER_HELP_LINE, ALLEGRO_ALIGN_LEFT, "Click and drag the object while holding shift to rotate it (some objects can't be rotated).");
      al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_BLUE] [SHADE_MAX], base_x - 10, LOWER_HELP_LINE+14, ALLEGRO_ALIGN_LEFT, "Hold control at the same time to lock the angle.");
					}*/
   break;
		case FSP_DESIGN_TOOLS_DELETE:
   al_draw_textf(font[FONT_SQUARE].fnt, colours.base [COL_BLUE] [SHADE_MAX], base_x - 10, base_y+2, ALLEGRO_ALIGN_LEFT, "Really delete?");  break;

	}

	base_x += 130;

// al_draw_textf(font[FONT_SQUARE].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x + 5, base_y, ALLEGRO_ALIGN_LEFT, "design data");
// al_draw_textf(font[FONT_SQUARE].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x + 145, base_y+2, ALLEGRO_ALIGN_LEFT, "data cost %i", dwindow.templ->data_cost);
// al_draw_textf(font[FONT_SQUARE].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x + 255, base_y+2, ALLEGRO_ALIGN_LEFT, "inertia %i", dwindow.templ->total_mass);
// al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x + 145, base_y+2, ALLEGRO_ALIGN_LEFT, "Template %i (%s) data cost %i inertia %i", dwindow.templ->template_index, dwindow.templ->name, dwindow.templ->data_cost, dwindow.templ->total_mass);
// al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], panel[PANEL_DESIGN].x1 + 140, panel[PANEL_DESIGN].y1+3, ALLEGRO_ALIGN_LEFT, "Player %i Template %i (%s)  data cost %i  inertia %i", dwindow.templ->player_index, dwindow.templ->template_index, dwindow.templ->name, dwindow.templ->data_cost, dwindow.templ->total_mass);
 al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], panel[PANEL_DESIGN].x1 + 140, panel[PANEL_DESIGN].y1+3, ALLEGRO_ALIGN_LEFT, "Player %i Template %i (%s)", dwindow.templ->player_index, dwindow.templ->template_index, dwindow.templ->name);
// if (dwindow.templ->active)
//  al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], panel[PANEL_DESIGN].x1 + 140, panel[PANEL_DESIGN].y1+15, ALLEGRO_ALIGN_LEFT, "Power: capacity %i  use: peak %i average %i base %i", nshape[dwindow.templ->member[0].shape].power_capacity, dwindow.templ->power_use_peak, dwindow.templ->power_use_smoothed, dwindow.templ->power_use_base);

	if (control.mouse_panel == PANEL_DESIGN)
//		&&	control.panel_element_highlighted_time == game.total_time)
	{
		design_help_highlight(base_x, base_y);
	}
	 else
			design_help_unhighlighted(base_x, base_y);

}

static void design_help_unhighlighted(int base_x, int base_y)
{
// the type of help drawn depends on which menu is open:
 switch(dwindow.tools_open)
 {
 	case FSP_DESIGN_TOOLS_CORE:
//   al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x + 15, base_y+2, ALLEGRO_ALIGN_LEFT, "data cost %i", dwindow.templ->data_cost);
   break;

 }


}

char* object_description [OBJECT_TYPES] [3] =
{
 {"No object.","",""}, //	OBJECT_TYPE_NONE,
 {"Connects a component to its parent component.",
  "Changing this object to a different link changes the way",
  "the component connects to its parent."}, //	OBJECT_TYPE_UPLINK,
//  "Changing this object to a different link changes the way the component connects to its parent."}, //	OBJECT_TYPE_UPLINK,
 {"Connects a component to a child component.",
  "To remove, select the child component and delete it.",
  ""}, //	OBJECT_TYPE_DOWNLINK,
 {"Moves the process. Must not be obstructed by another",
  "component (make sure the line from the object doesn't",
  "cross the square around a component)."}, //	OBJECT_TYPE_MOVE,
 {"Fires a malicious data packet.",
  "Can rotate to track its target.",
  ""}, //	OBJECT_TYPE_PULSE,
 {"Fires a malicious data packet.",
  "Can rotate to track its target.",
  "Large pulse is slower but more powerful than standard pulse."}, //	OBJECT_TYPE_PULSE_L,
 {"Fires a malicious data packet.",
  "Can rotate to track its target.",
  "X-Large pulse is very slow but powerful."}, //	OBJECT_TYPE_PULSE_XL,
 {"Fires a malicious data packet.",
  "Cannot rotate, but is cheaper and stronger than pulse.",
  ""}, //	OBJECT_TYPE_BURST,
 {"Fires a malicious data packet. Cannot rotate.",
  "Large burst is slower but stronger than standard burst.",
  ""}, //	OBJECT_TYPE_BURST_L,
 {"Fires a malicious data packet. Cannot rotate.",
  "X-Large burst is very slow but powerful.",
  ""}, //	OBJECT_TYPE_BURST_XL,
 {"Allows the process to build other processes.",
  "Multiple build objects speed recovery time after building.",
  ""}, //	OBJECT_TYPE_BUILD,
 {"Generates an interface to protect this component.",
  "Requires at least one interface_depth object.",
  "Can't be placed on the core, or the same component as a move object."}, //	OBJECT_TYPE_INTERFACE,
 {"Provides an interface buffer for use by interface objects.",
  "Multiple depth objects increase the size and recovery", //	OBJECT_TYPE_INTERFACE_DEPTH,
  "speed of the buffer."}, //	OBJECT_TYPE_INTERFACE_DEPTH,
// {"","",""}, //	OBJECT_TYPE_INTERFACE_STABILITY,
// {"","",""}, //	OBJECT_TYPE_INTERFACE_RESPONSE,
 {"Allows the process to harvest data from data wells,",
  "and also transfer it to other processes.",
  "Requires at least one storage object."}, //	OBJECT_TYPE_HARVEST,
 {"Stores data harvested from data wells or transferred",
  "from other processes.",
  ""}, //	OBJECT_TYPE_STORAGE,
 {"Allocates data so that it can be used to build processes.",
  "Requires at least one storage object.",
   ""}, //	OBJECT_TYPE_ALLOCATE,
 {"Fires a stream of malicious data. Cannot rotate.",
  "Very powerful, but expensive.",
  ""}, //	OBJECT_TYPE_STREAM,
 {"Fires a stream of malicious data.",
  "Can rotate to track its target.",
  "Very powerful, but expensive."}, //	OBJECT_TYPE_STREAM_DIR,
 {"Long-range attacking object.",
  "Warning: the autocoder isn't very good at using this yet.",
  ""}, //	OBJECT_TYPE_SPIKE,
 {"Repairs damage to components of this process, and restores",
  "destroyed components. Multiple repair objects speed up",
  "repair, and reduce recovery time after restoring."}, //	OBJECT_TYPE_REPAIR,
 {"Works like a standard repair object, but can also repair",
  "and restore damage to other nearby processes. Allows",
  "standard repair objects to do this as well."}, //	OBJECT_TYPE_REPAIR_OTHER,

};

static void draw_design_help_strings(int base_x, int base_y, char* help_heading, char* help_line1, char* help_line2, char* help_line3);
static void draw_design_help_strings_for_help_button(int base_x, int base_y);
static void draw_design_help_strings_for_help_more_button(int base_x, int base_y);

// draws help for the button the mouse is over
static void design_help_highlight(int base_x, int base_y)
{


//	if (control.panel_element_highlighted >= FPE_DESIGN_SUB_BUTTON_0
//		&& control.panel_element_highlighted <= FPE_DESIGN_SUB_BUTTON_14)
	if (dwindow.selected_member != -1)
	{

// mouse is over a button for a shape.
// show information about the shape

		if (panel[PANEL_DESIGN].subpanel[FSP_DESIGN_TOOLS_CORE].open == 1
			|| panel[PANEL_DESIGN].subpanel[FSP_DESIGN_TOOLS_MEMBER].open == 1)
	 {
   int help_shape;
   int help_shape_col = PLAN_COL_DESIGN_BASIC;

  	if (control.panel_element_highlighted_time == game.total_time
				&&	control.panel_element_highlighted >= FPE_DESIGN_SUB_BUTTON_0
  		&& control.panel_element_highlighted <= FPE_DESIGN_SUB_BUTTON_14)
  	{
  		help_shape = panel[PANEL_DESIGN].element[control.panel_element_highlighted].value [2];
  		if (help_shape != dwindow.templ->member[dwindow.selected_member].shape)
					help_shape_col = PLAN_COL_DESIGN_MODIFIED;
  	}
  		else
				{
						help_shape = dwindow.templ->member[dwindow.selected_member].shape;
				}

   al_draw_textf(font[FONT_SQUARE].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x + 255, base_y + 2, ALLEGRO_ALIGN_LEFT, "%s", identifier[nshape[help_shape].keyword_index].name);
			int line_y = base_y + 20;

   al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x + 305, line_y, ALLEGRO_ALIGN_RIGHT, "total cost");
   al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x + 315, line_y, ALLEGRO_ALIGN_LEFT, "%i", dwindow.templ->member[dwindow.selected_member].data_cost);
   line_y += 12;
   al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x + 305, line_y, ALLEGRO_ALIGN_RIGHT, "angle");
   al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x + 315, line_y, ALLEGRO_ALIGN_LEFT, "%i", dwindow.templ->member[dwindow.selected_member].connection_angle_offset_angle);


   draw_proc_shape(base_x + 320, base_y + 90,
																			0, // angle
																	  help_shape, // this should be the shape index
																	  0,
																	  1, // zoom
																	  colours.plan_col [help_shape_col]);

			line_y = base_y + 150;

   al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x + 305, line_y, ALLEGRO_ALIGN_RIGHT, "base cost");
   al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x + 315, line_y, ALLEGRO_ALIGN_LEFT, "%i", nshape[help_shape].data_cost);
//   al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x + 340, line_y, ALLEGRO_ALIGN_RIGHT, "%i (%i)", nshape[panel[PANEL_DESIGN].element[control.panel_element_highlighted].value [2]].data_cost, panel[PANEL_DESIGN].element[control.panel_element_highlighted].value [2]);
   line_y += 12;
   if (panel[PANEL_DESIGN].subpanel[FSP_DESIGN_TOOLS_CORE].open == 1)
			{
    al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x + 305, line_y, ALLEGRO_ALIGN_RIGHT, "integrity");
    al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x + 315, line_y, ALLEGRO_ALIGN_LEFT, "%i", nshape[help_shape].base_hp_max);
    line_y += 12;
    al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x + 305, line_y, ALLEGRO_ALIGN_RIGHT, "power");
    al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x + 315, line_y, ALLEGRO_ALIGN_LEFT, "%i", nshape[help_shape].power_capacity);
    line_y += 12;
/*    al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x + 315, line_y, ALLEGRO_ALIGN_RIGHT, "build recycle");
    al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x + 340, line_y, ALLEGRO_ALIGN_RIGHT, "%i", nshape[help_shape].build_or_restore_time);*/
			}
			return;

	 }

// mouse is over a button for an object.
// show information about the object


	 if (dwindow.selected_link != -1
			&& (panel[PANEL_DESIGN].subpanel[FSP_DESIGN_TOOLS_ACTIVE_LINK].open == 1
		  || panel[PANEL_DESIGN].subpanel[FSP_DESIGN_TOOLS_EMPTY_LINK].open == 1))
		{
			struct object_struct display_object;
			int display_object_col = PLAN_COL_DESIGN_BASIC;

  	if (control.panel_element_highlighted_time == game.total_time
				&&	control.panel_element_highlighted >= FPE_DESIGN_SUB_BUTTON_0
  		&& control.panel_element_highlighted <= FPE_DESIGN_SUB_BUTTON_14)
  	{
 			display_object.type = design_sub_button[panel[PANEL_DESIGN].element[control.panel_element_highlighted].value[0]].value;
  		if (display_object.type != dwindow.templ->member[dwindow.selected_member].object[dwindow.selected_link].type)
					display_object_col = PLAN_COL_DESIGN_MODIFIED;
  	}
  		else
				{
					 display_object.type = dwindow.templ->member[dwindow.selected_member].object[dwindow.selected_link].type;
				}


			int object_detail_base_y = base_y;// - 20;

//			display_object.type = design_sub_button[panel[PANEL_DESIGN].element[control.panel_element_highlighted].value[0]].value; //panel[PANEL_DESIGN].element[control.panel_element_highlighted].value [2];
			display_object.base_angle_offset = 0;

			add_menu_button(base_x + 260, object_detail_base_y + 36,
																				base_x + 340, object_detail_base_y + 93,
																				colours.base [COL_BLUE] [SHADE_LOW], 6, 3);

			      draw_object(base_x + 250, object_detail_base_y + 65,
																					0, // angle
																					NSHAPE_CORE_STATIC_QUAD,
																					&display_object, // uses same code as drawing objects for the main display
																					NULL, // no object instance
																					NULL, // no core
																					NULL, // no proc
																					0, // link
																					colours.plan_col [display_object_col],
																			  1.5); // last number is zoom

    al_draw_textf(font[FONT_SQUARE].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x + 255, object_detail_base_y + 2, ALLEGRO_ALIGN_LEFT, "%s", otype[display_object.type].name);
		 	int line_y = object_detail_base_y + 20;
    if (!otype[display_object.type].object_details.only_zero_angle_offset)
				{
     al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x + 305, line_y, ALLEGRO_ALIGN_RIGHT, "angle");
     al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x + 315, line_y, ALLEGRO_ALIGN_LEFT, "%i", dwindow.templ->member[dwindow.selected_member].object[dwindow.selected_link].base_angle_offset_angle);
//     line_y += 12;
				}
    line_y = object_detail_base_y + 100;

    al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x + 305, line_y, ALLEGRO_ALIGN_RIGHT, "cost");
    al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x + 315, line_y, ALLEGRO_ALIGN_LEFT, "%i", otype[display_object.type].data_cost);
    line_y += 12;
    al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x + 305, line_y, ALLEGRO_ALIGN_RIGHT, "power");
    al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x + 315, line_y, ALLEGRO_ALIGN_LEFT, "%i", otype[display_object.type].power_use_peak);
    line_y += 12;
//    al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x + 305, line_y, ALLEGRO_ALIGN_RIGHT, "average power");
//    al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x + 315, line_y, ALLEGRO_ALIGN_LEFT, "%i", otype[display_object.type].power_use_smoothed);
//    line_y += 12;
    al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x + 305, line_y, ALLEGRO_ALIGN_RIGHT, "base power");
    al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x + 315, line_y, ALLEGRO_ALIGN_LEFT, "%i", otype[display_object.type].power_use_base);
    line_y += 20;
    al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x + 265, line_y, ALLEGRO_ALIGN_LEFT, "%s", object_description[display_object.type][0]);
    if (object_description[display_object.type][1][0] != 0)
				{
     line_y += 14;
     al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x + 265, line_y, ALLEGRO_ALIGN_LEFT, "%s", object_description[display_object.type][1]);
     if (object_description[display_object.type][2][0] != 0)
				 {
      line_y += 14;
      al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x + 265, line_y, ALLEGRO_ALIGN_LEFT, "%s", object_description[display_object.type][2]);
				 }
				}
    line_y += 28;
				switch(dwindow.templ->member[dwindow.selected_member].object[dwindow.selected_link].template_error)
				{
					case TEMPLATE_OBJECT_ERROR_INTERFACE_CORE:
      al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_RED] [SHADE_MED], base_x + 265, line_y, ALLEGRO_ALIGN_LEFT, "Error: interface on core"); break;
					case TEMPLATE_OBJECT_ERROR_MOVE_INTERFACE:
      al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_RED] [SHADE_MED], base_x + 265, line_y, ALLEGRO_ALIGN_LEFT, "Error: interface and move on same component"); break;
					case TEMPLATE_OBJECT_ERROR_STATIC_MOVE:
      al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_RED] [SHADE_MED], base_x + 265, line_y, ALLEGRO_ALIGN_LEFT, "Error: move on static process"); break;
					case TEMPLATE_OBJECT_ERROR_MOVE_OBSTRUCTED:
      al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_RED] [SHADE_MED], base_x + 265, line_y, ALLEGRO_ALIGN_LEFT, "Error: move obstructed by component"); break;
				}
		 return;
		}
	} // end if selected_member != -1

	// else
	if (control.panel_element_highlighted_time == game.total_time)
//		&&	control.panel_element_highlighted >= FPE_DESIGN_SUB_BUTTON_0
//		&& control.panel_element_highlighted <= FPE_DESIGN_SUB_BUTTON_14)
		{
			switch(control.panel_element_highlighted)
			{
				case FPE_DESIGN_TOOLS_EMPTY_NEW:
     draw_design_help_strings(base_x, base_y, "New template",
																														                "Prepares this template for editing.",
																														                "",
																														                "");
					break;
				case FPE_DESIGN_TOOLS_MAIN_AUTO:
     draw_design_help_strings(base_x, base_y, "Write header",
																														                "Updates the process header in this template's source code",
																														                "with code that will generate the process you have designed.",
																														                "");
					break;
				case FPE_DESIGN_TOOLS_MAIN_AUTOCODE:
     draw_design_help_strings(base_x, base_y, "Autocode",
																														                "Automatically generates code to run the process you",
																														                "have designed. You may need to delete the current",
																														                "source code (in the editor panel) first.");
					break;
				case FPE_DESIGN_TOOLS_MAIN_SYMM:
     draw_design_help_strings(base_x, base_y, "Symmetry",
																														                "Makes the process into a mirror image around the horizontal",
																														                "centre line.",
																														                "");
					break;
				case FPE_DESIGN_TOOLS_MAIN_LOCK:
     draw_design_help_strings(base_x, base_y, "Lock template",
																														                "Tries to build this process from source code, and",
																														                "locks the template.", "");
					break;
				case FPE_DESIGN_TOOLS_MAIN_UNLOCK:
     draw_design_help_strings(base_x, base_y, "Unlock template",
																														                "Tries to unlock this template so that it can be edited.",
																														                "Will only work if there are no processes built from it.",
																														                "");
					break;
				case FPE_DESIGN_TOOLS_MAIN_DELETE:
     draw_design_help_strings(base_x, base_y, "Delete template",
																														                "Deletes the template and everything in it.",
																														                "Will only work if there are no processes built from it.",
																														                "");
					break;
				case FPE_DESIGN_TOOLS_MAIN_HELP:
     draw_design_help_strings_for_help_button(base_x, base_y + 2);
					break;
				case FPE_DESIGN_TOOLS_MAIN_HELP_MORE:
     draw_design_help_strings_for_help_more_button(base_x, base_y + 2);
					break;
				case FPE_DESIGN_TOOLS_MEMBER_SHAPE:
     draw_design_help_strings(base_x, base_y, "Shape",
																														                "Changes the shape of the selected component.",
																														                "",
																														                "");
					break;
				case FPE_DESIGN_TOOLS_MEMBER_DELETE:
     draw_design_help_strings(base_x, base_y, "Delete component",
																														                "Removes the selected component and any other component",
																														                "downlinked from it.",
																														                "");
					break;
				case FPE_DESIGN_TOOLS_MEMBER_EXIT:
     draw_design_help_strings(base_x, base_y, "Exit",
																														                "Return to the main design menu.",
																														                "",
																														                "");
					break;
				case FPE_DESIGN_TOOLS_CORE_CORE_SHAPE:
     draw_design_help_strings(base_x, base_y, "Core shape",
																														                "Changes the shape of the core.",
																														                "Each different kind of core has a different cost and power capacity.",
																														                "More expensive cores increase recovery time for the builder process.");
					break;
				case FPE_DESIGN_TOOLS_CORE_EXIT:
     draw_design_help_strings(base_x, base_y, "Exit",
																														                "Return to the main design menu.",
																														                "",
																														                "");
					break;


/*
FPE_DESIGN_TOOLS_MEMBER_SHAPE,
//FPE_DESIGN_TOOLS_MEMBER_FLIP,
FPE_DESIGN_TOOLS_MEMBER_DELETE,
FPE_DESIGN_TOOLS_MEMBER_EXIT,
// subtools
//FPE_DESIGN_SUBTOOLS_MEMBER_SHAPE,
//FPE_DESIGN_SUBTOOLS_MEMBER_SCROLLBAR_H,

FPE_DESIGN_TOOLS_CORE_CORE_SHAPE,
FPE_DESIGN_TOOLS_CORE_EXIT,

FPE_DESIGN_TOOLS_ADD_LINK,

//FPE_DESIGN_TOOLS_VERTEX_OBJ_LINK,
FPE_DESIGN_TOOLS_VERTEX_OBJ_STD,
FPE_DESIGN_TOOLS_VERTEX_OBJ_MOVE,
FPE_DESIGN_TOOLS_VERTEX_OBJ_ATTACK,
FPE_DESIGN_TOOLS_VERTEX_OBJ_DEFEND,
FPE_DESIGN_TOOLS_VERTEX_OBJ_MISC,
FPE_DESIGN_TOOLS_VERTEX_OBJ_CLEAR,
FPE_DESIGN_TOOLS_VERTEX_EXIT,
//FPE_DESIGN_TOOLS_NEXT_LINK,

FPE_DESIGN_TOOLS_DELETE_CONFIRM,
FPE_DESIGN_TOOLS_DELETE_EXIT,

*/


			}

		}


}

static void draw_design_help_strings(int base_x, int base_y, char* help_heading, char* help_line1, char* help_line2, char* help_line3)
{

 al_draw_textf(font[FONT_SQUARE].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x - 20, base_y + 40, ALLEGRO_ALIGN_LEFT, "%s", help_heading);
 al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x, base_y + 60, ALLEGRO_ALIGN_LEFT, "%s", help_line1);
 al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x, base_y + 75, ALLEGRO_ALIGN_LEFT, "%s", help_line2);
 al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x, base_y + 90, ALLEGRO_ALIGN_LEFT, "%s", help_line3);



}

#define DESIGN_HELP_STRINGS 13

char *design_help_strings [DESIGN_HELP_STRINGS] =
{
"Use the process designer to design the structure of the process in the current template.",
"- Change templates using the Template panel (click the Te button in the top right).",
"- Open the Editor panel (the Ed button) to see the current template's source code.",
"  - The source code is definitive; the designer version of the process needs to be",
"    written to the source code before you can use it:",
"    - The -Autocode- button generates full source code for the process.",
"    - The -Write header- button just updates the structural part of the source code.",
"  - Load and save source code using the File menu in the Editor panel.",
"  - Compile the source code (using the Compile menu in the Editor panel) to update",
"    the version in the designer.",
"- When you've finished designing the process, you can build it in the game.",
"  - Since the process will be based on the source code, not on the version in",
"    the process designer, make sure you update the source code before you build it!"
};

static void draw_design_help_strings_for_help_button(int base_x, int base_y)
{

 al_draw_textf(font[FONT_SQUARE].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x - 20, base_y, ALLEGRO_ALIGN_LEFT, "Process design - help");
 float line_y = base_y + 20;

 int i;

 for (i = 0; i < DESIGN_HELP_STRINGS; i ++)
	{

  al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x, line_y, ALLEGRO_ALIGN_LEFT, design_help_strings [i]);
  line_y += 15;

	}

}


#define DESIGN_HELP_MORE_STRINGS 11

char *design_help_strings2 [DESIGN_HELP_MORE_STRINGS] =
{
"- In the window above, select components or objects (objects are the little modules",
"  attached to components, which are larger) to change or remove them.",
"- Hold shift to rotate components and objects, and control to lock rotation to certain angles.",
"- Add new components by adding Link|Downlink objects to existing components.",
"- Adding components and objects increases the cost of the process and the time it",
"  takes to build the process.",
"- Some objects require power.",
"  - The process' core (central component) determines power capacity.",
"  - The process' -peak- power is the power required if all objects are in use at the same time.",
"    If peak power is much greater than power capacity, the process may not work very well.",
"  - The process' -base- power is the basic power consumption of its move and interface objects.",


};

static void draw_design_help_strings_for_help_more_button(int base_x, int base_y)
{

 al_draw_textf(font[FONT_SQUARE].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x - 20, base_y, ALLEGRO_ALIGN_LEFT, "Process design - more help");
 float line_y = base_y + 20;

 int i;

 for (i = 0; i < DESIGN_HELP_MORE_STRINGS; i ++)
	{

  al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_GREY] [SHADE_HIGH], base_x, line_y, ALLEGRO_ALIGN_LEFT, design_help_strings2 [i]);
  line_y += 15;

	}

}

