
#include <allegro5/allegro.h>
#include <allegro5/allegro_primitives.h>
#include <allegro5/allegro_native_dialog.h>

#include <stdio.h>
#include <string.h>

#include "m_config.h"

#include "g_header.h"
#include "m_globvars.h"
#include "i_header.h"

#include "g_misc.h"

#include "e_slider.h"
#include "e_header.h"
#include "e_editor.h"
#include "e_help.h"
#include "e_log.h"
#include "e_inter.h"

#include "i_input.h"
#include "i_view.h"
#include "i_display.h"
#include "i_buttons.h"
#include "t_template.h"
#include "m_input.h"
#include "f_load.h"
#include "f_game.h"
#include "x_sound.h"

#include "s_mission.h"
#include "t_draw.h"

#include "p_panels.h"
#include "d_draw.h"


//#include "s_setup.h"

extern struct fontstruct font [FONTS];
extern struct template_struct templ [PLAYERS] [TEMPLATES_PER_PLAYER];

extern ALLEGRO_DISPLAY* display;

// these queues are declared in g_game.c. They're externed here so that they can be flushed when the editor does something slow.
extern ALLEGRO_EVENT_QUEUE* event_queue; // these queues are initialised in main.c
extern ALLEGRO_EVENT_QUEUE* fps_queue;

extern struct game_struct game; // in g_game.c
extern struct view_struct view;

char mstring [MENU_STRING_LENGTH];

void display_standard_panel(int pan);
static void print_sysmenu_help(float base_x, float base_y);

/*

Plan: how to draw buttons etc:

- problem: need to draw primitives first, then strings.
 - possibly may need to draw primitives after strings too, sometimes (although maybe just for overwindows)



*/

char mode_button_text [MODE_BUTTONS] [3] =
{
	"X",
	"Sy",
	"Ed",
	"De",
	"Te"
};


void draw_panels(void)
{
 int i;

 for (i = 1; i < PANELS; i ++) // note: starts at 1
	{
		if (!panel[i].open)
			continue;

	 al_set_clipping_rectangle(panel[i].x1, panel[i].y1, panel[i].w, panel[i].h);

  switch(i)
  {
		 case PANEL_EDITOR:
//				display_standard_panel(PANEL_EDITOR);
			 draw_edit_bmp();
			 break;
			case PANEL_LOG:
				display_log();
				break;
			case PANEL_SYSMENU:
    al_clear_to_color(panel[i].background_colour);
    al_draw_textf(font[FONT_SQUARE].fnt, colours.base [COL_GREY] [SHADE_MAX], panel[i].x1 + 9, panel[i].y1 + 2, ALLEGRO_ALIGN_LEFT, "System");
				display_standard_panel(PANEL_SYSMENU);
				print_sysmenu_help(panel[i].x1 + 16, 300);
				break;
			case PANEL_DESIGN:
		  al_clear_to_color(panel[i].background_colour);
    al_draw_textf(font[FONT_SQUARE].fnt, colours.base [COL_GREY] [SHADE_MAX], panel[i].x1 + 9, panel[i].y1 + 2, ALLEGRO_ALIGN_LEFT, "Process design");
  		display_standard_panel(PANEL_DESIGN);
				break;
			case PANEL_TEMPLATE:
				draw_template_panel();
//    al_clear_to_color(panel[i].background_colour);
//				display_standard_panel(PANEL_TEMPLATE);
				break;

  }

//	 al_draw_rectangle(panel[i].x1 + 5, panel[i].y1 + 5, panel[i].x2 - 5, panel[i].y2 - 5, colours.base [COL_AQUA] [SHADE_HIGH], 1);

	}

	 al_set_clipping_rectangle(0, 0, inter.display_w, inter.display_h);



	 for (i = 0; i < MODE_BUTTONS; i ++)
		{
			if (inter.mode_button_highlight == i
				&& inter.mode_button_highlight_time >= inter.running_time - 1)
				{
 	   al_draw_filled_rectangle(inter.mode_button_x[i], MODE_BUTTON_Y, inter.mode_button_x[i] + MODE_BUTTON_SIZE, MODE_BUTTON_Y + MODE_BUTTON_SIZE, colours.base_trans [COL_BLUE] [SHADE_HIGH] [2]);
				}
 	   else
					{
 	    al_draw_filled_rectangle(inter.mode_button_x[i], MODE_BUTTON_Y, inter.mode_button_x[i] + MODE_BUTTON_SIZE, MODE_BUTTON_Y + MODE_BUTTON_SIZE, colours.base_trans [COL_BLUE] [SHADE_MED] [1]);
					}

 	 if (i != MODE_BUTTON_CLOSE
				&& panel[i].open)
 	   al_draw_rectangle(inter.mode_button_x[i] - 0.5, MODE_BUTTON_Y-0.5, inter.mode_button_x[i] + MODE_BUTTON_SIZE+0.5, MODE_BUTTON_Y + MODE_BUTTON_SIZE+0.5, colours.base [COL_BLUE] [SHADE_MAX], 1);

   al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_BLUE] [SHADE_MAX], inter.mode_button_x[i] + 8, MODE_BUTTON_Y + 4, ALLEGRO_ALIGN_CENTER, "%s", mode_button_text [i]);

// 	 adtf(inter.mode_button_x[i] + 3, MODE_BUTTON_Y + 3, "%i:%i", i, inter.mode_button_available[i]);

		}

}

void display_standard_panel(int pan)
{
 clear_vbuf();
 reset_i_buttons();
	al_set_clipping_rectangle(panel[pan].x1, panel[pan].y1, panel[pan].w, panel[pan].h);
	int col, shade;


	int el;

	for (el = 0; el < ELEMENTS; el++)
	{
		if (panel[pan].subpanel[panel[pan].element[el].subpanel].open
			&& panel[pan].element[el].open
		 && panel[pan].element[el].exists) // possibly could remove this if .open is reliable (as if exists == 0, open should == 0 too)
		{
//			 	fpr("\nButton pan %i el %i", pan, el);
			switch(panel[pan].element[el].type)
			{
			 case PE_TYPE_BUTTON:
				 switch(panel[pan].element[el].style)
				 {
					 case BUTTON_STYLE_MENU_BIG:
					 	add_menu_button(panel[pan].x1 + panel[pan].subpanel[panel[pan].element[el].subpanel].x1 + panel[pan].element[el].x1,
																							panel[pan].y1 + panel[pan].subpanel[panel[pan].element[el].subpanel].y1 + panel[pan].element[el].y1,
																							panel[pan].x1 + panel[pan].subpanel[panel[pan].element[el].subpanel].x1 + panel[pan].element[el].x2,
																							panel[pan].y1 + panel[pan].subpanel[panel[pan].element[el].subpanel].y1 + panel[pan].element[el].y2,
																							colours.base [COL_BLUE] [SHADE_MED + (panel[pan].element[el].last_highlight >= game.total_time - 1)],
																							12, 6);
							add_menu_string(panel[pan].x1 + panel[pan].subpanel[panel[pan].element[el].subpanel].x1 + panel[pan].element[el].x1 + 25,
																							panel[pan].y1 + panel[pan].subpanel[panel[pan].element[el].subpanel].y1 + panel[pan].element[el].y1 + 25,
																							&colours.base [COL_BLUE] [SHADE_MAX],
																							ALLEGRO_ALIGN_LEFT,
																							FONT_SQUARE,
																							panel[pan].element[el].name);
							break;
/*
						case BUTTON_STYLE_TAB:
					 	add_menu_button(panel[pan].x1 + panel[pan].subpanel[panel[pan].element[el].subpanel].x1 + panel[pan].element[el].x1,
																							panel[pan].y1 + panel[pan].subpanel[panel[pan].element[el].subpanel].y1 + panel[pan].element[el].y1,
																							panel[pan].x1 + panel[pan].subpanel[panel[pan].element[el].subpanel].x1 + panel[pan].element[el].x2,
																							panel[pan].y1 + panel[pan].subpanel[panel[pan].element[el].subpanel].y1 + panel[pan].element[el].y2,
																							colours.base [COL_BLUE] [SHADE_MED + (panel[pan].element[el].last_highlight >= game.total_time - 1)],
																							1, 2);
							add_menu_string(panel[pan].x1 + panel[pan].subpanel[panel[pan].element[el].subpanel].x1 + panel[pan].element[el].x1 + 4,
																							panel[pan].y1 + panel[pan].subpanel[panel[pan].element[el].subpanel].y1 + panel[pan].element[el].y1 + 4,
																							&colours.base [COL_BLUE] [SHADE_MAX],
																							ALLEGRO_ALIGN_LEFT,
																							FONT_BASIC,
																							panel[pan].element[el].name);
							break;
						case BUTTON_STYLE_TEMPLATE:
					 	add_menu_button(panel[pan].x1 + panel[pan].subpanel[panel[pan].element[el].subpanel].x1 + panel[pan].element[el].x1,
																							panel[pan].y1 + panel[pan].subpanel[panel[pan].element[el].subpanel].y1 + panel[pan].element[el].y1,
																							panel[pan].x1 + panel[pan].subpanel[panel[pan].element[el].subpanel].x1 + panel[pan].element[el].x2,
																							panel[pan].y1 + panel[pan].subpanel[panel[pan].element[el].subpanel].y1 + panel[pan].element[el].y2,
																							colours.base [COL_BLUE] [SHADE_LOW + (panel[pan].element[el].last_highlight >= game.total_time - 1)],
																							6, 12);
						add_menu_string(panel[pan].x1 + panel[pan].subpanel[panel[pan].element[el].subpanel].x1 + panel[pan].element[el].x1 + 10,
																						panel[pan].y1 + panel[pan].subpanel[panel[pan].element[el].subpanel].y1 + panel[pan].element[el].y1 + 10,
																						&colours.base [COL_GREY] [SHADE_MAX],
																						ALLEGRO_ALIGN_LEFT,
																						FONT_SQUARE,
																						templ[panel[pan].element[el].value[0]][panel[pan].element[el].value[1]].menu_button_title);
						if (templ[panel[pan].element[el].value[0]][panel[pan].element[el].value[1]].name [0] != 0)
						{
						 add_menu_string(panel[pan].x1 + panel[pan].subpanel[panel[pan].element[el].subpanel].x1 + panel[pan].element[el].x1 + 50,
																						panel[pan].y1 + panel[pan].subpanel[panel[pan].element[el].subpanel].y1 + panel[pan].element[el].y1 + 35,
																						&colours.base [COL_BLUE] [SHADE_MAX],
																						ALLEGRO_ALIGN_LEFT,
																						FONT_SQUARE,
																						templ[tstate.template_player_tab][panel[pan].element[el].value[1]].name);
						}

							break;*/
						case BUTTON_STYLE_DESIGN:
// value [0] = special highlight for button which reflects actual state (e.g. category of actual shape of currently selected template member)
					 	add_menu_button(panel[pan].x1 + panel[pan].subpanel[panel[pan].element[el].subpanel].x1 + panel[pan].element[el].x1,
																							panel[pan].y1 + panel[pan].subpanel[panel[pan].element[el].subpanel].y1 + panel[pan].element[el].y1,
																							panel[pan].x1 + panel[pan].subpanel[panel[pan].element[el].subpanel].x1 + panel[pan].element[el].x2,
																							panel[pan].y1 + panel[pan].subpanel[panel[pan].element[el].subpanel].y1 + panel[pan].element[el].y2 - 1,
																							colours.base [COL_BLUE] [SHADE_LOW + (panel[pan].element[el].last_highlight >= game.total_time - 1)],
																							2, 4);
							shade = SHADE_MAX;
							col = COL_BLUE;
							if (panel[pan].element[el].value [0])
							{
								shade = SHADE_MAX;
								col = COL_GREY;
							}
							add_menu_string(panel[pan].x1 + panel[pan].subpanel[panel[pan].element[el].subpanel].x1 + panel[pan].element[el].x1 + 4,
																							panel[pan].y1 + panel[pan].subpanel[panel[pan].element[el].subpanel].y1 + panel[pan].element[el].y1 + 6,
																							&colours.base [col] [shade],
																							ALLEGRO_ALIGN_LEFT,
																							FONT_BASIC,
																							panel[pan].element[el].name);
							break;
						case BUTTON_STYLE_DESIGN_SUB:
						case BUTTON_STYLE_SUBMENU:
						case BUTTON_STYLE_SUBMENU_LINE:
// value [0] = DSB value (see d_design.c)
// value [1] = special highlight for button which reflects actual state (e.g. actual shape of currently selected template member)
					 	add_menu_button(panel[pan].x1 + panel[pan].subpanel[panel[pan].element[el].subpanel].x1 + panel[pan].element[el].x1,
																							panel[pan].y1 + panel[pan].subpanel[panel[pan].element[el].subpanel].y1 + panel[pan].element[el].y1,
																							panel[pan].x1 + panel[pan].subpanel[panel[pan].element[el].subpanel].x1 + panel[pan].element[el].x2,
																							panel[pan].y1 + panel[pan].subpanel[panel[pan].element[el].subpanel].y1 + panel[pan].element[el].y2 - 1,
																							colours.base [COL_BLUE] [SHADE_MIN + (panel[pan].element[el].last_highlight >= game.total_time - 1) + (panel[pan].element[el].value [1]!=0)],
																							4, 2);
							shade = SHADE_HIGH;
							if (panel[pan].element[el].value [1])
								shade = SHADE_MAX;
							add_menu_string(panel[pan].x1 + panel[pan].subpanel[panel[pan].element[el].subpanel].x1 + panel[pan].element[el].x1 + 4,
																							panel[pan].y1 + panel[pan].subpanel[panel[pan].element[el].subpanel].y1 + panel[pan].element[el].y1 + 6,
																							&colours.base [COL_BLUE] [shade],
																							ALLEGRO_ALIGN_LEFT,
																							FONT_BASIC,
																							panel[pan].element[el].name);
							break;
				 }
				 break;
				case PE_TYPE_DESIGN_WINDOW:
					draw_design_window();
					break;
				case PE_TYPE_SCROLLBAR_EL_H_PIXEL:
				case PE_TYPE_SCROLLBAR_EL_V_PIXEL:
				case PE_TYPE_SCROLLBAR_EL_H_CHAR:
				case PE_TYPE_SCROLLBAR_EL_V_CHAR:
					draw_scrollbar(panel[pan].element[el].value [1]);
					break;
				case PE_TYPE_PANEL_RESIZE:
					if (panel[pan].element[el].last_highlight >= game.total_time - 1)
					{
						add_menu_rectangle(panel[pan].x1 + panel[pan].subpanel[panel[pan].element[el].subpanel].x1 + panel[pan].element[el].x1,
																									0, //	panel[pan].y1 + panel[pan].subpanel[panel[pan].element[el].subpanel].y1 + panel[pan].element[el].y1,
																							  panel[pan].x1 + panel[pan].subpanel[panel[pan].element[el].subpanel].x1 + 5, //panel[pan].element[el].x2,
																							  panel[pan].y1 + panel[pan].subpanel[panel[pan].element[el].subpanel].y1 + panel[pan].element[el].y2,
																							  colours.base [COL_BLUE] [SHADE_MED]);
					}
					 else
						add_menu_rectangle(panel[pan].x1 + panel[pan].subpanel[panel[pan].element[el].subpanel].x1 + panel[pan].element[el].x1,
																							  0, //panel[pan].y1 + panel[pan].subpanel[panel[pan].element[el].subpanel].y1 + panel[pan].element[el].y1,
																							  panel[pan].x1 + panel[pan].subpanel[panel[pan].element[el].subpanel].x1 + 2,
																							  panel[pan].y1 + panel[pan].subpanel[panel[pan].element[el].subpanel].y1 + panel[pan].element[el].y2,
																							  colours.base [COL_BLUE] [SHADE_LOW]);
					break;
				case PE_TYPE_DESIGN_DATA:
					draw_design_data();
					break;

			}


		}
	}

 draw_menu_buttons();

}

float smh_text_y;
float smh_text_x;

static void print_sysmenu_line(const char* left_string, const char* right_string);

static void print_sysmenu_help(float base_x, float base_y)
{

#define SMH_LINE_HEIGHT 16
#define SMH_LINE_HEADER 5
#define SMH_HEADER_X (base_x + 5)
	smh_text_x = base_x + 69;
	smh_text_y = base_y;
 al_draw_textf(font[FONT_SQUARE].fnt, colours.base [COL_GREY] [SHADE_MAX], SMH_HEADER_X - 10, smh_text_y, ALLEGRO_ALIGN_LEFT, "CONTROLS");
 smh_text_y += SMH_LINE_HEIGHT + SMH_LINE_HEADER;
 al_draw_textf(font[FONT_SQUARE].fnt, colours.base [COL_GREY] [SHADE_MAX], SMH_HEADER_X, smh_text_y, ALLEGRO_ALIGN_LEFT, "SELECTING");
 smh_text_y += SMH_LINE_HEIGHT + SMH_LINE_HEADER;
 print_sysmenu_line("SELECT", "Left-click on a process.");
 print_sysmenu_line("BOX SELECT", "Left-click then hold to drag a selection box.");
 print_sysmenu_line("SELECT+", "Hold shift while selecting to add/remove.");

 smh_text_y += SMH_LINE_HEADER;
 al_draw_textf(font[FONT_SQUARE].fnt, colours.base [COL_GREY] [SHADE_MAX], SMH_HEADER_X, smh_text_y, ALLEGRO_ALIGN_LEFT, "COMMANDS (while a process is selected)");
 smh_text_y += SMH_LINE_HEIGHT + SMH_LINE_HEADER;
 print_sysmenu_line("MOVE", "Right-click on the display or the map.");
 print_sysmenu_line("ATTACK", "Right-click on an enemy process.");
 print_sysmenu_line("ATTACK-MOVE", "Hold control while giving a MOVE command.");
 print_sysmenu_line("HARVEST", "Right-click on a data well.");
// print_sysmenu_line("", "(The process must have a harvest object.)");
 print_sysmenu_line("RETURN", "Right-click on a process with an allocator");
 print_sysmenu_line("", "to return to that process after harvesting.");
 print_sysmenu_line("GUARD", "Right-click on a friendly target.");
// print_sysmenu_line("", "(Requires a repair_other object.)");
 print_sysmenu_line("WAYPOINTS", "Hold shift to queue commands.");
 print_sysmenu_line("BUILD", "Select a process with a build object, then use");
 print_sysmenu_line("", "the buttons on the left side of screen to choose");
 print_sysmenu_line("", "what to build.");
 print_sysmenu_line("", "Hold shift while placing process to queue build.");
 print_sysmenu_line("", "Hold control while placing process to repeat build.");

 smh_text_y += SMH_LINE_HEADER;
 al_draw_textf(font[FONT_SQUARE].fnt, colours.base [COL_GREY] [SHADE_MAX], SMH_HEADER_X, smh_text_y, ALLEGRO_ALIGN_LEFT, "OTHER");
 smh_text_y += SMH_LINE_HEIGHT + SMH_LINE_HEADER;
 print_sysmenu_line("PAUSE", "P to pause/unpause.");
 print_sysmenu_line("PAUSE ADVANCE", "[ to advance 1 frame.");
 print_sysmenu_line("DEBUG MODE", "F1 to toggle debug mode.");
 print_sysmenu_line("FAST FORWARD", "F2, F3 and F4 to toggle different speeds.");
// print_sysmenu_line("FF (SKIP)", "F3 to toggle extra fast forward (skips frames).");
// print_sysmenu_line("FF (ND)", "F4 to toggle super fast forward (no display).");
 print_sysmenu_line("CHANGE PLAYER", "F5 to change player (custom game only).");
 print_sysmenu_line("ZOOM", "Use mousewheel to zoom in/out.");
 print_sysmenu_line("QUIT", "Escape to quit program entirely.");


}

static void print_sysmenu_line(const char* left_string, const char* right_string)
{

 al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_AQUA] [SHADE_MAX], smh_text_x, smh_text_y, ALLEGRO_ALIGN_RIGHT, "%s", left_string);
 al_draw_textf(font[FONT_BASIC].fnt, colours.base [COL_BLUE] [SHADE_HIGH], smh_text_x + 10, smh_text_y, ALLEGRO_ALIGN_LEFT, "%s", right_string);
 smh_text_y += SMH_LINE_HEIGHT;

}
