#include <allegro5/allegro.h>

#include <stdio.h>

#include "m_config.h"

#include "g_header.h"

#include "m_maths.h"
#include "g_misc.h"
#include "g_motion.h"
#include "g_command.h"
#include "m_globvars.h"
#include "m_input.h"
#include "e_slider.h"
#include "e_header.h"
#include "c_header.h"
#include "e_editor.h"
//#include "e_slider.h"
#include "i_console.h"
#include "i_view.h"

#include "p_panels.h"

void initialise_control(void);
void run_mouse_drag(void);

extern struct game_struct game;
extern struct view_struct view;

struct control_struct control;

// this array indicates which allegro_key enum corresponds to each KEY_? enum. Used for allowing system/clob programs to access keyboard
int corresponding_allegro_key [KEYS] =
{

ALLEGRO_KEY_0, // KEY_0,
ALLEGRO_KEY_1, // KEY_1,
ALLEGRO_KEY_2, // KEY_2,
ALLEGRO_KEY_3, // KEY_3,
ALLEGRO_KEY_4, // KEY_4,
ALLEGRO_KEY_5, // KEY_5,
ALLEGRO_KEY_6, // KEY_6,
ALLEGRO_KEY_7, // KEY_7,
ALLEGRO_KEY_8, // KEY_8,
ALLEGRO_KEY_9, // KEY_9,

ALLEGRO_KEY_A, // KEY_A,
ALLEGRO_KEY_B, // KEY_B,
ALLEGRO_KEY_C, // KEY_C,
ALLEGRO_KEY_D, // KEY_D,
ALLEGRO_KEY_E, // KEY_E,
ALLEGRO_KEY_F, // KEY_F,
ALLEGRO_KEY_G, // KEY_G,
ALLEGRO_KEY_H, // KEY_H,
ALLEGRO_KEY_I, // KEY_I,
ALLEGRO_KEY_J, // KEY_J,
ALLEGRO_KEY_K, // KEY_K,
ALLEGRO_KEY_L, // KEY_L,
ALLEGRO_KEY_M, // KEY_M,
ALLEGRO_KEY_N, // KEY_N,
ALLEGRO_KEY_O, // KEY_O,
ALLEGRO_KEY_P, // KEY_P,
ALLEGRO_KEY_Q, // KEY_Q,
ALLEGRO_KEY_R, // KEY_R,
ALLEGRO_KEY_S, // KEY_S,
ALLEGRO_KEY_T, // KEY_T,
ALLEGRO_KEY_U, // KEY_U,
ALLEGRO_KEY_V, // KEY_V,
ALLEGRO_KEY_W, // KEY_W,
ALLEGRO_KEY_X, // KEY_X,
ALLEGRO_KEY_Y, // KEY_Y,
ALLEGRO_KEY_Z, // KEY_Z,

ALLEGRO_KEY_MINUS, // KEY_MINUS,
ALLEGRO_KEY_EQUALS, // KEY_EQUALS,
ALLEGRO_KEY_OPENBRACE, // KEY_SBRACKET_OPEN,
ALLEGRO_KEY_CLOSEBRACE, // KEY_SBRACKET_CLOSE,
ALLEGRO_KEY_BACKSLASH, // KEY_BACKSLASH,
ALLEGRO_KEY_SEMICOLON, // KEY_SEMICOLON,
ALLEGRO_KEY_QUOTE, // KEY_APOSTROPHE,
ALLEGRO_KEY_COMMA, // KEY_COMMA,
ALLEGRO_KEY_FULLSTOP, // KEY_PERIOD,
ALLEGRO_KEY_SLASH, // KEY_SLASH,

ALLEGRO_KEY_UP, // KEY_UP,
ALLEGRO_KEY_DOWN, // KEY_DOWN,
ALLEGRO_KEY_LEFT, // KEY_LEFT,
ALLEGRO_KEY_RIGHT, // KEY_RIGHT,

ALLEGRO_KEY_ENTER, // KEY_ENTER,
ALLEGRO_KEY_BACKSPACE, // KEY_BACKSPACE,
ALLEGRO_KEY_INSERT, // KEY_INSERT,
ALLEGRO_KEY_HOME, // KEY_HOME,
ALLEGRO_KEY_PGUP, // KEY_PGUP,
ALLEGRO_KEY_PGDN, // KEY_PGDN,
ALLEGRO_KEY_DELETE, // KEY_DELETE,
ALLEGRO_KEY_END, // KEY_END,



ALLEGRO_KEY_TAB, // KEY_TAB,
// KEY_ESCAPE is not available to user programs

ALLEGRO_KEY_PAD_0, // KEY_PAD_0,
ALLEGRO_KEY_PAD_1, // KEY_PAD_1,
ALLEGRO_KEY_PAD_2, // KEY_PAD_2,
ALLEGRO_KEY_PAD_3, // KEY_PAD_3,
ALLEGRO_KEY_PAD_4, // KEY_PAD_4,
ALLEGRO_KEY_PAD_5, // KEY_PAD_5,
ALLEGRO_KEY_PAD_6, // KEY_PAD_6,
ALLEGRO_KEY_PAD_7, // KEY_PAD_7,
ALLEGRO_KEY_PAD_8, // KEY_PAD_8,
ALLEGRO_KEY_PAD_9, // KEY_PAD_9,
ALLEGRO_KEY_PAD_MINUS, // KEY_PAD_MINUS,
ALLEGRO_KEY_PAD_PLUS, // KEY_PAD_PLUS,
ALLEGRO_KEY_PAD_ENTER, // KEY_PAD_ENTER,
ALLEGRO_KEY_PAD_DELETE, // KEY_PAD_DELETE,

ALLEGRO_KEY_LSHIFT, // KEY_LSHIFT,
ALLEGRO_KEY_RSHIFT, // KEY_RSHIFT,
ALLEGRO_KEY_LCTRL, // KEY_LCTRL,
ALLEGRO_KEY_RCTRL, // KEY_RCTRL,

ALLEGRO_KEY_F1, // KEY_F1
ALLEGRO_KEY_F2, // etc.
ALLEGRO_KEY_F3,
ALLEGRO_KEY_F4,
ALLEGRO_KEY_F5,
ALLEGRO_KEY_F6,
ALLEGRO_KEY_F7,
ALLEGRO_KEY_F8,
ALLEGRO_KEY_F9,
ALLEGRO_KEY_F10,
ALLEGRO_KEY_F11,
ALLEGRO_KEY_F12,

//KEYS

};



// this is called at startup, and when input capture is set to the editor, and also when loading from disk
void initialise_control(void)
{
 control.mouse_status = MOUSE_STATUS_PANEL; // TO DO: make sure this is correct (could be wrong if it's possible for game to start with editor open and mouse in editor window)
 control.mouse_panel = PANEL_MAIN;
 control.mouse_x_world_pixels = 0;
 control.mouse_y_world_pixels = 0;
 control.mouse_x_screen_pixels = 0;
 control.mouse_y_screen_pixels = 0;
 control.mbutton_press [0] = BUTTON_NOT_PRESSED; // not sure about this - should we try to read the actual mouse status?
 control.mbutton_press [1] = BUTTON_NOT_PRESSED;
 control.mbutton_press_timestamp [0] = 0;
 control.mbutton_press_timestamp [1] = 0;

 control.mouse_drag = MOUSE_DRAG_NONE;
 control.mouse_drag_panel = 0;
 control.mouse_drag_element = 0;

 control.panel_element_highlighted = -1;
	control.panel_element_highlighted_time = 0;

	control.editor_captures_input = 0;


 int i;

 for (i = 0; i < KEYS; i ++)
 {
  control.key_press [i] = BUTTON_NOT_PRESSED;
 }
 control.any_key = -1;

// control.mouse_hold_x_pixels [0] = -1;
// control.mouse_hold_x_pixels [1] = -1;
/*
 int i;

 for (i = 0; i < MBB_BITS; i ++)
 {
  control.mb_bits [i] = 0;
 }*/


}

/*

Plan: how to handle input

Option 1:
- Have a client process.
- client process has the following methods (all of which are probably costless; no point in imposing cost on client process):
 - mouse: call to poll mouse.
  - return value is status: 0 for mouse not on world screen (e.g. is on another panel), 1 for success
  - first mbank entry is mode. Usual mode is query:
   - two mbank entries give x/y in world (not on screen), given in pixel units.
   - final mbank entry contains bitfield for buttons and maybe wheel
  - another mode allows settings, maybe? (this is to allow box drawing etc to be set)
   - not sure if needed
   - maybe could merge mouse and keyboard methods and use the status mbank entry to determined what's being checked.
  - another mode allows checking of whether a particular proc is under the cursor
   - one field will be team of proc under mouse cursor (not necess clicked on).
    - maybe that's the only information that'll be available about procs on other teams.
    - or maybe the client process will have access to all of this information? Probably.
 - keyboard: call to query keyboard
  - first mbank sets the key being queried
  - second mbank is the result: -1 just released; 0 not pressed; 1 just pressed; 2 held
  - third mbank is a bitfield for shift etc (although these can be queried individually) - maybe not needed.

- to support these input methods, there'll be a special input structure kept up to date each frame
 - contains mouse information
 - contains information for each key (although maybe not all keys)

- So how can the client process select particular procs?
 - each proc will be assigned a number on creation. These numbers are not re-used. They are visible only to the client process.
 - each proc will also have a special field for client interactions.

 - the client process will have a method for interacting with these:
  - first mbank entry is mode
   - some different basic mode types:
    - proc-based allows read access to information about the proc (location, hp etc)
    - client/team based allows r/w access to the special client interactions field for all procs on client's team
     - procs will also have a method giving r/w access to this field
    - client based but all teams: similar to client/team, but can be used for all teams.
    - bcode allows read access to proc's bcode
    - method allows read access to methods
    - mbank allows read access to mbank
  - second mbank entry is proc number
  - third is field number
  - fourth is field value - read or write depending on mode
  - return value is 1 if proc exists, 0 if not

 - the client process will have another method for creating interface elements
  - first mbank entry is mode. modes are:
   - mode: selection indicators
    - second is field number
    - third is result attached to field
     - none (default)
     - select (maybe various types of select)
   - mode: proc data display
    - when called, sets which proc is being inspected
    - there'll need to be a way of setting the proc under the cursor, to allow other team procs to be inspected.
    - probably make this proc the focus as well
    - call with -1 proc to cancel.
   - mode: proc focus
    - sets which proc is in focus (-1 for no focus) - may not be needed

 - a point-marking method:
  - has a certain number (32?) of points
  - each point has a type:
   - appearance
   - displayed on screen?
   - displayed on map?
  - other information:
   - active?
   - times out? (set to -1 if no timeout)

 - a viewpoint method:
  - can be used to find out information about the game window (x/y location, size etc)
  - maybe could be used to set focus on a particular proc? This would only work if other teams' procs can be selected



- keep in mind that there's no reason to withhold from the client any information visible to the player.


A few other things to do:
 - large-scale initialisation in asm: [20] will initialise 20 memory addresses (to zero)

*/


void run_input(void)
{


/*
  if (game.phase == GAME_PHASE_PREGAME)
		{
   control.mouse_status = MOUSE_STATUS_OUTSIDE;
   control.any_key = -1;
			return;
		}
*/
  int i;

// this code removes focus from a proc that has been destroyed
//  - possibly it can be removed? (TO DO: check whether everything focus_proc does can be delegated to client program)
  if (view.focus_proc != NULL
   && view.focus_proc->exists == 0)
  {
   view.focus_proc = NULL;
//   reset_proc_box_height(NULL);
  }

  control.editor_captures_input = 0;

  if (ex_control.mouse_on_display == 0)
  {
   control.mouse_status = MOUSE_STATUS_OUTSIDE;
   goto mouse_unavailable;
  }

 control.mouse_status = MOUSE_STATUS_PANEL;
 control.mouse_panel = PANEL_MAIN;

	for (i = 0; i < PANELS; i ++)
	{
		if (panel[i].open
			&&	control.mouse_x_screen_pixels >= panel[i].x1
			&& control.mouse_y_screen_pixels >= panel[i].y1
			&&	control.mouse_x_screen_pixels <= panel[i].x2
			&& control.mouse_y_screen_pixels <= panel[i].y2)
			{
			 control.mouse_panel = i;
			 break;
			} // probably use <= because maximum mouse_x should be in rightmost open panel

	}

 if (control.mouse_panel != PANEL_MAIN
		&& panel[PANEL_EDITOR].open)
		control.editor_captures_input = 1;
			else
	  {

// check for the mouse pointer being in the console window, a score box etc:
    check_mouse_on_consoles_etc(ex_control.mouse_x_pixels, ex_control.mouse_y_pixels, (ex_control.mb_press [0] == BUTTON_JUST_PRESSED));
	  }

// not sure if the following need to be set if the editor is capturing input

  control.mouse_x_world_pixels = (ex_control.mouse_x_pixels / view.zoom + al_fixtoi(view.camera_x - view.centre_x_zoomed)) ;
  control.mouse_y_world_pixels = (ex_control.mouse_y_pixels / view.zoom + al_fixtoi(view.camera_y - view.centre_y_zoomed));

  control.mouse_x_screen_pixels = ex_control.mouse_x_pixels;
  control.mouse_y_screen_pixels = ex_control.mouse_y_pixels;

//  run_mouse_interface();

mouse_unavailable:

  for (i = 0; i < 2; i ++)
  {
   switch(control.mbutton_press [i])
   {
    case BUTTON_NOT_PRESSED:
     if (ex_control.mb_press [i] != BUTTON_NOT_PRESSED)
					{
      control.mbutton_press [i] = BUTTON_JUST_PRESSED;
      control.mbutton_press_timestamp [i] = game.total_time;
					}
     break;
    case BUTTON_JUST_RELEASED:
     if (ex_control.mb_press [i] <= BUTTON_NOT_PRESSED)
      control.mbutton_press [i] = BUTTON_NOT_PRESSED;
       else
					  {
        control.mbutton_press [i] = BUTTON_JUST_PRESSED;
        control.mbutton_press_timestamp [i] = game.total_time;
					  }
     break;
    case BUTTON_JUST_PRESSED:
     if (ex_control.mb_press [i] <= BUTTON_NOT_PRESSED)
      control.mbutton_press [i] = BUTTON_JUST_RELEASED;
       else
        control.mbutton_press [i] = BUTTON_HELD;
     break;
    case BUTTON_HELD:
     if (ex_control.mb_press [i] <= BUTTON_NOT_PRESSED)
      control.mbutton_press [i] = BUTTON_JUST_RELEASED;
     break;
   }
  }


 if (control.mouse_drag != MOUSE_DRAG_NONE)
	{
  run_mouse_drag();
	}


 control.any_key = -1;

// we need to specially calculate whether the keys have just been pressed etc, rather than relying on ex_control values, because the control_struct is saved to file and ex_control may not be reliable when loading/saving
 for (i = KEYS - 1; i >= 0; i --) // Counts down so that any_key detects letters in preference to shift, control etc
 {
  switch(control.key_press[i])
  {
   case BUTTON_JUST_RELEASED:
    if (ex_control.key_press [corresponding_allegro_key [i]] == BUTTON_NOT_PRESSED)
     control.key_press [i] = BUTTON_NOT_PRESSED;
      else
						{
       control.key_press [i] = BUTTON_JUST_PRESSED;
       control.any_key = i;
						}
    break;
   case BUTTON_NOT_PRESSED:
    if (ex_control.key_press [corresponding_allegro_key [i]] != BUTTON_NOT_PRESSED)
				{
     control.key_press [i] = BUTTON_JUST_PRESSED; // if ex_control value is BUTTON_JUST_RELEASED, control value will be set to BUTTON_JUST_PRESSED and then (probably) to BUTTON_JUST_RELEASED the next tick
     control.any_key = i;
				}
    break;
   case BUTTON_JUST_PRESSED:
    if (ex_control.key_press [corresponding_allegro_key [i]] <= BUTTON_NOT_PRESSED) // <= BUTTON_NOT_PRESSED means BUTTON_NOT_PRESSED (0) or BUTTON_JUST_RELEASED (-1)
     control.key_press [i] = BUTTON_JUST_RELEASED;
      else
						{
       control.key_press [i] = BUTTON_HELD;
//       control.any_key = i;
						}
    break;
   case BUTTON_HELD:
    if (ex_control.key_press [corresponding_allegro_key [i]] <= BUTTON_NOT_PRESSED) // <= BUTTON_NOT_PRESSED means BUTTON_NOT_PRESSED (0) or BUTTON_JUST_RELEASED (-1)
     control.key_press [i] = BUTTON_JUST_RELEASED;
    break;
  }
 }




 if (control.editor_captures_input)
	 return;

	if (ex_control.mousewheel_change == -1
		 && control.mouse_panel == PANEL_MAIN)
	{
		if (view.zoom_level < ZOOM_MAX_LEVEL)
		 view.zoom_level ++;
//		view.zoom += 0.009;
//		reset_view_values(view.window_x_unzoomed, view.window_y_unzoomed);
	}

	if	(ex_control.mousewheel_change == 1
		 && control.mouse_panel == PANEL_MAIN)
	{
		if (view.zoom_level > 1)
		 view.zoom_level --;
//		view.zoom -= 0.009;
//		if (view.zoom < 0.3)
//			view.zoom = 0.3;
//		reset_view_values(view.window_x_unzoomed, view.window_y_unzoomed);
	}

int zoom_target [ZOOM_MAX_LEVEL + 1] = {10, 16, 26, 36};

// if any of this zoom stuff changes, may also need to change in initialise_view() in i_view.c
	if (view.zoom_int != zoom_target [view.zoom_level])
	{
		if (view.zoom_int < zoom_target [view.zoom_level])
			view.zoom_int ++;
		if (view.zoom_int > zoom_target [view.zoom_level])
			view.zoom_int --;
		view.zoom = view.zoom_int * 0.03;
		reset_view_values(view.window_x_unzoomed, view.window_y_unzoomed);
	}

 if (control.key_press [KEY_P] == BUTTON_JUST_PRESSED)
	{
		if (game.pause_soft == 0)
			game.pause_soft = 1;
		  else
			  game.pause_soft = 0;
	}

 static int pause_advance = 0;

 if (pause_advance == 1)
	{
		game.pause_soft = 1;
		pause_advance = 0;
	}

 if (control.key_press [KEY_SBRACKET_OPEN] == BUTTON_JUST_PRESSED)
	{
		if (pause_advance == 0)
		{
			game.pause_soft = 0;
			pause_advance = 1;
		}
	}



 if (control.key_press [KEY_F1] == BUTTON_JUST_PRESSED)
	{
		if (!w.debug_mode_general)
		{
			write_text_to_console(CONSOLE_GENERAL, PRINT_COL_DBLUE, -1, 0, "Debug mode activated.");
			w.debug_mode_general = 1;
		}
		 else
 		{
	 		write_text_to_console(CONSOLE_GENERAL, PRINT_COL_DBLUE, -1, 0, "Debug mode deactivated.");
		 	w.debug_mode_general = 0;
		 }
	}


 if (control.key_press [KEY_F2] == BUTTON_JUST_PRESSED)
	{
		if (game.fast_forward == 0
			|| (game.fast_forward != 0
				&& game.fast_forward_type != FAST_FORWARD_TYPE_SMOOTH))
		{
			game.fast_forward = 1;
			game.fast_forward_type = FAST_FORWARD_TYPE_SMOOTH;
		}
		  else
			  game.fast_forward = 0;
	}

 if (control.key_press [KEY_F3] == BUTTON_JUST_PRESSED)
	{
		if (game.fast_forward == 0
			|| (game.fast_forward != 0
				&& game.fast_forward_type != FAST_FORWARD_TYPE_SKIP))
		{
			game.fast_forward = 1;
			game.fast_forward_type = FAST_FORWARD_TYPE_SKIP;
		}
		  else
			  game.fast_forward = 0;
	}

 if (control.key_press [KEY_F4] == BUTTON_JUST_PRESSED)
	{
		if (game.fast_forward == 0
			|| (game.fast_forward != 0
				&& game.fast_forward_type != FAST_FORWARD_TYPE_NO_DISPLAY))
		{
			game.fast_forward = 1;
			game.fast_forward_type = FAST_FORWARD_TYPE_NO_DISPLAY;
		}
		  else
			  game.fast_forward = 0;
	}

 if (control.key_press [KEY_F5] == BUTTON_JUST_PRESSED
		&& game.type != GAME_TYPE_MISSION)
	{
		clear_selection();
		game.user_player_index ++;
		if (game.user_player_index >= w.players)
			game.user_player_index = 0;

	}

// control may not reach here (e.g. if input being captured by editor  - control.editor_captures_input == 1)

}


// called if mouse_drag != MOUSE_DRAG_NONE
void run_mouse_drag(void)
{

	int released = 0;

 if (control.mbutton_press [0] <= 0)
		released = 1;

	switch(control.mouse_drag)
	{
	 case MOUSE_DRAG_SLIDER:
	 	run_slider(panel[control.mouse_drag_panel].element[control.mouse_drag_element].value [1]);
	 	if (released == 1)
			{
				control.mouse_drag = MOUSE_DRAG_NONE;
			}
		 break;

	}

}


