#include <allegro5/allegro.h>


#include "m_config.h"

#include "g_header.h"
#include "c_header.h"
#include "g_shapes.h"
#include "g_method.h"
#include "g_method_core.h"
#include "g_method_std.h"
#include "g_method_uni.h"

#include "c_keywords.h"


struct identifierstruct identifier [IDENTIFIERS] =
{
// {name, type, value...}
	{"core_quad_A", CTOKEN_TYPE_IDENTIFIER_CORE_SHAPE, NSHAPE_CORE_QUAD_A}, // KEYWORD_CORE_QUAD_A
	{"core_quad_B", CTOKEN_TYPE_IDENTIFIER_CORE_SHAPE, NSHAPE_CORE_QUAD_B}, // KEYWORD_CORE_QUAD_B
	{"core_pent_A", CTOKEN_TYPE_IDENTIFIER_CORE_SHAPE, NSHAPE_CORE_PENT_A}, // KEYWORD_CORE_PENT_A
	{"core_pent_B", CTOKEN_TYPE_IDENTIFIER_CORE_SHAPE, NSHAPE_CORE_PENT_B}, // KEYWORD_CORE_PENT_B
	{"core_hex_A", CTOKEN_TYPE_IDENTIFIER_CORE_SHAPE, NSHAPE_CORE_HEX_A}, // KEYWORD_CORE_HEX_A
	{"core_hex_B", CTOKEN_TYPE_IDENTIFIER_CORE_SHAPE, NSHAPE_CORE_HEX_B}, // KEYWORD_CORE_HEX_B
	{"core_hex_C", CTOKEN_TYPE_IDENTIFIER_CORE_SHAPE, NSHAPE_CORE_HEX_C}, // KEYWORD_CORE_HEX_C

	{"core_static_quad", CTOKEN_TYPE_IDENTIFIER_CORE_SHAPE, NSHAPE_CORE_STATIC_QUAD}, // KEYWORD_CORE_STATIC_QUAD
	{"core_static_pent", CTOKEN_TYPE_IDENTIFIER_CORE_SHAPE, NSHAPE_CORE_STATIC_PENT}, // KEYWORD_CORE_STATIC_PENT
	{"core_static_hex_A", CTOKEN_TYPE_IDENTIFIER_CORE_SHAPE, NSHAPE_CORE_STATIC_HEX_A}, // KEYWORD_CORE_STATIC_HEX_A
	{"core_static_hex_B", CTOKEN_TYPE_IDENTIFIER_CORE_SHAPE, NSHAPE_CORE_STATIC_HEX_B}, // KEYWORD_CORE_STATIC_HEX_B
	{"core_static_hex_C", CTOKEN_TYPE_IDENTIFIER_CORE_SHAPE, NSHAPE_CORE_STATIC_HEX_C}, // KEYWORD_CORE_STATIC_HEX_C

	{"component_tri", CTOKEN_TYPE_IDENTIFIER_SHAPE, NSHAPE_COMPONENT_TRI}, // KEYWORD_COMPONENT_TRI
	{"component_fork", CTOKEN_TYPE_IDENTIFIER_SHAPE, NSHAPE_COMPONENT_FORK}, // KEYWORD_COMPONENT_FORK
	{"component_box", CTOKEN_TYPE_IDENTIFIER_SHAPE, NSHAPE_COMPONENT_BOX}, // KEYWORD_COMPONENT_BOX
	{"component_long4", CTOKEN_TYPE_IDENTIFIER_SHAPE, NSHAPE_COMPONENT_LONG4}, // KEYWORD_COMPONENT_LONG4
	{"component_cap", CTOKEN_TYPE_IDENTIFIER_SHAPE, NSHAPE_COMPONENT_CAP}, // KEYWORD_COMPONENT_CAP
	{"component_prong", CTOKEN_TYPE_IDENTIFIER_SHAPE, NSHAPE_COMPONENT_PRONG}, // KEYWORD_COMPONENT_PRONG
	{"component_long5", CTOKEN_TYPE_IDENTIFIER_SHAPE, NSHAPE_COMPONENT_LONG5}, // KEYWORD_COMPONENT_LONG5
	{"component_bowl", CTOKEN_TYPE_IDENTIFIER_SHAPE, NSHAPE_COMPONENT_BOWL}, // KEYWORD_COMPONENT_BOWL
	{"component_long6", CTOKEN_TYPE_IDENTIFIER_SHAPE, NSHAPE_COMPONENT_LONG6}, // KEYWORD_COMPONENT_LONG6

 {"object_none", CTOKEN_TYPE_IDENTIFIER_OBJECT, OBJECT_TYPE_NONE}, // KEYWORD_OBJECT_NONE
 {"object_uplink", CTOKEN_TYPE_IDENTIFIER_OBJECT, OBJECT_TYPE_UPLINK}, // KEYWORD_OBJECT_UPLINK
 {"object_downlink", CTOKEN_TYPE_IDENTIFIER_OBJECT, OBJECT_TYPE_DOWNLINK}, // KEYWORD_OBJECT_DOWNLINK
 {"object_move", CTOKEN_TYPE_IDENTIFIER_OBJECT, OBJECT_TYPE_MOVE}, // KEYWORD_OBJECT_MOVE
 {"object_pulse", CTOKEN_TYPE_IDENTIFIER_OBJECT, OBJECT_TYPE_PULSE}, // KEYWORD_OBJECT_PULSE
 {"object_pulse_l", CTOKEN_TYPE_IDENTIFIER_OBJECT, OBJECT_TYPE_PULSE_L}, // KEYWORD_OBJECT_PULSE_L
 {"object_pulse_xl", CTOKEN_TYPE_IDENTIFIER_OBJECT, OBJECT_TYPE_PULSE_XL}, // KEYWORD_OBJECT_PULSE_XL
 {"object_burst", CTOKEN_TYPE_IDENTIFIER_OBJECT, OBJECT_TYPE_BURST}, // KEYWORD_OBJECT_BURST
 {"object_burst_l", CTOKEN_TYPE_IDENTIFIER_OBJECT, OBJECT_TYPE_BURST_L}, // KEYWORD_OBJECT_BURST_L
 {"object_burst_xl", CTOKEN_TYPE_IDENTIFIER_OBJECT, OBJECT_TYPE_BURST_XL}, // KEYWORD_OBJECT_BURST_XL
 {"object_build", CTOKEN_TYPE_IDENTIFIER_OBJECT, OBJECT_TYPE_BUILD}, // KEYWORD_OBJECT_BUILD
 {"object_interface", CTOKEN_TYPE_IDENTIFIER_OBJECT, OBJECT_TYPE_INTERFACE}, // KEYWORD_OBJECT_INTERFACE
 {"object_interface_depth", CTOKEN_TYPE_IDENTIFIER_OBJECT, OBJECT_TYPE_INTERFACE_DEPTH}, // KEYWORD_OBJECT_INTERFACE_DEPTH
// {"object_interface_stability", CTOKEN_TYPE_IDENTIFIER_OBJECT, OBJECT_TYPE_INTERFACE_STABILITY}, // KEYWORD_OBJECT_INTERFACE_STABILITY
// {"object_interface_response", CTOKEN_TYPE_IDENTIFIER_OBJECT, OBJECT_TYPE_INTERFACE_RESPONSE}, // KEYWORD_OBJECT_INTERFACE_RESPONSE
 {"object_harvest", CTOKEN_TYPE_IDENTIFIER_OBJECT, OBJECT_TYPE_HARVEST}, // KEYWORD_OBJECT_HARVEST
 {"object_storage", CTOKEN_TYPE_IDENTIFIER_OBJECT, OBJECT_TYPE_STORAGE}, // KEYWORD_OBJECT_STORAGE
 {"object_allocate", CTOKEN_TYPE_IDENTIFIER_OBJECT, OBJECT_TYPE_ALLOCATE}, // KEYWORD_OBJECT_ALLOCATE
 {"object_stream", CTOKEN_TYPE_IDENTIFIER_OBJECT, OBJECT_TYPE_STREAM}, // KEYWORD_OBJECT_STREAM
 {"object_stream_dir", CTOKEN_TYPE_IDENTIFIER_OBJECT, OBJECT_TYPE_STREAM_DIR}, // KEYWORD_OBJECT_STREAM_DIR
 {"object_spike", CTOKEN_TYPE_IDENTIFIER_OBJECT, OBJECT_TYPE_SPIKE}, // KEYWORD_OBJECT_SPIKE
 {"object_repair", CTOKEN_TYPE_IDENTIFIER_OBJECT, OBJECT_TYPE_REPAIR}, // KEYWORD_OBJECT_REPAIR
 {"object_repair_other", CTOKEN_TYPE_IDENTIFIER_OBJECT, OBJECT_TYPE_REPAIR_OTHER}, // KEYWORD_OBJECT_REPAIR_OTHER

// compiler keywords
 {"int", CTOKEN_TYPE_IDENTIFIER_C_KEYWORD}, //, KEYWORD_C_INT},
 {"if", CTOKEN_TYPE_IDENTIFIER_C_KEYWORD}, //, KEYWORD_C_IF},
 {"else", CTOKEN_TYPE_IDENTIFIER_C_KEYWORD}, //, KEYWORD_C_ELSE},
 {"return", CTOKEN_TYPE_IDENTIFIER_C_KEYWORD}, //, KEYWORD_C_RETURN},
 {"printf", CTOKEN_TYPE_IDENTIFIER_C_KEYWORD}, //, KEYWORD_C_PRINTF},
 {"while", CTOKEN_TYPE_IDENTIFIER_C_KEYWORD}, //, KEYWORD_C_WHILE},
 {"do", CTOKEN_TYPE_IDENTIFIER_C_KEYWORD}, //, KEYWORD_C_DO},
 {"for", CTOKEN_TYPE_IDENTIFIER_C_KEYWORD}, //, KEYWORD_C_FOR},
 {"break", CTOKEN_TYPE_IDENTIFIER_C_KEYWORD}, //, KEYWORD_C_BREAK},
 {"continue", CTOKEN_TYPE_IDENTIFIER_C_KEYWORD}, //, KEYWORD_C_CONTINUE},
 {"enum", CTOKEN_TYPE_IDENTIFIER_C_KEYWORD}, //, KEYWORD_C_ENUM},
 {"goto", CTOKEN_TYPE_IDENTIFIER_C_KEYWORD}, //, KEYWORD_C_GOTO},
 {"gosub", CTOKEN_TYPE_IDENTIFIER_NON_C_KEYWORD}, //, KEYWORD_C_GOSUB}, *** note type (not really a C keyword)
 {"switch", CTOKEN_TYPE_IDENTIFIER_C_KEYWORD}, //, KEYWORD_C_SWITCH},
 {"case", CTOKEN_TYPE_IDENTIFIER_C_KEYWORD}, //, KEYWORD_C_CASE},
 {"default", CTOKEN_TYPE_IDENTIFIER_C_KEYWORD}, //, KEYWORD_C_DEFAULT},
 {"exit", CTOKEN_TYPE_IDENTIFIER_C_KEYWORD}, //, KEYWORD_C_EXIT},

 {"process", CTOKEN_TYPE_IDENTIFIER_NON_C_KEYWORD}, //, KEYWORD_C_PROCESS},
 {"code", CTOKEN_TYPE_IDENTIFIER_NON_C_KEYWORD}, //, KEYWORD_C_CODE},
 {"component", CTOKEN_TYPE_IDENTIFIER_NON_C_KEYWORD}, //, KEYWORD_C_COMPONENT},
 {"object", CTOKEN_TYPE_IDENTIFIER_NON_C_KEYWORD}, //, KEYWORD_C_OBJECT},
 {"class", CTOKEN_TYPE_IDENTIFIER_NON_C_KEYWORD}, //, KEYWORD_C_CLASS},

// object methods
// - move
 {"set_power", CTOKEN_TYPE_IDENTIFIER_OMETHOD, CALL_SET_POWER}, // KEYWORD_OMETHOD_SET_POWER,
 {"move_to", CTOKEN_TYPE_IDENTIFIER_OMETHOD, CALL_MOVE_TO}, // KEYWORD_OMETHOD_MOVE_TO,

 {"turn_to_xy", CTOKEN_TYPE_IDENTIFIER_OMETHOD, CALL_TURN_TO_XY}, // KEYWORD_OMETHOD_TURN_TO_XY,
 {"turn_to_angle", CTOKEN_TYPE_IDENTIFIER_OMETHOD, CALL_TURN_TO_ANGLE}, // KEYWORD_OMETHOD_TURN_TO_ANGLE,
 {"turn_to_target", CTOKEN_TYPE_IDENTIFIER_OMETHOD, CALL_TURN_TO_TARGET}, // KEYWORD_OMETHOD_TURN_TO_TARGET,
 {"track_target", CTOKEN_TYPE_IDENTIFIER_OMETHOD, CALL_TRACK_TARGET}, // KEYWORD_OMETHOD_TRACK_TARGET,
 {"approach_xy", CTOKEN_TYPE_IDENTIFIER_OMETHOD, CALL_APPROACH_XY}, // KEYWORD_OMETHOD_APPROACH_XY,
 {"approach_target", CTOKEN_TYPE_IDENTIFIER_OMETHOD, CALL_APPROACH_TARGET}, // KEYWORD_OMETHOD_APPROACH_TARGET,
 {"approach_track", CTOKEN_TYPE_IDENTIFIER_OMETHOD, CALL_APPROACH_TRACK}, // KEYWORD_OMETHOD_APPROACH_TRACK,

// packet
 {"fire", CTOKEN_TYPE_IDENTIFIER_OMETHOD, CALL_FIRE}, // KEYWORD_OMETHOD_FIRE,
 {"rotate", CTOKEN_TYPE_IDENTIFIER_OMETHOD, CALL_ROTATE}, // KEYWORD_OMETHOD_ROTATE,
 {"no_target", CTOKEN_TYPE_IDENTIFIER_OMETHOD, CALL_NO_TARGET}, // KEYWORD_OMETHOD_NO_TARGET,
 {"aim_at", CTOKEN_TYPE_IDENTIFIER_OMETHOD, CALL_AIM_AT}, // KEYWORD_OMETHOD_AIM_AT,
 {"fire_at", CTOKEN_TYPE_IDENTIFIER_OMETHOD, CALL_FIRE_AT}, // KEYWORD_OMETHOD_FIRE_AT,
 {"intercept", CTOKEN_TYPE_IDENTIFIER_OMETHOD, CALL_INTERCEPT}, // KEYWORD_OMETHOD_INTERCEPT,
// {"build_retry", CTOKEN_TYPE_IDENTIFIER_OMETHOD, CALL_BUILD_RETRY}, // KEYWORD_OMETHOD_BUILD_RETRY,
 {"gather_data", CTOKEN_TYPE_IDENTIFIER_OMETHOD, CALL_GATHER_DATA}, // KEYWORD_OMETHOD_GATHER_DATA,
 {"give_data", CTOKEN_TYPE_IDENTIFIER_OMETHOD, CALL_GIVE_DATA}, // KEYWORD_OMETHOD_GIVE_DATA,
 {"allocate_data", CTOKEN_TYPE_IDENTIFIER_OMETHOD, CALL_ALLOCATE_DATA}, // KEYWORD_OMETHOD_ALLOCATE_DATA,
 {"fire_spike", CTOKEN_TYPE_IDENTIFIER_OMETHOD, CALL_FIRE_SPIKE}, // KEYWORD_OMETHOD_FIRE_SPIKE,
 {"fire_spike_at", CTOKEN_TYPE_IDENTIFIER_OMETHOD, CALL_FIRE_SPIKE_AT}, // KEYWORD_OMETHOD_FIRE_SPIKE_AT,
 {"fire_spike_xy", CTOKEN_TYPE_IDENTIFIER_OMETHOD, CALL_FIRE_SPIKE_XY}, // KEYWORD_OMETHOD_FIRE_SPIKE_XY,
 {"set_interface", CTOKEN_TYPE_IDENTIFIER_OMETHOD, CALL_SET_INTERFACE}, // KEYWORD_OMETHOD_SET_INTERFACE,
 {"attack_scan", CTOKEN_TYPE_IDENTIFIER_OMETHOD, CALL_ATTACK_SCAN}, // KEYWORD_OMETHOD_ATTACK_SCAN
 {"attack_scan_aim", CTOKEN_TYPE_IDENTIFIER_OMETHOD, CALL_ATTACK_SCAN_AIM}, // KEYWORD_OMETHOD_ATTACK_SCAN_AIM

// component methods
 {"get_component_x", CTOKEN_TYPE_IDENTIFIER_MMETHOD, MMETHOD_CALL_GET_COMPONENT_X}, // KEYWORD_MMETHOD_GET_COMPONENT_X,
 {"get_component_y", CTOKEN_TYPE_IDENTIFIER_MMETHOD, MMETHOD_CALL_GET_COMPONENT_Y}, // KEYWORD_MMETHOD_GET_COMPONENT_Y,
 {"component_exists", CTOKEN_TYPE_IDENTIFIER_MMETHOD, MMETHOD_CALL_COMPONENT_EXISTS}, // KEYWORD_MMETHOD_COMPONENT_EXISTS,
 {"get_integrity", CTOKEN_TYPE_IDENTIFIER_MMETHOD, MMETHOD_CALL_GET_INTEGRITY}, // KEYWORD_MMETHOD_GET_INTEGRITY,
 {"get_integrity_max", CTOKEN_TYPE_IDENTIFIER_MMETHOD, MMETHOD_CALL_GET_INTEGRITY_MAX}, // KEYWORD_MMETHOD_GET_INTEGRITY_MAX,

// core methods
 {"get_core_x", CTOKEN_TYPE_IDENTIFIER_CMETHOD, CMETHOD_CALL_GET_CORE_X}, // KEYWORD_CMETHOD_GET_CORE_X,
 {"get_core_y", CTOKEN_TYPE_IDENTIFIER_CMETHOD, CMETHOD_CALL_GET_CORE_Y}, // KEYWORD_CMETHOD_GET_CORE_Y,
 {"get_process_x", CTOKEN_TYPE_IDENTIFIER_CMETHOD, CMETHOD_CALL_GET_PROCESS_X}, // KEYWORD_CMETHOD_GET_PROCESS_X,
 {"get_process_y", CTOKEN_TYPE_IDENTIFIER_CMETHOD, CMETHOD_CALL_GET_PROCESS_Y}, // KEYWORD_CMETHOD_GET_PROCESS_Y,
 {"get_core_angle", CTOKEN_TYPE_IDENTIFIER_CMETHOD, CMETHOD_CALL_GET_CORE_ANGLE}, // KEYWORD_CMETHOD_GET_CORE_ANGLE,
 {"get_core_spin", CTOKEN_TYPE_IDENTIFIER_CMETHOD, CMETHOD_CALL_GET_CORE_SPIN}, // KEYWORD_CMETHOD_GET_CORE_SPIN,
 {"get_core_speed_x", CTOKEN_TYPE_IDENTIFIER_CMETHOD, CMETHOD_CALL_GET_CORE_SPEED_X}, // KEYWORD_CMETHOD_GET_CORE_SPEED_X,
 {"get_core_speed_y", CTOKEN_TYPE_IDENTIFIER_CMETHOD, CMETHOD_CALL_GET_CORE_SPEED_Y}, // KEYWORD_CMETHOD_GET_CORE_SPEED_Y,
// {"get_core_speed_x", CTOKEN_TYPE_IDENTIFIER_CMETHOD, CMETHOD_CALL_GET_CORE_SPEED_X}, // KEYWORD_CMETHOD_GET_CORE_SPEED_X,
// {"get_core_speed_y", CTOKEN_TYPE_IDENTIFIER_CMETHOD, CMETHOD_CALL_GET_CORE_SPEED_Y}, // KEYWORD_CMETHOD_GET_CORE_SPEED_Y,
 {"get_interface_strength", CTOKEN_TYPE_IDENTIFIER_CMETHOD, CMETHOD_CALL_GET_INTERFACE_STRENGTH}, // KEYWORD_CMETHOD_GET_INTERFACE_STRENGTH
 {"get_interface_capacity", CTOKEN_TYPE_IDENTIFIER_CMETHOD, CMETHOD_CALL_GET_INTERFACE_CAPACITY}, // KEYWORD_CMETHOD_GET_INTERFACE_CAPACITY
 {"get_user", CTOKEN_TYPE_IDENTIFIER_CMETHOD, CMETHOD_CALL_GET_USER}, // KEYWORD_CMETHOD_GET_USER
 {"get_template", CTOKEN_TYPE_IDENTIFIER_CMETHOD, CMETHOD_CALL_GET_TEMPLATE}, // KEYWORD_CMETHOD_GET_TEMPLATE
 {"distance", CTOKEN_TYPE_IDENTIFIER_CMETHOD, CMETHOD_CALL_DISTANCE}, // KEYWORD_CMETHOD_DISTANCE
// {"distance_hypot", CTOKEN_TYPE_IDENTIFIER_CMETHOD, CMETHOD_CALL_DISTANCE_HYPOT}, // KEYWORD_CMETHOD_DISTANCE_HYPOT
 {"distance_less", CTOKEN_TYPE_IDENTIFIER_CMETHOD, CMETHOD_CALL_DISTANCE_LESS}, // KEYWORD_CMETHOD_DISTANCE_LESS
 {"distance_more", CTOKEN_TYPE_IDENTIFIER_CMETHOD, CMETHOD_CALL_DISTANCE_MORE}, // KEYWORD_CMETHOD_DISTANCE_MORE
 {"target_angle", CTOKEN_TYPE_IDENTIFIER_CMETHOD, CMETHOD_CALL_TARGET_ANGLE}, // KEYWORD_CMETHOD_TARGET_ANGLE
 {"get_components", CTOKEN_TYPE_IDENTIFIER_CMETHOD, CMETHOD_CALL_GET_COMPONENTS}, // KEYWORD_CMETHOD_GET_COMPONENTS
 {"get_components_max", CTOKEN_TYPE_IDENTIFIER_CMETHOD, CMETHOD_CALL_GET_COMPONENTS_MAX}, // KEYWORD_CMETHOD_GET_COMPONENTS_MAX
 {"get_total_integrity", CTOKEN_TYPE_IDENTIFIER_CMETHOD, CMETHOD_CALL_GET_TOTAL_INTEGRITY}, // KEYWORD_CMETHOD_GET_TOTAL_INTEGRITY
 {"get_total_integrity_max", CTOKEN_TYPE_IDENTIFIER_CMETHOD, CMETHOD_CALL_GET_TOTAL_INTEGRITY_MAX}, // KEYWORD_CMETHOD_GET_TOTAL_INTEGRITY_MAX
 {"get_unharmed_integrity_max", CTOKEN_TYPE_IDENTIFIER_CMETHOD, CMETHOD_CALL_GET_UNHARMED_INTEGRITY_MAX}, // KEYWORD_CMETHOD_GET_UNHARMED_INTEGRITY_MAX
 {"visible", CTOKEN_TYPE_IDENTIFIER_CMETHOD, CMETHOD_CALL_VISIBLE}, // KEYWORD_CMETHOD_VISIBLE

 {"scan_for_threat", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_SCAN_FOR_THREAT}, // KEYWORD_SMETHOD_SCAN_FOR_THREAT
 {"check_point", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_CHECK_POINT}, // KEYWORD_SMETHOD_CHECK_POINT
 {"get_command_type", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_COMMAND_TYPE}, // KEYWORD_SMETHOD_GET_COMMAND_TYPE,
 {"get_command_x", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_COMMAND_X}, // KEYWORD_SMETHOD_GET_COMMAND_X,
 {"get_command_y", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_COMMAND_Y}, // KEYWORD_SMETHOD_GET_COMMAND_Y,
 {"get_command_number", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_COMMAND_NUMBER}, // KEYWORD_SMETHOD_GET_COMMAND_NUMBER,
 {"get_command_ctrl", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_COMMAND_CTRL}, // KEYWORD_SMETHOD_GET_COMMAND_CTRL,
 {"get_commands", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_COMMANDS}, // KEYWORD_SMETHOD_GET_COMMANDS,
 {"clear_command", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_CLEAR_COMMAND}, // KEYWORD_SMETHOD_CLEAR_COMMAND,
 {"clear_all_commands", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_CLEAR_ALL_COMMANDS}, // KEYWORD_SMETHOD_CLEAR_ALL_COMMANDS,
 {"get_command_target", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_COMMAND_TARGET}, // KEYWORD_SMETHOD_GET_COMMAND_TARGET,
 {"get_command_target_component", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_COMMAND_TARGET_COMPONENT}, // KEYWORD_SMETHOD_GET_COMMAND_TARGET_COMPONENT,
 {"check_new_command", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_CHECK_NEW_COMMAND}, // KEYWORD_SMETHOD_CHECK_NEW_COMMAND,
 {"check_new_build_command", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_CHECK_NEW_BUILD_COMMAND}, // KEYWORD_SMETHOD_CHECK_NEW_BUILD_COMMAND,
 {"check_build_command", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_CHECK_BUILD_COMMAND}, // KEYWORD_SMETHOD_CHECK_BUILD_COMMAND,
 {"get_build_command_x", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_BUILD_COMMAND_X}, // KEYWORD_SMETHOD_GET_BUILD_COMMAND_X,
 {"get_build_command_y", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_BUILD_COMMAND_Y}, // KEYWORD_SMETHOD_GET_BUILD_COMMAND_Y,
 {"get_build_command_angle", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_BUILD_COMMAND_ANGLE}, // KEYWORD_SMETHOD_GET_BUILD_COMMAND_ANGLE,
 {"get_build_command_template", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_BUILD_COMMAND_TEMPLATE}, // KEYWORD_SMETHOD_GET_BUILD_COMMAND_TEMPLATE,
 {"get_build_command_ctrl", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_BUILD_COMMAND_CTRL}, // KEYWORD_SMETHOD_GET_BUILD_COMMAND_CTRL,
 {"clear_build_command", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_CLEAR_BUILD_COMMAND}, // KEYWORD_SMETHOD_CLEAR_BUILD_COMMAND,
 {"clear_all_build_commands", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_CLEAR_ALL_BUILD_COMMANDS}, // KEYWORD_SMETHOD_CLEAR_ALL_BUILD_COMMANDS,
// {"get_interface_strength", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_INTERFACE_STRENGTH}, // KEYWORD_SMETHOD_GET_INTERFACE_STRENGTH,
// {"get_interface_capacity", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_INTERFACE_CAPACITY}, // KEYWORD_SMETHOD_GET_INTERFACE_CAPACITY,
 {"charge_interface", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_CHARGE_INTERFACE}, // KEYWORD_SMETHOD_CHARGE_INTERFACE

 {"set_interface_general", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_SET_INTERFACE_GENERAL}, // KEYWORD_SMETHOD_SET_INTERFACE_GENERAL
// {"spare_power_to_interface", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_SPARE_POWER_TO_INTERFACE}, // KEYWORD_SMETHOD_SPARE_POWER_TO_INTERFACE
// {"all_power_to_interface", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_ALL_POWER_TO_INTERFACE}, // KEYWORD_SMETHOD_ALL_POWER_TO_INTERFACE
 {"charge_interface_max", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_CHARGE_INTERFACE_MAX}, // KEYWORD_SMETHOD_CHARGE_INTERFACE_MAX


 {"check_selected", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_CHECK_SELECTED}, // KEYWORD_SMETHOD_CHECK_SELECTED,
 {"check_selected_single", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_CHECK_SELECTED_SINGLE}, // KEYWORD_SMETHOD_CHECK_SELECTED_SINGLE,
 {"get_available_data", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_AVAILABLE_DATA}, // KEYWORD_SMETHOD_GET_AVAILABLE_DATA,
 {"search_for_well", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_SEARCH_FOR_WELL}, // KEYWORD_SMETHOD_SEARCH_FOR_WELL,
 {"get_well_x", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_WELL_X}, // KEYWORD_SMETHOD_GET_WELL_X,
 {"get_well_y", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_WELL_Y}, // KEYWORD_SMETHOD_GET_WELL_Y,
 {"get_well_data", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_WELL_DATA}, // KEYWORD_SMETHOD_GET_WELL_DATA,
 {"get_data_stored", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_DATA_STORED}, // KEYWORD_SMETHOD_GET_DATA_STORED,
 {"get_data_capacity", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_DATA_CAPACITY}, // KEYWORD_SMETHOD_GET_DATA_CAPACITY,
 {"scan_single", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_SCAN_SINGLE}, // KEYWORD_SMETHOD_SCAN_SINGLE,
 {"scan_multi", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_SCAN_MULTI}, // KEYWORD_SMETHOD_SCAN_MULTI,
// {"scan_for_template", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_SCAN_FOR_TEMPLATE}, // KEYWORD_SMETHOD_SCAN_FOR_TEMPLATE

 {"get_power_capacity", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_POWER_CAPACITY}, // KEYWORD_SMETHOD_GET_POWER_CAPACITY,
 {"get_power_used", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_POWER_USED}, // KEYWORD_SMETHOD_GET_POWER_USED,
 {"get_power_left", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_POWER_LEFT}, // KEYWORD_SMETHOD_GET_POWER_LEFT,
// {"get_power_used_actual", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_POWER_USED_ACTUAL}, // KEYWORD_SMETHOD_GET_POWER_USED_ACTUAL,
// {"get_power_left_actual", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_POWER_LEFT_ACTUAL}, // KEYWORD_SMETHOD_GET_POWER_LEFT_ACTUAL,
// {"get_stress", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_STRESS}, // KEYWORD_SMETHOD_GET_STRESS,
// {"get_stress_percent", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_STRESS_PERCENT}, // KEYWORD_SMETHOD_GET_STRESS_PERCENT,
// {"predict_stress", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_PREDICT_STRESS}, // KEYWORD_SMETHOD_PREDICT_STRESS, - not implemented
 {"set_debug_mode", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_SET_DEBUG_MODE}, // KEYWORD_SMETHOD_SET_DEBUG_MODE,

 {"transmit", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_TRANSMIT}, // KEYWORD_SMETHOD_TRANSMIT
 {"broadcast", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_BROADCAST}, // KEYWORD_SMETHOD_BROADCAST
 {"transmit_target", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_TRANSMIT_TARGET}, // KEYWORD_SMETHOD_TRANSMIT_TARGET
 {"broadcast_target", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_BROADCAST_TARGET}, // KEYWORD_SMETHOD_BROADCAST_TARGET
 {"check_messages", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_CHECK_MESSAGES}, // KEYWORD_SMETHOD_CHECK_MESSAGES
 {"get_message_type", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_MESSAGE_TYPE}, // KEYWORD_SMETHOD_GET_MESSAGE_TYPE
 {"get_message_channel", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_MESSAGE_CHANNEL}, // KEYWORD_SMETHOD_GET_MESSAGE_CHANNEL
 {"get_message_source", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_MESSAGE_SOURCE}, // KEYWORD_SMETHOD_GET_MESSAGE_SOURCE
 {"get_message_x", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_MESSAGE_X}, // KEYWORD_SMETHOD_GET_MESSAGE_X
 {"get_message_y", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_MESSAGE_Y}, // KEYWORD_SMETHOD_GET_MESSAGE_Y
 {"get_message_target", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_MESSAGE_TARGET}, // KEYWORD_SMETHOD_GET_MESSAGE_TARGET
 {"get_message_priority", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_MESSAGE_PRIORITY}, // KEYWORD_SMETHOD_GET_MESSAGE_PRIORITY
 {"read_message", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_READ_MESSAGE}, // KEYWORD_SMETHOD_READ_MESSAGE
 {"next_message", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_NEXT_MESSAGE}, // KEYWORD_SMETHOD_NEXT_MESSAGE
 {"ignore_channel", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_IGNORE_CHANNEL}, // KEYWORD_SMETHOD_IGNORE_CHANNEL
 {"listen_channel", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_LISTEN_CHANNEL}, // KEYWORD_SMETHOD_LISTEN_CHANNEL
 {"ignore_all_channels", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_IGNORE_ALL_CHANNELS}, // KEYWORD_SMETHOD_IGNORE_ALL_CHANNELS
 {"copy_commands", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_COPY_COMMANDS}, // KEYWORD_SMETHOD_COPY_COMMANDS
 {"check_build_range", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_CHECK_BUILD_RANGE}, // KEYWORD_SMETHOD_CHECK_BUILD_RANGE
 {"repair_self", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_REPAIR_SELF}, // KEYWORD_SMETHOD_REPAIR_SELF
 {"restore_self", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_RESTORE_SELF}, // KEYWORD_SMETHOD_RESTORE_SELF
 {"repair_other", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_REPAIR_OTHER}, // KEYWORD_SMETHOD_REPAIR_OTHER
 {"repair_scan", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_REPAIR_SCAN}, // KEYWORD_SMETHOD_REPAIR_SCAN
 {"restore_other", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_RESTORE_OTHER}, // KEYWORD_SMETHOD_RESTORE_OTHER
 {"restore_scan", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_RESTORE_SCAN}, // KEYWORD_SMETHOD_RESTORE_SCAN
 {"build_process", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_BUILD_PROCESS}, // KEYWORD_SMETHOD_BUILD_PROCESS,
 {"build_as_commanded", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_BUILD_AS_COMMANDED}, // KEYWORD_SMETHOD_BUILD_AS_COMMANDED,
 {"build_repeat", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_BUILD_REPEAT}, // KEYWORD_SMETHOD_BUILD_REPEAT,
 {"get_template_cost", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_TEMPLATE_COST}, // KEYWORD_SMETHOD_GET_TEMPLATE_COST,
 {"random", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_RANDOM}, // KEYWORD_SMETHOD_RANDOM,

 {"check_contact", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_CHECK_CONTACT}, // KEYWORD_SMETHOD_CHECK_CONTACT,
 {"get_damage", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_DAMAGE}, // KEYWORD_SMETHOD_GET_DAMAGE,
 {"get_damage_source", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_DAMAGE_SOURCE}, // KEYWORD_SMETHOD_GET_DAMAGE_SOURCE,
 {"distance_from_xy", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_DISTANCE_FROM_XY}, // KEYWORD_SMETHOD_DISTANCE_FROM_XY,
// {"distance_from_xy_hypot", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_DISTANCE_FROM_XY_HYPOT}, // KEYWORD_SMETHOD_DISTANCE_XY_HYPOT,
 {"distance_from_xy_less", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_DISTANCE_FROM_XY_LESS}, // KEYWORD_SMETHOD_DISTANCE_LESS,
 {"distance_from_xy_more", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_DISTANCE_FROM_XY_MORE}, // KEYWORD_SMETHOD_DISTANCE_MORE,
 {"distance_xy", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_DISTANCE_XY}, // KEYWORD_SMETHOD_DISTANCE_XY,

// from_target stuff is done as core methods
// {"distance_from_target", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_DISTANCE_FROM_TARGET}, // KEYWORD_SMETHOD_DISTANCE_TARGET,
// {"distance_from_target_hypot", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_DISTANCE_FROM_TARGET_HYPOT}, // KEYWORD_SMETHOD_DISTANCE_TARGET_HYPOT,
 {"target_clear", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_TARGET_CLEAR}, // KEYWORD_SMETHOD_TARGET_CLEAR,
 {"target_compare", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_TARGET_COMPARE}, // KEYWORD_SMETHOD_TARGET_COMPARE,
 {"target_copy", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_TARGET_COPY}, // KEYWORD_SMETHOD_TARGET_COPY,
 {"target_destroyed", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_TARGET_DESTROYED}, // KEYWORD_SMETHOD_TARGET_DESTROYED,

 {"attack_mode", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_ATTACK_MODE}, // KEYWORD_SMETHOD_ATTACK_MODE,

 {"sin", CTOKEN_TYPE_IDENTIFIER_UMETHOD, UMETHOD_CALL_SIN}, // KEYWORD_UMETHOD_SIN,
 {"cos", CTOKEN_TYPE_IDENTIFIER_UMETHOD, UMETHOD_CALL_COS}, // KEYWORD_UMETHOD_COS,
 {"atan2", CTOKEN_TYPE_IDENTIFIER_UMETHOD, UMETHOD_CALL_ATAN2}, // KEYWORD_UMETHOD_ATAN2
 {"hypot", CTOKEN_TYPE_IDENTIFIER_UMETHOD, UMETHOD_CALL_HYPOT}, // KEYWORD_UMETHOD_HYPOT
// {"hypot_less", CTOKEN_TYPE_IDENTIFIER_UMETHOD, UMETHOD_CALL_HYPOT_LESS}, // KEYWORD_UMETHOD_HYPOT_LESS
// {"hypot_more", CTOKEN_TYPE_IDENTIFIER_UMETHOD, UMETHOD_CALL_HYPOT_MORE}, // KEYWORD_UMETHOD_HYPOT_MORE
 {"world_x", CTOKEN_TYPE_IDENTIFIER_UMETHOD, UMETHOD_CALL_WORLD_X}, // KEYWORD_UMETHOD_WORLD_X
 {"world_y", CTOKEN_TYPE_IDENTIFIER_UMETHOD, UMETHOD_CALL_WORLD_Y}, // KEYWORD_UMETHOD_WORLD_Y
 {"abs", CTOKEN_TYPE_IDENTIFIER_UMETHOD, UMETHOD_CALL_ABS}, // KEYWORD_UMETHOD_ABS,
 {"angle_difference", CTOKEN_TYPE_IDENTIFIER_UMETHOD, UMETHOD_CALL_ANGLE_DIFFERENCE}, // KEYWORD_UMETHOD_ANGLE_DIFFERENCE,
 {"arc_length", CTOKEN_TYPE_IDENTIFIER_UMETHOD, UMETHOD_CALL_ARC_LENGTH}, // KEYWORD_UMETHOD_ARC_LENGTH,

 {"(empty)", CTOKEN_TYPE_NONE}, // KEYWORDS (this is the start of the user-defined identifiers)

};
/*
// scan methods
 {"scan_for_threat", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_SCAN_FOR_THREAT}, // KEYWORD_SMETHOD_SCAN_FOR_THREAT
 {"scan_point", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_SCAN_POINT}, // KEYWORD_SMETHOD_SCAN_POINT
 {"scan_single", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_SCAN_SINGLE}, // KEYWORD_SMETHOD_SCAN_SINGLE,
 {"scan_multi", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_SCAN_MULTI}, // KEYWORD_SMETHOD_SCAN_MULTI,
 {"scan_for_template", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_SCAN_FOR_TEMPLATE}, // KEYWORD_SMETHOD_SCAN_FOR_TEMPLATE

// power methods
 {"get_power_capacity", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_POWER_CAPACITY}, // KEYWORD_SMETHOD_GET_POWER_CAPACITY,
 {"get_power_used", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_POWER_USED}, // KEYWORD_SMETHOD_GET_POWER_USED,
 {"get_power_left", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_POWER_LEFT}, // KEYWORD_SMETHOD_GET_POWER_LEFT,
 {"get_power_used_actual", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_POWER_USED_ACTUAL}, // KEYWORD_SMETHOD_GET_POWER_USED_ACTUAL,
 {"get_power_left_actual", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_POWER_LEFT_ACTUAL}, // KEYWORD_SMETHOD_GET_POWER_LEFT_ACTUAL,
 {"get_stress", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_STRESS}, // KEYWORD_SMETHOD_GET_STRESS,

// contact/damage methods
 {"check_contact", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_CHECK_CONTACT}, // KEYWORD_SMETHOD_CHECK_CONTACT,
 {"get_damage", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_DAMAGE}, // KEYWORD_SMETHOD_GET_DAMAGE,
 {"get_damage_source", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_DAMAGE_SOURCE}, // KEYWORD_SMETHOD_GET_DAMAGE_SOURCE,

// data well methods
 {"search_for_well", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_SEARCH_FOR_WELL}, // KEYWORD_SMETHOD_SEARCH_FOR_WELL,
 {"get_well_x", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_WELL_X}, // KEYWORD_SMETHOD_GET_WELL_X,
 {"get_well_y", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_WELL_Y}, // KEYWORD_SMETHOD_GET_WELL_Y,
 {"get_well_data", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_WELL_DATA}, // KEYWORD_SMETHOD_GET_WELL_DATA,
 {"get_data_stored", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_DATA_STORED}, // KEYWORD_SMETHOD_GET_DATA_STORED,
 {"get_data_capacity", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_DATA_CAPACITY}, // KEYWORD_SMETHOD_GET_DATA_CAPACITY,

// message methods
 {"transmit", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_TRANSMIT}, // KEYWORD_SMETHOD_TRANSMIT
 {"broadcast", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_BROADCAST}, // KEYWORD_SMETHOD_BROADCAST
 {"check_messages", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_CHECK_MESSAGES}, // KEYWORD_SMETHOD_CHECK_MESSAGES
 {"get_message_type", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_MESSAGE_TYPE}, // KEYWORD_SMETHOD_GET_MESSAGE_TYPE
 {"get_message_channel", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_MESSAGE_CHANNEL}, // KEYWORD_SMETHOD_GET_MESSAGE_CHANNEL
 {"get_message_source", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_MESSAGE_SOURCE}, // KEYWORD_SMETHOD_GET_MESSAGE_SOURCE
 {"get_message_x", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_MESSAGE_X}, // KEYWORD_SMETHOD_GET_MESSAGE_X
 {"get_message_y", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_MESSAGE_Y}, // KEYWORD_SMETHOD_GET_MESSAGE_Y
 {"get_message_priority", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_MESSAGE_PRIORITY}, // KEYWORD_SMETHOD_GET_MESSAGE_PRIORITY
 {"read_message", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_READ_MESSAGE}, // KEYWORD_SMETHOD_READ_MESSAGE
 {"next_message", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_NEXT_MESSAGE}, // KEYWORD_SMETHOD_NEXT_MESSAGE
 {"ignore_channel", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_IGNORE_CHANNEL}, // KEYWORD_SMETHOD_IGNORE_CHANNEL
 {"listen_channel", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_LISTEN_CHANNEL}, // KEYWORD_SMETHOD_LISTEN_CHANNEL
 {"ignore_all_channels", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_IGNORE_ALL_CHANNELS}, // KEYWORD_SMETHOD_IGNORE_ALL_CHANNELS
 {"copy_commands", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_COPY_COMMANDS}, // KEYWORD_SMETHOD_COPY_COMMANDS

// build methods
 {"check_build_range", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_CHECK_BUILD_RANGE}, // KEYWORD_SMETHOD_CHECK_BUILD_RANGE
 {"build_process", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_BUILD_PROCESS}, // KEYWORD_SMETHOD_BUILD_PROCESS,
 {"build_as_commanded", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_BUILD_AS_COMMANDED}, // KEYWORD_SMETHOD_BUILD_AS_COMMANDED,
 {"build_repeat", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_BUILD_REPEAT}, // KEYWORD_SMETHOD_BUILD_REPEAT,

// interface methods
 {"charge_interface", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_CHARGE_INTERFACE}, // KEYWORD_SMETHOD_CHARGE_INTERFACE
 {"set_interface_general", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_SET_INTERFACE_GENERAL}, // KEYWORD_SMETHOD_SET_INTERFACE_GENERAL
 {"spare_power_to_interface", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_SPARE_POWER_TO_INTERFACE}, // KEYWORD_SMETHOD_SPARE_POWER_TO_INTERFACE
 {"all_power_to_interface", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_ALL_POWER_TO_INTERFACE}, // KEYWORD_SMETHOD_ALL_POWER_TO_INTERFACE

// repair methods
 {"repair_self", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_REPAIR_SELF}, // KEYWORD_SMETHOD_REPAIR_SELF
 {"restore_self", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_RESTORE_SELF}, // KEYWORD_SMETHOD_RESTORE_SELF
 {"repair_other", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_REPAIR_OTHER}, // KEYWORD_SMETHOD_REPAIR_OTHER
 {"repair_scan", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_REPAIR_SCAN}, // KEYWORD_SMETHOD_REPAIR_SCAN
 {"restore_other", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_RESTORE_OTHER}, // KEYWORD_SMETHOD_RESTORE_OTHER
 {"restore_scan", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_RESTORE_SCAN}, // KEYWORD_SMETHOD_RESTORE_SCAN

// user selection methods
 {"check_selected", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_CHECK_SELECTED}, // KEYWORD_SMETHOD_CHECK_SELECTED,
 {"check_selected_single", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_CHECK_SELECTED_SINGLE}, // KEYWORD_SMETHOD_CHECK_SELECTED_SINGLE,

// command methods
 {"check_new_command", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_CHECK_NEW_COMMAND}, // KEYWORD_SMETHOD_CHECK_NEW_COMMAND,
 {"get_commands", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_COMMANDS}, // KEYWORD_SMETHOD_GET_COMMANDS,
 {"get_command_type", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_COMMAND_TYPE}, // KEYWORD_SMETHOD_GET_COMMAND_TYPE,
 {"get_command_x", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_COMMAND_X}, // KEYWORD_SMETHOD_GET_COMMAND_X,
 {"get_command_y", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_COMMAND_Y}, // KEYWORD_SMETHOD_GET_COMMAND_Y,
 {"get_command_ctrl", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_COMMAND_CTRL}, // KEYWORD_SMETHOD_GET_COMMAND_CTRL,
 {"clear_command", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_CLEAR_COMMAND}, // KEYWORD_SMETHOD_CLEAR_COMMAND,
 {"clear_all_commands", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_CLEAR_ALL_COMMANDS}, // KEYWORD_SMETHOD_CLEAR_ALL_COMMANDS,
 {"get_command_target", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_COMMAND_TARGET}, // KEYWORD_SMETHOD_GET_COMMAND_TARGET,
 {"get_command_target_member", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_COMMAND_TARGET_MEMBER}, // KEYWORD_SMETHOD_GET_COMMAND_TARGET_MEMBER,

// build command methods
 {"check_new_build_command", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_CHECK_NEW_BUILD_COMMAND}, // KEYWORD_SMETHOD_CHECK_NEW_BUILD_COMMAND,
 {"check_build_command", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_CHECK_BUILD_COMMAND}, // KEYWORD_SMETHOD_CHECK_BUILD_COMMAND,
 {"get_build_command_x", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_BUILD_COMMAND_X}, // KEYWORD_SMETHOD_GET_BUILD_COMMAND_X,
 {"get_build_command_y", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_BUILD_COMMAND_Y}, // KEYWORD_SMETHOD_GET_BUILD_COMMAND_Y,
 {"get_build_command_angle", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_BUILD_COMMAND_ANGLE}, // KEYWORD_SMETHOD_GET_BUILD_COMMAND_ANGLE,
 {"get_build_command_template", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_BUILD_COMMAND_TEMPLATE}, // KEYWORD_SMETHOD_GET_BUILD_COMMAND_TEMPLATE,
 {"get_build_command_ctrl", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_GET_BUILD_COMMAND_CTRL}, // KEYWORD_SMETHOD_GET_BUILD_COMMAND_CTRL,
 {"clear_build_command", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_CLEAR_BUILD_COMMAND}, // KEYWORD_SMETHOD_CLEAR_BUILD_COMMAND,
 {"clear_all_build_commands", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_CLEAR_ALL_BUILD_COMMANDS}, // KEYWORD_SMETHOD_CLEAR_ALL_BUILD_COMMANDS,

// maths and miscellaneous methods
 {"sin", CTOKEN_TYPE_IDENTIFIER_UMETHOD, UMETHOD_CALL_SIN}, // KEYWORD_UMETHOD_SIN,
 {"cos", CTOKEN_TYPE_IDENTIFIER_UMETHOD, UMETHOD_CALL_COS}, // KEYWORD_UMETHOD_COS,
 {"atan2", CTOKEN_TYPE_IDENTIFIER_UMETHOD, UMETHOD_CALL_ATAN2}, // KEYWORD_UMETHOD_ATAN2
 {"hypot", CTOKEN_TYPE_IDENTIFIER_UMETHOD, UMETHOD_CALL_HYPOT}, // KEYWORD_UMETHOD_HYPOT
 {"world_x", CTOKEN_TYPE_IDENTIFIER_UMETHOD, UMETHOD_CALL_WORLD_X}, // KEYWORD_UMETHOD_WORLD_X
 {"world_y", CTOKEN_TYPE_IDENTIFIER_UMETHOD, UMETHOD_CALL_WORLD_Y}, // KEYWORD_UMETHOD_WORLD_Y
 {"abs", CTOKEN_TYPE_IDENTIFIER_UMETHOD, UMETHOD_CALL_ABS}, // KEYWORD_UMETHOD_ABS,
 {"angle_difference", CTOKEN_TYPE_IDENTIFIER_UMETHOD, UMETHOD_CALL_ANGLE_DIFFERENCE}, // KEYWORD_UMETHOD_ANGLE_DIFFERENCE,
 {"arc_length", CTOKEN_TYPE_IDENTIFIER_UMETHOD, UMETHOD_CALL_ARC_LENGTH}, // KEYWORD_UMETHOD_ARC_LENGTH,
 {"distance_from_xy", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_DISTANCE_FROM_XY}, // KEYWORD_SMETHOD_DISTANCE_XY,
 {"distance_from_xy_hypot", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_DISTANCE_FROM_XY_HYPOT}, // KEYWORD_SMETHOD_DISTANCE_XY_HYPOT,
 {"distance_from_target", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_DISTANCE_FROM_TARGET}, // KEYWORD_SMETHOD_DISTANCE_TARGET,
 {"distance_from_target_hypot", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_DISTANCE_FROM_TARGET_HYPOT}, // KEYWORD_SMETHOD_DISTANCE_TARGET_HYPOT,
 {"random", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_RANDOM}, // KEYWORD_SMETHOD_RANDOM,
 {"set_debug_mode", CTOKEN_TYPE_IDENTIFIER_SMETHOD, SMETHOD_CALL_SET_DEBUG_MODE}, // KEYWORD_SMETHOD_SET_DEBUG_MODE,
*/
