// NIGHT OF THE LIVING NERD!
// Speedhack 07 entry by
// Dennis Busch (Concept, Graphics, Code,Samples)
// Pedro Avelar Gontijo (Music, Name Of The Game)

// external data is needed to run the compiled code: "sh07data.dat" (contains graphics and music)

// see readme.txt for additional details about the Speedhack07 competition

// ...and it's all full of bugs(well maybe there are some) and crap code(all written from scratch for this compo)...

// (yes, it's one ugly mess of hardcoded values and purely procedural madness and the game logic even depends on some
// graphics in the datafile, so do not dare to change any values!(chance to break everything by doing that is very high))

#include "main.h"

const char* data_filename = "./media/sh07data.dat";
DATAFILE* data = NULL;
BITMAP* backbuffer = NULL; // will be created later

// following bitmaps will be just pointer to data from the datafile (won't be created or destroyed)
BITMAP* map_direction = NULL;
BITMAP* map_surface = NULL;
BITMAP* sprite_cloud = NULL;
BITMAP* sprite_stapler = NULL;
BITMAP* sprite_stapler_s = NULL;
BITMAP* sprite_sheet = NULL;
BITMAP* sprite_sheet_s = NULL;
BITMAP* sprite_monitor = NULL;
BITMAP* sprite_monitor_s = NULL;
BITMAP* sprite_glue = NULL;
BITMAP* sprite_glue_s = NULL;
BITMAP* sprite_player = NULL;
BITMAP* sprite_opendoor = NULL;
BITMAP* sprite_building_overlay = NULL;
BITMAP* sprite_crt = NULL;
FONT* font_border = NULL;
FONT* font_inner = NULL;
MIDI* music_epic = NULL;
SAMPLE* snd_stapler = NULL;
SAMPLE* snd_monitor = NULL;
SAMPLE* snd_explosion = NULL;
SAMPLE* snd_urks0 = NULL;
SAMPLE* snd_urks1 = NULL;

// for the input
int poll_k = false;
int poll_m = false;

// for music control
bool i_can_has_sound = false;
const int snd_vol = 255;
const int mus_vol = 196;

// for the gamestate
bool quit_ingame = false;
bool game_over = false;
const int game_over_delay = 320;
int game_over_countdown = game_over_delay;

// for the hud state
//#define __DEBUG_LOOKUP
int selected_weapon = 0; // 0 stapler, (1 codesheets), 2 monitor, (3 glue) ("removed due to lack of time")
const int change_weapon_delay = 10;
int change_weapon_countdown = 0;

// for the player
const int ply_range_start = 267;
const int ply_range_x_start = 155;
double ply_stair_speed = 0.25;
double ply_plain_speed = 0.5;
const double ammo_stapler_speed = 2.0;
const double ammo_monitor_speed = 0.6;
int ammo_stapler_reload_delay = 15;
int ammo_monitor_reload_delay = 30;
double ply_x = 160.0;
double ply_dest = 160.0;
double ply_min_x = 0.0; // gets set correctly after the lookup table for the rooftop is created
double ply_max_x = 0.0; // gets set correctly after the lookup table for the rooftop is created
int ply_range_y = 0; // gets set correctly after the lookup table for the rooftop is created
int ply_range_x = 0; // gets set correctly after the lookup table for the rooftop is created
int ply_y[320]; // lookup table for rooftop
int score = 0;
int door_strength = 4096;
int ammo_stapler = 8192;
int ammo_sheet = 0;
int ammo_monitor = 512;
int ammo_glue = 0;
int ammo_stapler_countdown = 0;
int ammo_monitor_countdown = 0;

// for the zombies
int score_multiplier = 1; // (depends on difficulty)
int zombie_spawn_delay = 60; // ticks between zombie spawns (depends on difficulty)
int zombie_spawn_countdown = 60;
const double water_stream_speed = 0.0625;
const double zombie_fly_speed = 1.0; // for zombies that get thrown around by explosions
const double zombie_pavement_speed = 0.125;
const double zombie_grass_speed = 0.0625;
const double zombie_water_speed = 0.03175;
const int max_wave = 10; // maximum of ten waves, so 1024 zombies max
int wave = 3; // zombies will come in 2^wave per wave, player won't see wave number, starting with 8 zombies
const int zombie_fly_state_delay = 20;
const int zombie_frame_delay = 20;
const int zombie_die_frame_delay = 10;
struct zombie
{
  double x,y;
  double z; // for flight control (will be used very simple with no real throw curve)
  double fx, fy; // also for flight control
  int state_countdown; // used for (reading) and flying zombies (not enought time)
  int frame_countdown; // used for changing the current frame
  int frame_number;
  int dir;
  int state; // -1 inactive, 0 walking , 1 flying rise, 2 flying peak, 3 flying fall, 4 reading code, 5 at door, 6 dying
  bool water;
  bool building;
};
int next_zombie = 0;
const int max_zombies = 1024;
zombie enemies[max_zombies]; // no time for fancy dynamic stuff

const int shot_die_delay = 15;
struct shot
{
  double x,y;
  double dest_x, dest_y; // destination (for monitors and to make shots dissappear when they are out of their range)
  double vx,vy; // shoot direction
  int type; // 0 stapler, 1 sheets, 2 monitor, 3 glue (1 and 3 are not implemented)
  int state; // -1 inactive, 0 flying, 1 out of range
  int die_countdown;
};
int next_shot = 0;
const int max_shots = 256;
shot shots[max_shots]; // no time for fancy dynamic stuff

const int explosion_frame_delay = 20;
struct explosion
{
  double x,y;
  int frame_countdown;
  int frame_number;
  int state; // -1 inactive, 0 active
};
int next_explosion = 0;
const int max_explosions = 256;
explosion explosions[max_explosions]; // no time for fancy dynamic stuff

// for the cloud
int cloud_y = 10;
double cloud_x = 0.0;
double cloud_s = 0.125;

// for the carriage
const double carriage_speed = 0.25;
const int carriage_frame_delay = 20;
const int carriage_die_frame_delay = 10;
int carriage_frame_countdown = carriage_frame_delay;
int carriage_frame_number = 0;
double carriage_x = -16.0;
double carriage_y = 224.0;
int carriage_state = 0; // 0 active, 1 dying
int carriage_dir = 0; // 0 going right, 1 going left

// for ingame speed control
const int ticks_per_second = 60;
volatile int speed_counter = 0;
void increment_speed_counter()
{
  speed_counter++;
}
END_OF_FUNCTION(increment_speed_counter)

void spawn_shot(int type, double x, double y, double dest_x, double dest_y);
bool point_inside_rect(double x1, double y1, double x2, double y2, double px, double py);

void process_input()
{
  if(poll_m)
    poll_mouse();
  if(poll_k)
    poll_keyboard();

  if(mouse_y < 128) // mouse in upper "half" makes player move
  {
    if(mouse_b & 1) // left click
    {
      ply_dest = double(mouse_x);
    }
  }
  else // mouse in lower half makes player shoot
  {
    double mx = double(mouse_x);
    double my = double(mouse_y);
    if(mouse_b & 1) // left click
    {
      if(point_inside_rect(ply_x-ply_range_x, 129.0, ply_x+ply_range_x, ply_range_y, mx,my))
      {
        if((selected_weapon==0)&&(ammo_stapler_countdown==0)&&(ammo_stapler>0))
        {
          if(i_can_has_sound)
            play_sample(snd_stapler, snd_vol, 128, 1000, 0);
          spawn_shot(selected_weapon, ply_x, double(ply_y[fixfloor(ftofix(ply_x))])-8.0, mx,my);
          ammo_stapler--;
          ammo_stapler_countdown = ammo_stapler_reload_delay;
        }
        if((selected_weapon==2)&&(ammo_monitor_countdown==0)&&(ammo_monitor>0))
        {
          if(i_can_has_sound)
            play_sample(snd_monitor, snd_vol, 128, 1000, 0);
          spawn_shot(selected_weapon, ply_x, double(ply_y[fixfloor(ftofix(ply_x))])-8.0, mx,my);
          ammo_monitor--;
          ammo_monitor_countdown = ammo_monitor_reload_delay;
        }
      }
    }
  }

  if(key[KEY_SPACE] || (mouse_b & 2)) // SPACE, RIGHT BUTTON cycle weapons
  {
    if(change_weapon_countdown == 0)
    {
      selected_weapon = (selected_weapon+2)%4;
      change_weapon_countdown = change_weapon_delay;
    }
  }
  
  if(key[KEY_LEFT]) // cursor key movement for player
    ply_dest = 0.0;
  if(key[KEY_RIGHT])
    ply_dest = 319.0;
  if(key[KEY_DOWN])
    ply_dest = ply_x;
  
  if(key[KEY_F12]) // screenshot
  {
    save_pcx("screenshot.pcx", backbuffer, (RGB*)data[GAMEPAL].dat);
    while(key[KEY_F12]);
  }

  if(key[KEY_ESC]) // ESC quits from ingame
    quit_ingame = true;
}

void recalc_ply_range()
{
  ply_range_y = ply_range_start - (ply_y[fixfloor(ftofix(ply_x))]);
  ply_range_x = ply_range_x_start - (ply_y[fixfloor(ftofix(ply_x))]);
}

void reset_zombies()
{
  for(int i=0; i<max_zombies; i++)
    enemies[i].state = -1;
  next_zombie = 0;
}

void reset_shots()
{
  for(int i=0; i<max_shots; i++)
    shots[i].state = -1;
  next_shot = 0;
}

void reset_explosions()
{
  for(int i=0; i<max_explosions; i++)
    explosions[i].state = -1;
  next_explosion = 0;
}

bool point_inside_rect(double x1, double y1, double x2, double y2, double px, double py)
{
  if(px < x1)
    return false;
  if(px > x2)
    return false;
  if(py < y1)
    return false;
  if(py > y2)
    return false;
  return true;
}

void spawn_zombie()
{
  int spawn_area = rand()%4;
  double spawn_x = 0.0;
  double spawn_y = 0.0;
  switch(spawn_area)
  {
    case 0: // left of screen
      spawn_x = -10.0;
      spawn_y = 171.0 + double(rand()%70);
    break;
    case 1: // left half of below screen
      spawn_y = 270.0;
      spawn_x = 0.0 + double(rand()%160); 
    break;
    case 2: // right half of below screen
      spawn_y = 270.0;
      spawn_x = 160.0 + double(rand()%160);
    break;
    case 3: // right of screen
      spawn_x = 330.0;
      spawn_y = 135.0 + double(rand()%100);
    break;
    default:
      // nothing
    break;
  }
  
  enemies[next_zombie].state = 0;
  enemies[next_zombie].frame_number = rand()%4;
  enemies[next_zombie].frame_countdown = zombie_frame_delay;
  enemies[next_zombie].z = 0.0;
  enemies[next_zombie].x = spawn_x;
  enemies[next_zombie].y = spawn_y;
  enemies[next_zombie].building = false;
  
  next_zombie = (next_zombie+1)%max_zombies;
}

void spawn_shot(int type, double x, double y, double dest_x, double dest_y)
{
  if((type==1) || (type==3))  // stapler sheets and glue were cut out for time reasons
    return;

  shots[next_shot].type = type;
  shots[next_shot].x = x;
  shots[next_shot].y = y;
  shots[next_shot].dest_x = dest_x;
  shots[next_shot].dest_y = dest_y;
  
  double vx = dest_x - x;
  double vy = dest_y - y;
  double vl = sqrt(vx*vx + vy*vy);
  vx = vx/vl;
  vy = vy/vl;
  
  shots[next_shot].vx = vx;
  shots[next_shot].vy = vy;
  
  shots[next_shot].state = 0;
  
  next_shot = (next_shot+1)%max_shots;
}

void spawn_explosion(double x, double y)
{
  if(i_can_has_sound)
    play_sample(snd_explosion, snd_vol, 128, 1000, 0);
  explosions[next_explosion].frame_countdown = explosion_frame_delay;
  explosions[next_explosion].frame_number = 0;
  explosions[next_explosion].x = x;
  explosions[next_explosion].y = y;
  explosions[next_explosion].state = 0;
  
  next_explosion = (next_explosion+1)%max_explosions;
}

void update_shot(int which)
{
  if(shots[which].state == -1)
    return;
  
  if(shots[which].state == 1) // out of range
  {
    if(shots[which].die_countdown > 0)
      shots[which].die_countdown--;
    else
      shots[which].state = -1;
    return;
  }
  
  // update position
  double speed = 0.0;
  if(shots[which].type == 0)
    speed = ammo_stapler_speed;
  if(shots[which].type == 2)
    speed = ammo_monitor_speed;
    
  shots[which].x += shots[which].vx*speed;
  shots[which].y += shots[which].vy*speed;
  
  // out of range check
  bool die = false;
  if(shots[which].vx > 0) 
    if(shots[which].x > shots[which].dest_x) // shot too far to the right
    {
      shots[which].x = shots[which].dest_x;
      shots[which].y = shots[which].dest_y;
      die = true;
    }
  if(shots[which].vx < 0) 
    if(shots[which].x < shots[which].dest_x) // shot too far to the left
    {
      shots[which].x = shots[which].dest_x;
      shots[which].y = shots[which].dest_y;
      die = true;
    }
  if(shots[which].vy > 0) // shot too far down
    if(shots[which].y > shots[which].dest_y)
    {
      shots[which].y = shots[which].dest_x;
      shots[which].y = shots[which].dest_y;
      die = true;
    }
  
  if(die)
  {
    if(shots[which].type == 0)  // stapler ammo just dies with a delay
    {
      shots[which].die_countdown = shot_die_delay;
      shots[which].state = 1;
    }
    if(shots[which].type == 2) // monitor ammo spawns an explosion and does get inactive immediately
    {
      spawn_explosion(shots[which].x, shots[which].y);
      shots[which].state = -1;
    }
  }
}

void update_carriage()
{
  if(carriage_frame_countdown > 0)
  {
    carriage_frame_countdown--;
  }
  else
  {
    if(carriage_state == 0) // active ?
    {
      carriage_frame_number = (carriage_frame_number+1)%4;
      carriage_frame_countdown = carriage_frame_delay;
    }
    else // dying
    {
      if((carriage_frame_number+1)==4) // finished dying ?
      {
        // reset carriage
        carriage_frame_countdown = carriage_frame_delay;
        int carriage_dir = rand()%2;
        if(carriage_dir == 0)
          carriage_x = -16.0;
        else
          carriage_x = 336.0;
        carriage_state = 0;
        carriage_frame_number = 0;
      }
      else // still dying
      {
        carriage_frame_number = (carriage_frame_number+1)%4;
        carriage_frame_countdown = carriage_die_frame_delay;
      }
    }
  }
  
  // update position
  if(carriage_state == 0)
  {
    if(carriage_dir == 0)
    {
      carriage_x += carriage_speed;
      if(carriage_x > 336.0)
        carriage_dir = 1;
    }
    else
    {
      carriage_x -= carriage_speed;
      if(carriage_x < -16.0)
        carriage_dir = 0;
    }
  }
}

void draw_carriage()
{
  BITMAP* frame = NULL;
  if(carriage_state==0)
    frame = (BITMAP*)data[CARRIAGE000+carriage_frame_number].dat;
  else
    frame = (BITMAP*)data[CARRIAGEDIE000+carriage_frame_number].dat;
  
  if(carriage_dir == 0)
    masked_blit(frame, backbuffer, 0,0, fixfloor(ftofix(carriage_x))-frame->w/2, fixfloor(ftofix(carriage_y))-frame->h, frame->w, frame->h);
  else
    draw_sprite_h_flip(backbuffer, frame, fixfloor(ftofix(carriage_x))-frame->w/2, fixfloor(ftofix(carriage_y))-frame->h);  
}

void update_explosion(int which)
{
  if(explosions[which].state == -1)
    return;
  
  if(explosions[which].frame_countdown > 0)
  {
    explosions[which].frame_countdown--;
  }
  else
  {
    explosions[which].frame_number++;
    explosions[which].frame_countdown = explosion_frame_delay;
  }
  
  if(explosions[which].frame_number == 4) // explosion ended?
  {
    explosions[which].state = -1;
  }
}

void update_zombie(int which)
{
  if(enemies[which].state == -1)
    return;

  // update animation state
  if(enemies[which].frame_countdown > 0)
    enemies[which].frame_countdown--;
  else
  {
    if((enemies[which].state == 6)&&(enemies[which].frame_number+1==4)) // dying zombie is finished dying?
    {
      enemies[which].state = -1;
      score = score + 10*score_multiplier;
      return; // dead zombie is dead! :D
    }
    else // normal zombeh is normal! :P lol i'm in ur code, upgrayding ur fraym-numbahs
    {
      enemies[which].frame_number = (enemies[which].frame_number+1)%4;
      if(enemies[which].state ==6)
        enemies[which].frame_countdown = zombie_die_frame_delay;
      else
        enemies[which].frame_countdown = zombie_frame_delay;
    }
  }
  
  if(enemies[which].state == 1) // flying rise
  {
    if(enemies[which].state_countdown >0)
    {
      enemies[which].state_countdown--;
      enemies[which].x += enemies[which].fx * zombie_fly_speed;
      enemies[which].y += enemies[which].fy * zombie_fly_speed;
      if(enemies[which].y <= 134.0)
        enemies[which].y = 134.0;
      enemies[which].z += zombie_fly_speed;
    }
    else
    {
      enemies[which].state = 2; // continue flying at peak
      enemies[which].state_countdown = zombie_fly_state_delay/4;
    }
    return;
  }
  if(enemies[which].state == 2) // flying peak
  {
    if(enemies[which].state_countdown >0)
    {
      enemies[which].state_countdown--;
      enemies[which].x += enemies[which].fx * zombie_fly_speed;
      enemies[which].y += enemies[which].fy * zombie_fly_speed;
      if(enemies[which].y <= 134.0)
        enemies[which].y = 134.0;
    }
    else
    {
      enemies[which].state = 3; // continue flying fall
      enemies[which].state_countdown = zombie_fly_state_delay;
    }
    return;
  }
  if(enemies[which].state == 3) // flying fall
  {
    if(enemies[which].state_countdown >0)
    {
      enemies[which].state_countdown--;
      enemies[which].x += enemies[which].fx * zombie_fly_speed;
      enemies[which].y += enemies[which].fy * zombie_fly_speed;
      if(enemies[which].y <= 134.0)
        enemies[which].y = 134.0;
      enemies[which].z -= zombie_fly_speed;
    }
    else
    {
      enemies[which].state = 0; // continue walking
    }
    return;
  }
  
  if(enemies[which].state == 5) // at door
  {
    if(door_strength > 0)
      door_strength--;
    else
    {
      enemies[which].state = 0; // the door is down! back to walking mode and set inside building flag
      enemies[which].building = true; // needed for drawing
    }
  }
  
  // update position
  if(enemies[which].state == 0) // walking
  {
    enemies[which].water = false;
    int direction = 0;
    double speed = 0.5;
    int speed_pixel = 0;
    
    // outside screen area, set move direction and speed manually
    bool left = enemies[which].x < 0.0;
    bool right = enemies[which].x > 319.0;
    bool below = enemies[which].y > 239.0;
    if(left||right||below) 
    {
      if(left)
        direction = 0;
      if(right)
        direction = 4;
      if(below)
      {
        if(enemies[which].x < 160.0)
          direction = 7;
        else
          direction = 5;
      }
      speed = 0.5;
    }
    else // inside screen area, use direction map to get move direction
    {
      direction = getpixel(map_direction, fixfloor(ftofix(enemies[which].x)), fixfloor(ftofix(enemies[which].y))); 
      speed_pixel = getpixel(map_surface, fixfloor(ftofix(enemies[which].x)), fixfloor(ftofix(enemies[which].y)));
      if(speed_pixel == 1)
        speed = zombie_pavement_speed;
      if(speed_pixel == 2)
        speed = zombie_grass_speed;
      if(speed_pixel == 3)
        speed = zombie_water_speed;
    } 
   
    enemies[which].dir = direction; // needed for drawing
   
    // adjust x by found speed
    if((direction == 0)||(direction == 1)||(direction == 7))
      enemies[which].x += speed;
    if((direction == 4)||(direction == 5)||(direction == 3))
      enemies[which].x -= speed;
      
    // if inside water, add some more x to simulate a strong stream
    if(speed_pixel == 3)
    {
      enemies[which].x += water_stream_speed;
      enemies[which].water = true; // need this info for drawing
    }
    
    // adjust y by found speed
    if((direction == 1)||(direction == 2)||(direction == 3))
      enemies[which].y += speed;
    if((direction == 5)||(direction == 6)||(direction == 7))
      enemies[which].y -= speed;
    
    // check for changing state to "at door"
    if(point_inside_rect(148.0,111.0, 179.0,134.0, enemies[which].x, enemies[which].y))
      enemies[which].state = 5; // 5 is "at door"
    
    // check for game over condition (when zombie reaches code safe)
    if(point_inside_rect(270.0,122.0,281.0,133.0, enemies[which].x, enemies[which].y))
      game_over = true;
      
  } // end of if "walking" 
}

void collisions()
{
  // explosions with zombies and carriage
  for(int e=0; e<max_explosions; e++)
  {
    if(explosions[e].state == 0) // explosion active?
    {
      for(int z=0; z<max_zombies; z++) // for all zombies
      {
        if((enemies[z].state != -1)&&(enemies[z].state != 6)&&(!(enemies[z].building))) // active zombie?, outside?
        {
          // get distance to explosion
          double vx = enemies[z].x - explosions[e].x;
          double vy = enemies[z].y - explosions[e].y;
          double vl = sqrt(vx*vx+vy*vy);
          vx = vx/vl;
          vy = vy/vl;
          
          if(vl <= 32.0) // near explosion? -> kill zombie
          {
            enemies[z].frame_number = 0;
            enemies[z].frame_countdown = zombie_die_frame_delay;
            enemies[z].state = 6;
            if(i_can_has_sound)
              play_sample(snd_urks0, snd_vol, 128, 750+rand()%500, 0);
            break; // move on to next zombie, this one is already taken care of
          }
          if(vl <= 42.0) // not so near explosion -> throw zombie back
          {
            if((enemies[z].state >= 1)&&((enemies[z].state <= 3))) // zombie already flying? 
            {
              // only changes directions for already flying zombie
              enemies[z].fx = vx;
              enemies[z].fy = vy;
            }
            else // zombie not already flying, starts flying
            {
              enemies[z].state = 1;  // 1 is flying "rise"
              enemies[z].state_countdown = zombie_fly_state_delay;
            }
            break;
          }
        }
      } // end of for all zombies
      
      // check carriage
      double vx = carriage_x - explosions[e].x;
      double vy = carriage_y - explosions[e].y;
      double vl = sqrt(vx*vx+vy*vy);
      if((vl <= 32.0) && (carriage_state == 0))
      {
        if(i_can_has_sound)
          play_sample(snd_urks1, 255, 128, 1000, 0);
        carriage_frame_number = 0;
        carriage_frame_countdown = carriage_die_frame_delay;
        carriage_state = 1;
        score += 500*score_multiplier;
      }
    }
  }
  
  // shots with zombies and carriage
  for(int s=0; s<max_shots; s++)
  {
    if((shots[s].state == 0) && (shots[s].type == 0)) // shot active and of type stapler ammo?
    {
      for(int z=0; z<max_zombies; z++) // for all zombies
      {
        if((enemies[z].state!= -1)&&(enemies[z].state != 6)&&(!enemies[z].building)) // zombie active and not dying and outside?
        {
          // prepare collision box
          double zx1 = enemies[z].x-4.0;
          double zx2 = zx1+8.0;
          double zy1 = enemies[z].y-20.0-enemies[z].z;
          double zy2 = zy1+20.0;
          
          if(point_inside_rect(zx1, zy1, zx2, zy2, shots[s].x, shots[s].y))
          {
            // kill zombie
            enemies[z].frame_number = 0;
            enemies[z].frame_countdown = zombie_die_frame_delay;
            enemies[z].state = 6;
            if(i_can_has_sound)
              play_sample(snd_urks0, snd_vol, 128, 750+rand()%500, 0);
            
            // kill shot
            //shots[s].die_countdown = shot_die_delay;
            shots[s].state = -1;
            break; // every shot can only kill one thing
          }
        }
      }
      
      // check carriage
      if(point_inside_rect(carriage_x-10.0, carriage_y-16.0, carriage_x+10.0, carriage_y, shots[s].x, shots[s].y)
        && (carriage_state == 0))
      {
        shots[s].state = -1;
        if(i_can_has_sound)
          play_sample(snd_urks1, 255, 128, 1000, 0);
        carriage_frame_number = 0;
        carriage_frame_countdown = carriage_die_frame_delay;
        carriage_state = 1;
        score += 500*score_multiplier;
      }
    }
  }
  
}

void update_game_objects()
{
  if(game_over)
  {
    if(game_over_countdown > 0)
      game_over_countdown--;
    if(i_can_has_sound)
      set_volume(game_over_countdown, game_over_countdown);
    return; // game does not continue to run on game_over
  }

  // input control behaviour
  if(change_weapon_countdown > 0)
    change_weapon_countdown--;

  // update cloud
  cloud_x += cloud_s;
  if(cloud_x > 320.0 + (double)((BITMAP*)data[CLOUD].dat)->w)
  {
    cloud_x = 0;
    cloud_y = 10+(rand()%60);
  }
  
  // update_carriage
  update_carriage();
  
  // update player
  // read player speed from surfaces map and apply it
  double ply_speed = 0.0;
  if(getpixel(map_surface, fixfloor(ftofix(ply_x)), 0)==1)
    ply_speed = ply_plain_speed;
  else
    ply_speed = ply_stair_speed;
  
  // move towards destination x
  if(ply_dest > ply_x) 
    ply_x += ply_speed;
  if(ply_dest < ply_x)
    ply_x -= ply_speed;
  
  if(ply_x < ply_min_x) // stop at left end of rooftop
    ply_x = ply_min_x;
  if(ply_x > ply_max_x) // stop at right end of rooftop
    ply_x = ply_max_x; 
    
  recalc_ply_range();
  
  // enforce weapon reload delays
  if(ammo_stapler_countdown > 0)
    ammo_stapler_countdown--;
    
  if(ammo_monitor_countdown > 0)
    ammo_monitor_countdown--;
  
  // update shots and explosions
  for(int s=0; s<max_shots; s++)
    update_shot(s);
    
  for(int e=0; e<max_explosions; e++)
    update_explosion(e);
  
  // collision detection
  collisions();
  
  // update enemies
  if(zombie_spawn_countdown > 0)
    zombie_spawn_countdown--;
  else
  {
    zombie_spawn_countdown = zombie_spawn_delay;
    spawn_zombie();
  }
  
  for(int z=0; z<max_zombies; z++)
    update_zombie(z);
}

void draw_zombie(int which)
{
  if((enemies[which].building)||(enemies[which].state==-1)) // zombies inside were already drawn earlier
    return; 
    
  int x = fixfloor(ftofix(enemies[which].x));
  int y = fixfloor(ftofix(enemies[which].y));
  int y_offset = 0;

  if(enemies[which].state == 6) // dying
  {
    BITMAP* frame = (BITMAP*)data[ZOMBIEDIE000+enemies[which].frame_number].dat;
    if(!enemies[which].water)
      masked_blit(frame, backbuffer, 0,0, x-frame->w/2, y-frame->h, frame->w, frame->h);
    else
    { 
      y_offset = 12;
      masked_blit(frame, backbuffer, 0,0, x-frame->w/2, y-frame->h+y_offset, frame->w, frame->h-10);
      hline(backbuffer, x-5, y+2,x+5, 107);
    }
  }
  
  if((enemies[which].state >= 1)&&(enemies[which].state<=3)) // flying
  {
    BITMAP* frame = (BITMAP*)data[ZOMBIEDIE000].dat;
    circlefill(backbuffer, x, y, 2, 118);
    masked_blit(frame, backbuffer, 0,0,x-frame->w/2, y-frame->h-fixfloor(ftofix(enemies[which].z)), frame->w, frame->h);
  }

  if(enemies[which].state == 5) // at door
    enemies[which].dir = 6;
  if((enemies[which].state == 0) || (enemies[which].state == 5)) // walking or at door
  {
    BITMAP* frame = (BITMAP*)data[ZOMBIEWALK000+enemies[which].dir*4+enemies[which].frame_number].dat;
    if(!enemies[which].water)
      masked_blit(frame, backbuffer, 0,0, x-frame->w/2, y-frame->h, frame->w, frame->h);
    else
    { 
      y_offset = 12;
      masked_blit(frame, backbuffer, 0,0, x-frame->w/2, y-frame->h+y_offset, frame->w, frame->h-10);
      hline(backbuffer, x-5, y+2,x+5, 107);
    }
  }
}

void draw_inside_zombie(int which)
{
  if(!(enemies[which].building)||(enemies[which].state==-1)) // zombies outside will be drawn later
    return;
  
  int x = fixfloor(ftofix(enemies[which].x));
  int y = fixfloor(ftofix(enemies[which].y)); 
  
  BITMAP* frame = (BITMAP*)data[ZOMBIEWALK000+enemies[which].dir*4+enemies[which].frame_number].dat;
  masked_blit(frame, backbuffer, 0,0, x-frame->w/2, y-frame->h, frame->w, frame->h);
}

void draw_shot(int which)
{
  if(shots[which].state == -1)
    return;
    
  if(shots[which].type == 0) // stapler ammo
  {
    if(shots[which].state == 0) // flying
      circlefill(backbuffer, fixfloor(ftofix(shots[which].x)), fixfloor(ftofix(shots[which].y)), 2, 1);
    else // dying
      hline(backbuffer, fixfloor(ftofix(shots[which].x))-3, fixfloor(ftofix(shots[which].y)), fixfloor(ftofix(shots[which].x))+3, 4);
  }
  if(shots[which].type == 2) // crt
  {
    masked_blit(sprite_crt, backbuffer, 0,0, fixfloor(ftofix(shots[which].x))-sprite_crt->w/2, fixfloor(ftofix(shots[which].y))-sprite_crt->h, sprite_crt->w, sprite_crt->h);
  }
}

void draw_explosion(int which)
{
  if(explosions[which].state == -1)
    return;
      
  BITMAP* frame = (BITMAP*)data[EXPLOSION000+explosions[which].frame_number].dat;
  masked_blit(frame, backbuffer, 0,0, fixfloor(ftofix(explosions[which].x))-frame->w/2, fixfloor(ftofix(explosions[which].y))-frame->h, frame->w, frame->h);
}

void render_game_state()
{
  // hide cursor during update
  show_mouse(NULL);
  
  // draw sky
  clear_to_color(backbuffer, 39);
  
  // draw cloud
  masked_blit(sprite_cloud, backbuffer, 0,0, fixfloor(ftofix(cloud_x))-sprite_cloud->w, cloud_y, sprite_cloud->w, sprite_cloud->h);
  
  // draw player
  masked_blit(sprite_player, backbuffer, 0,0, fixfloor(ftofix(ply_x))-sprite_player->w/2, ply_y[(int)ply_x]-sprite_player->h, sprite_player->w, sprite_player->h);
  
  // draw background graphics
  masked_blit((BITMAP*)data[GAMESCREEN].dat, backbuffer, 0,0,0,0,320,240);  

  // draw open door, zombies inside, and building overlay
  if(door_strength == 0)
  {
    masked_blit(sprite_opendoor, backbuffer, 0,0, 146,107, sprite_opendoor->w, sprite_opendoor->h);
    for(int iz=0; iz<next_zombie; iz++)
      draw_inside_zombie(iz);
    masked_blit(sprite_building_overlay, backbuffer, 0,0, 149,105, sprite_building_overlay->w, sprite_building_overlay->h);
  }

  // draw carriage
  draw_carriage();

  // draw enemies and NPCs
  for(int z=0; z<next_zombie; z++)
    draw_zombie(z);
  
  // draw shots
  for(int s=0; s<max_shots; s++)
    draw_shot(s);
  
  // draw explosions
  for(int e=0; e<max_explosions; e++)
    draw_explosion(e);
  
  // draw hud
  
  // player range (is rectangular, not circular (because a rectangle matches the perspective of the background better)
  //hline(backbuffer, 0, ply_range_y, 19, 1);
  //hline(backbuffer, 150, ply_range_y, 169, 1);
  //hline(backbuffer, 300, ply_range_y, 319, 1);
  //vline(backbuffer, fixfloor(ftofix(ply_x)) - ply_range_x, 220, 239, 1);
  //vline(backbuffer, fixfloor(ftofix(ply_x)) + ply_range_x, 220, 239, 1);
  vline(backbuffer, fixfloor(ftofix(ply_x)) - ply_range_x, 129, ply_range_y, 7);
  vline(backbuffer, fixfloor(ftofix(ply_x)) + ply_range_x, 129, ply_range_y, 7);
  hline(backbuffer, fixfloor(ftofix(ply_x)) - ply_range_x, ply_range_y, fixfloor(ftofix(ply_x)) + ply_range_x, 7);
  
  // weapons display
  if(selected_weapon == 0)
    masked_blit(sprite_stapler_s, backbuffer, 0,0,0,0,32,32);
  else
    masked_blit(sprite_stapler, backbuffer, 0,0,0,0,32,32);
  /*if(selected_weapon == 1)
    masked_blit(sprite_sheet_s, backbuffer, 0,0, 32,0, 32,32);
  else
    masked_blit(sprite_sheet, backbuffer, 0,0, 32,0, 32,32);*/
  if(selected_weapon == 2)
    masked_blit(sprite_monitor_s, backbuffer, 0,0, 64,0, 32,32);
  else
    masked_blit(sprite_monitor, backbuffer, 0,0, 64,0, 32,32);
  /*if(selected_weapon == 3)
    masked_blit(sprite_glue_s, backbuffer, 0,0, 96,0, 32,32);
  else
    masked_blit(sprite_glue, backbuffer, 0,0, 96,0, 32,32);*/
  
  // draw score, door strength, ammo
  textprintf_right_ex(backbuffer, font_border, 310, 0, 4, -1, "Score: %i", score);
  textprintf_right_ex(backbuffer, font_inner, 310, 0, 1, -1, "Score: %i", score);
  
  // door strength
  textprintf_right_ex(backbuffer, font_border, 310, 12, 4, -1, "Doorstrength: %i", door_strength);
  textprintf_right_ex(backbuffer, font_inner, 310, 12, 1, -1, "Doorstrength: %i", door_strength);
  
  // ammo
  textprintf_centre_ex(backbuffer, font_border, 16, 32, 4, -1, "%i", ammo_stapler);
  textprintf_centre_ex(backbuffer, font_inner, 16, 32, 1, -1, "%i", ammo_stapler);
  /*textprintf_centre_ex(backbuffer, font_border, 48, 32, 4, -1, "%i", ammo_sheet);
  textprintf_centre_ex(backbuffer, font_inner, 48, 32, 1, -1, "%i", ammo_sheet);*/
  textprintf_centre_ex(backbuffer, font_border, 80, 32, 4, -1, "%i", ammo_monitor);
  textprintf_centre_ex(backbuffer, font_inner, 80, 32, 1, -1, "%i", ammo_monitor);
  /*textprintf_centre_ex(backbuffer, font_border, 112, 32, 4, -1, "%i", ammo_glue);
  textprintf_centre_ex(backbuffer, font_inner, 112, 32, 1, -1, "%i", ammo_glue);*/

  #ifdef __DEBUG_LOOKUP
    for(int i=0; i<320; i++)
      putpixel(backbuffer, i, ply_y[i], 5);
    putpixel(backbuffer, (int)ply_min_x, ply_y[(int)ply_min_x], 1);
    putpixel(backbuffer, (int)ply_max_x, ply_y[(int)ply_max_x], 2);
  #endif

  // draw cursor
  show_mouse(backbuffer);
  
  // game over message
  if(game_over)
  {
    textprintf_centre_ex(backbuffer, font_border, 160, 120, 4, -1, "GAME OVER!");
    textprintf_centre_ex(backbuffer, font_inner, 160, 120, 1, -1, "GAME OVER!");
  }
  
  // finally blit everything to the screen
  stretch_blit(backbuffer, screen, 0,0,320,240,0,0,640,480);
}

void dialog() // cheapo interactive dialog at gamestart
{
  // draw sky
  clear_to_color(backbuffer, 39);
    
  // draw player
  masked_blit(sprite_player, backbuffer, 0,0, fixfloor(ftofix(ply_x))-sprite_player->w/2, ply_y[(int)ply_x]-sprite_player->h, sprite_player->w, sprite_player->h);
  
  // draw background graphics
  masked_blit((BITMAP*)data[GAMESCREEN].dat, backbuffer, 0,0,0,0,320,240);  
  
  masked_blit((BITMAP*)data[ZOMBIEWALK000+16].dat, backbuffer, 0,0, 280, 130, 32,32);
  
  // draw dialog
  rectfill(backbuffer, 10,20, 310, 40, 1);
  rect(backbuffer, 10,20,310,40,4);
  textprintf_centre_ex(backbuffer, font_border, 160, 23, 4, -1, "Muhaha do you think you can stop us?!");
  textprintf_centre_ex(backbuffer,  font_inner, 160, 23, 1, -1, "Muhaha do you think you can stop us?!");
  line(backbuffer, 300, 40, 300, 125, 1);
  
  rectfill(backbuffer, 10, 100, 200, 155, 1);
  rect(backbuffer, 10, 100, 200, 155, 4);
  line(backbuffer, 80, 100, 150, 80, 1);
  textprintf_ex(backbuffer, font_border, 12, 103, 4, -1, "1. Yeah, you suck!!!");
  textprintf_ex(backbuffer,  font_inner, 12, 103, 1, -1, "1. Yeah, you suck!!!");
  
  textprintf_ex(backbuffer, font_border, 12, 115, 4, -1, "2. Of course I do.");
  textprintf_ex(backbuffer,  font_inner, 12, 115, 1, -1, "2. Of course I do.");
  
  textprintf_ex(backbuffer, font_border, 12, 127, 4, -1, "3. We will see..");
  textprintf_ex(backbuffer,  font_inner, 12, 127, 1, -1, "3. We will see..");
  
  textprintf_ex(backbuffer, font_border, 12, 139, 4, -1, "4. No, please leave :'(");
  textprintf_ex(backbuffer,  font_inner, 12, 139, 1, -1, "4. No, please leave :'(");
  
  // make dialog visible
  stretch_blit(backbuffer, screen, 0,0,320,240,0,0,640,480);
  
  // get user input
  int choice_made = 0;
  while(choice_made == 0)
  {
    if(poll_k)
      poll_keyboard();
    if(key[KEY_1])
      choice_made = 1;
    if(key[KEY_2])
      choice_made = 2;
    if(key[KEY_3])
      choice_made = 3;
    if(key[KEY_4])
      choice_made = 4;
  }
  
  // set game variables according to users response
  switch(choice_made)
  {
    case 1:
      score_multiplier = 8;
      zombie_spawn_delay = 30;
      ply_stair_speed = 0.10;
      ply_plain_speed = 0.20;
      ammo_stapler_reload_delay = 40;
      ammo_monitor_reload_delay = 120;
      door_strength = 512;
      ammo_stapler = 1024;
      ammo_monitor = 16;
    break;
    case 2:
      score_multiplier = 4;
      zombie_spawn_delay = 90;
      ply_stair_speed = 0.15;
      ply_plain_speed = 0.35;
      ammo_stapler_reload_delay = 25;
      ammo_monitor_reload_delay = 50;
      door_strength = 1024;
      ammo_stapler = 2048;
      ammo_monitor = 128;
    break;
    case 3:
      score_multiplier = 2;
      zombie_spawn_delay = 120;
      ply_stair_speed = 0.20;
      ply_plain_speed = 0.40;
      ammo_stapler_reload_delay = 20;
      ammo_monitor_reload_delay = 40;
      door_strength = 2048;
      ammo_stapler = 4096;
      ammo_monitor = 256;
    break;
    case 4:
      score_multiplier = 1;
      zombie_spawn_delay = 150;
      ply_stair_speed = 0.25;
      ply_plain_speed = 0.5;
      ammo_stapler_reload_delay = 15;
      ammo_monitor_reload_delay = 30;
      door_strength = 4096;
      ammo_stapler = 8192;
      ammo_monitor = 512;
    break;
    default:
    break;
  }
  
  ammo_stapler_countdown = 0;
  ammo_monitor_countdown = 0;
}

void start_ingame_loop()
{
  dialog();

  reset_zombies();
  reset_shots();
  reset_explosions();
  
  if(i_can_has_sound)
  {
    set_volume(snd_vol, mus_vol);
    play_midi(music_epic, 1);
  }

  // initialize ingame clock
  LOCK_VARIABLE(speed_counter);
  LOCK_FUNCTION(increment_speed_counter);
  install_int_ex(increment_speed_counter, BPS_TO_TIMER(ticks_per_second));

  // main game loop
  while((!quit_ingame)&&(game_over_countdown > 0))
  {
    while (speed_counter > 0) 
    {
      process_input();
      update_game_objects();
      speed_counter--;
    }

    render_game_state();
  }
  // end of main game loop
  
  // deinitialize ingame clock
  remove_int(increment_speed_counter);
}


// initializes the library, loads datafile
int startup()
{
  if(allegro_init()!=0)
  return -1;
  
  if(install_keyboard()!=0)
  return -2;
  
  if(install_timer()!=0)
  return -3;
  
  set_color_depth(8);
  if(set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0,0) != 0)
  return -4;
  
  // create backbuffer
  backbuffer = create_bitmap_ex(8,320, 240);
  if(backbuffer==NULL)
    return -5;
  else
    clear_to_color(backbuffer, 7);
  
  // now load the datafile
  data = load_datafile(data_filename);
  if(data==NULL)
    return -6;
  
  set_palette((RGB*)data[GAMEPAL].dat);
  
  if(install_mouse()==-1)
    return -7;
  
  if(install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL)==-1)
    i_can_has_sound = false;
  else
    i_can_has_sound = true;
  
  // set mouse cursor
  set_mouse_sprite((BITMAP*)data[CURSOR].dat);
  set_mouse_sprite_focus(13,13);
  position_mouse(160,120);
  
  poll_k = keyboard_needs_poll();
  poll_m = mouse_needs_poll();
  
  // link sprites from datafile to bitmap pointers
  map_direction = (BITMAP *)data[GAMEDIRECTIONS].dat;
  map_surface = (BITMAP *)data[GAMESURFACES].dat;
  sprite_cloud = (BITMAP*)data[CLOUD].dat;
  sprite_stapler = (BITMAP*)data[STAPLER0].dat;
  sprite_stapler_s = (BITMAP*)data[STAPLER1].dat;
  sprite_sheet = (BITMAP*)data[SHEET0].dat;
  sprite_sheet_s = (BITMAP*)data[SHEET1].dat;
  sprite_monitor = (BITMAP*)data[MONITOR0].dat;
  sprite_monitor_s = (BITMAP*)data[MONITOR1].dat;
  sprite_glue = (BITMAP*)data[GLUE0].dat;
  sprite_glue_s = (BITMAP*)data[GLUE1].dat;
  sprite_player = (BITMAP*)data[PLAYER].dat;
  sprite_opendoor = (BITMAP*)data[OPENDOOR].dat;
  sprite_building_overlay = (BITMAP*)data[BUILDING_OVLY].dat;
  sprite_crt = (BITMAP*)data[CRT].dat;
  
  // link fonts
  font_inner = (FONT*)data[INNERFONT].dat;
  font_border = (FONT*)data[OUTERFONT].dat;
  
  // link music
  music_epic = (MIDI*)data[MUSIC].dat;
  
  // link sounds
  snd_stapler = (SAMPLE*)data[STAPSND].dat;
  snd_monitor = (SAMPLE*)data[MONSND].dat;
  snd_explosion = (SAMPLE*)data[EXPLSND].dat;
  snd_urks0 = (SAMPLE*)data[URKS0SND].dat;
  snd_urks1 = (SAMPLE*)data[URKS1SND].dat;
  
  // generate lookup table for player heights and find min_ply_x and max_ply_x
  bool min_x_found = false;
  bool max_x_found = false;
  for(int i=0; i<320; i++)
  {
    ply_y[i] = -1; // init to be able to check later, if all positions have been found correctly
    
    if(!max_x_found) // if the max position has already been found, leave the y at -1
    {
      for(int j=0; j<85; j++) // rooftop must not be "higher"(logically) than 85 or this will fail
      {
        if(getpixel(map_surface, i,j)== 5) // color at index 5 was used to define the rooftop positions
        {
          if(!min_x_found) // if this is the first column that a pixel for the rooftop position was found
          {
            min_x_found = true;
            ply_min_x = double(i);
          }
          
          ply_y[i] = j;
          break;
        }
      }
      if((ply_y[i]== -1) && (min_x_found)) // still -1 and min_x_found means that we passed the last possible rooftop position at the right
      {
        max_x_found = true;
        ply_max_x = double(i-1);
      }
    }
  }
  recalc_ply_range();
  
  return 0;
}

// unloads datafile, deinitilizes the library.
void shutdown()
{
  if(i_can_has_sound)
    stop_midi();

  show_mouse(NULL);
  if(backbuffer!=NULL)
    destroy_bitmap(backbuffer);
    
  unload_datafile(data);
  allegro_exit();
}

int main(void)
{
  if(startup()!=0)
  {
    allegro_message("initialization failed. sorry. bye.");
  }
  else
  {
    // if code reaches this line, the library and everything was initialized ok, so we can start the action
    start_ingame_loop();    
  }
        
  shutdown();
  return 0;
}
END_OF_MAIN()
