/*--- Filename: "ca_point.hpp" ---

  --- Projectname: DB's Dynamic Color Gradient Generator ---
  (Targetsystem: Crossplatform)
  
  Author: Dennis Busch (http://www.dennisbusch.de)

  Content:
  The point color attractor.

*/

#include "shared.hpp"
#include "ca_global.hpp"

#if !defined(__DB_ca_point_HEAD_INCLUDED)
#define __DB_ca_point_HEAD_INCLUDED

class CA_POINT : public CA_GLOBAL
{
  protected:
    double _pix_x; // horizontal offset(in pixels,for internal calc. only)
    double _pix_y; // vertical offset(in pixels, for internal calc. only)
    double _pix_range;// range(in pixels)

  // variables that affect the attractors influence
    double EXP;// exponent to modify falloff behaviour in relation to distance
    double X; // the horizontal offset for the point(relative to width)
    double Y; // the vertical offset for the point(relative to height)
    double RANGE; // the range(around (X,Y)) in which the attractor is active
/*!*/virtual double distance(int x, int y); // calculate distance to (x,y)

  // function for loading the vars from a string
/*!*/virtual int update_vars_from_line(); // continues loading from string
    
  public:
    CA_POINT();
    CA_POINT(CA_MODE mode, int r, int g, int b, double colint=1.0,
             double exp=1.0, double x=0.5, double y=0.5, double range=0.5);
/*!*/virtual ~CA_POINT(); // remember to have virtual dtor in derived types

  // Set and Get Methods
    void set_exp(double exp);
    double get_exp();

    void set_x(double x);
    double get_x();

    void set_y(double y);
    double get_y();

    void set_range(double range);
    double get_range();

  // called by the GRADIENT_GEN prior to rendering
  // (should return true, if rendering should be done, false otherwise)
/*!*/virtual bool update_absolutes(int width, int height,
                                   lut_callback lcall, double lcall_skip, int n);

  // The *only* function ever called by the "render_gradient" method from..
  // ..GRADIENT_GEN class (directly modifies "crgb"; applies CA's influence)
/*!*/virtual void modify_crgb(int x, int y, customRGB<double>& crgb);

  // Saving to string (loading from string is handled by "update_vars_..."
/*!*/virtual string get_as_text();

  // Helper function for GUI building that returns some very sparse info
  // meant to be displayed in a list
/*!*/virtual string gui_quick_info();
};

#endif // #if !defined(__DB_ca_point_HEAD_INCLUDED)

/*
  Preserving the possibilty to make nicely formatted printouts
  (Format: "Portrait"), the code should be normed to a width of 78 chars.
123456789012345678901234567890123456789012345678901234567890123456789012345678
---------10--------20--------30--------40--------50--------60--------70-----78
*/
