/*--- Filename: "ca_pointe.hpp" ---

  --- Projectname: DB's Dynamic Color Gradient Generator ---
  (Targetsystem: Crossplatform)
  
  Author: Dennis Busch (http://www.dennisbusch.de)

  Content:
  The pointe color attractor. (the "e" behind point stands for elliptic,
  this color attractor has a rotated elliptic range around its' center)

*/

#include "shared.hpp"
#include "ca_point.hpp"

#if !defined(__DB_ca_pointe_HEAD_INCLUDED)
#define __DB_ca_pointe_HEAD_INCLUDED

class CA_POINTE : public CA_POINT
{
  protected:
    double _pix_w2; // width/2 (in pixels, for internal calc. only)
    double _pix_h2; // height/2 (in pixels, for internal calc. only)
    double _ang_rad; // the rotation angle in radians
    double _bounding_circle_r; // radius of a circle that includes ellipse

  // variables that affect the attractors influence
    // inherited RANGE from CA_POINT is not used in here but in CA_ELLIPSE
    double WIDTH; // the width(around (X,Y)) of the elliptic range
    double HEIGHT; // the height of the elliptic range
    double ANGLE; // the rotation angle in DEGREES (0-359)
/*!*/virtual double distance(int x, int y); /* calculate distance to (x,y)
     (also adjusts the _pix_range for the angle of the distance vector */

  // function for loading the vars from a string
/*!*/virtual int update_vars_from_line(); // continues loading from string
    
  public:
    CA_POINTE();
    CA_POINTE(CA_MODE mode, int r, int g, int b, double colint=1.0,
             double exp=1.0, double x=0.5, double y=0.5, 
             double width=0.5, double height=0.5, double angle=0.0);
/*!*/virtual ~CA_POINTE(); // remember to have virtual dtor in derived types

    void set_width(double width);
    double get_width();

    void set_height(double height);
    double get_height();

    void set_angle(double angle);
    double get_angle();

  // called by the GRADIENT_GEN prior to rendering
  // (should return true, if rendering should be done, false otherwise)
/*!*/virtual bool update_absolutes(int width, int height,
                                   lut_callback lcall, double lcall_skip, int n);

  // The *only* function ever called by the "render_gradient" method from..
  // ..GRADIENT_GEN class (directly modifies "crgb"; applies CA's influence)
/*!*/virtual void modify_crgb(int x, int y, customRGB<double>& crgb);

  // Saving to string (loading from string is handled by "update_vars_..."
/*!*/virtual string get_as_text();

  // Helper function for GUI building that returns some very sparse info
  // meant to be displayed in a list
/*!*/virtual string gui_quick_info();
};

#endif // #if !defined(__DB_ca_pointe_HEAD_INCLUDED)

/*
  Preserving the possibilty to make nicely formatted printouts
  (Format: "Portrait"), the code should be normed to a width of 78 chars.
123456789012345678901234567890123456789012345678901234567890123456789012345678
---------10--------20--------30--------40--------50--------60--------70-----78
*/
