/*--- Filename: "ca_ellipse.hpp" ---

  --- Projectname: DB's Dynamic Color Gradient Generator ---
  (Targetsystem: Crossplatform)
  
  Author: Dennis Busch (http://www.dennisbusch.de)

  Content:
  The ellipse color attractor.

  NOTE:
    This is not being used anymore in the final version as as standalone
    attractor.
    Instead the previous ellipsep! has been promoted to be externally
    known as ellipse(without p).
    This is still here, because the ellipsep attractor type inherits
    the standard ellipse attractor type.
*/

#include "shared.hpp"
#include "ca_pointe.hpp"

#if !defined(__DB_ca_ellipse_HEAD_INCLUDED)
#define __DB_ca_ellipse_HEAD_INCLUDED

class CA_ELLIPSE : public CA_POINTE
{
  protected:
/*!*/virtual double distance(int x, int y); // calculate distance to (x,y)

  // function for loading the vars from a string
/*!*/virtual int update_vars_from_line(); // continues loading from string
    
  public:
    CA_ELLIPSE();
    CA_ELLIPSE(CA_MODE mode, int r, int g, int b, double colint=1.0,
               double exp=1.0, double x=0.5, double y=0.5, 
               double width=0.5, double height=0.5,
               double angle=0.0, double range=0.25);
/*!*/virtual ~CA_ELLIPSE(); // remember to have virtual dtor in derived types

  // called by the GRADIENT_GEN prior to rendering
  // (should return true, if rendering should be done, false otherwise)
/*!*/virtual bool update_absolutes(int width, int height,
                                   lut_callback lcall, double lcall_skip, int n);

  // Saving to string (loading from string is handled by "update_vars_..."
/*!*/virtual string get_as_text();

  // Helper function for GUI building that returns some very sparse info
  // meant to be displayed in a list
/*!*/virtual string gui_quick_info();
};

#endif // #if !defined(__DB_ca_ellipse_HEAD_INCLUDED)

/*
  Preserving the possibilty to make nicely formatted printouts
  (Format: "Portrait"), the code should be normed to a width of 78 chars.
123456789012345678901234567890123456789012345678901234567890123456789012345678
---------10--------20--------30--------40--------50--------60--------70-----78
*/
