/*--- Filename: "ca_circlef.hpp" ---

  --- Projectname: DB's Dynamic Color Gradient Generator ---
  (Targetsystem: Crossplatform)
  
  Author: Dennis Busch (http://www.dennisbusch.de)

  Content:
  The filled(inside circle distance always 0) circle color attractor.

*/

#include "shared.hpp"
#include "ca_circle.hpp"

#if !defined(__DB_ca_circlef_HEAD_INCLUDED)
#define __DB_ca_circlef_HEAD_INCLUDED

class CA_CIRCLEF : public CA_CIRCLE
{
/*!*/virtual double distance(int x, int y); // calculate distance to (x,y)
  public:
    CA_CIRCLEF();
    CA_CIRCLEF(CA_MODE mode, int r, int g, int b, double colint=1.0,
               double exp=1.0, double x=0.5, double y=0.5, 
               double radius=0.5, double range=0.5);
/*!*/virtual ~CA_CIRCLEF(); // remember to have virtual dtor in derived types

  // Helper function for GUI building that returns some very sparse info
  // meant to be displayed in a list
/*!*/virtual string gui_quick_info();
};

#endif // #if !defined(__DB_ca_circlef_HEAD_INCLUDED)

/*
  Preserving the possibilty to make nicely formatted printouts
  (Format: "Portrait"), the code should be normed to a width of 78 chars.
123456789012345678901234567890123456789012345678901234567890123456789012345678
---------10--------20--------30--------40--------50--------60--------70-----78
*/
