/*--- Filename: "ca_circlef.cpp" ---

  --- Projectname: DB's Dynamic Color Gradient Generator ---
  (Targetsystem: Crossplatform)
  
  Author: Dennis Busch (http://www.dennisbusch.de)

  Content:
  The filled(inside circle distance always 0) circle color attractor.
  
*/

#include "ca_circlef.hpp"

#if !defined(__DB_ca_circlef_BODY_INCLUDED)
#define __DB_ca_circlef_BODY_INCLUDED

// default ctor just sets default values
CA_CIRCLEF::CA_CIRCLEF()
{
  TYPE = CAT_CIRCLEF; // remember to override in derived types
}

// other ctor sets user values
CA_CIRCLEF::CA_CIRCLEF(CA_MODE mode, int r, int g, int b, 
                       double colint, double exp,
                       double x, double y, double radius, double range)
{
  CA_CIRCLE::CA_CIRCLE(mode,r,g,b,colint,exp,x,y,radius,range);
  TYPE = CAT_CIRCLEF; // remember to override in derived types
}

CA_CIRCLEF::~CA_CIRCLEF()
{
  CA_GLOBAL::delete_line_buf();
}

// calculate distance to (x,y) in pixels
// (is protected virtual)
double CA_CIRCLEF::distance(int x, int y)
{
  double d = CA_POINT::distance(x,y);
  if (d<=_pix_r) // (x,y) is inside circle
    return 0;
  else return fabs(d - _pix_r);
}

/* Helper function for GUI building that returns some very sparse info
   meant to be displayed in a list*/
// (is virtual)
string CA_CIRCLEF::gui_quick_info()
{
  ostringstream rline;
  rline.exceptions(ios_base::badbit|ios_base::failbit|ios_base::eofbit);
  try
  {
    rline.setf(ios_base::dec,ios_base::basefield);
    rline.setf(ios_base::fixed,ios_base::floatfield);
    rline.precision(2);
    rline << "i " << COLINT
          << ",e " << EXP
          << ",p(" << X << "," << Y << ")";
    rline.clear();
    return rline.str();
  }
  catch(ios_base::failure)
  {
    return string("stream error");
  }
}

#endif // #if !defined(__DB_ca_circlef_BODY_INCLUDED)

/*
  Preserving the possibilty to make nicely formatted printouts
  (Format: "Portrait"), the code should be normed to a width of 78 chars.
123456789012345678901234567890123456789012345678901234567890123456789012345678
---------10--------20--------30--------40--------50--------60--------70-----78
*/
