/*--- Filename: "ca_bar.hpp" ---

  --- Projectname: DB's Dynamic Color Gradient Generator ---
  (Targetsystem: Crossplatform)
  
  Author: Dennis Busch (http://www.dennisbusch.de)

  Content:
  The rotated bar color attractor.

*/

#include "shared.hpp"
#include "ca_point.hpp"

#if !defined(__DB_ca_bar_HEAD_INCLUDED)
#define __DB_ca_bar_HEAD_INCLUDED

class CA_BAR : public CA_POINT
{
  protected:
    double _ang_rad; // angle in radians

  // variables that affect the attractors influence
    double ANGLE; // the rotation angle(around the bar's origin)    

/*!*/virtual double distance(int x, int y); // calculate distance to (x,y)

  // function for loading the vars from a string
/*!*/virtual int update_vars_from_line(); // continues loading from string
    
  public:
    CA_BAR();
    CA_BAR(CA_MODE mode, int r, int g, int b, double colint=1.0,
             double exp=1.0, double x=0.5, double y=0.5,
             double angle=0.0, double range=0.5);
/*!*/virtual ~CA_BAR(); // remember to have virtual dtor in derived types

  // Set and Get Methods
    void set_angle(double angle);
    double get_angle();

  // Saving to string (loading from string is handled by "update_vars_..."
/*!*/virtual string get_as_text();

  // Helper function for GUI building that returns some very sparse info
  // meant to be displayed in a list
/*!*/virtual string gui_quick_info();
};

#endif // #if !defined(__DB_ca_bar_HEAD_INCLUDED)

/*
  Preserving the possibilty to make nicely formatted printouts
  (Format: "Portrait"), the code should be normed to a width of 78 chars.
123456789012345678901234567890123456789012345678901234567890123456789012345678
---------10--------20--------30--------40--------50--------60--------70-----78
*/
