/*--- Filename: "bmp_t.hpp" ---

  --- Projectname: DB's Dynamic Color Gradient Generator ---
  (Targetsystem: Crossplatform)
  
  Author: Dennis Busch (http://www.dennisbusch.de)

  Content:
  The used bitmap type.
  (For the ALLEGRO specific version.
   Write a modification/rewrite of this type and then
   include that instead of this file into "gradient_gen.hpp"
   to port the gradient generator.)

  The class BMP_T
  has to have a "get_pixel32(x,y)" method that returns the color as an integer
  in the format "0x00RRGGBB". And a "put_pixel32(x,y,int)" method that will
  write the color(same format) to the bitmap.
  The bitmap type also has to supply a "get_width()" and a "get_height()" 
  method and an "is_valid()" method that returns true, if the bitmap is 
  correctly initialized and usable.
*/

#include "allegro.h"
#include "shared.hpp"

#if !defined(__DB_bmp_t_HEAD_INCLUDED)
#define __DB_bmp_t_HEAD_INCLUDED

class BMP_T // the system specific bitmap type (change this for every port)
{
  private:
    BITMAP *BMP;

  public:
    BMP_T();

    void attach_al_bmp(BITMAP *bmp);
    BITMAP* get_al_bmp();

    bool is_valid();
    int get_width();
    int get_height();

    int get_pixel32(int x, int y);
    void put_pixel32(int x, int y, int col);
};

#endif // #if !defined(__DB_bmp_t_HEAD_INCLUDED)

/*
  Preserving the possibilty to make nicely formatted printouts
  (Format: "Portrait"), the code should be normed to a width of 78 chars.
123456789012345678901234567890123456789012345678901234567890123456789012345678
---------10--------20--------30--------40--------50--------60--------70-----78
*/
