/*--- Filename: "bmp_t.cpp" ---

  --- Projectname: DB's Dynamic Color Gradient Generator ---
  (Targetsystem: Crossplatform)
  
  Author: Dennis Busch (http://www.dennisbusch.de)

  Content:
  The used bitmap type.
  (For the ALLEGRO specific version.
   Write a modification/rewrite of this type and then
   include that instead of this file into "gradient_gen.hpp"
   to port the gradient generator.)

  The class BMP_T
  has to have a "get_pixel32(x,y)" method that returns the color as an integer
  in the format "0x00RRGGBB". And a "put_pixel32(x,y,int)" method that will
  write the color to the bitmap.
  The bitmap type also has to supply a "get_width()" and a "get_height()" 
  method and an "is_valid()" method that returns true, if the bitmap is 
  correctly initialized and usable.
*/

#include "bmp_t.hpp"

#if !defined(__DB_bmp_t_BODY_INCLUDED)
#define __DB_bmp_t_BODY_INCLUDED

BMP_T::BMP_T()
{
  BMP = NULL;
}

void BMP_T::attach_al_bmp(BITMAP *bmp)
{
  BMP = bmp;
}

BITMAP* BMP_T::get_al_bmp()
{
  return BMP;
}

bool BMP_T::is_valid()
{
  return (BMP!=NULL);
}

int BMP_T::get_width()
{
  if(BMP) 
    return BMP->w;
  else
    return 0;
}

int BMP_T::get_height()
{
  if(BMP)
    return BMP->h;
  else
    return 0;
}

int BMP_T::get_pixel32(int x, int y)
{
  if(BMP)
  {
    int i=getpixel(BMP,x,y);
    return make_rgb32(getr(i),getg(i),getb(i));
  }
  else 
    return 0;
}

void BMP_T::put_pixel32(int x, int y, int col)
{
  if(BMP)
  {
    if((x<0)||(y<0)||(x>BMP->w-1)||(y>BMP->h-1)) return;
    putpixel(BMP,x,y,makecol(get_r32(col),get_g32(col),get_b32(col)));
  }
}

#endif // #if !defined(__DB_bmp_t_BODY_INCLUDED)

/*
  Preserving the possibilty to make nicely formatted printouts
  (Format: "Portrait"), the code should be normed to a width of 78 chars.
123456789012345678901234567890123456789012345678901234567890123456789012345678
---------10--------20--------30--------40--------50--------60--------70-----78
*/
