/*--- Filename: "shared.cpp" ---

  --- Projectname: DB's Dynamic Color Gradient Generator ---
  (Targetsystem: Crossplatform)
  
  Author: Dennis Busch (http://www.dennisbusch.de)

  Content:
  Shared functions and types used by other classes.
  
*/

#include "shared.hpp"

#if !defined(__DB_shared_BODY_INCLUDED)
#define __DB_shared_BODY_INCLUDED

// returns and integer of the format 0x00rrggbb, r,g,b will be clamped [0,255]
int make_rgb32(int r, int g, int b)
{
  int R,G,B;
  R = clamp_val<int>(0,r,255);
  G = clamp_val<int>(0,g,255);
  B = clamp_val<int>(0,b,255);
  return ((((0+R)<<8)+G)<<8)+B;
}

// return a portion from an rgb32 int as described in the function above
int get_r32(int color)
{
  return ((color|0xFF00FFFF)^(0xFF00FFFF))>>16;
}
int get_g32(int color)
{
  return ((color|0xFFFF00FF)^(0xFFFF00FF))>>8;
}
int get_b32(int color)
{
  return ((color|0xFFFFFF00)^(0xFFFFFF00));
}

// Internal Type Text Identifiers(Descriptions)
string CA_TYPE_TEXT[] =
{
  string("GLOBAL"),
  string("POINT"),
  string("POINTE"),
  string("HBAR"),
  string("VBAR"),
  string("BAR"),
  string("POLYNOMIAL"),
  string("CIRCLE"),
  string("CIRCLEF"),
  string("ELLIPSE")
};

// returns a string containing the internal description of the CA_TYPE
string get_ca_type_text(CA_TYPE which)
{
  if(which<CAT_NUM_TYPES)
    return CA_TYPE_TEXT[which];
  else 
    return string("invalid type id!");
}

// Internal Mode Text Identifiers(Descriptions)
string CA_MODE_TEXT[] =
{
  string("ATTRACT"),
  string("ABSORB")
};

// returns a string containing the internal description of the CA_MODE
string get_ca_mode_text(CA_MODE which)
{
  if(which<CAM_NUM_MODES)
    return CA_MODE_TEXT[which];
  else
    return string("invalid mode id!");
}

// returns the newly allocated buffer or NULL on failure
char *make_char_buffer(unsigned int length)
{
  char *ret = NULL;
  ret = new(nothrow)char[length];
  return ret;
}

#endif // #if !defined(__DB_shared_BODY_INCLUDED)

/*
  Preserving the possibilty to make nicely formatted printouts
  (Format: "Portrait"), the code should be normed to a width of 78 chars.
123456789012345678901234567890123456789012345678901234567890123456789012345678
---------10--------20--------30--------40--------50--------60--------70-----78
*/
