/*--- Filename: "ca_vbar.hpp" ---

  --- Projectname: DB's Dynamic Color Gradient Generator ---
  (Targetsystem: Crossplatform)
  
  Author: Dennis Busch (http://www.dennisbusch.de)

  Content:
  The vertical bar color attractor.

*/

#include "shared.hpp"
#include "ca_point.hpp"

#if !defined(__DB_ca_vbar_HEAD_INCLUDED)
#define __DB_ca_vbar_HEAD_INCLUDED

class CA_VBAR : public CA_POINT
{
  protected:
/*!*/virtual double distance(int x, int y); // calculate distance to x

  // function for loading the vars from a string
/*!*/virtual int update_vars_from_line(); // continues loading from string
    
  public:
    CA_VBAR();
    CA_VBAR(CA_MODE mode, int r, int g, int b, double colint=1.0,
            double exp=1.0, double x=0.5, double range=0.5);
/*!*/virtual ~CA_VBAR(); // remember to have virtual dtor in derived types

  // called by the GRADIENT_GEN prior to rendering
  // (should return true, if rendering should be done, false otherwise)
/*!*/virtual bool update_absolutes(int width, int height,
                                   lut_callback lcall, double lcall_skip, int n);

  // The *only* function ever called by the "render_gradient" method from..
  // ..GRADIENT_GEN class (directly modifies "crgb"; applies CA's influence)
/*!*/virtual void modify_crgb(int x, int y, customRGB<double>& crgb);

  // Saving to string (loading from string is handled by "update_vars_..."
/*!*/virtual string get_as_text();

  // Helper function for GUI building that returns some very sparse info
  // meant to be displayed in a list
/*!*/virtual string gui_quick_info();
};

#endif // #if !defined(__DB_ca_vbar_HEAD_INCLUDED)

/*
  Preserving the possibilty to make nicely formatted printouts
  (Format: "Portrait"), the code should be normed to a width of 78 chars.
123456789012345678901234567890123456789012345678901234567890123456789012345678
---------10--------20--------30--------40--------50--------60--------70-----78
*/
